/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.widget.LinearLayout;
import com.android.internal.R;

public class WeightedLinearLayout
extends LinearLayout {
    private float mMajorWeight;
    private float mMinorWeight;

    public WeightedLinearLayout(Context context) {
        super(context);
    }

    public WeightedLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.WeightedLinearLayout);
        this.mMajorWeight = a.getFloat(0, 0.0f);
        this.mMinorWeight = a.getFloat(1, 0.0f);
        a.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        float widthWeight;
        DisplayMetrics metrics = this.getContext().getResources().getDisplayMetrics();
        int screenWidth = metrics.widthPixels;
        boolean isPortrait = screenWidth < metrics.heightPixels;
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        boolean measure = false;
        widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(width, 0x40000000);
        heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(height, 0x40000000);
        float f = widthWeight = isPortrait ? this.mMinorWeight : this.mMajorWeight;
        if (widthMode == Integer.MIN_VALUE && widthWeight > 0.0f && (float)width < (float)screenWidth * widthWeight) {
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)((float)screenWidth * widthWeight), 0x40000000);
            measure = true;
        }
        if (measure) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }
}

