/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.os.Bundle;
import android.text.Editable;
import android.text.method.KeyListener;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.widget.TextView;

public class EditableInputConnection
extends BaseInputConnection {
    private static final boolean DEBUG = false;
    private static final String TAG = "EditableInputConnection";
    private final TextView mTextView;

    public EditableInputConnection(TextView textview) {
        super(textview, true);
        this.mTextView = textview;
    }

    public Editable getEditable() {
        TextView tv = this.mTextView;
        if (tv != null) {
            return tv.getEditableText();
        }
        return null;
    }

    public boolean beginBatchEdit() {
        this.mTextView.beginBatchEdit();
        return true;
    }

    public boolean endBatchEdit() {
        this.mTextView.endBatchEdit();
        return true;
    }

    public boolean clearMetaKeyStates(int states) {
        Editable content = this.getEditable();
        if (content == null) {
            return false;
        }
        KeyListener kl = this.mTextView.getKeyListener();
        if (kl != null) {
            try {
                kl.clearMetaKeyState(this.mTextView, content, states);
            }
            catch (AbstractMethodError e) {
                // empty catch block
            }
        }
        return true;
    }

    public boolean commitCompletion(CompletionInfo text) {
        this.mTextView.beginBatchEdit();
        this.mTextView.onCommitCompletion(text);
        this.mTextView.endBatchEdit();
        return true;
    }

    public boolean performEditorAction(int actionCode) {
        this.mTextView.onEditorAction(actionCode);
        return true;
    }

    public boolean performContextMenuAction(int id2) {
        this.mTextView.beginBatchEdit();
        this.mTextView.onTextContextMenuItem(id2);
        this.mTextView.endBatchEdit();
        return true;
    }

    public ExtractedText getExtractedText(ExtractedTextRequest request, int flags) {
        ExtractedText et;
        if (this.mTextView != null && this.mTextView.extractText(request, et = new ExtractedText())) {
            if ((flags & 1) != 0) {
                this.mTextView.setExtracting(request);
            }
            return et;
        }
        return null;
    }

    public boolean performPrivateCommand(String action, Bundle data) {
        this.mTextView.onPrivateIMECommand(action, data);
        return true;
    }

    public boolean commitText(CharSequence text, int newCursorPosition) {
        if (this.mTextView == null) {
            return super.commitText(text, newCursorPosition);
        }
        CharSequence errorBefore = this.mTextView.getError();
        boolean success = super.commitText(text, newCursorPosition);
        CharSequence errorAfter = this.mTextView.getError();
        if (errorAfter != null && errorBefore == errorAfter) {
            this.mTextView.setError(null, null);
        }
        return success;
    }
}

