/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.SparseArray;
import android.view.ContextMenu;
import android.view.ContextThemeWrapper;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.android.internal.view.menu.IconMenuView;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuView;
import com.android.internal.view.menu.SubMenuBuilder;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuBuilder
implements Menu {
    private static final String LOGTAG = "MenuBuilder";
    public static final int NUM_TYPES = 3;
    public static final int TYPE_ICON = 0;
    public static final int TYPE_EXPANDED = 1;
    public static final int TYPE_DIALOG = 2;
    private static final String VIEWS_TAG = "android:views";
    static final int[] THEME_RES_FOR_TYPE = new int[]{16973990, 16973991, 0};
    static final int[] LAYOUT_RES_FOR_TYPE = new int[]{17367081, 17367076, 0};
    static final int[] ITEM_LAYOUT_RES_FOR_TYPE = new int[]{17367080, 17367103, 17367103};
    private static final int[] sCategoryToOrder = new int[]{1, 4, 5, 3, 2, 0};
    private final Context mContext;
    private final Resources mResources;
    private boolean mQwertyMode;
    private boolean mShortcutsVisible;
    private Callback mCallback;
    private ArrayList<MenuItemImpl> mItems;
    private ArrayList<MenuItemImpl> mVisibleItems;
    private boolean mIsVisibleItemsStale;
    private ContextMenu.ContextMenuInfo mCurrentMenuInfo;
    CharSequence mHeaderTitle;
    Drawable mHeaderIcon;
    View mHeaderView;
    private SparseArray<Parcelable> mFrozenViewStates;
    private boolean mPreventDispatchingItemsChanged = false;
    private boolean mOptionalIconsVisible = false;
    private MenuType[] mMenuTypes = new MenuType[3];

    public MenuBuilder(Context context) {
        this.mContext = context;
        this.mResources = context.getResources();
        this.mItems = new ArrayList();
        this.mVisibleItems = new ArrayList();
        this.mIsVisibleItemsStale = true;
        this.mShortcutsVisible = this.mResources.getConfiguration().keyboard != 1;
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    MenuType getMenuType(int menuType) {
        if (this.mMenuTypes[menuType] == null) {
            this.mMenuTypes[menuType] = new MenuType(menuType);
        }
        return this.mMenuTypes[menuType];
    }

    public View getMenuView(int menuType, ViewGroup parent) {
        if (!(menuType != 1 || this.mMenuTypes[0] != null && this.mMenuTypes[0].hasMenuView())) {
            this.getMenuType(0).getMenuView(parent);
        }
        return (View)((Object)this.getMenuType(menuType).getMenuView(parent));
    }

    private int getNumIconMenuItemsShown() {
        ViewGroup parent = null;
        if (!this.mMenuTypes[0].hasMenuView() && this.mMenuTypes[1].hasMenuView()) {
            View expandedMenuView = (View)((Object)this.mMenuTypes[1].getMenuView(null));
            parent = (ViewGroup)expandedMenuView.getParent();
        }
        return ((IconMenuView)this.getMenuView(0, parent)).getNumActualItemsShown();
    }

    public void clearMenuViews() {
        int i;
        for (i = 2; i >= 0; --i) {
            if (this.mMenuTypes[i] == null) continue;
            this.mMenuTypes[i].mMenuView = null;
        }
        for (i = this.mItems.size() - 1; i >= 0; --i) {
            MenuItemImpl item = this.mItems.get(i);
            if (item.hasSubMenu()) {
                ((SubMenuBuilder)item.getSubMenu()).clearMenuViews();
            }
            item.clearItemViews();
        }
    }

    private MenuItem addInternal(int group, int id2, int categoryOrder, CharSequence title) {
        int ordering = MenuBuilder.getOrdering(categoryOrder);
        MenuItemImpl item = new MenuItemImpl(this, group, id2, categoryOrder, ordering, title);
        if (this.mCurrentMenuInfo != null) {
            item.setMenuInfo(this.mCurrentMenuInfo);
        }
        this.mItems.add(MenuBuilder.findInsertIndex(this.mItems, ordering), item);
        this.onItemsChanged(false);
        return item;
    }

    @Override
    public MenuItem add(CharSequence title) {
        return this.addInternal(0, 0, 0, title);
    }

    @Override
    public MenuItem add(int titleRes) {
        return this.addInternal(0, 0, 0, this.mResources.getString(titleRes));
    }

    @Override
    public MenuItem add(int group, int id2, int categoryOrder, CharSequence title) {
        return this.addInternal(group, id2, categoryOrder, title);
    }

    @Override
    public MenuItem add(int group, int id2, int categoryOrder, int title) {
        return this.addInternal(group, id2, categoryOrder, this.mResources.getString(title));
    }

    @Override
    public SubMenu addSubMenu(CharSequence title) {
        return this.addSubMenu(0, 0, 0, title);
    }

    @Override
    public SubMenu addSubMenu(int titleRes) {
        return this.addSubMenu(0, 0, 0, this.mResources.getString(titleRes));
    }

    @Override
    public SubMenu addSubMenu(int group, int id2, int categoryOrder, CharSequence title) {
        MenuItemImpl item = (MenuItemImpl)this.addInternal(group, id2, categoryOrder, title);
        SubMenuBuilder subMenu = new SubMenuBuilder(this.mContext, this, item);
        item.setSubMenu(subMenu);
        return subMenu;
    }

    @Override
    public SubMenu addSubMenu(int group, int id2, int categoryOrder, int title) {
        return this.addSubMenu(group, id2, categoryOrder, this.mResources.getString(title));
    }

    @Override
    public int addIntentOptions(int group, int id2, int categoryOrder, ComponentName caller, Intent[] specifics, Intent intent, int flags, MenuItem[] outSpecificItems) {
        int N;
        PackageManager pm = this.mContext.getPackageManager();
        List<ResolveInfo> lri = pm.queryIntentActivityOptions(caller, specifics, intent, 0);
        int n = N = lri != null ? lri.size() : 0;
        if ((flags & 1) == 0) {
            this.removeGroup(group);
        }
        for (int i = 0; i < N; ++i) {
            ResolveInfo ri = lri.get(i);
            Intent rintent = new Intent(ri.specificIndex < 0 ? intent : specifics[ri.specificIndex]);
            rintent.setComponent(new ComponentName(ri.activityInfo.applicationInfo.packageName, ri.activityInfo.name));
            MenuItem item = this.add(group, id2, categoryOrder, ri.loadLabel(pm)).setIcon(ri.loadIcon(pm)).setIntent(rintent);
            if (outSpecificItems == null || ri.specificIndex < 0) continue;
            outSpecificItems[ri.specificIndex] = item;
        }
        return N;
    }

    @Override
    public void removeItem(int id2) {
        this.removeItemAtInt(this.findItemIndex(id2), true);
    }

    @Override
    public void removeGroup(int group) {
        int i = this.findGroupIndex(group);
        if (i >= 0) {
            int maxRemovable = this.mItems.size() - i;
            int numRemoved = 0;
            while (numRemoved++ < maxRemovable && this.mItems.get(i).getGroupId() == group) {
                this.removeItemAtInt(i, false);
            }
            this.onItemsChanged(false);
        }
    }

    private void removeItemAtInt(int index, boolean updateChildrenOnMenuViews) {
        if (index < 0 || index >= this.mItems.size()) {
            return;
        }
        this.mItems.remove(index);
        if (updateChildrenOnMenuViews) {
            this.onItemsChanged(false);
        }
    }

    public void removeItemAt(int index) {
        this.removeItemAtInt(index, true);
    }

    public void clearAll() {
        this.mPreventDispatchingItemsChanged = true;
        this.clear();
        this.clearHeader();
        this.mPreventDispatchingItemsChanged = false;
        this.onItemsChanged(true);
    }

    @Override
    public void clear() {
        this.mItems.clear();
        this.onItemsChanged(true);
    }

    void setExclusiveItemChecked(MenuItem item) {
        int group = item.getGroupId();
        int N = this.mItems.size();
        for (int i = 0; i < N; ++i) {
            MenuItemImpl curItem = this.mItems.get(i);
            if (curItem.getGroupId() != group || !curItem.isExclusiveCheckable() || !curItem.isCheckable()) continue;
            curItem.setCheckedInt(curItem == item);
        }
    }

    @Override
    public void setGroupCheckable(int group, boolean checkable, boolean exclusive) {
        int N = this.mItems.size();
        for (int i = 0; i < N; ++i) {
            MenuItemImpl item = this.mItems.get(i);
            if (item.getGroupId() != group) continue;
            item.setExclusiveCheckable(exclusive);
            item.setCheckable(checkable);
        }
    }

    @Override
    public void setGroupVisible(int group, boolean visible) {
        int N = this.mItems.size();
        boolean changedAtLeastOneItem = false;
        for (int i = 0; i < N; ++i) {
            MenuItemImpl item = this.mItems.get(i);
            if (item.getGroupId() != group || !item.setVisibleInt(visible)) continue;
            changedAtLeastOneItem = true;
        }
        if (changedAtLeastOneItem) {
            this.onItemsChanged(false);
        }
    }

    @Override
    public void setGroupEnabled(int group, boolean enabled) {
        int N = this.mItems.size();
        for (int i = 0; i < N; ++i) {
            MenuItemImpl item = this.mItems.get(i);
            if (item.getGroupId() != group) continue;
            item.setEnabled(enabled);
        }
    }

    @Override
    public boolean hasVisibleItems() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            MenuItemImpl item = this.mItems.get(i);
            if (!item.isVisible()) continue;
            return true;
        }
        return false;
    }

    @Override
    public MenuItem findItem(int id2) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            MenuItem possibleItem;
            MenuItemImpl item = this.mItems.get(i);
            if (item.getItemId() == id2) {
                return item;
            }
            if (!item.hasSubMenu() || (possibleItem = item.getSubMenu().findItem(id2)) == null) continue;
            return possibleItem;
        }
        return null;
    }

    public int findItemIndex(int id2) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            MenuItemImpl item = this.mItems.get(i);
            if (item.getItemId() != id2) continue;
            return i;
        }
        return -1;
    }

    public int findGroupIndex(int group) {
        return this.findGroupIndex(group, 0);
    }

    public int findGroupIndex(int group, int start) {
        int size = this.size();
        if (start < 0) {
            start = 0;
        }
        for (int i = start; i < size; ++i) {
            MenuItemImpl item = this.mItems.get(i);
            if (item.getGroupId() != group) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int size() {
        return this.mItems.size();
    }

    @Override
    public MenuItem getItem(int index) {
        return this.mItems.get(index);
    }

    @Override
    public boolean isShortcutKey(int keyCode, KeyEvent event) {
        return this.findItemWithShortcutForKey(keyCode, event) != null;
    }

    @Override
    public void setQwertyMode(boolean isQwerty) {
        this.mQwertyMode = isQwerty;
        this.refreshShortcuts(this.isShortcutsVisible(), isQwerty);
    }

    private static int getOrdering(int categoryOrder) {
        int index = (categoryOrder & 0xFFFF0000) >> 16;
        if (index < 0 || index >= sCategoryToOrder.length) {
            throw new IllegalArgumentException("order does not contain a valid category.");
        }
        return sCategoryToOrder[index] << 16 | categoryOrder & 0xFFFF;
    }

    boolean isQwertyMode() {
        return this.mQwertyMode;
    }

    private void refreshShortcuts(boolean shortcutsVisible, boolean qwertyMode) {
        for (int i = this.mItems.size() - 1; i >= 0; --i) {
            MenuItemImpl item = this.mItems.get(i);
            if (item.hasSubMenu()) {
                ((MenuBuilder)((Object)item.getSubMenu())).refreshShortcuts(shortcutsVisible, qwertyMode);
            }
            item.refreshShortcutOnItemViews(shortcutsVisible, qwertyMode);
        }
    }

    public void setShortcutsVisible(boolean shortcutsVisible) {
        if (this.mShortcutsVisible == shortcutsVisible) {
            return;
        }
        this.mShortcutsVisible = this.mResources.getConfiguration().keyboard != 1 && shortcutsVisible;
        this.refreshShortcuts(this.mShortcutsVisible, this.isQwertyMode());
    }

    public boolean isShortcutsVisible() {
        return this.mShortcutsVisible;
    }

    Resources getResources() {
        return this.mResources;
    }

    public Callback getCallback() {
        return this.mCallback;
    }

    public Context getContext() {
        return this.mContext;
    }

    private static int findInsertIndex(ArrayList<MenuItemImpl> items, int ordering) {
        for (int i = items.size() - 1; i >= 0; --i) {
            MenuItemImpl item = items.get(i);
            if (item.getOrdering() > ordering) continue;
            return i + 1;
        }
        return 0;
    }

    @Override
    public boolean performShortcut(int keyCode, KeyEvent event, int flags) {
        MenuItemImpl item = this.findItemWithShortcutForKey(keyCode, event);
        boolean handled = false;
        if (item != null) {
            handled = this.performItemAction(item, flags);
        }
        if ((flags & 2) != 0) {
            this.close(true);
        }
        return handled;
    }

    List<MenuItemImpl> findItemsWithShortcutForKey(int keyCode, KeyEvent event) {
        boolean qwerty = this.isQwertyMode();
        int metaState = event.getMetaState();
        KeyCharacterMap.KeyData possibleChars = new KeyCharacterMap.KeyData();
        boolean isKeyCodeMapped = event.getKeyData(possibleChars);
        if (!isKeyCodeMapped && keyCode != 67) {
            return null;
        }
        Vector<MenuItemImpl> items = new Vector<MenuItemImpl>();
        int N = this.mItems.size();
        for (int i = 0; i < N; ++i) {
            char shortcutChar;
            MenuItemImpl item = this.mItems.get(i);
            if (item.hasSubMenu()) {
                List<MenuItemImpl> subMenuItems = ((MenuBuilder)((Object)item.getSubMenu())).findItemsWithShortcutForKey(keyCode, event);
                items.addAll(subMenuItems);
            }
            char c = shortcutChar = qwerty ? item.getAlphabeticShortcut() : item.getNumericShortcut();
            if ((metaState & 5) != 0 || shortcutChar == '\u0000' || shortcutChar != possibleChars.meta[0] && shortcutChar != possibleChars.meta[2] && (!qwerty || shortcutChar != '\b' || keyCode != 67) || !item.isEnabled()) continue;
            items.add(item);
        }
        return items;
    }

    MenuItemImpl findItemWithShortcutForKey(int keyCode, KeyEvent event) {
        List<MenuItemImpl> items = this.findItemsWithShortcutForKey(keyCode, event);
        if (items == null) {
            return null;
        }
        int metaState = event.getMetaState();
        KeyCharacterMap.KeyData possibleChars = new KeyCharacterMap.KeyData();
        event.getKeyData(possibleChars);
        if (items.size() == 1) {
            return items.get(0);
        }
        boolean qwerty = this.isQwertyMode();
        for (MenuItemImpl item : items) {
            char shortcutChar;
            char c = shortcutChar = qwerty ? item.getAlphabeticShortcut() : item.getNumericShortcut();
            if (!(shortcutChar == possibleChars.meta[0] && (metaState & 2) == 0 || shortcutChar == possibleChars.meta[2] && (metaState & 2) != 0) && (!qwerty || shortcutChar != '\b' || keyCode != 67)) continue;
            return item;
        }
        return null;
    }

    @Override
    public boolean performIdentifierAction(int id2, int flags) {
        return this.performItemAction(this.findItem(id2), flags);
    }

    public boolean performItemAction(MenuItem item, int flags) {
        MenuItemImpl itemImpl = (MenuItemImpl)item;
        if (itemImpl == null || !itemImpl.isEnabled()) {
            return false;
        }
        boolean invoked = itemImpl.invoke();
        if (item.hasSubMenu()) {
            this.close(false);
            if (this.mCallback != null) {
                invoked = this.mCallback.onSubMenuSelected((SubMenuBuilder)item.getSubMenu()) || invoked;
            }
        } else if ((flags & 1) == 0) {
            this.close(true);
        }
        return invoked;
    }

    final void close(boolean allMenusAreClosing) {
        Callback callback = this.getCallback();
        if (callback != null) {
            callback.onCloseMenu(this, allMenusAreClosing);
        }
    }

    @Override
    public void close() {
        this.close(true);
    }

    private void onItemsChanged(boolean cleared) {
        if (!this.mPreventDispatchingItemsChanged) {
            if (!this.mIsVisibleItemsStale) {
                this.mIsVisibleItemsStale = true;
            }
            MenuType[] menuTypes = this.mMenuTypes;
            for (int i = 0; i < 3; ++i) {
                if (menuTypes[i] == null || !menuTypes[i].hasMenuView()) continue;
                MenuView menuView = (MenuView)menuTypes[i].mMenuView.get();
                menuView.updateChildren(cleared);
            }
        }
    }

    void onItemVisibleChanged(MenuItemImpl item) {
        this.onItemsChanged(false);
    }

    ArrayList<MenuItemImpl> getVisibleItems() {
        if (!this.mIsVisibleItemsStale) {
            return this.mVisibleItems;
        }
        this.mVisibleItems.clear();
        int itemsSize = this.mItems.size();
        for (int i = 0; i < itemsSize; ++i) {
            MenuItemImpl item = this.mItems.get(i);
            if (!item.isVisible()) continue;
            this.mVisibleItems.add(item);
        }
        this.mIsVisibleItemsStale = false;
        return this.mVisibleItems;
    }

    public void clearHeader() {
        this.mHeaderIcon = null;
        this.mHeaderTitle = null;
        this.mHeaderView = null;
        this.onItemsChanged(false);
    }

    private void setHeaderInternal(int titleRes, CharSequence title, int iconRes, Drawable icon, View view) {
        Resources r = this.getResources();
        if (view != null) {
            this.mHeaderView = view;
            this.mHeaderTitle = null;
            this.mHeaderIcon = null;
        } else {
            if (titleRes > 0) {
                this.mHeaderTitle = r.getText(titleRes);
            } else if (title != null) {
                this.mHeaderTitle = title;
            }
            if (iconRes > 0) {
                this.mHeaderIcon = r.getDrawable(iconRes);
            } else if (icon != null) {
                this.mHeaderIcon = icon;
            }
            this.mHeaderView = null;
        }
        this.onItemsChanged(false);
    }

    protected MenuBuilder setHeaderTitleInt(CharSequence title) {
        this.setHeaderInternal(0, title, 0, null, null);
        return this;
    }

    protected MenuBuilder setHeaderTitleInt(int titleRes) {
        this.setHeaderInternal(titleRes, null, 0, null, null);
        return this;
    }

    protected MenuBuilder setHeaderIconInt(Drawable icon) {
        this.setHeaderInternal(0, null, 0, icon, null);
        return this;
    }

    protected MenuBuilder setHeaderIconInt(int iconRes) {
        this.setHeaderInternal(0, null, iconRes, null, null);
        return this;
    }

    protected MenuBuilder setHeaderViewInt(View view) {
        this.setHeaderInternal(0, null, 0, null, view);
        return this;
    }

    public CharSequence getHeaderTitle() {
        return this.mHeaderTitle;
    }

    public Drawable getHeaderIcon() {
        return this.mHeaderIcon;
    }

    public View getHeaderView() {
        return this.mHeaderView;
    }

    public MenuBuilder getRootMenu() {
        return this;
    }

    public void setCurrentMenuInfo(ContextMenu.ContextMenuInfo menuInfo) {
        this.mCurrentMenuInfo = menuInfo;
    }

    public MenuAdapter getMenuAdapter(int menuType) {
        return new MenuAdapter(menuType);
    }

    void setOptionalIconsVisible(boolean visible) {
        this.mOptionalIconsVisible = visible;
    }

    boolean getOptionalIconsVisible() {
        return this.mOptionalIconsVisible;
    }

    public void saveHierarchyState(Bundle outState) {
        SparseArray<Parcelable> viewStates = new SparseArray<Parcelable>();
        MenuType[] menuTypes = this.mMenuTypes;
        for (int i = 2; i >= 0; --i) {
            if (menuTypes[i] == null || !menuTypes[i].hasMenuView()) continue;
            ((View)((Object)menuTypes[i].getMenuView(null))).saveHierarchyState(viewStates);
        }
        outState.putSparseParcelableArray(VIEWS_TAG, viewStates);
    }

    public void restoreHierarchyState(Bundle inState) {
        this.mFrozenViewStates = inState.getSparseParcelableArray(VIEWS_TAG);
        SparseArray<Parcelable> viewStates = this.mFrozenViewStates;
        MenuType[] menuTypes = this.mMenuTypes;
        for (int i = 2; i >= 0; --i) {
            if (menuTypes[i] == null || !menuTypes[i].hasMenuView()) continue;
            ((View)((Object)menuTypes[i].getMenuView(null))).restoreHierarchyState(viewStates);
        }
    }

    public class MenuAdapter
    extends BaseAdapter {
        private int mMenuType;

        public MenuAdapter(int menuType) {
            this.mMenuType = menuType;
        }

        public int getOffset() {
            if (this.mMenuType == 1) {
                return MenuBuilder.this.getNumIconMenuItemsShown();
            }
            return 0;
        }

        public int getCount() {
            return MenuBuilder.this.getVisibleItems().size() - this.getOffset();
        }

        public MenuItemImpl getItem(int position) {
            return MenuBuilder.this.getVisibleItems().get(position + this.getOffset());
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            return this.getItem(position).getItemView(this.mMenuType, parent);
        }
    }

    public static interface ItemInvoker {
        public boolean invokeItem(MenuItemImpl var1);
    }

    public static interface Callback {
        public boolean onMenuItemSelected(MenuBuilder var1, MenuItem var2);

        public void onCloseMenu(MenuBuilder var1, boolean var2);

        public boolean onSubMenuSelected(SubMenuBuilder var1);

        public void onCloseSubMenu(SubMenuBuilder var1);

        public void onMenuModeChange(MenuBuilder var1);
    }

    class MenuType {
        private int mMenuType;
        private LayoutInflater mInflater;
        private WeakReference<MenuView> mMenuView;

        MenuType(int menuType) {
            this.mMenuType = menuType;
        }

        LayoutInflater getInflater() {
            if (this.mInflater == null) {
                ContextThemeWrapper wrappedContext = new ContextThemeWrapper(MenuBuilder.this.mContext, THEME_RES_FOR_TYPE[this.mMenuType]);
                this.mInflater = (LayoutInflater)((Context)wrappedContext).getSystemService("layout_inflater");
            }
            return this.mInflater;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        MenuView getMenuView(ViewGroup parent) {
            if (LAYOUT_RES_FOR_TYPE[this.mMenuType] == 0) {
                return null;
            }
            MenuType menuType = this;
            synchronized (menuType) {
                MenuView menuView;
                MenuView menuView2 = menuView = this.mMenuView != null ? (MenuView)this.mMenuView.get() : null;
                if (menuView == null) {
                    menuView = (MenuView)((Object)this.getInflater().inflate(LAYOUT_RES_FOR_TYPE[this.mMenuType], parent, false));
                    menuView.initialize(MenuBuilder.this, this.mMenuType);
                    this.mMenuView = new WeakReference<MenuView>(menuView);
                    if (MenuBuilder.this.mFrozenViewStates != null) {
                        View view = (View)((Object)menuView);
                        view.restoreHierarchyState(MenuBuilder.this.mFrozenViewStates);
                        MenuBuilder.this.mFrozenViewStates.remove(view.getId());
                    }
                }
                return menuView;
            }
        }

        boolean hasMenuView() {
            return this.mMenuView != null && this.mMenuView.get() != null;
        }
    }
}

