/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.telephony.TelephonyManager;
import android.telephony.gsm.GsmCellLocation;
import android.util.EventLog;
import android.util.Log;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CallTracker;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.gsm.GsmCall;
import com.android.internal.telephony.gsm.GsmConnection;
import java.util.ArrayList;
import java.util.List;

public final class GsmCallTracker
extends CallTracker {
    static final String LOG_TAG = "GSM";
    private static final boolean REPEAT_POLLING = false;
    private static final boolean DBG_POLL = false;
    static final int MAX_CONNECTIONS = 7;
    static final int MAX_CONNECTIONS_PER_CALL = 5;
    GsmConnection[] connections = new GsmConnection[7];
    RegistrantList voiceCallEndedRegistrants = new RegistrantList();
    RegistrantList voiceCallStartedRegistrants = new RegistrantList();
    ArrayList<GsmConnection> droppedDuringPoll = new ArrayList(7);
    GsmCall ringingCall = new GsmCall(this);
    GsmCall foregroundCall = new GsmCall(this);
    GsmCall backgroundCall = new GsmCall(this);
    GsmConnection pendingMO;
    boolean hangupPendingMO;
    GSMPhone phone;
    boolean desiredMute = false;
    Phone.State state = Phone.State.IDLE;

    GsmCallTracker(GSMPhone phone) {
        this.phone = phone;
        this.cm = phone.mCM;
        this.cm.registerForCallStateChanged(this, 2, null);
        this.cm.registerForOn(this, 9, null);
        this.cm.registerForNotAvailable(this, 10, null);
    }

    public void dispose() {
        this.cm.unregisterForCallStateChanged(this);
        this.cm.unregisterForOn(this);
        this.cm.unregisterForNotAvailable(this);
        for (GsmConnection c : this.connections) {
            try {
                if (c == null) continue;
                this.hangup(c);
            }
            catch (CallStateException ex) {
                Log.e(LOG_TAG, "unexpected error on hangup during dispose");
            }
        }
        try {
            if (this.pendingMO != null) {
                this.hangup(this.pendingMO);
            }
        }
        catch (CallStateException ex) {
            Log.e(LOG_TAG, "unexpected error on hangup during dispose");
        }
        this.clearDisconnected();
    }

    protected void finalize() {
        Log.d(LOG_TAG, "GsmCallTracker finalized");
    }

    public void registerForVoiceCallStarted(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.voiceCallStartedRegistrants.add(r);
    }

    public void unregisterForVoiceCallStarted(Handler h) {
        this.voiceCallStartedRegistrants.remove(h);
    }

    public void registerForVoiceCallEnded(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.voiceCallEndedRegistrants.add(r);
    }

    public void unregisterForVoiceCallEnded(Handler h) {
        this.voiceCallEndedRegistrants.remove(h);
    }

    private void fakeHoldForegroundBeforeDial() {
        List connCopy = (List)this.foregroundCall.connections.clone();
        int s = connCopy.size();
        for (int i = 0; i < s; ++i) {
            GsmConnection conn = (GsmConnection)connCopy.get(i);
            conn.fakeHoldBeforeDial();
        }
    }

    Connection dial(String dialString, int clirMode, UUSInfo uusInfo) throws CallStateException {
        this.clearDisconnected();
        if (!this.canDial()) {
            throw new CallStateException("cannot dial in current state");
        }
        if (this.foregroundCall.getState() == Call.State.ACTIVE) {
            this.switchWaitingOrHoldingAndActive();
            this.fakeHoldForegroundBeforeDial();
        }
        if (this.foregroundCall.getState() != Call.State.IDLE) {
            throw new CallStateException("cannot dial in current state");
        }
        this.pendingMO = new GsmConnection(this.phone.getContext(), dialString, this, this.foregroundCall);
        this.hangupPendingMO = false;
        if (this.pendingMO.address == null || this.pendingMO.address.length() == 0 || this.pendingMO.address.indexOf(78) >= 0) {
            this.pendingMO.cause = Connection.DisconnectCause.INVALID_NUMBER;
            this.pollCallsWhenSafe();
        } else {
            this.setMute(false);
            this.cm.dial(this.pendingMO.address, clirMode, uusInfo, this.obtainCompleteMessage());
        }
        this.updatePhoneState();
        this.phone.notifyPreciseCallStateChanged();
        return this.pendingMO;
    }

    Connection dial(String dialString) throws CallStateException {
        return this.dial(dialString, 0, null);
    }

    Connection dial(String dialString, UUSInfo uusInfo) throws CallStateException {
        return this.dial(dialString, 0, uusInfo);
    }

    Connection dial(String dialString, int clirMode) throws CallStateException {
        return this.dial(dialString, clirMode, null);
    }

    void acceptCall() throws CallStateException {
        if (this.ringingCall.getState() == Call.State.INCOMING) {
            Log.i("phone", "acceptCall: incoming...");
            this.setMute(false);
            this.cm.acceptCall(this.obtainCompleteMessage());
        } else if (this.ringingCall.getState() == Call.State.WAITING) {
            this.setMute(false);
            this.switchWaitingOrHoldingAndActive();
        } else {
            throw new CallStateException("phone not ringing");
        }
    }

    void rejectCall() throws CallStateException {
        if (!this.ringingCall.getState().isRinging()) {
            throw new CallStateException("phone not ringing");
        }
        this.cm.rejectCall(this.obtainCompleteMessage());
    }

    void switchWaitingOrHoldingAndActive() throws CallStateException {
        if (this.ringingCall.getState() == Call.State.INCOMING) {
            throw new CallStateException("cannot be in the incoming state");
        }
        this.cm.switchWaitingOrHoldingAndActive(this.obtainCompleteMessage(8));
    }

    void conference() throws CallStateException {
        this.cm.conference(this.obtainCompleteMessage(11));
    }

    void explicitCallTransfer() throws CallStateException {
        this.cm.explicitCallTransfer(this.obtainCompleteMessage(13));
    }

    void clearDisconnected() {
        this.internalClearDisconnected();
        this.updatePhoneState();
        this.phone.notifyPreciseCallStateChanged();
    }

    boolean canConference() {
        return this.foregroundCall.getState() == Call.State.ACTIVE && this.backgroundCall.getState() == Call.State.HOLDING && !this.backgroundCall.isFull() && !this.foregroundCall.isFull();
    }

    boolean canDial() {
        int serviceState = this.phone.getServiceState().getState();
        String disableCall = SystemProperties.get("ro.telephony.disable-call", "false");
        boolean ret = serviceState != 3 && this.pendingMO == null && !this.ringingCall.isRinging() && !disableCall.equals("true") && (!this.foregroundCall.getState().isAlive() || !this.backgroundCall.getState().isAlive());
        return ret;
    }

    boolean canTransfer() {
        return this.foregroundCall.getState() == Call.State.ACTIVE && this.backgroundCall.getState() == Call.State.HOLDING;
    }

    private void internalClearDisconnected() {
        this.ringingCall.clearDisconnected();
        this.foregroundCall.clearDisconnected();
        this.backgroundCall.clearDisconnected();
    }

    private Message obtainCompleteMessage() {
        return this.obtainCompleteMessage(4);
    }

    private Message obtainCompleteMessage(int what) {
        ++this.pendingOperations;
        this.lastRelevantPoll = null;
        this.needsPoll = true;
        return this.obtainMessage(what);
    }

    private void operationComplete() {
        --this.pendingOperations;
        if (this.pendingOperations == 0 && this.needsPoll) {
            this.lastRelevantPoll = this.obtainMessage(1);
            this.cm.getCurrentCalls(this.lastRelevantPoll);
        } else if (this.pendingOperations < 0) {
            Log.e(LOG_TAG, "GsmCallTracker.pendingOperations < 0");
            this.pendingOperations = 0;
        }
    }

    private void updatePhoneState() {
        Phone.State oldState = this.state;
        this.state = this.ringingCall.isRinging() ? Phone.State.RINGING : (this.pendingMO != null || !this.foregroundCall.isIdle() || !this.backgroundCall.isIdle() ? Phone.State.OFFHOOK : Phone.State.IDLE);
        if (this.state == Phone.State.IDLE && oldState != this.state) {
            this.voiceCallEndedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        } else if (oldState == Phone.State.IDLE && oldState != this.state) {
            this.voiceCallStartedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        }
        if (this.state != oldState) {
            this.phone.notifyPhoneStateChanged();
        }
    }

    protected void handlePollCalls(AsyncResult ar) {
        int i;
        ArrayList polledCalls;
        if (ar.exception == null) {
            polledCalls = (ArrayList)ar.result;
        } else if (this.isCommandExceptionRadioNotAvailable(ar.exception)) {
            polledCalls = new ArrayList();
        } else {
            this.pollCallsAfterDelay();
            return;
        }
        GsmConnection newRinging = null;
        boolean hasNonHangupStateChanged = false;
        boolean needsPollDelay = false;
        boolean unknownConnectionAppeared = false;
        int curDC = 0;
        int dcSize = polledCalls.size();
        for (i = 0; i < this.connections.length; ++i) {
            GsmConnection conn = this.connections[i];
            DriverCall dc = null;
            if (curDC < dcSize) {
                dc = (DriverCall)polledCalls.get(curDC);
                if (dc.index == i + 1) {
                    ++curDC;
                } else {
                    dc = null;
                }
            }
            if (conn == null && dc != null) {
                if (this.pendingMO != null && this.pendingMO.compareTo(dc)) {
                    this.connections[i] = this.pendingMO;
                    this.pendingMO.index = i;
                    this.pendingMO.update(dc);
                    this.pendingMO = null;
                    if (this.hangupPendingMO) {
                        this.hangupPendingMO = false;
                        try {
                            this.log("poll: hangupPendingMO, hangup conn " + i);
                            this.hangup(this.connections[i]);
                        }
                        catch (CallStateException ex) {
                            Log.e(LOG_TAG, "unexpected error on hangup");
                        }
                        return;
                    }
                } else {
                    this.connections[i] = new GsmConnection(this.phone.getContext(), dc, this, i);
                    if (this.connections[i].getCall() == this.ringingCall) {
                        newRinging = this.connections[i];
                    } else {
                        Log.i(LOG_TAG, "Phantom call appeared " + dc);
                        if (dc.state != DriverCall.State.ALERTING && dc.state != DriverCall.State.DIALING) {
                            this.connections[i].connectTime = System.currentTimeMillis();
                        }
                        unknownConnectionAppeared = true;
                    }
                }
                hasNonHangupStateChanged = true;
                continue;
            }
            if (conn != null && dc == null) {
                this.droppedDuringPoll.add(conn);
                this.connections[i] = null;
                continue;
            }
            if (conn != null && dc != null && !conn.compareTo(dc)) {
                this.droppedDuringPoll.add(conn);
                this.connections[i] = new GsmConnection(this.phone.getContext(), dc, this, i);
                if (this.connections[i].getCall() == this.ringingCall) {
                    newRinging = this.connections[i];
                }
                hasNonHangupStateChanged = true;
                continue;
            }
            if (conn == null || dc == null) continue;
            boolean changed = conn.update(dc);
            hasNonHangupStateChanged = hasNonHangupStateChanged || changed;
        }
        if (this.pendingMO != null) {
            Log.d(LOG_TAG, "Pending MO dropped before poll fg state:" + (Object)((Object)this.foregroundCall.getState()));
            this.droppedDuringPoll.add(this.pendingMO);
            this.pendingMO = null;
            this.hangupPendingMO = false;
        }
        if (newRinging != null) {
            this.phone.notifyNewRingingConnection(newRinging);
        }
        for (i = this.droppedDuringPoll.size() - 1; i >= 0; --i) {
            GsmConnection conn = this.droppedDuringPoll.get(i);
            if (conn.isIncoming() && conn.getConnectTime() == 0L) {
                Connection.DisconnectCause cause = conn.cause == Connection.DisconnectCause.LOCAL ? Connection.DisconnectCause.INCOMING_REJECTED : Connection.DisconnectCause.INCOMING_MISSED;
                this.log("missed/rejected call, conn.cause=" + (Object)((Object)conn.cause));
                this.log("setting cause to " + (Object)((Object)cause));
                this.droppedDuringPoll.remove(i);
                conn.onDisconnect(cause);
                continue;
            }
            if (conn.cause == Connection.DisconnectCause.LOCAL) {
                this.droppedDuringPoll.remove(i);
                conn.onDisconnect(Connection.DisconnectCause.LOCAL);
                continue;
            }
            if (conn.cause != Connection.DisconnectCause.INVALID_NUMBER) continue;
            this.droppedDuringPoll.remove(i);
            conn.onDisconnect(Connection.DisconnectCause.INVALID_NUMBER);
        }
        if (this.droppedDuringPoll.size() > 0) {
            this.cm.getLastCallFailCause(this.obtainNoPollCompleteMessage(5));
        }
        if (needsPollDelay) {
            this.pollCallsAfterDelay();
        }
        if (newRinging != null || hasNonHangupStateChanged) {
            this.internalClearDisconnected();
        }
        this.updatePhoneState();
        if (unknownConnectionAppeared) {
            this.phone.notifyUnknownConnection();
        }
        if (hasNonHangupStateChanged || newRinging != null) {
            this.phone.notifyPreciseCallStateChanged();
        }
    }

    private void handleRadioNotAvailable() {
        this.pollCallsWhenSafe();
    }

    private void dumpState() {
        int i;
        Log.i(LOG_TAG, "Phone State:" + (Object)((Object)this.state));
        Log.i(LOG_TAG, "Ringing call: " + this.ringingCall.toString());
        List<Connection> l = this.ringingCall.getConnections();
        int s = l.size();
        for (i = 0; i < s; ++i) {
            Log.i(LOG_TAG, ((Object)l.get(i)).toString());
        }
        Log.i(LOG_TAG, "Foreground call: " + this.foregroundCall.toString());
        l = this.foregroundCall.getConnections();
        s = l.size();
        for (i = 0; i < s; ++i) {
            Log.i(LOG_TAG, ((Object)l.get(i)).toString());
        }
        Log.i(LOG_TAG, "Background call: " + this.backgroundCall.toString());
        l = this.backgroundCall.getConnections();
        s = l.size();
        for (i = 0; i < s; ++i) {
            Log.i(LOG_TAG, ((Object)l.get(i)).toString());
        }
    }

    void hangup(GsmConnection conn) throws CallStateException {
        if (conn.owner != this) {
            throw new CallStateException("GsmConnection " + conn + "does not belong to GsmCallTracker " + this);
        }
        if (conn == this.pendingMO) {
            this.log("hangup: set hangupPendingMO to true");
            this.hangupPendingMO = true;
        } else {
            try {
                this.cm.hangupConnection(conn.getGSMIndex(), this.obtainCompleteMessage());
            }
            catch (CallStateException ex) {
                Log.w(LOG_TAG, "GsmCallTracker WARN: hangup() on absent connection " + conn);
            }
        }
        conn.onHangupLocal();
    }

    void separate(GsmConnection conn) throws CallStateException {
        if (conn.owner != this) {
            throw new CallStateException("GsmConnection " + conn + "does not belong to GsmCallTracker " + this);
        }
        try {
            this.cm.separateConnection(conn.getGSMIndex(), this.obtainCompleteMessage(12));
        }
        catch (CallStateException ex) {
            Log.w(LOG_TAG, "GsmCallTracker WARN: separate() on absent connection " + conn);
        }
    }

    void setMute(boolean mute) {
        this.desiredMute = mute;
        this.cm.setMute(this.desiredMute, null);
    }

    boolean getMute() {
        return this.desiredMute;
    }

    void hangup(GsmCall call) throws CallStateException {
        if (call.getConnections().size() == 0) {
            throw new CallStateException("no connections in call");
        }
        if (call == this.ringingCall) {
            this.log("(ringing) hangup waiting or background");
            this.cm.hangupWaitingOrBackground(this.obtainCompleteMessage());
        } else if (call == this.foregroundCall) {
            if (call.isDialingOrAlerting()) {
                this.log("(foregnd) hangup dialing or alerting...");
                this.hangup((GsmConnection)call.getConnections().get(0));
            } else {
                this.hangupForegroundResumeBackground();
            }
        } else if (call == this.backgroundCall) {
            if (this.ringingCall.isRinging()) {
                this.log("hangup all conns in background call");
                this.hangupAllConnections(call);
            } else {
                this.hangupWaitingOrBackground();
            }
        } else {
            throw new RuntimeException("GsmCall " + call + "does not belong to GsmCallTracker " + this);
        }
        call.onHangupLocal();
        this.phone.notifyPreciseCallStateChanged();
    }

    void hangupWaitingOrBackground() {
        this.log("hangupWaitingOrBackground");
        this.cm.hangupWaitingOrBackground(this.obtainCompleteMessage());
    }

    void hangupForegroundResumeBackground() {
        this.log("hangupForegroundResumeBackground");
        this.cm.hangupForegroundResumeBackground(this.obtainCompleteMessage());
    }

    void hangupConnectionByIndex(GsmCall call, int index) throws CallStateException {
        int count = call.connections.size();
        for (int i = 0; i < count; ++i) {
            GsmConnection cn = (GsmConnection)call.connections.get(i);
            if (cn.getGSMIndex() != index) continue;
            this.cm.hangupConnection(index, this.obtainCompleteMessage());
            return;
        }
        throw new CallStateException("no gsm index found");
    }

    void hangupAllConnections(GsmCall call) throws CallStateException {
        try {
            int count = call.connections.size();
            for (int i = 0; i < count; ++i) {
                GsmConnection cn = (GsmConnection)call.connections.get(i);
                this.cm.hangupConnection(cn.getGSMIndex(), this.obtainCompleteMessage());
            }
        }
        catch (CallStateException ex) {
            Log.e(LOG_TAG, "hangupConnectionByIndex caught " + ex);
        }
    }

    GsmConnection getConnectionByIndex(GsmCall call, int index) throws CallStateException {
        int count = call.connections.size();
        for (int i = 0; i < count; ++i) {
            GsmConnection cn = (GsmConnection)call.connections.get(i);
            if (cn.getGSMIndex() != index) continue;
            return cn;
        }
        return null;
    }

    private Phone.SuppService getFailedService(int what) {
        switch (what) {
            case 8: {
                return Phone.SuppService.SWITCH;
            }
            case 11: {
                return Phone.SuppService.CONFERENCE;
            }
            case 12: {
                return Phone.SuppService.SEPARATE;
            }
            case 13: {
                return Phone.SuppService.TRANSFER;
            }
        }
        return Phone.SuppService.UNKNOWN;
    }

    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (msg != this.lastRelevantPoll) break;
                this.needsPoll = false;
                this.lastRelevantPoll = null;
                this.handlePollCalls((AsyncResult)msg.obj);
                break;
            }
            case 4: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.operationComplete();
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) {
                    this.phone.notifySuppServiceFailed(this.getFailedService(msg.what));
                }
                this.operationComplete();
                break;
            }
            case 5: {
                int causeCode;
                AsyncResult ar = (AsyncResult)msg.obj;
                this.operationComplete();
                if (ar.exception != null) {
                    causeCode = 16;
                    Log.i(LOG_TAG, "Exception during getLastCallFailCause, assuming normal disconnect");
                } else {
                    causeCode = ((int[])ar.result)[0];
                }
                if (causeCode == 34 || causeCode == 41 || causeCode == 42 || causeCode == 44 || causeCode == 49 || causeCode == 58 || causeCode == 65535) {
                    GsmCellLocation loc = (GsmCellLocation)this.phone.getCellLocation();
                    EventLog.writeEvent(50106, causeCode, loc != null ? loc.getCid() : -1, TelephonyManager.getDefault().getNetworkType());
                }
                int s = this.droppedDuringPoll.size();
                for (int i = 0; i < s; ++i) {
                    GsmConnection conn = this.droppedDuringPoll.get(i);
                    conn.onRemoteDisconnect(causeCode);
                }
                this.updatePhoneState();
                this.phone.notifyPreciseCallStateChanged();
                this.droppedDuringPoll.clear();
                break;
            }
            case 2: 
            case 3: {
                this.pollCallsWhenSafe();
                break;
            }
            case 9: {
                this.handleRadioAvailable();
                break;
            }
            case 10: {
                this.handleRadioNotAvailable();
            }
        }
    }

    protected void log(String msg) {
        Log.d(LOG_TAG, "[GsmCallTracker] " + msg);
    }
}

