/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.net.IConnectivityManager;
import android.net.NetworkInfo;
import android.net.TrafficStats;
import android.os.AsyncResult;
import android.os.Message;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.telephony.TelephonyManager;
import android.telephony.cdma.CdmaCellLocation;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.Log;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.DataCallState;
import com.android.internal.telephony.DataConnection;
import com.android.internal.telephony.DataConnectionTracker;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.cdma.CDMAPhone;
import com.android.internal.telephony.cdma.CdmaDataConnection;
import com.android.internal.telephony.cdma.CdmaServiceStateTracker;
import com.android.internal.telephony.gsm.ApnSetting;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CdmaDataConnectionTracker
extends DataConnectionTracker {
    protected final String LOG_TAG = "CDMA";
    private CDMAPhone mCdmaPhone;
    private boolean noAutoAttach = false;
    private boolean mIsScreenOn = true;
    boolean failNextConnect = false;
    private ArrayList<DataConnection> dataConnectionList;
    private CdmaDataConnection mActiveDataConnection;
    private boolean mPendingRestartRadio = false;
    private static final int TIME_DELAYED_TO_RESTART_RADIO = SystemProperties.getInt("ro.cdma.timetoradiorestart", 60000);
    private static final int DATA_CONNECTION_POOL_SIZE = 1;
    private static final int POLL_CONNECTION_MILLIS = 5000;
    private static final String INTENT_RECONNECT_ALARM = "com.android.internal.telephony.cdma-reconnect";
    private static final String INTENT_RECONNECT_ALARM_EXTRA_REASON = "reason";
    private static final int DATA_CONNECTION_ACTIVE_PH_LINK_INACTIVE = 0;
    private static final int DATA_CONNECTION_ACTIVE_PH_LINK_DOWN = 1;
    private static final int DATA_CONNECTION_ACTIVE_PH_LINK_UP = 2;
    private static final String[] mSupportedApnTypes = new String[]{"default", "mms", "dun", "hipri"};
    private static final String[] mDefaultApnTypes = new String[]{"default", "mms", "hipri"};
    protected ApnSetting mActiveApn;
    BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.intent.action.SCREEN_ON")) {
                CdmaDataConnectionTracker.this.mIsScreenOn = true;
                CdmaDataConnectionTracker.this.stopNetStatPoll();
                CdmaDataConnectionTracker.this.startNetStatPoll();
            } else if (action.equals("android.intent.action.SCREEN_OFF")) {
                CdmaDataConnectionTracker.this.mIsScreenOn = false;
                CdmaDataConnectionTracker.this.stopNetStatPoll();
                CdmaDataConnectionTracker.this.startNetStatPoll();
            } else if (action.equals(CdmaDataConnectionTracker.INTENT_RECONNECT_ALARM)) {
                Log.d("CDMA", "Data reconnect alarm. Previous state was " + (Object)((Object)CdmaDataConnectionTracker.this.state));
                String reason = intent.getStringExtra(CdmaDataConnectionTracker.INTENT_RECONNECT_ALARM_EXTRA_REASON);
                if (CdmaDataConnectionTracker.this.state == DataConnectionTracker.State.FAILED) {
                    CdmaDataConnectionTracker.this.cleanUpConnection(false, reason);
                }
                CdmaDataConnectionTracker.this.trySetupData(reason);
            } else if (action.equals("android.net.wifi.STATE_CHANGE")) {
                NetworkInfo networkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                CdmaDataConnectionTracker.this.mIsWifiConnected = networkInfo != null && networkInfo.isConnected();
            } else if (action.equals("android.net.wifi.WIFI_STATE_CHANGED")) {
                boolean enabled;
                boolean bl = enabled = intent.getIntExtra("wifi_state", 4) == 3;
                if (!enabled) {
                    CdmaDataConnectionTracker.this.mIsWifiConnected = false;
                }
            }
        }
    };
    private Runnable mPollNetStat = new Runnable(){

        public void run() {
            long preTxPkts = -1L;
            long preRxPkts = -1L;
            preTxPkts = CdmaDataConnectionTracker.this.txPkts;
            preRxPkts = CdmaDataConnectionTracker.this.rxPkts;
            CdmaDataConnectionTracker.this.txPkts = TrafficStats.getMobileTxPackets();
            CdmaDataConnectionTracker.this.rxPkts = TrafficStats.getMobileRxPackets();
            if (CdmaDataConnectionTracker.this.netStatPollEnabled && (preTxPkts > 0L || preRxPkts > 0L)) {
                DataConnectionTracker.Activity newActivity;
                long sent = CdmaDataConnectionTracker.this.txPkts - preTxPkts;
                long received = CdmaDataConnectionTracker.this.rxPkts - preRxPkts;
                if (sent > 0L && received > 0L) {
                    CdmaDataConnectionTracker.this.sentSinceLastRecv = 0L;
                    newActivity = DataConnectionTracker.Activity.DATAINANDOUT;
                } else if (sent > 0L && received == 0L) {
                    if (CdmaDataConnectionTracker.this.phone.getState() == Phone.State.IDLE) {
                        CdmaDataConnectionTracker.this.sentSinceLastRecv += sent;
                    } else {
                        CdmaDataConnectionTracker.this.sentSinceLastRecv = 0L;
                    }
                    newActivity = DataConnectionTracker.Activity.DATAOUT;
                } else if (sent == 0L && received > 0L) {
                    CdmaDataConnectionTracker.this.sentSinceLastRecv = 0L;
                    newActivity = DataConnectionTracker.Activity.DATAIN;
                } else if (sent == 0L && received == 0L) {
                    newActivity = CdmaDataConnectionTracker.this.activity == DataConnectionTracker.Activity.DORMANT ? CdmaDataConnectionTracker.this.activity : DataConnectionTracker.Activity.NONE;
                } else {
                    CdmaDataConnectionTracker.this.sentSinceLastRecv = 0L;
                    DataConnectionTracker.Activity activity = newActivity = CdmaDataConnectionTracker.this.activity == DataConnectionTracker.Activity.DORMANT ? CdmaDataConnectionTracker.this.activity : DataConnectionTracker.Activity.NONE;
                }
                if (CdmaDataConnectionTracker.this.activity != newActivity) {
                    CdmaDataConnectionTracker.this.activity = newActivity;
                    CdmaDataConnectionTracker.this.phone.notifyDataActivity();
                }
            }
            if (CdmaDataConnectionTracker.this.sentSinceLastRecv >= 10L) {
                if (CdmaDataConnectionTracker.this.mNoRecvPollCount == 0) {
                    EventLog.writeEvent(50101, CdmaDataConnectionTracker.this.sentSinceLastRecv);
                }
                if (CdmaDataConnectionTracker.this.mNoRecvPollCount < 24) {
                    CdmaDataConnectionTracker.this.mNoRecvPollCount++;
                    CdmaDataConnectionTracker.this.netStatPollPeriod = 5000;
                } else {
                    CdmaDataConnectionTracker.this.netStatPollEnabled = false;
                    CdmaDataConnectionTracker.this.stopNetStatPoll();
                    CdmaDataConnectionTracker.this.restartRadio();
                    EventLog.writeEvent(50102, 24);
                }
            } else {
                CdmaDataConnectionTracker.this.mNoRecvPollCount = 0;
                CdmaDataConnectionTracker.this.netStatPollPeriod = 1000;
            }
            if (CdmaDataConnectionTracker.this.netStatPollEnabled) {
                CdmaDataConnectionTracker.this.mDataConnectionTracker.postDelayed(this, CdmaDataConnectionTracker.this.netStatPollPeriod);
            }
        }
    };

    CdmaDataConnectionTracker(CDMAPhone p) {
        super(p);
        this.mCdmaPhone = p;
        p.mCM.registerForAvailable(this, 3, null);
        p.mCM.registerForOffOrNotAvailable(this, 12, null);
        p.mRuimRecords.registerForRecordsLoaded(this, 4, null);
        p.mCM.registerForNVReady(this, 31, null);
        p.mCM.registerForDataStateChanged(this, 6, null);
        p.mCT.registerForVoiceCallEnded(this, 15, null);
        p.mCT.registerForVoiceCallStarted(this, 14, null);
        p.mSST.registerForCdmaDataConnectionAttached(this, 5, null);
        p.mSST.registerForCdmaDataConnectionDetached(this, 30, null);
        p.mSST.registerForRoamingOn(this, 21, null);
        p.mSST.registerForRoamingOff(this, 22, null);
        p.mCM.registerForCdmaOtaProvision(this, 35, null);
        IntentFilter filter = new IntentFilter();
        filter.addAction(INTENT_RECONNECT_ALARM);
        filter.addAction("android.intent.action.SCREEN_ON");
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction("android.net.wifi.STATE_CHANGE");
        filter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
        p.getContext().registerReceiver(this.mIntentReceiver, filter, null, p);
        this.mDataConnectionTracker = this;
        this.createAllDataConnectionList();
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.phone.getContext());
        boolean dataEnabledSetting = true;
        try {
            dataEnabledSetting = IConnectivityManager.Stub.asInterface(ServiceManager.getService("connectivity")).getMobileDataEnabled();
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean bl = this.dataEnabled[0] = !sp.getBoolean("disabled_on_boot_key", false) && dataEnabledSetting;
        if (this.dataEnabled[0]) {
            ++this.enabledCount;
        }
        boolean bl2 = this.noAutoAttach = !this.dataEnabled[0];
        if (!this.mRetryMgr.configure(SystemProperties.get("ro.cdma.data_retry_config")) && !this.mRetryMgr.configure("default_randomization=2000,5000,10000,20000,40000,80000:5000,160000:5000,320000:5000,640000:5000,1280000:5000,1800000:5000")) {
            Log.e("CDMA", "Could not configure using DEFAULT_DATA_RETRY_CONFIG=default_randomization=2000,5000,10000,20000,40000,80000:5000,160000:5000,320000:5000,640000:5000,1280000:5000,1800000:5000");
            this.mRetryMgr.configure(20, 2000, 1000);
        }
    }

    @Override
    public void dispose() {
        this.phone.mCM.unregisterForAvailable(this);
        this.phone.mCM.unregisterForOffOrNotAvailable(this);
        this.mCdmaPhone.mRuimRecords.unregisterForRecordsLoaded(this);
        this.phone.mCM.unregisterForNVReady(this);
        this.phone.mCM.unregisterForDataStateChanged(this);
        this.mCdmaPhone.mCT.unregisterForVoiceCallEnded(this);
        this.mCdmaPhone.mCT.unregisterForVoiceCallStarted(this);
        this.mCdmaPhone.mSST.unregisterForCdmaDataConnectionAttached(this);
        this.mCdmaPhone.mSST.unregisterForCdmaDataConnectionDetached(this);
        this.mCdmaPhone.mSST.unregisterForRoamingOn(this);
        this.mCdmaPhone.mSST.unregisterForRoamingOff(this);
        this.phone.mCM.unregisterForCdmaOtaProvision(this);
        this.phone.getContext().unregisterReceiver(this.mIntentReceiver);
        this.destroyAllDataConnectionList();
    }

    protected void finalize() {
    }

    @Override
    protected void setState(DataConnectionTracker.State s) {
        if (this.state != s) {
            EventLog.writeEvent(50115, this.state.toString(), s.toString());
            this.state = s;
        }
    }

    @Override
    protected boolean isApnTypeActive(String type) {
        return this.mActiveApn != null && this.mActiveApn.canHandleType(type);
    }

    @Override
    protected boolean isApnTypeAvailable(String type) {
        for (String s : mSupportedApnTypes) {
            if (!TextUtils.equals(type, s)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String[] getActiveApnTypes() {
        String[] result = this.mActiveApn != null ? this.mActiveApn.types : new String[]{"default"};
        return result;
    }

    @Override
    protected String getActiveApnString() {
        return null;
    }

    @Override
    public boolean isDataConnectionAsDesired() {
        boolean roaming = this.phone.getServiceState().getRoaming();
        if (!(this.phone.mCM.getRadioState() != CommandsInterface.RadioState.NV_READY && !this.mCdmaPhone.mRuimRecords.getRecordsLoaded() || this.mCdmaPhone.mSST.getCurrentCdmaDataConnectionState() != 0 || roaming && !this.getDataOnRoamingEnabled() || this.mIsWifiConnected)) {
            return this.state == DataConnectionTracker.State.CONNECTED;
        }
        return true;
    }

    private boolean isDataAllowed() {
        boolean roaming = this.phone.getServiceState().getRoaming();
        return this.getAnyDataEnabled() && (!roaming || this.getDataOnRoamingEnabled()) && this.mMasterDataEnabled;
    }

    private boolean trySetupData(String reason) {
        if (this.phone.getSimulatedRadioControl() != null) {
            this.setState(DataConnectionTracker.State.CONNECTED);
            this.phone.notifyDataConnection(reason);
            Log.i("CDMA", "(fix?) We're on the simulator; assuming data is connected");
            return true;
        }
        int psState = this.mCdmaPhone.mSST.getCurrentCdmaDataConnectionState();
        boolean roaming = this.phone.getServiceState().getRoaming();
        boolean desiredPowerState = this.mCdmaPhone.mSST.getDesiredPowerState();
        if (!(this.state != DataConnectionTracker.State.IDLE && this.state != DataConnectionTracker.State.SCANNING || psState != 0 || this.phone.mCM.getRadioState() != CommandsInterface.RadioState.NV_READY && !this.mCdmaPhone.mRuimRecords.getRecordsLoaded() || !this.mCdmaPhone.mSST.isConcurrentVoiceAndData() && this.phone.getState() != Phone.State.IDLE || !this.isDataAllowed() || !desiredPowerState || this.mPendingRestartRadio || this.mCdmaPhone.needsOtaServiceProvisioning())) {
            return this.setupData(reason);
        }
        return false;
    }

    private void cleanUpConnection(boolean tearDown, String reason) {
        if (this.mReconnectIntent != null) {
            AlarmManager am = (AlarmManager)this.phone.getContext().getSystemService("alarm");
            am.cancel(this.mReconnectIntent);
            this.mReconnectIntent = null;
        }
        this.setState(DataConnectionTracker.State.DISCONNECTING);
        boolean notificationDeferred = false;
        for (DataConnection conn : this.dataConnectionList) {
            if (conn == null) continue;
            if (tearDown) {
                conn.disconnect(this.obtainMessage(25, reason));
                notificationDeferred = true;
                continue;
            }
            conn.resetSynchronously();
            notificationDeferred = false;
        }
        this.stopNetStatPoll();
        if (!notificationDeferred) {
            this.gotoIdleAndNotifyDataConnection(reason);
        }
    }

    private CdmaDataConnection findFreeDataConnection() {
        for (DataConnection connBase : this.dataConnectionList) {
            CdmaDataConnection conn = (CdmaDataConnection)connBase;
            if (!conn.isInactive()) continue;
            return conn;
        }
        return null;
    }

    private boolean setupData(String reason) {
        CdmaDataConnection conn = this.findFreeDataConnection();
        if (conn == null) {
            return false;
        }
        this.mActiveDataConnection = conn;
        String[] types = this.mRequestedApnType.equals("dun") ? new String[]{"dun"} : mDefaultApnTypes;
        this.mActiveApn = new ApnSetting(0, "", "", "", "", "", "", "", "", "", "", 0, types, "IP", "IP");
        Message msg = this.obtainMessage();
        msg.what = 1;
        msg.obj = reason;
        conn.connect(msg, this.mActiveApn);
        this.setState(DataConnectionTracker.State.INITING);
        this.phone.notifyDataConnection(reason);
        return true;
    }

    private void notifyDefaultData(String reason) {
        this.setState(DataConnectionTracker.State.CONNECTED);
        this.phone.notifyDataConnection(reason);
        this.startNetStatPoll();
        this.mRetryMgr.resetRetryCount();
    }

    private void resetPollStats() {
        this.txPkts = -1L;
        this.rxPkts = -1L;
        this.sentSinceLastRecv = 0L;
        this.netStatPollPeriod = 1000;
        this.mNoRecvPollCount = 0;
    }

    @Override
    protected void startNetStatPoll() {
        if (this.state == DataConnectionTracker.State.CONNECTED && !this.netStatPollEnabled) {
            Log.d("CDMA", "[DataConnection] Start poll NetStat");
            this.resetPollStats();
            this.netStatPollEnabled = true;
            this.mPollNetStat.run();
        }
    }

    @Override
    protected void stopNetStatPoll() {
        this.netStatPollEnabled = false;
        this.removeCallbacks(this.mPollNetStat);
        Log.d("CDMA", "[DataConnection] Stop poll NetStat");
    }

    @Override
    protected void restartRadio() {
        this.cleanUpConnection(true, "radioTurnedOff");
        this.sendEmptyMessageDelayed(36, TIME_DELAYED_TO_RESTART_RADIO);
        this.mPendingRestartRadio = true;
    }

    private boolean shouldPostNotification(DataConnection.FailCause cause) {
        return cause != DataConnection.FailCause.UNKNOWN;
    }

    private boolean retryAfterDisconnected(String reason) {
        boolean retry = true;
        if ("radioTurnedOff".equals(reason)) {
            retry = false;
        }
        return retry;
    }

    private void reconnectAfterFail(DataConnection.FailCause lastFailCauseCode, String reason) {
        if (this.state == DataConnectionTracker.State.FAILED) {
            int nextReconnectDelay = this.mRetryMgr.getRetryTimer();
            Log.d("CDMA", "Data Connection activate failed. Scheduling next attempt for " + nextReconnectDelay / 1000 + "s");
            AlarmManager am = (AlarmManager)this.phone.getContext().getSystemService("alarm");
            Intent intent = new Intent(INTENT_RECONNECT_ALARM);
            intent.putExtra(INTENT_RECONNECT_ALARM_EXTRA_REASON, reason);
            this.mReconnectIntent = PendingIntent.getBroadcast(this.phone.getContext(), 0, intent, 0);
            am.set(2, SystemClock.elapsedRealtime() + (long)nextReconnectDelay, this.mReconnectIntent);
            this.mRetryMgr.increaseRetryCount();
            if (!this.shouldPostNotification(lastFailCauseCode)) {
                Log.d("CDMA", "NOT Posting Data Connection Unavailable notification -- likely transient error");
            } else {
                this.notifyNoData(lastFailCauseCode);
            }
        }
    }

    private void notifyNoData(DataConnection.FailCause lastFailCauseCode) {
        this.setState(DataConnectionTracker.State.FAILED);
    }

    private void gotoIdleAndNotifyDataConnection(String reason) {
        this.setState(DataConnectionTracker.State.IDLE);
        this.phone.notifyDataConnection(reason);
        this.mActiveApn = null;
    }

    protected void onRecordsLoaded() {
        if (this.state == DataConnectionTracker.State.FAILED) {
            this.cleanUpConnection(false, null);
        }
        this.sendMessage(this.obtainMessage(5, "simLoaded"));
    }

    protected void onNVReady() {
        if (this.state == DataConnectionTracker.State.FAILED) {
            this.cleanUpConnection(false, null);
        }
        this.sendMessage(this.obtainMessage(5));
    }

    @Override
    protected void onEnableNewApn() {
        this.cleanUpConnection(true, "apnSwitched");
    }

    @Override
    protected boolean onTrySetupData(String reason) {
        return this.trySetupData(reason);
    }

    @Override
    protected void onRoamingOff() {
        this.trySetupData("roamingOff");
    }

    @Override
    protected void onRoamingOn() {
        if (this.getDataOnRoamingEnabled()) {
            this.trySetupData("roamingOn");
        } else {
            this.cleanUpConnection(true, "roamingOn");
        }
    }

    @Override
    protected void onRadioAvailable() {
        if (this.phone.getSimulatedRadioControl() != null) {
            this.setState(DataConnectionTracker.State.CONNECTED);
            this.phone.notifyDataConnection(null);
            Log.i("CDMA", "We're on the simulator; assuming data is connected");
        }
        if (this.state != DataConnectionTracker.State.IDLE) {
            this.cleanUpConnection(true, null);
        }
    }

    @Override
    protected void onRadioOffOrNotAvailable() {
        this.mRetryMgr.resetRetryCount();
        if (this.phone.getSimulatedRadioControl() != null) {
            Log.i("CDMA", "We're on the simulator; assuming radio off is meaningless");
        } else {
            this.cleanUpConnection(false, "radioTurnedOff");
        }
    }

    @Override
    protected void onDataSetupComplete(AsyncResult ar) {
        String reason = null;
        if (ar.userObj instanceof String) {
            reason = (String)ar.userObj;
        }
        if (ar.exception == null) {
            this.notifyDefaultData(reason);
        } else {
            DataConnection.FailCause cause = (DataConnection.FailCause)((Object)ar.result);
            if (cause.isPermanentFail()) {
                this.notifyNoData(cause);
                return;
            }
            this.startDelayedRetry(cause, reason);
        }
    }

    @Override
    protected void onDisconnectDone(AsyncResult ar) {
        CdmaServiceStateTracker ssTracker;
        String reason = null;
        if (ar.userObj instanceof String) {
            reason = (String)ar.userObj;
        }
        this.setState(DataConnectionTracker.State.IDLE);
        if (this.mPendingRestartRadio) {
            this.removeMessages(36);
        }
        if ((ssTracker = this.mCdmaPhone.mSST).processPendingRadioPowerOffAfterDataOff()) {
            this.mPendingRestartRadio = false;
        } else {
            this.onRestartRadio();
        }
        this.phone.notifyDataConnection(reason);
        this.mActiveApn = null;
        if (this.retryAfterDisconnected(reason)) {
            this.trySetupData(reason);
        }
    }

    @Override
    protected void onResetDone(AsyncResult ar) {
        String reason = null;
        if (ar.userObj instanceof String) {
            reason = (String)ar.userObj;
        }
        this.gotoIdleAndNotifyDataConnection(reason);
    }

    @Override
    protected void onVoiceCallStarted() {
        if (this.state == DataConnectionTracker.State.CONNECTED && !this.mCdmaPhone.mSST.isConcurrentVoiceAndData()) {
            this.stopNetStatPoll();
            this.phone.notifyDataConnection("2GVoiceCallStarted");
        }
    }

    @Override
    protected void onVoiceCallEnded() {
        if (this.state == DataConnectionTracker.State.CONNECTED) {
            if (!this.mCdmaPhone.mSST.isConcurrentVoiceAndData()) {
                this.startNetStatPoll();
                this.phone.notifyDataConnection("2GVoiceCallEnded");
            } else {
                this.resetPollStats();
            }
        } else {
            this.mRetryMgr.resetRetryCount();
            this.trySetupData("2GVoiceCallEnded");
        }
    }

    @Override
    protected void onCleanUpConnection(boolean tearDown, String reason) {
        this.cleanUpConnection(tearDown, reason);
    }

    private void createAllDataConnectionList() {
        this.dataConnectionList = new ArrayList();
        for (int i = 0; i < 1; ++i) {
            CdmaDataConnection dataConn = CdmaDataConnection.makeDataConnection(this.mCdmaPhone);
            this.dataConnectionList.add(dataConn);
        }
    }

    private void destroyAllDataConnectionList() {
        if (this.dataConnectionList != null) {
            this.dataConnectionList.removeAll(this.dataConnectionList);
        }
    }

    private void onCdmaDataDetached() {
        if (this.state == DataConnectionTracker.State.CONNECTED) {
            this.startNetStatPoll();
            this.phone.notifyDataConnection("cdmaDataDetached");
        } else {
            if (this.state == DataConnectionTracker.State.FAILED) {
                this.cleanUpConnection(false, "cdmaDataDetached");
                this.mRetryMgr.resetRetryCount();
                CdmaCellLocation loc = (CdmaCellLocation)this.phone.getCellLocation();
                EventLog.writeEvent(50110, loc != null ? loc.getBaseStationId() : -1, TelephonyManager.getDefault().getNetworkType());
            }
            this.trySetupData("cdmaDataDetached");
        }
    }

    private void onCdmaOtaProvision(AsyncResult ar) {
        int[] otaPrivision;
        if (ar.exception != null && (otaPrivision = (int[])ar.result) != null && otaPrivision.length > 1) {
            switch (otaPrivision[0]) {
                case 8: 
                case 10: {
                    this.mRetryMgr.resetRetryCount();
                    break;
                }
            }
        }
    }

    private void onRestartRadio() {
        if (this.mPendingRestartRadio) {
            Log.d("CDMA", "************TURN OFF RADIO**************");
            this.phone.mCM.setRadioPower(false, null);
            this.mPendingRestartRadio = false;
        }
    }

    private void writeEventLogCdmaDataDrop() {
        CdmaCellLocation loc = (CdmaCellLocation)this.phone.getCellLocation();
        EventLog.writeEvent(50111, loc != null ? loc.getBaseStationId() : -1, TelephonyManager.getDefault().getNetworkType());
    }

    protected void onDataStateChanged(AsyncResult ar) {
        ArrayList dataCallStates = (ArrayList)ar.result;
        if (ar.exception != null) {
            return;
        }
        if (this.state == DataConnectionTracker.State.CONNECTED) {
            boolean isActiveOrDormantConnectionPresent = false;
            int connectionState = 0;
            for (int index = 0; index < dataCallStates.size(); ++index) {
                connectionState = ((DataCallState)dataCallStates.get((int)index)).active;
                if (connectionState == 0) continue;
                isActiveOrDormantConnectionPresent = true;
                break;
            }
            if (!isActiveOrDormantConnectionPresent) {
                Log.i("CDMA", "onDataStateChanged: No active connectionstate is CONNECTED, disconnecting/cleanup");
                this.writeEventLogCdmaDataDrop();
                this.cleanUpConnection(true, null);
                return;
            }
            switch (connectionState) {
                case 2: {
                    Log.v("CDMA", "onDataStateChanged: active=LINK_ACTIVE && CONNECTED, ignore");
                    this.activity = DataConnectionTracker.Activity.NONE;
                    this.phone.notifyDataActivity();
                    this.startNetStatPoll();
                    break;
                }
                case 1: {
                    Log.v("CDMA", "onDataStateChanged active=LINK_DOWN && CONNECTED, dormant");
                    this.activity = DataConnectionTracker.Activity.DORMANT;
                    this.phone.notifyDataActivity();
                    this.stopNetStatPoll();
                    break;
                }
                default: {
                    Log.v("CDMA", "onDataStateChanged: IGNORE unexpected DataCallState.active=" + connectionState);
                    break;
                }
            }
        } else {
            Log.i("CDMA", "onDataStateChanged: not connected, state=" + (Object)((Object)this.state) + " ignoring");
        }
    }

    @Override
    protected String getInterfaceName(String apnType) {
        if (this.mActiveDataConnection != null) {
            return this.mActiveDataConnection.getInterface();
        }
        return null;
    }

    @Override
    protected String getIpAddress(String apnType) {
        if (this.mActiveDataConnection != null) {
            return this.mActiveDataConnection.getIpAddress();
        }
        return null;
    }

    @Override
    protected String getGateway(String apnType) {
        if (this.mActiveDataConnection != null) {
            return this.mActiveDataConnection.getGatewayAddress();
        }
        return null;
    }

    @Override
    protected String[] getDnsServers(String apnType) {
        if (this.mActiveDataConnection != null) {
            return this.mActiveDataConnection.getDnsServers();
        }
        return null;
    }

    @Override
    public ArrayList<DataConnection> getAllDataConnections() {
        return this.dataConnectionList;
    }

    private void startDelayedRetry(DataConnection.FailCause cause, String reason) {
        this.notifyNoData(cause);
        this.reconnectAfterFail(cause, reason);
    }

    @Override
    public void handleMessage(Message msg) {
        if (!this.phone.mIsTheCurrentActivePhone) {
            Log.d("CDMA", "Ignore CDMA msgs since CDMA phone is inactive");
            return;
        }
        switch (msg.what) {
            case 4: {
                this.onRecordsLoaded();
                break;
            }
            case 31: {
                this.onNVReady();
                break;
            }
            case 30: {
                this.onCdmaDataDetached();
                break;
            }
            case 6: {
                this.onDataStateChanged((AsyncResult)msg.obj);
                break;
            }
            case 35: {
                this.onCdmaOtaProvision((AsyncResult)msg.obj);
                break;
            }
            case 36: {
                this.onRestartRadio();
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    @Override
    protected void log(String s) {
        Log.d("CDMA", "[CdmaDataConnectionTracker] " + s);
    }
}

