/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.content.Intent;
import android.util.Log;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.SMSDispatcher;
import com.android.internal.telephony.WspTypeDecoder;

public class WapPushOverSms {
    private static final String LOG_TAG = "WAP PUSH";
    private final Context mContext;
    private WspTypeDecoder pduDecoder;
    private SMSDispatcher mSmsDispatcher;
    private final int WAKE_LOCK_TIMEOUT = 5000;

    public WapPushOverSms(Phone phone, SMSDispatcher smsDispatcher) {
        this.mSmsDispatcher = smsDispatcher;
        this.mContext = phone.getContext();
    }

    public int dispatchWapPdu(byte[] pdu) {
        int binaryContentType;
        String mimeType;
        int headerStartIndex;
        int headerLength;
        int pduType;
        int transactionId;
        block38: {
            block37: {
                Log.d(LOG_TAG, "Rx: " + IccUtils.bytesToHexString(pdu));
                int index = 0;
                transactionId = pdu[index++] & 0xFF;
                pduType = pdu[index++] & 0xFF;
                headerLength = 0;
                if (pduType != 6 && pduType != 7) {
                    Log.w(LOG_TAG, "Received non-PUSH WAP PDU. Type = " + pduType);
                    return 1;
                }
                this.pduDecoder = new WspTypeDecoder(pdu);
                if (!this.pduDecoder.decodeUintvarInteger(index)) {
                    Log.w(LOG_TAG, "Received PDU. Header Length error.");
                    return 2;
                }
                headerLength = (int)this.pduDecoder.getValue32();
                headerStartIndex = index += this.pduDecoder.getDecodedDataLength();
                if (!this.pduDecoder.decodeContentType(index)) {
                    Log.w(LOG_TAG, "Received PDU. Header Content-Type error.");
                    return 2;
                }
                mimeType = this.pduDecoder.getValueString();
                if (mimeType != null) break block37;
                binaryContentType = (int)this.pduDecoder.getValue32();
                switch (binaryContentType) {
                    case 74: {
                        mimeType = "application/vnd.oma.drm.rights+xml";
                        break block38;
                    }
                    case 75: {
                        mimeType = "application/vnd.oma.drm.rights+wbxml";
                        break block38;
                    }
                    case 46: {
                        mimeType = "application/vnd.wap.sic";
                        break block38;
                    }
                    case 48: {
                        mimeType = "application/vnd.wap.slc";
                        break block38;
                    }
                    case 50: {
                        mimeType = "application/vnd.wap.coc";
                        break block38;
                    }
                    case 62: {
                        mimeType = "application/vnd.wap.mms-message";
                        break block38;
                    }
                    case 784: {
                        mimeType = "application/vnd.docomo.pf";
                        break block38;
                    }
                    case 786: {
                        mimeType = "application/vnd.omaloc-supl-init";
                        break block38;
                    }
                    case 68: {
                        mimeType = "application/vnd.syncml.notification";
                        break block38;
                    }
                    default: {
                        Log.w(LOG_TAG, "Received PDU. Unsupported Content-Type = " + binaryContentType);
                        return 1;
                    }
                }
            }
            if (mimeType.equals("application/vnd.oma.drm.rights+xml")) {
                binaryContentType = 74;
            } else if (mimeType.equals("application/vnd.oma.drm.rights+wbxml")) {
                binaryContentType = 75;
            } else if (mimeType.equals("application/vnd.wap.sic")) {
                binaryContentType = 46;
            } else if (mimeType.equals("application/vnd.wap.slc")) {
                binaryContentType = 48;
            } else if (mimeType.equals("application/vnd.wap.coc")) {
                binaryContentType = 50;
            } else if (mimeType.equals("application/vnd.wap.mms-message")) {
                binaryContentType = 62;
            } else if (mimeType.equals("application/vnd.docomo.pf")) {
                binaryContentType = 784;
            } else if (mimeType.equals("application/vnd.omaloc-supl-init")) {
                binaryContentType = 786;
            } else if (mimeType.equals("application/vnd.syncml.notification")) {
                binaryContentType = 68;
            } else {
                Log.w(LOG_TAG, "Received PDU. Unknown Content-Type = " + mimeType);
                return 1;
            }
        }
        index += this.pduDecoder.getDecodedDataLength();
        boolean dispatchedByApplication = false;
        switch (binaryContentType) {
            case 50: {
                this.dispatchWapPdu_PushCO(pdu, transactionId, pduType, headerStartIndex, headerLength);
                dispatchedByApplication = true;
                break;
            }
            case 62: {
                this.dispatchWapPdu_MMS(pdu, transactionId, pduType, headerStartIndex, headerLength);
                dispatchedByApplication = true;
                break;
            }
        }
        if (!dispatchedByApplication) {
            this.dispatchWapPdu_default(pdu, transactionId, pduType, mimeType, headerStartIndex, headerLength);
        }
        return -1;
    }

    private void dispatchWapPdu_default(byte[] pdu, int transactionId, int pduType, String mimeType, int headerStartIndex, int headerLength) {
        byte[] header = new byte[headerLength];
        System.arraycopy(pdu, headerStartIndex, header, 0, header.length);
        int dataIndex = headerStartIndex + headerLength;
        byte[] data = new byte[pdu.length - dataIndex];
        System.arraycopy(pdu, dataIndex, data, 0, data.length);
        Intent intent = new Intent("android.provider.Telephony.WAP_PUSH_RECEIVED");
        intent.setType(mimeType);
        intent.putExtra("transactionId", transactionId);
        intent.putExtra("pduType", pduType);
        intent.putExtra("header", header);
        intent.putExtra("data", data);
        this.mSmsDispatcher.dispatch(intent, "android.permission.RECEIVE_WAP_PUSH");
    }

    private void dispatchWapPdu_PushCO(byte[] pdu, int transactionId, int pduType, int headerStartIndex, int headerLength) {
        byte[] header = new byte[headerLength];
        System.arraycopy(pdu, headerStartIndex, header, 0, header.length);
        Intent intent = new Intent("android.provider.Telephony.WAP_PUSH_RECEIVED");
        intent.setType("application/vnd.wap.coc");
        intent.putExtra("transactionId", transactionId);
        intent.putExtra("pduType", pduType);
        intent.putExtra("header", header);
        intent.putExtra("data", pdu);
        this.mSmsDispatcher.dispatch(intent, "android.permission.RECEIVE_WAP_PUSH");
    }

    private void dispatchWapPdu_MMS(byte[] pdu, int transactionId, int pduType, int headerStartIndex, int headerLength) {
        byte[] header = new byte[headerLength];
        System.arraycopy(pdu, headerStartIndex, header, 0, header.length);
        int dataIndex = headerStartIndex + headerLength;
        byte[] data = new byte[pdu.length - dataIndex];
        System.arraycopy(pdu, dataIndex, data, 0, data.length);
        Intent intent = new Intent("android.provider.Telephony.WAP_PUSH_RECEIVED");
        intent.setType("application/vnd.wap.mms-message");
        intent.putExtra("transactionId", transactionId);
        intent.putExtra("pduType", pduType);
        intent.putExtra("header", header);
        intent.putExtra("data", data);
        this.mSmsDispatcher.dispatch(intent, "android.permission.RECEIVE_MMS");
    }
}

