/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.net.Uri;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.AdnRecord;
import com.android.internal.telephony.ArrayListCursor;
import com.android.internal.telephony.IIccPhoneBook;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IccProvider
extends ContentProvider {
    private static final String TAG = "IccProvider";
    private static final boolean DBG = false;
    private static final String[] ADDRESS_BOOK_COLUMN_NAMES = new String[]{"name", "number", "emails"};
    private static final int ADN = 1;
    private static final int FDN = 2;
    private static final int SDN = 3;
    private static final String STR_TAG = "tag";
    private static final String STR_NUMBER = "number";
    private static final String STR_EMAILS = "emails";
    private static final String STR_PIN2 = "pin2";
    private static final UriMatcher URL_MATCHER = new UriMatcher(-1);
    private boolean mSimulator;

    @Override
    public boolean onCreate() {
        String device = SystemProperties.get("ro.product.device");
        this.mSimulator = TextUtils.isEmpty(device);
        return true;
    }

    @Override
    public Cursor query(Uri url, String[] projection, String selection, String[] selectionArgs, String sort) {
        ArrayList<ArrayList> results;
        block6: {
            block5: {
                if (this.mSimulator) break block5;
                switch (URL_MATCHER.match(url)) {
                    case 1: {
                        results = this.loadFromEf(28474);
                        break block6;
                    }
                    case 2: {
                        results = this.loadFromEf(28475);
                        break block6;
                    }
                    case 3: {
                        results = this.loadFromEf(28489);
                        break block6;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown URL " + url);
                    }
                }
            }
            results = new ArrayList(4);
            ArrayList<String> contact = new ArrayList<String>();
            contact.add("Ron Stevens/H");
            contact.add("512-555-5038");
            results.add(contact);
            contact = new ArrayList();
            contact.add("Ron Stevens/M");
            contact.add("512-555-8305");
            results.add(contact);
            contact = new ArrayList();
            contact.add("Melissa Owens");
            contact.add("512-555-8305");
            results.add(contact);
            contact = new ArrayList();
            contact.add("Directory Assistence");
            contact.add("411");
            results.add(contact);
        }
        return new ArrayListCursor(ADDRESS_BOOK_COLUMN_NAMES, results);
    }

    @Override
    public String getType(Uri url) {
        switch (URL_MATCHER.match(url)) {
            case 1: 
            case 2: 
            case 3: {
                return "vnd.android.cursor.dir/sim-contact";
            }
        }
        throw new IllegalArgumentException("Unknown URL " + url);
    }

    @Override
    public Uri insert(Uri url, ContentValues initialValues) {
        int efType;
        String pin2 = null;
        int match = URL_MATCHER.match(url);
        switch (match) {
            case 1: {
                efType = 28474;
                break;
            }
            case 2: {
                efType = 28475;
                pin2 = initialValues.getAsString(STR_PIN2);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot insert into URL: " + url);
            }
        }
        String tag = initialValues.getAsString(STR_TAG);
        String number = initialValues.getAsString(STR_NUMBER);
        boolean success = this.addIccRecordToEf(efType, tag, number, null, pin2);
        if (!success) {
            return null;
        }
        StringBuilder buf = new StringBuilder("content://icc/");
        switch (match) {
            case 1: {
                buf.append("adn/");
                break;
            }
            case 2: {
                buf.append("fdn/");
            }
        }
        buf.append(0);
        Uri resultUri = Uri.parse(buf.toString());
        return resultUri;
    }

    private String normalizeValue(String inVal) {
        int len = inVal.length();
        String retVal = inVal;
        if (inVal.charAt(0) == '\'' && inVal.charAt(len - 1) == '\'') {
            retVal = inVal.substring(1, len - 1);
        }
        return retVal;
    }

    @Override
    public int delete(Uri url, String where, String[] whereArgs) {
        int efType;
        int match = URL_MATCHER.match(url);
        switch (match) {
            case 1: {
                efType = 28474;
                break;
            }
            case 2: {
                efType = 28475;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot insert into URL: " + url);
            }
        }
        String tag = null;
        String number = null;
        Object emails = null;
        String pin2 = null;
        String[] tokens = where.split("AND");
        int n = tokens.length;
        while (--n >= 0) {
            String param = tokens[n];
            String[] pair = param.split("=");
            if (pair.length != 2) {
                Log.e(TAG, "resolve: bad whereClause parameter: " + param);
                continue;
            }
            String key = pair[0].trim();
            String val = pair[1].trim();
            if (STR_TAG.equals(key)) {
                tag = this.normalizeValue(val);
                continue;
            }
            if (STR_NUMBER.equals(key)) {
                number = this.normalizeValue(val);
                continue;
            }
            if (STR_EMAILS.equals(key)) {
                emails = null;
                continue;
            }
            if (!STR_PIN2.equals(key)) continue;
            pin2 = this.normalizeValue(val);
        }
        if (TextUtils.isEmpty(number)) {
            return 0;
        }
        if (efType == 28475 && TextUtils.isEmpty(pin2)) {
            return 0;
        }
        boolean success = this.deleteIccRecordFromEf(efType, tag, number, emails, pin2);
        if (!success) {
            return 0;
        }
        return 1;
    }

    @Override
    public int update(Uri url, ContentValues values, String where, String[] whereArgs) {
        int efType;
        String pin2 = null;
        int match = URL_MATCHER.match(url);
        switch (match) {
            case 1: {
                efType = 28474;
                break;
            }
            case 2: {
                efType = 28475;
                pin2 = values.getAsString(STR_PIN2);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot insert into URL: " + url);
            }
        }
        String tag = values.getAsString(STR_TAG);
        String number = values.getAsString(STR_NUMBER);
        Object emails = null;
        String newTag = values.getAsString("newTag");
        String newNumber = values.getAsString("newNumber");
        Object newEmails = null;
        boolean success = this.updateIccRecordInEf(efType, tag, number, newTag, newNumber, pin2);
        if (!success) {
            return 0;
        }
        return 1;
    }

    private ArrayList<ArrayList> loadFromEf(int efType) {
        ArrayList<ArrayList> results = new ArrayList<ArrayList>();
        List<AdnRecord> adnRecords = null;
        try {
            IIccPhoneBook iccIpb = IIccPhoneBook.Stub.asInterface(ServiceManager.getService("simphonebook"));
            if (iccIpb != null) {
                adnRecords = iccIpb.getAdnRecordsInEf(efType);
            }
        }
        catch (RemoteException ex) {
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        if (adnRecords != null) {
            int N = adnRecords.size();
            for (int i = 0; i < N; ++i) {
                this.loadRecord(adnRecords.get(i), results);
            }
        } else {
            Log.w(TAG, "Cannot load ADN records");
            results.clear();
        }
        return results;
    }

    private boolean addIccRecordToEf(int efType, String name, String number, String[] emails, String pin2) {
        boolean success = false;
        try {
            IIccPhoneBook iccIpb = IIccPhoneBook.Stub.asInterface(ServiceManager.getService("simphonebook"));
            if (iccIpb != null) {
                success = iccIpb.updateAdnRecordsInEfBySearch(efType, "", "", name, number, pin2);
            }
        }
        catch (RemoteException ex) {
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        return success;
    }

    private boolean updateIccRecordInEf(int efType, String oldName, String oldNumber, String newName, String newNumber, String pin2) {
        boolean success = false;
        try {
            IIccPhoneBook iccIpb = IIccPhoneBook.Stub.asInterface(ServiceManager.getService("simphonebook"));
            if (iccIpb != null) {
                success = iccIpb.updateAdnRecordsInEfBySearch(efType, oldName, oldNumber, newName, newNumber, pin2);
            }
        }
        catch (RemoteException ex) {
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        return success;
    }

    private boolean deleteIccRecordFromEf(int efType, String name, String number, String[] emails, String pin2) {
        boolean success = false;
        try {
            IIccPhoneBook iccIpb = IIccPhoneBook.Stub.asInterface(ServiceManager.getService("simphonebook"));
            if (iccIpb != null) {
                success = iccIpb.updateAdnRecordsInEfBySearch(efType, name, number, "", "", pin2);
            }
        }
        catch (RemoteException ex) {
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        return success;
    }

    private void loadRecord(AdnRecord record, ArrayList<ArrayList> results) {
        if (!record.isEmpty()) {
            ArrayList<String> contact = new ArrayList<String>();
            String alphaTag = record.getAlphaTag();
            String number = record.getNumber();
            String[] emails = record.getEmails();
            contact.add(alphaTag);
            contact.add(number);
            StringBuilder emailString = new StringBuilder();
            if (emails != null) {
                for (String email : emails) {
                    emailString.append(email);
                    emailString.append(",");
                }
                contact.add(emailString.toString());
            } else {
                contact.add(null);
            }
            results.add(contact);
        }
    }

    private void log(String msg) {
        Log.d(TAG, "[IccProvider] " + msg);
    }

    static {
        URL_MATCHER.addURI("icc", "adn", 1);
        URL_MATCHER.addURI("icc", "fdn", 2);
        URL_MATCHER.addURI("icc", "sdn", 3);
    }
}

