/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.service.wallpaper;

import android.app.WallpaperManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.os.HandlerThread;
import android.os.Looper;
import android.service.wallpaper.WallpaperService;
import android.util.Log;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import com.android.internal.view.WindowManagerPolicyThread;

public class ImageWallpaper
extends WallpaperService {
    WallpaperManager mWallpaperManager;
    private HandlerThread mThread;

    public void onCreate() {
        super.onCreate();
        this.mWallpaperManager = (WallpaperManager)this.getSystemService("wallpaper");
        Looper looper = WindowManagerPolicyThread.getLooper();
        if (looper != null) {
            this.setCallbackLooper(looper);
        } else {
            this.mThread = new HandlerThread("Wallpaper", -2);
            this.mThread.start();
            this.setCallbackLooper(this.mThread.getLooper());
        }
    }

    public WallpaperService.Engine onCreateEngine() {
        return new DrawableEngine();
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mThread != null) {
            this.mThread.quit();
        }
    }

    class DrawableEngine
    extends WallpaperService.Engine {
        private final Object mLock = new Object();
        private WallpaperObserver mReceiver;
        Drawable mBackground;
        float mXOffset;
        float mYOffset;

        DrawableEngine() {
        }

        public void onCreate(SurfaceHolder surfaceHolder) {
            super.onCreate(surfaceHolder);
            IntentFilter filter = new IntentFilter("android.intent.action.WALLPAPER_CHANGED");
            this.mReceiver = new WallpaperObserver();
            ImageWallpaper.this.registerReceiver(this.mReceiver, filter);
            this.updateWallpaper();
            surfaceHolder.setSizeFromLayout();
        }

        public void onDestroy() {
            super.onDestroy();
            ImageWallpaper.this.unregisterReceiver(this.mReceiver);
        }

        public void onVisibilityChanged(boolean visible) {
            this.drawFrame();
        }

        public void onTouchEvent(MotionEvent event) {
            super.onTouchEvent(event);
        }

        public void onOffsetsChanged(float xOffset, float yOffset, float xOffsetStep, float yOffsetStep, int xPixels, int yPixels) {
            this.mXOffset = xOffset;
            this.mYOffset = yOffset;
            this.drawFrame();
        }

        public void onSurfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            super.onSurfaceChanged(holder, format, width, height);
            this.drawFrame();
        }

        public void onSurfaceCreated(SurfaceHolder holder) {
            super.onSurfaceCreated(holder);
        }

        public void onSurfaceDestroyed(SurfaceHolder holder) {
            super.onSurfaceDestroyed(holder);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void drawFrame() {
            SurfaceHolder sh = this.getSurfaceHolder();
            Canvas c = sh.lockCanvas();
            if (c != null) {
                Rect frame = sh.getSurfaceFrame();
                Object object = this.mLock;
                synchronized (object) {
                    Drawable background = this.mBackground;
                    int dw = frame.width();
                    int dh = frame.height();
                    int bw = background != null ? background.getIntrinsicWidth() : 0;
                    int bh = background != null ? background.getIntrinsicHeight() : 0;
                    int availw = dw - bw;
                    int availh = dh - bh;
                    int xPixels = availw < 0 ? (int)((float)availw * this.mXOffset + 0.5f) : availw / 2;
                    int yPixels = availh < 0 ? (int)((float)availh * this.mYOffset + 0.5f) : availh / 2;
                    c.translate(xPixels, yPixels);
                    if (availw < 0 || availh < 0) {
                        c.save(2);
                        c.clipRect(0.0f, 0.0f, bw, bh, Region.Op.DIFFERENCE);
                        c.drawColor(-16777216);
                        c.restore();
                    }
                    if (background != null) {
                        background.draw(c);
                    }
                }
                sh.unlockCanvasAndPost(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateWallpaper() {
            Object object = this.mLock;
            synchronized (object) {
                try {
                    this.mBackground = ImageWallpaper.this.mWallpaperManager.getFastDrawable();
                }
                catch (RuntimeException e) {
                    Log.w("ImageWallpaper", "Unable to load wallpaper!", e);
                }
            }
        }

        class WallpaperObserver
        extends BroadcastReceiver {
            WallpaperObserver() {
            }

            public void onReceive(Context context, Intent intent) {
                DrawableEngine.this.updateWallpaper();
                DrawableEngine.this.drawFrame();
                System.gc();
            }
        }
    }
}

