/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.SystemProperties;
import android.util.Log;
import dalvik.system.SamplingProfiler;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class SamplingProfilerIntegration {
    private static final String TAG = "SamplingProfilerIntegration";
    private static final boolean enabled = "1".equals(SystemProperties.get("persist.sampling_profiler"));
    private static final Executor snapshotWriter;
    private static SamplingProfiler INSTANCE;
    static boolean dirMade;
    static volatile boolean pending;

    public static boolean isEnabled() {
        return enabled;
    }

    public static void start() {
        if (!enabled) {
            return;
        }
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        SamplingProfiler.ThreadSet threadSet = SamplingProfiler.newThreadGroupTheadSet((ThreadGroup)group);
        INSTANCE = new SamplingProfiler(4, threadSet);
        INSTANCE.start(10);
    }

    public static void writeSnapshot(final String name) {
        if (!enabled) {
            return;
        }
        if (!pending) {
            pending = true;
            snapshotWriter.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    String dir = "/sdcard/snapshots";
                    if (!dirMade) {
                        new File(dir).mkdirs();
                        if (new File(dir).isDirectory()) {
                            dirMade = true;
                        } else {
                            Log.w(SamplingProfilerIntegration.TAG, "Creation of " + dir + " failed.");
                            return;
                        }
                    }
                    try {
                        SamplingProfilerIntegration.writeSnapshot(dir, name);
                    }
                    finally {
                        pending = false;
                    }
                }
            });
        }
    }

    public static void writeZygoteSnapshot() {
        if (!enabled) {
            return;
        }
        String dir = "/data/zygote/snapshots";
        new File(dir).mkdirs();
        SamplingProfilerIntegration.writeSnapshot(dir, "zygote");
        INSTANCE.shutdown();
        INSTANCE = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeSnapshot(String dir, String name) {
        PrintStream out;
        if (!enabled) {
            return;
        }
        INSTANCE.stop();
        long start = System.currentTimeMillis();
        String path = dir + "/" + name.replace(':', '.') + "-" + System.currentTimeMillis() + ".snapshot";
        int count = 0;
        while (true) {
            try {
                out = new PrintStream(new BufferedOutputStream(new FileOutputStream(path)));
            }
            catch (FileNotFoundException e) {
                if (++count > 3) {
                    Log.e(TAG, "Could not open " + path + ".");
                    return;
                }
                try {
                    Thread.sleep(2500L);
                }
                catch (InterruptedException e1) {}
                continue;
            }
            break;
        }
        try {
            INSTANCE.writeHprofData(out);
        }
        finally {
            out.close();
        }
        if (out.checkError()) {
            Log.e(TAG, "Error writing snapshot.");
        } else {
            long elapsed = System.currentTimeMillis() - start;
            Log.i(TAG, "Wrote snapshot for " + name + " in " + elapsed + "ms.");
        }
    }

    static {
        if (enabled) {
            snapshotWriter = Executors.newSingleThreadExecutor();
            Log.i(TAG, "Profiler is enabled.");
        } else {
            snapshotWriter = null;
            Log.i(TAG, "Profiler is disabled.");
        }
        dirMade = false;
    }
}

