/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.nfc;

import android.nfc.ErrorCodes;
import android.nfc.ILlcpSocket;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.nfc.LlcpException;
import java.io.IOException;

public class LlcpSocket {
    private static final String TAG = "LlcpSocket";
    protected int mHandle;
    protected ILlcpSocket mService;

    static LlcpException convertErrorToLlcpException(int errorCode) {
        return LlcpSocket.convertErrorToLlcpException(errorCode, null);
    }

    static LlcpException convertErrorToLlcpException(int errorCode, String message) {
        message = message == null ? "" : " (" + message + ")";
        switch (errorCode) {
            case -10: {
                return new LlcpException("Error during the creation of an Llcp socket" + message);
            }
            case -9: {
                return new LlcpException("Not enough ressources are available" + message);
            }
            case -11: {
                return new LlcpException("Socket not connected to an Llcp Service" + message);
            }
        }
        return new LlcpException("Unkown error code " + errorCode + message);
    }

    public LlcpSocket(ILlcpSocket service, int handle) {
        this.mService = service;
        this.mHandle = handle;
    }

    public void connect(int sap) throws IOException, LlcpException {
        try {
            int result = this.mService.connect(this.mHandle, sap);
            if (ErrorCodes.isError(result)) {
                if (result == -1) {
                    throw new IOException();
                }
                throw LlcpSocket.convertErrorToLlcpException(result);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in accept(): ", e);
        }
    }

    public void connect(String sn) throws IOException, LlcpException {
        try {
            int result = this.mService.connectByName(this.mHandle, sn);
            if (ErrorCodes.isError(result)) {
                if (result == -1) {
                    throw new IOException();
                }
                throw LlcpSocket.convertErrorToLlcpException(result);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in accept(): ", e);
        }
    }

    public void close() throws IOException {
        try {
            int result = this.mService.close(this.mHandle);
            if (ErrorCodes.isError(result)) {
                throw new IOException();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in close(): ", e);
        }
    }

    public void send(byte[] data) throws IOException {
        try {
            int result = this.mService.send(this.mHandle, data);
            if (ErrorCodes.isError(result)) {
                throw new IOException();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in send(): ", e);
        }
    }

    public int receive(byte[] receiveBuffer) throws IOException {
        int receivedLength = 0;
        try {
            receivedLength = this.mService.receive(this.mHandle, receiveBuffer);
            if (receivedLength == 0) {
                throw new IOException();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in receive(): ", e);
        }
        return receivedLength;
    }

    public int getLocalSap() {
        try {
            return this.mService.getLocalSap(this.mHandle);
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in getLocalSap(): ", e);
            return 0;
        }
    }

    public int getLocalSocketMiu() {
        try {
            return this.mService.getLocalSocketMiu(this.mHandle);
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in getLocalSocketMiu(): ", e);
            return 0;
        }
    }

    public int getLocalSocketRw() {
        try {
            return this.mService.getLocalSocketRw(this.mHandle);
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in getLocalSocketRw(): ", e);
            return 0;
        }
    }

    public int getRemoteSocketMiu() throws LlcpException {
        try {
            int result = this.mService.getRemoteSocketMiu(this.mHandle);
            if (result != -11) {
                return result;
            }
            throw LlcpSocket.convertErrorToLlcpException(result);
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in getRemoteSocketMiu(): ", e);
            return 0;
        }
    }

    public int getRemoteSocketRw() throws LlcpException {
        try {
            int result = this.mService.getRemoteSocketRw(this.mHandle);
            if (result != -11) {
                return result;
            }
            throw LlcpSocket.convertErrorToLlcpException(result);
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in getRemoteSocketRw(): ", e);
            return 0;
        }
    }
}

