/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.nfc;

import android.nfc.ErrorCodes;
import android.nfc.ILlcpConnectionlessSocket;
import android.nfc.LlcpPacket;
import android.os.RemoteException;
import android.util.Log;
import java.io.IOException;

public class LlcpConnectionlessSocket {
    private static final String TAG = "LlcpConnectionlessSocket";
    protected int mHandle;
    protected ILlcpConnectionlessSocket mService;

    LlcpConnectionlessSocket(ILlcpConnectionlessSocket service, int handle) {
        this.mService = service;
        this.mHandle = handle;
    }

    public void sendTo(LlcpPacket packet) throws IOException {
        try {
            int result = this.mService.sendTo(this.mHandle, packet);
            if (ErrorCodes.isError(result)) {
                throw new IOException();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in sendTo(): ", e);
        }
    }

    public LlcpPacket receiveFrom() throws IOException {
        try {
            LlcpPacket packet = this.mService.receiveFrom(this.mHandle);
            if (packet != null) {
                return packet;
            }
            throw new IOException();
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in receiveFrom(): ", e);
            return null;
        }
    }

    public void close() {
        try {
            this.mService.close(this.mHandle);
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in close(): ", e);
        }
    }

    public int getSap() {
        int sap = 0;
        try {
            sap = this.mService.getSap(this.mHandle);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return sap;
    }
}

