/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.content;

import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.storage.IMountService;
import android.util.Log;

public class PackageHelper {
    public static final int RECOMMEND_INSTALL_INTERNAL = 1;
    public static final int RECOMMEND_INSTALL_EXTERNAL = 2;
    public static final int RECOMMEND_FAILED_INSUFFICIENT_STORAGE = -1;
    public static final int RECOMMEND_FAILED_INVALID_APK = -2;
    public static final int RECOMMEND_FAILED_INVALID_LOCATION = -3;
    public static final int RECOMMEND_FAILED_ALREADY_EXISTS = -4;
    public static final int RECOMMEND_MEDIA_UNAVAILABLE = -5;
    private static final boolean localLOGV = true;
    private static final String TAG = "PackageHelper";
    public static final int APP_INSTALL_AUTO = 0;
    public static final int APP_INSTALL_INTERNAL = 1;
    public static final int APP_INSTALL_EXTERNAL = 2;

    public static IMountService getMountService() {
        IBinder service = ServiceManager.getService("mount");
        if (service != null) {
            return IMountService.Stub.asInterface(service);
        }
        Log.e(TAG, "Can't get mount service");
        return null;
    }

    public static String createSdDir(long sizeBytes, String cid, String sdEncKey, int uid) {
        IMountService mountService = PackageHelper.getMountService();
        int sizeMb = (int)(sizeBytes >> 20);
        if (sizeBytes - (long)(sizeMb * 1024 * 1024) > 0L) {
            ++sizeMb;
        }
        Log.i(TAG, "Size of container " + ++sizeMb + " MB " + sizeBytes + " bytes");
        try {
            int rc = mountService.createSecureContainer(cid, sizeMb, "fat", sdEncKey, uid);
            if (rc != 0) {
                Log.e(TAG, "Failed to create secure container " + cid);
                return null;
            }
            String cachePath = mountService.getSecureContainerPath(cid);
            Log.i(TAG, "Created secure container " + cid + " at " + cachePath);
            return cachePath;
        }
        catch (RemoteException e) {
            Log.e(TAG, "MountService running?");
            return null;
        }
    }

    public static String mountSdDir(String cid, String key, int ownerUid) {
        try {
            int rc = PackageHelper.getMountService().mountSecureContainer(cid, key, ownerUid);
            if (rc != 0) {
                Log.i(TAG, "Failed to mount container " + cid + " rc : " + rc);
                return null;
            }
            return PackageHelper.getMountService().getSecureContainerPath(cid);
        }
        catch (RemoteException e) {
            Log.e(TAG, "MountService running?");
            return null;
        }
    }

    public static boolean unMountSdDir(String cid) {
        try {
            int rc = PackageHelper.getMountService().unmountSecureContainer(cid, true);
            if (rc != 0) {
                Log.e(TAG, "Failed to unmount " + cid + " with rc " + rc);
                return false;
            }
            return true;
        }
        catch (RemoteException e) {
            Log.e(TAG, "MountService running?");
            return false;
        }
    }

    public static boolean renameSdDir(String oldId, String newId) {
        try {
            int rc = PackageHelper.getMountService().renameSecureContainer(oldId, newId);
            if (rc != 0) {
                Log.e(TAG, "Failed to rename " + oldId + " to " + newId + "with rc " + rc);
                return false;
            }
            return true;
        }
        catch (RemoteException e) {
            Log.i(TAG, "Failed ot rename  " + oldId + " to " + newId + " with exception : " + e);
            return false;
        }
    }

    public static String getSdDir(String cid) {
        try {
            return PackageHelper.getMountService().getSecureContainerPath(cid);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to get container path for " + cid + " with exception " + e);
            return null;
        }
    }

    public static boolean finalizeSdDir(String cid) {
        try {
            int rc = PackageHelper.getMountService().finalizeSecureContainer(cid);
            if (rc != 0) {
                Log.i(TAG, "Failed to finalize container " + cid);
                return false;
            }
            return true;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to finalize container " + cid + " with exception " + e);
            return false;
        }
    }

    public static boolean destroySdDir(String cid) {
        try {
            Log.i(TAG, "Forcibly destroying container " + cid);
            int rc = PackageHelper.getMountService().destroySecureContainer(cid, true);
            if (rc != 0) {
                Log.i(TAG, "Failed to destroy container " + cid);
                return false;
            }
            return true;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to destroy container " + cid + " with exception " + e);
            return false;
        }
    }

    public static String[] getSecureContainerList() {
        try {
            return PackageHelper.getMountService().getSecureContainerList();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to get secure container list with exception" + e);
            return null;
        }
    }

    public static boolean isContainerMounted(String cid) {
        try {
            return PackageHelper.getMountService().isSecureContainerMounted(cid);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to find out if container " + cid + " mounted");
            return false;
        }
    }
}

