/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.format.DateFormat;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.NumberPicker;
import com.android.internal.R;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatePicker
extends FrameLayout {
    private static final int DEFAULT_START_YEAR = 1900;
    private static final int DEFAULT_END_YEAR = 2100;
    private static final int NUMBER_OF_MONTHS = 12;
    private final NumberPicker mDayPicker;
    private final NumberPicker mMonthPicker;
    private final NumberPicker mYearPicker;
    private OnDateChangedListener mOnDateChangedListener;
    private int mDay;
    private int mMonth;
    private int mYear;
    private Object mMonthUpdateLock = new Object();
    private volatile Locale mMonthLocale;
    private String[] mShortMonths;

    public DatePicker(Context context) {
        this(context, null);
    }

    public DatePicker(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DatePicker(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        inflater.inflate(17367071, (ViewGroup)this, true);
        this.mDayPicker = (NumberPicker)this.findViewById(16908703);
        this.mDayPicker.setFormatter(NumberPicker.TWO_DIGIT_FORMATTER);
        this.mDayPicker.setSpeed(100L);
        this.mDayPicker.setOnChangeListener(new NumberPicker.OnChangedListener(){

            public void onChanged(NumberPicker picker, int oldVal, int newVal) {
                DatePicker.this.mDay = newVal;
                DatePicker.this.notifyDateChanged();
            }
        });
        this.mMonthPicker = (NumberPicker)this.findViewById(16908702);
        this.mMonthPicker.setFormatter(NumberPicker.TWO_DIGIT_FORMATTER);
        String[] months = this.getShortMonths();
        if (months[0].startsWith("1")) {
            for (int i = 0; i < months.length; ++i) {
                months[i] = String.valueOf(i + 1);
            }
            this.mMonthPicker.setRange(1, 12);
        } else {
            this.mMonthPicker.setRange(1, 12, months);
        }
        this.mMonthPicker.setSpeed(200L);
        this.mMonthPicker.setOnChangeListener(new NumberPicker.OnChangedListener(){

            public void onChanged(NumberPicker picker, int oldVal, int newVal) {
                DatePicker.this.mMonth = newVal - 1;
                DatePicker.this.adjustMaxDay();
                DatePicker.this.notifyDateChanged();
                DatePicker.this.updateDaySpinner();
            }
        });
        this.mYearPicker = (NumberPicker)this.findViewById(16908704);
        this.mYearPicker.setSpeed(100L);
        this.mYearPicker.setOnChangeListener(new NumberPicker.OnChangedListener(){

            public void onChanged(NumberPicker picker, int oldVal, int newVal) {
                DatePicker.this.mYear = newVal;
                DatePicker.this.adjustMaxDay();
                DatePicker.this.notifyDateChanged();
                DatePicker.this.updateDaySpinner();
            }
        });
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DatePicker);
        int mStartYear = a.getInt(0, 1900);
        int mEndYear = a.getInt(1, 2100);
        this.mYearPicker.setRange(mStartYear, mEndYear);
        a.recycle();
        Calendar cal = Calendar.getInstance();
        this.init(cal.get(1), cal.get(2), cal.get(5), null);
        this.reorderPickers(months);
        if (!this.isEnabled()) {
            this.setEnabled(false);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mDayPicker.setEnabled(enabled);
        this.mMonthPicker.setEnabled(enabled);
        this.mYearPicker.setEnabled(enabled);
    }

    private void reorderPickers(String[] months) {
        java.text.DateFormat format = months[0].startsWith("1") ? DateFormat.getDateFormat(this.getContext()) : DateFormat.getMediumDateFormat(this.getContext());
        String order = format instanceof SimpleDateFormat ? ((SimpleDateFormat)format).toPattern() : new String(DateFormat.getDateFormatOrder(this.getContext()));
        LinearLayout parent = (LinearLayout)this.findViewById(16908701);
        parent.removeAllViews();
        boolean quoted = false;
        boolean didDay = false;
        boolean didMonth = false;
        boolean didYear = false;
        for (int i = 0; i < order.length(); ++i) {
            char c = order.charAt(i);
            if (c == '\'') {
                boolean bl = quoted = !quoted;
            }
            if (quoted) continue;
            if (c == 'd' && !didDay) {
                parent.addView(this.mDayPicker);
                didDay = true;
                continue;
            }
            if (!(c != 'M' && c != 'L' || didMonth)) {
                parent.addView(this.mMonthPicker);
                didMonth = true;
                continue;
            }
            if (c != 'y' || didYear) continue;
            parent.addView(this.mYearPicker);
            didYear = true;
        }
        if (!didMonth) {
            parent.addView(this.mMonthPicker);
        }
        if (!didDay) {
            parent.addView(this.mDayPicker);
        }
        if (!didYear) {
            parent.addView(this.mYearPicker);
        }
    }

    public void updateDate(int year, int monthOfYear, int dayOfMonth) {
        if (this.mYear != year || this.mMonth != monthOfYear || this.mDay != dayOfMonth) {
            this.mYear = year;
            this.mMonth = monthOfYear;
            this.mDay = dayOfMonth;
            this.updateSpinners();
            this.reorderPickers(this.getShortMonths());
            this.notifyDateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getShortMonths() {
        Locale currentLocale = Locale.getDefault();
        if (currentLocale.equals(this.mMonthLocale) && this.mShortMonths != null) {
            return this.mShortMonths;
        }
        Object object = this.mMonthUpdateLock;
        synchronized (object) {
            if (!currentLocale.equals(this.mMonthLocale)) {
                this.mShortMonths = new String[12];
                for (int i = 0; i < 12; ++i) {
                    this.mShortMonths[i] = DateUtils.getMonthString(0 + i, 20);
                }
                this.mMonthLocale = currentLocale;
            }
        }
        return this.mShortMonths;
    }

    @Override
    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
        this.dispatchThawSelfOnly(container);
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return new SavedState(superState, this.mYear, this.mMonth, this.mDay);
    }

    @Override
    protected void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mYear = ss.getYear();
        this.mMonth = ss.getMonth();
        this.mDay = ss.getDay();
        this.updateSpinners();
    }

    public void init(int year, int monthOfYear, int dayOfMonth, OnDateChangedListener onDateChangedListener) {
        this.mYear = year;
        this.mMonth = monthOfYear;
        this.mDay = dayOfMonth;
        this.mOnDateChangedListener = onDateChangedListener;
        this.updateSpinners();
    }

    private void updateSpinners() {
        this.updateDaySpinner();
        this.mYearPicker.setCurrent(this.mYear);
        this.mMonthPicker.setCurrent(this.mMonth + 1);
    }

    private void updateDaySpinner() {
        Calendar cal = Calendar.getInstance();
        cal.set(this.mYear, this.mMonth, this.mDay);
        int max = cal.getActualMaximum(5);
        this.mDayPicker.setRange(1, max);
        this.mDayPicker.setCurrent(this.mDay);
    }

    public int getYear() {
        return this.mYear;
    }

    public int getMonth() {
        return this.mMonth;
    }

    public int getDayOfMonth() {
        return this.mDay;
    }

    private void adjustMaxDay() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, this.mYear);
        cal.set(2, this.mMonth);
        int max = cal.getActualMaximum(5);
        if (this.mDay > max) {
            this.mDay = max;
        }
    }

    private void notifyDateChanged() {
        if (this.mOnDateChangedListener != null) {
            this.mOnDateChangedListener.onDateChanged(this, this.mYear, this.mMonth, this.mDay);
        }
    }

    private static class SavedState
    extends View.BaseSavedState {
        private final int mYear;
        private final int mMonth;
        private final int mDay;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        private SavedState(Parcelable superState, int year, int month, int day) {
            super(superState);
            this.mYear = year;
            this.mMonth = month;
            this.mDay = day;
        }

        private SavedState(Parcel in) {
            super(in);
            this.mYear = in.readInt();
            this.mMonth = in.readInt();
            this.mDay = in.readInt();
        }

        public int getYear() {
            return this.mYear;
        }

        public int getMonth() {
            return this.mMonth;
        }

        public int getDay() {
            return this.mDay;
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mYear);
            dest.writeInt(this.mMonth);
            dest.writeInt(this.mDay);
        }
    }

    public static interface OnDateChangedListener {
        public void onDateChanged(DatePicker var1, int var2, int var3, int var4);
    }
}

