/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.widget.ProgressBar;
import com.android.internal.R;

public abstract class AbsSeekBar
extends ProgressBar {
    private Drawable mThumb;
    private int mThumbOffset;
    float mTouchProgressOffset;
    boolean mIsUserSeekable = true;
    private int mKeyProgressIncrement = 1;
    private static final int NO_ALPHA = 255;
    private float mDisabledAlpha;

    public AbsSeekBar(Context context) {
        super(context);
    }

    public AbsSeekBar(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AbsSeekBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SeekBar, defStyle, 0);
        Drawable thumb = a.getDrawable(0);
        this.setThumb(thumb);
        int thumbOffset = a.getDimensionPixelOffset(1, this.getThumbOffset());
        this.setThumbOffset(thumbOffset);
        a.recycle();
        a = context.obtainStyledAttributes(attrs, R.styleable.Theme, 0, 0);
        this.mDisabledAlpha = a.getFloat(3, 0.5f);
        a.recycle();
    }

    public void setThumb(Drawable thumb) {
        if (thumb != null) {
            thumb.setCallback(this);
            this.mThumbOffset = thumb.getIntrinsicWidth() / 2;
        }
        this.mThumb = thumb;
        this.invalidate();
    }

    public int getThumbOffset() {
        return this.mThumbOffset;
    }

    public void setThumbOffset(int thumbOffset) {
        this.mThumbOffset = thumbOffset;
        this.invalidate();
    }

    public void setKeyProgressIncrement(int increment) {
        this.mKeyProgressIncrement = increment < 0 ? -increment : increment;
    }

    public int getKeyProgressIncrement() {
        return this.mKeyProgressIncrement;
    }

    public synchronized void setMax(int max) {
        super.setMax(max);
        if (this.mKeyProgressIncrement == 0 || this.getMax() / this.mKeyProgressIncrement > 20) {
            this.setKeyProgressIncrement(Math.max(1, Math.round((float)this.getMax() / 20.0f)));
        }
    }

    protected boolean verifyDrawable(Drawable who) {
        return who == this.mThumb || super.verifyDrawable(who);
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        Drawable progressDrawable = this.getProgressDrawable();
        if (progressDrawable != null) {
            progressDrawable.setAlpha(this.isEnabled() ? 255 : (int)(255.0f * this.mDisabledAlpha));
        }
        if (this.mThumb != null && this.mThumb.isStateful()) {
            int[] state = this.getDrawableState();
            this.mThumb.setState(state);
        }
    }

    void onProgressRefresh(float scale, boolean fromUser) {
        Drawable thumb = this.mThumb;
        if (thumb != null) {
            this.setThumbPos(this.getWidth(), thumb, scale, Integer.MIN_VALUE);
            this.invalidate();
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        float scale;
        Drawable d = this.getCurrentDrawable();
        Drawable thumb = this.mThumb;
        int thumbHeight = thumb == null ? 0 : thumb.getIntrinsicHeight();
        int trackHeight = Math.min(this.mMaxHeight, h - this.mPaddingTop - this.mPaddingBottom);
        int max = this.getMax();
        float f = scale = max > 0 ? (float)this.getProgress() / (float)max : 0.0f;
        if (thumbHeight > trackHeight) {
            if (thumb != null) {
                this.setThumbPos(w, thumb, scale, 0);
            }
            int gapForCenteringTrack = (thumbHeight - trackHeight) / 2;
            if (d != null) {
                d.setBounds(0, gapForCenteringTrack, w - this.mPaddingRight - this.mPaddingLeft, h - this.mPaddingBottom - gapForCenteringTrack - this.mPaddingTop);
            }
        } else {
            if (d != null) {
                d.setBounds(0, 0, w - this.mPaddingRight - this.mPaddingLeft, h - this.mPaddingBottom - this.mPaddingTop);
            }
            int gap = (trackHeight - thumbHeight) / 2;
            if (thumb != null) {
                this.setThumbPos(w, thumb, scale, gap);
            }
        }
    }

    private void setThumbPos(int w, Drawable thumb, float scale, int gap) {
        int bottomBound;
        int topBound;
        int available = w - this.mPaddingLeft - this.mPaddingRight;
        int thumbWidth = thumb.getIntrinsicWidth();
        int thumbHeight = thumb.getIntrinsicHeight();
        available -= thumbWidth;
        int thumbPos = (int)(scale * (float)(available += this.mThumbOffset * 2));
        if (gap == Integer.MIN_VALUE) {
            Rect oldBounds = thumb.getBounds();
            topBound = oldBounds.top;
            bottomBound = oldBounds.bottom;
        } else {
            topBound = gap;
            bottomBound = gap + thumbHeight;
        }
        thumb.setBounds(thumbPos, topBound, thumbPos + thumbWidth, bottomBound);
    }

    protected synchronized void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mThumb != null) {
            canvas.save();
            canvas.translate(this.mPaddingLeft - this.mThumbOffset, this.mPaddingTop);
            this.mThumb.draw(canvas);
            canvas.restore();
        }
    }

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Drawable d = this.getCurrentDrawable();
        int thumbHeight = this.mThumb == null ? 0 : this.mThumb.getIntrinsicHeight();
        int dw = 0;
        int dh = 0;
        if (d != null) {
            dw = Math.max(this.mMinWidth, Math.min(this.mMaxWidth, d.getIntrinsicWidth()));
            dh = Math.max(this.mMinHeight, Math.min(this.mMaxHeight, d.getIntrinsicHeight()));
            dh = Math.max(thumbHeight, dh);
        }
        this.setMeasuredDimension(AbsSeekBar.resolveSize(dw += this.mPaddingLeft + this.mPaddingRight, widthMeasureSpec), AbsSeekBar.resolveSize(dh += this.mPaddingTop + this.mPaddingBottom, heightMeasureSpec));
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mIsUserSeekable || !this.isEnabled()) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                this.setPressed(true);
                this.onStartTrackingTouch();
                this.trackTouchEvent(event);
                break;
            }
            case 2: {
                this.trackTouchEvent(event);
                this.attemptClaimDrag();
                break;
            }
            case 1: {
                this.trackTouchEvent(event);
                this.onStopTrackingTouch();
                this.setPressed(false);
                this.invalidate();
                break;
            }
            case 3: {
                this.onStopTrackingTouch();
                this.setPressed(false);
                this.invalidate();
            }
        }
        return true;
    }

    private void trackTouchEvent(MotionEvent event) {
        float scale;
        int width = this.getWidth();
        int available = width - this.mPaddingLeft - this.mPaddingRight;
        int x = (int)event.getX();
        float progress = 0.0f;
        if (x < this.mPaddingLeft) {
            scale = 0.0f;
        } else if (x > width - this.mPaddingRight) {
            scale = 1.0f;
        } else {
            scale = (float)(x - this.mPaddingLeft) / (float)available;
            progress = this.mTouchProgressOffset;
        }
        int max = this.getMax();
        this.setProgress((int)(progress += scale * (float)max), true);
    }

    private void attemptClaimDrag() {
        if (this.mParent != null) {
            this.mParent.requestDisallowInterceptTouchEvent(true);
        }
    }

    void onStartTrackingTouch() {
    }

    void onStopTrackingTouch() {
    }

    void onKeyChange() {
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.isEnabled()) {
            int progress = this.getProgress();
            switch (keyCode) {
                case 21: {
                    if (progress <= 0) break;
                    this.setProgress(progress - this.mKeyProgressIncrement, true);
                    this.onKeyChange();
                    return true;
                }
                case 22: {
                    if (progress >= this.getMax()) break;
                    this.setProgress(progress + this.mKeyProgressIncrement, true);
                    this.onKeyChange();
                    return true;
                }
            }
        }
        return super.onKeyDown(keyCode, event);
    }
}

