/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.webkit.CallbackProxy;
import android.webkit.LoadListener;
import android.webkit.Network;
import java.util.LinkedList;

public class HttpAuthHandler
extends Handler {
    private static final String LOGTAG = "network";
    private Network mNetwork;
    private LinkedList<LoadListener> mLoaderQueue;
    private static final int AUTH_PROCEED = 100;
    private static final int AUTH_CANCEL = 200;
    Object mRequestInFlightLock = new Object();
    boolean mRequestInFlight;
    String mUsername;
    String mPassword;

    HttpAuthHandler(Network network) {
        this.mNetwork = network;
        this.mLoaderQueue = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Message msg) {
        LoadListener loader = null;
        LinkedList<LoadListener> linkedList = this.mLoaderQueue;
        synchronized (linkedList) {
            loader = this.mLoaderQueue.poll();
        }
        assert (!loader.isSynchronous());
        switch (msg.what) {
            case 100: {
                String username = msg.getData().getString("username");
                String password = msg.getData().getString("password");
                loader.handleAuthResponse(username, password);
                break;
            }
            case 200: {
                loader.handleAuthResponse(null, null);
            }
        }
        this.processNextLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleResponseForSynchronousRequest(String username, String password) {
        LoadListener loader = null;
        LinkedList<LoadListener> linkedList = this.mLoaderQueue;
        synchronized (linkedList) {
            loader = this.mLoaderQueue.peek();
        }
        if (loader.isSynchronous()) {
            this.mUsername = username;
            this.mPassword = password;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalRequestComplete() {
        Object object = this.mRequestInFlightLock;
        synchronized (object) {
            assert (this.mRequestInFlight);
            this.mRequestInFlight = false;
            this.mRequestInFlightLock.notify();
        }
    }

    public void proceed(String username, String password) {
        if (this.handleResponseForSynchronousRequest(username, password)) {
            this.signalRequestComplete();
            return;
        }
        Message msg = this.obtainMessage(100);
        msg.getData().putString("username", username);
        msg.getData().putString("password", password);
        this.sendMessage(msg);
        this.signalRequestComplete();
    }

    public void cancel() {
        if (this.handleResponseForSynchronousRequest(null, null)) {
            this.signalRequestComplete();
            return;
        }
        this.sendMessage(this.obtainMessage(200));
        this.signalRequestComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean useHttpAuthUsernamePassword() {
        LoadListener loader = null;
        LinkedList<LoadListener> linkedList = this.mLoaderQueue;
        synchronized (linkedList) {
            loader = this.mLoaderQueue.peek();
        }
        if (loader != null) {
            return !loader.authCredentialsInvalid();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleAuthRequest(LoadListener loader) {
        if (loader.isSynchronous()) {
            this.waitForRequestToComplete();
            LinkedList<LoadListener> linkedList = this.mLoaderQueue;
            synchronized (linkedList) {
                this.mLoaderQueue.addFirst(loader);
            }
            this.processNextLoader();
            this.waitForRequestToComplete();
            linkedList = this.mLoaderQueue;
            synchronized (linkedList) {
                assert (this.mLoaderQueue.peek() == loader);
                this.mLoaderQueue.poll();
            }
            loader.handleAuthResponse(this.mUsername, this.mPassword);
            return;
        }
        boolean processNext = false;
        LinkedList<LoadListener> linkedList = this.mLoaderQueue;
        synchronized (linkedList) {
            this.mLoaderQueue.offer(loader);
            processNext = this.mLoaderQueue.size() == 1;
        }
        if (processNext) {
            this.processNextLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForRequestToComplete() {
        Object object = this.mRequestInFlightLock;
        synchronized (object) {
            while (this.mRequestInFlight) {
                try {
                    this.mRequestInFlightLock.wait();
                }
                catch (InterruptedException e) {
                    Log.e(LOGTAG, "Interrupted while waiting for request to complete");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNextLoader() {
        LoadListener loader = null;
        Object object = this.mLoaderQueue;
        synchronized (object) {
            loader = this.mLoaderQueue.peek();
        }
        if (loader != null) {
            object = this.mRequestInFlightLock;
            synchronized (object) {
                assert (!this.mRequestInFlight);
                this.mRequestInFlight = true;
            }
            CallbackProxy proxy = loader.getFrame().getCallbackProxy();
            String hostname = loader.proxyAuthenticate() ? this.mNetwork.getProxyHostname() : loader.host();
            String realm = loader.realm();
            proxy.onReceivedHttpAuthRequest(this, hostname, realm);
        }
    }

    public static void onReceivedCredentials(LoadListener loader, String host, String realm, String username, String password) {
        CallbackProxy proxy = loader.getFrame().getCallbackProxy();
        proxy.onReceivedHttpAuthCredentials(host, realm, username, password);
    }
}

