/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.app.ActivityThread;
import android.app.Application;
import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.util.Log;

final class GeolocationService
implements LocationListener {
    private static final String TAG = "geolocationService";
    private long mNativeObject;
    private LocationManager mLocationManager;
    private boolean mIsGpsEnabled;
    private boolean mIsRunning;
    private boolean mIsNetworkProviderAvailable;
    private boolean mIsGpsProviderAvailable;

    public GeolocationService(long nativeObject) {
        this.mNativeObject = nativeObject;
        ActivityThread thread = ActivityThread.systemMain();
        Application context = thread.getApplication();
        this.mLocationManager = (LocationManager)((Context)context).getSystemService("location");
        if (this.mLocationManager == null) {
            Log.e(TAG, "Could not get location manager.");
        }
    }

    public void start() {
        this.registerForLocationUpdates();
        this.mIsRunning = true;
    }

    public void stop() {
        this.unregisterFromLocationUpdates();
        this.mIsRunning = false;
    }

    public void setEnableGps(boolean enable) {
        if (this.mIsGpsEnabled != enable) {
            this.mIsGpsEnabled = enable;
            if (this.mIsRunning) {
                this.unregisterFromLocationUpdates();
                this.registerForLocationUpdates();
            }
        }
    }

    public void onLocationChanged(Location location) {
        if (this.mIsRunning) {
            GeolocationService.nativeNewLocationAvailable(this.mNativeObject, location);
        }
    }

    public void onStatusChanged(String providerName, int status, Bundle extras) {
        boolean isAvailable;
        boolean bl = isAvailable = status == 2;
        if ("network".equals(providerName)) {
            this.mIsNetworkProviderAvailable = isAvailable;
        } else if ("gps".equals(providerName)) {
            this.mIsGpsProviderAvailable = isAvailable;
        }
        this.maybeReportError("The last location provider is no longer available");
    }

    public void onProviderEnabled(String providerName) {
        if ("network".equals(providerName)) {
            this.mIsNetworkProviderAvailable = true;
        } else if ("gps".equals(providerName)) {
            this.mIsGpsProviderAvailable = true;
        }
    }

    public void onProviderDisabled(String providerName) {
        if ("network".equals(providerName)) {
            this.mIsNetworkProviderAvailable = false;
        } else if ("gps".equals(providerName)) {
            this.mIsGpsProviderAvailable = false;
        }
        this.maybeReportError("The last location provider was disabled");
    }

    private void registerForLocationUpdates() {
        try {
            this.mLocationManager.requestLocationUpdates("network", 0L, 0.0f, this);
            this.mIsNetworkProviderAvailable = true;
            if (this.mIsGpsEnabled) {
                this.mLocationManager.requestLocationUpdates("gps", 0L, 0.0f, this);
                this.mIsGpsProviderAvailable = true;
            }
        }
        catch (SecurityException e) {
            Log.e(TAG, "Caught security exception registering for location updates from system. This should only happen in DumpRenderTree.");
        }
    }

    private void unregisterFromLocationUpdates() {
        this.mLocationManager.removeUpdates(this);
    }

    private void maybeReportError(String message) {
        if (this.mIsRunning && !this.mIsNetworkProviderAvailable && !this.mIsGpsProviderAvailable) {
            GeolocationService.nativeNewErrorAvailable(this.mNativeObject, message);
        }
    }

    private static native void nativeNewLocationAvailable(long var0, Location var2);

    private static native void nativeNewErrorAvailable(long var0, String var2);
}

