/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.net.http.AndroidHttpClient;
import android.net.http.Headers;
import android.os.FileUtils;
import android.util.Log;
import android.webkit.WebViewDatabase;
import android.webkit.WebViewWorker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CacheManager {
    private static final String LOGTAG = "cache";
    static final String HEADER_KEY_IFMODIFIEDSINCE = "if-modified-since";
    static final String HEADER_KEY_IFNONEMATCH = "if-none-match";
    private static final String NO_STORE = "no-store";
    private static final String NO_CACHE = "no-cache";
    private static final String MAX_AGE = "max-age";
    private static final String MANIFEST_MIME = "text/cache-manifest";
    private static long CACHE_THRESHOLD = 0x600000L;
    private static long CACHE_TRIM_AMOUNT = 0x200000L;
    static long CACHE_MAX_SIZE = (CACHE_THRESHOLD - CACHE_TRIM_AMOUNT) / 2L;
    private static boolean mDisabled;
    private static int mRefCount;
    private static int mTrimCacheCount;
    private static final int TRIM_CACHE_INTERVAL = 5;
    private static WebViewDatabase mDataBase;
    private static File mBaseDir;
    private static boolean mClearCacheOnInit;

    static void init(Context context) {
        mDataBase = WebViewDatabase.getInstance(context.getApplicationContext());
        mBaseDir = new File(context.getCacheDir(), "webviewCache");
        if (CacheManager.createCacheDirectory() && mClearCacheOnInit) {
            CacheManager.removeAllCacheFiles();
            mClearCacheOnInit = false;
        }
    }

    private static boolean createCacheDirectory() {
        if (!mBaseDir.exists()) {
            if (!mBaseDir.mkdirs()) {
                Log.w(LOGTAG, "Unable to create webviewCache directory");
                return false;
            }
            FileUtils.setPermissions(mBaseDir.toString(), 505, -1, -1);
            WebViewWorker.getHandler().sendEmptyMessage(109);
            return true;
        }
        return false;
    }

    public static File getCacheFileBaseDir() {
        return mBaseDir;
    }

    static void setCacheDisabled(boolean disabled) {
        if (disabled == mDisabled) {
            return;
        }
        mDisabled = disabled;
        if (mDisabled) {
            CacheManager.removeAllCacheFiles();
        }
    }

    public static boolean cacheDisabled() {
        return mDisabled;
    }

    static boolean enableTransaction() {
        if (++mRefCount == 1) {
            mDataBase.startCacheTransaction();
            return true;
        }
        return false;
    }

    static boolean disableTransaction() {
        if (--mRefCount == 0) {
            mDataBase.endCacheTransaction();
            return true;
        }
        return false;
    }

    static boolean startTransaction() {
        return mDataBase.startCacheTransaction();
    }

    static boolean endTransaction() {
        boolean ret = mDataBase.endCacheTransaction();
        if (++mTrimCacheCount >= 5) {
            mTrimCacheCount = 0;
            CacheManager.trimCacheIfNeeded();
        }
        return ret;
    }

    @Deprecated
    public static boolean startCacheTransaction() {
        return false;
    }

    @Deprecated
    public static boolean endCacheTransaction() {
        return false;
    }

    public static CacheResult getCacheFile(String url, Map<String, String> headers) {
        return CacheManager.getCacheFile(url, 0L, headers);
    }

    static CacheResult getCacheFile(String url, long postIdentifier, Map<String, String> headers) {
        if (mDisabled) {
            return null;
        }
        String databaseKey = CacheManager.getDatabaseKey(url, postIdentifier);
        CacheResult result = mDataBase.getCache(databaseKey);
        if (result != null) {
            if (result.contentLength == 0L) {
                if (!CacheManager.checkCacheRedirect(result.httpStatusCode)) {
                    mDataBase.removeCache(databaseKey);
                    return null;
                }
            } else {
                File src = new File(mBaseDir, result.localPath);
                try {
                    result.inStream = new FileInputStream(src);
                }
                catch (FileNotFoundException e) {
                    mDataBase.removeCache(databaseKey);
                    return null;
                }
            }
        } else {
            return null;
        }
        if (headers != null && result.expires >= 0L && result.expires <= System.currentTimeMillis()) {
            if (result.lastModified == null && result.etag == null) {
                return null;
            }
            if (result.etag != null) {
                headers.put(HEADER_KEY_IFNONEMATCH, result.etag);
            }
            if (result.lastModified != null) {
                headers.put(HEADER_KEY_IFMODIFIEDSINCE, result.lastModified);
            }
        }
        return result;
    }

    public static CacheResult createCacheFile(String url, int statusCode, Headers headers, String mimeType, boolean forceCache) {
        return CacheManager.createCacheFile(url, statusCode, headers, mimeType, 0L, forceCache);
    }

    static CacheResult createCacheFile(String url, int statusCode, Headers headers, String mimeType, long postIdentifier, boolean forceCache) {
        if (!forceCache && mDisabled) {
            return null;
        }
        String databaseKey = CacheManager.getDatabaseKey(url, postIdentifier);
        if (statusCode == 303) {
            mDataBase.removeCache(databaseKey);
            return null;
        }
        if (CacheManager.checkCacheRedirect(statusCode) && !headers.getSetCookie().isEmpty()) {
            mDataBase.removeCache(databaseKey);
            return null;
        }
        CacheResult ret = CacheManager.parseHeaders(statusCode, headers, mimeType);
        if (ret == null) {
            mDataBase.removeCache(databaseKey);
        } else {
            CacheManager.setupFiles(databaseKey, ret);
            try {
                ret.outStream = new FileOutputStream(ret.outFile);
            }
            catch (FileNotFoundException e) {
                if (CacheManager.createCacheDirectory()) {
                    try {
                        ret.outStream = new FileOutputStream(ret.outFile);
                    }
                    catch (FileNotFoundException e2) {
                        return null;
                    }
                }
                return null;
            }
            ret.mimeType = mimeType;
        }
        return ret;
    }

    public static void saveCacheFile(String url, CacheResult cacheRet) {
        CacheManager.saveCacheFile(url, 0L, cacheRet);
    }

    static void saveCacheFile(String url, long postIdentifier, CacheResult cacheRet) {
        try {
            cacheRet.outStream.close();
        }
        catch (IOException e) {
            return;
        }
        if (!cacheRet.outFile.exists()) {
            return;
        }
        boolean redirect = CacheManager.checkCacheRedirect(cacheRet.httpStatusCode);
        if (redirect) {
            cacheRet.contentLength = 0L;
            cacheRet.localPath = "";
        }
        if ((redirect || cacheRet.contentLength == 0L) && !cacheRet.outFile.delete()) {
            Log.e(LOGTAG, cacheRet.outFile.getPath() + " delete failed.");
        }
        if (cacheRet.contentLength == 0L) {
            return;
        }
        mDataBase.addCache(CacheManager.getDatabaseKey(url, postIdentifier), cacheRet);
    }

    static boolean cleanupCacheFile(CacheResult cacheRet) {
        try {
            cacheRet.outStream.close();
        }
        catch (IOException e) {
            return false;
        }
        return cacheRet.outFile.delete();
    }

    static boolean removeAllCacheFiles() {
        if (mBaseDir == null) {
            mClearCacheOnInit = true;
            return true;
        }
        WebViewWorker.getHandler().sendEmptyMessage(109);
        Runnable clearCache = new Runnable(){

            public void run() {
                try {
                    String[] files = mBaseDir.list();
                    if (files != null) {
                        for (int i = 0; i < files.length; ++i) {
                            File f = new File(mBaseDir, files[i]);
                            if (f.delete()) continue;
                            Log.e(CacheManager.LOGTAG, f.getPath() + " delete failed.");
                        }
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        };
        new Thread(clearCache).start();
        return true;
    }

    static boolean cacheEmpty() {
        return mDataBase.hasCache();
    }

    static void trimCacheIfNeeded() {
        if (mDataBase.getCacheTotalSize() > CACHE_THRESHOLD) {
            List<String> pathList = mDataBase.trimCache(CACHE_TRIM_AMOUNT);
            int size = pathList.size();
            for (int i = 0; i < size; ++i) {
                File f = new File(mBaseDir, pathList.get(i));
                if (f.delete()) continue;
                Log.e(LOGTAG, f.getPath() + " delete failed.");
            }
            final List<String> fileList = mDataBase.getAllCacheFileNames();
            if (fileList == null) {
                return;
            }
            String[] toDelete = mBaseDir.list(new FilenameFilter(){

                public boolean accept(File dir, String filename) {
                    return !fileList.contains(filename);
                }
            });
            if (toDelete == null) {
                return;
            }
            size = toDelete.length;
            for (int i = 0; i < size; ++i) {
                File f = new File(mBaseDir, toDelete[i]);
                if (f.delete()) continue;
                Log.e(LOGTAG, f.getPath() + " delete failed.");
            }
        }
    }

    static void clearCache() {
        mDataBase.clearCache();
    }

    private static boolean checkCacheRedirect(int statusCode) {
        return statusCode == 301 || statusCode == 302 || statusCode == 307;
    }

    private static String getDatabaseKey(String url, long postIdentifier) {
        if (postIdentifier == 0L) {
            return url;
        }
        return postIdentifier + url;
    }

    private static void setupFiles(String url, CacheResult cacheRet) {
        int hashCode = url.hashCode();
        StringBuffer ret = new StringBuffer(8);
        CacheManager.appendAsHex(hashCode, ret);
        String path = ret.toString();
        File file = new File(mBaseDir, path);
        boolean checkOldPath = true;
        while (file.exists()) {
            if (checkOldPath) {
                CacheResult oldResult = mDataBase.getCache(url);
                if (oldResult != null && oldResult.contentLength > 0L) {
                    if (path.equals(oldResult.localPath)) {
                        path = oldResult.localPath;
                        break;
                    }
                    path = oldResult.localPath;
                    file = new File(mBaseDir, path);
                    break;
                }
                checkOldPath = false;
            }
            ret = new StringBuffer(8);
            CacheManager.appendAsHex(++hashCode, ret);
            path = ret.toString();
            file = new File(mBaseDir, path);
        }
        cacheRet.localPath = path;
        cacheRet.outFile = file;
    }

    private static void appendAsHex(int i, StringBuffer ret) {
        String hex = Integer.toHexString(i);
        switch (hex.length()) {
            case 1: {
                ret.append("0000000");
                break;
            }
            case 2: {
                ret.append("000000");
                break;
            }
            case 3: {
                ret.append("00000");
                break;
            }
            case 4: {
                ret.append("0000");
                break;
            }
            case 5: {
                ret.append("000");
                break;
            }
            case 6: {
                ret.append("00");
                break;
            }
            case 7: {
                ret.append("0");
            }
        }
        ret.append(hex);
    }

    private static CacheResult parseHeaders(int statusCode, Headers headers, String mimeType) {
        String cacheControl;
        String etag;
        String lastModified;
        String crossDomain;
        String contentDisposition;
        if (headers.getContentLength() > CACHE_MAX_SIZE) {
            return null;
        }
        if (MANIFEST_MIME.equals(mimeType)) {
            return null;
        }
        CacheResult ret = new CacheResult();
        ret.httpStatusCode = statusCode;
        String location = headers.getLocation();
        if (location != null) {
            ret.location = location;
        }
        ret.expires = -1L;
        ret.expiresString = headers.getExpires();
        if (ret.expiresString != null) {
            try {
                ret.expires = AndroidHttpClient.parseDate(ret.expiresString);
            }
            catch (IllegalArgumentException ex) {
                if ("-1".equals(ret.expiresString) || "0".equals(ret.expiresString)) {
                    ret.expires = 0L;
                }
                Log.e(LOGTAG, "illegal expires: " + ret.expiresString);
            }
        }
        if ((contentDisposition = headers.getContentDisposition()) != null) {
            ret.contentdisposition = contentDisposition;
        }
        if ((crossDomain = headers.getXPermittedCrossDomainPolicies()) != null) {
            ret.crossDomain = crossDomain;
        }
        if ((lastModified = headers.getLastModified()) != null && lastModified.length() > 0) {
            ret.lastModified = lastModified;
        }
        if ((etag = headers.getEtag()) != null && etag.length() > 0) {
            ret.etag = etag;
        }
        if ((cacheControl = headers.getCacheControl()) != null) {
            String[] controls = cacheControl.toLowerCase().split("[ ,;]");
            for (int i = 0; i < controls.length; ++i) {
                if (NO_STORE.equals(controls[i])) {
                    return null;
                }
                if (NO_CACHE.equals(controls[i])) {
                    ret.expires = 0L;
                    continue;
                }
                if (!controls[i].startsWith(MAX_AGE)) continue;
                int separator = controls[i].indexOf(61);
                if (separator < 0) {
                    separator = controls[i].indexOf(58);
                }
                if (separator <= 0) continue;
                String s = controls[i].substring(separator + 1);
                try {
                    long sec = Long.parseLong(s);
                    if (sec < 0L) continue;
                    ret.expires = System.currentTimeMillis() + 1000L * sec;
                    continue;
                }
                catch (NumberFormatException ex) {
                    if ("1d".equals(s)) {
                        ret.expires = System.currentTimeMillis() + 86400000L;
                        continue;
                    }
                    Log.e(LOGTAG, "exception in parseHeaders for max-age:" + controls[i].substring(separator + 1));
                    ret.expires = 0L;
                }
            }
        }
        if (NO_CACHE.equals(headers.getPragma())) {
            ret.expires = 0L;
        }
        if (ret.expires == -1L) {
            if (ret.httpStatusCode == 301) {
                ret.expires = Long.MAX_VALUE;
            } else if (ret.httpStatusCode == 302 || ret.httpStatusCode == 307) {
                ret.expires = 0L;
            } else if (ret.lastModified == null) {
                ret.expires = !mimeType.startsWith("text/html") ? System.currentTimeMillis() + 86400000L : 0L;
            } else {
                long lastmod = System.currentTimeMillis() + 86400000L;
                try {
                    lastmod = AndroidHttpClient.parseDate(ret.lastModified);
                }
                catch (IllegalArgumentException ex) {
                    Log.e(LOGTAG, "illegal lastModified: " + ret.lastModified);
                }
                long difference = System.currentTimeMillis() - lastmod;
                ret.expires = difference > 0L ? System.currentTimeMillis() + difference / 5L : lastmod;
            }
        }
        return ret;
    }

    static {
        mTrimCacheCount = 0;
        mClearCacheOnInit = false;
    }

    public static class CacheResult {
        int httpStatusCode;
        long contentLength;
        long expires;
        String expiresString;
        String localPath;
        String lastModified;
        String etag;
        String mimeType;
        String location;
        String encoding;
        String contentdisposition;
        String crossDomain;
        InputStream inStream;
        OutputStream outStream;
        File outFile;

        public int getHttpStatusCode() {
            return this.httpStatusCode;
        }

        public long getContentLength() {
            return this.contentLength;
        }

        public String getLocalPath() {
            return this.localPath;
        }

        public long getExpires() {
            return this.expires;
        }

        public String getExpiresString() {
            return this.expiresString;
        }

        public String getLastModified() {
            return this.lastModified;
        }

        public String getETag() {
            return this.etag;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public String getContentDisposition() {
            return this.contentdisposition;
        }

        public InputStream getInputStream() {
            return this.inStream;
        }

        public OutputStream getOutputStream() {
            return this.outStream;
        }

        public void setInputStream(InputStream stream) {
            this.inStream = stream;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }
    }
}

