/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.android.internal.R;

public class ScaleAnimation
extends Animation {
    private float mFromX;
    private float mToX;
    private float mFromY;
    private float mToY;
    private int mPivotXType = 0;
    private int mPivotYType = 0;
    private float mPivotXValue = 0.0f;
    private float mPivotYValue = 0.0f;
    private float mPivotX;
    private float mPivotY;

    public ScaleAnimation(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ScaleAnimation);
        this.mFromX = a.getFloat(2, 0.0f);
        this.mToX = a.getFloat(3, 0.0f);
        this.mFromY = a.getFloat(4, 0.0f);
        this.mToY = a.getFloat(5, 0.0f);
        Animation.Description d = Animation.Description.parseValue(a.peekValue(0));
        this.mPivotXType = d.type;
        this.mPivotXValue = d.value;
        d = Animation.Description.parseValue(a.peekValue(1));
        this.mPivotYType = d.type;
        this.mPivotYValue = d.value;
        a.recycle();
    }

    public ScaleAnimation(float fromX, float toX, float fromY, float toY) {
        this.mFromX = fromX;
        this.mToX = toX;
        this.mFromY = fromY;
        this.mToY = toY;
        this.mPivotX = 0.0f;
        this.mPivotY = 0.0f;
    }

    public ScaleAnimation(float fromX, float toX, float fromY, float toY, float pivotX, float pivotY) {
        this.mFromX = fromX;
        this.mToX = toX;
        this.mFromY = fromY;
        this.mToY = toY;
        this.mPivotXType = 0;
        this.mPivotYType = 0;
        this.mPivotXValue = pivotX;
        this.mPivotYValue = pivotY;
    }

    public ScaleAnimation(float fromX, float toX, float fromY, float toY, int pivotXType, float pivotXValue, int pivotYType, float pivotYValue) {
        this.mFromX = fromX;
        this.mToX = toX;
        this.mFromY = fromY;
        this.mToY = toY;
        this.mPivotXValue = pivotXValue;
        this.mPivotXType = pivotXType;
        this.mPivotYValue = pivotYValue;
        this.mPivotYType = pivotYType;
    }

    protected void applyTransformation(float interpolatedTime, Transformation t) {
        float sx = 1.0f;
        float sy = 1.0f;
        if (this.mFromX != 1.0f || this.mToX != 1.0f) {
            sx = this.mFromX + (this.mToX - this.mFromX) * interpolatedTime;
        }
        if (this.mFromY != 1.0f || this.mToY != 1.0f) {
            sy = this.mFromY + (this.mToY - this.mFromY) * interpolatedTime;
        }
        if (this.mPivotX == 0.0f && this.mPivotY == 0.0f) {
            t.getMatrix().setScale(sx, sy);
        } else {
            t.getMatrix().setScale(sx, sy, this.mPivotX, this.mPivotY);
        }
    }

    public void initialize(int width, int height, int parentWidth, int parentHeight) {
        super.initialize(width, height, parentWidth, parentHeight);
        this.mPivotX = this.resolveSize(this.mPivotXType, this.mPivotXValue, width, parentWidth);
        this.mPivotY = this.resolveSize(this.mPivotYType, this.mPivotYValue, height, parentHeight);
    }
}

