/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.MessageQueue;
import android.view.InputChannel;
import android.view.InputHandler;
import android.view.KeyEvent;
import android.view.MotionEvent;

public final class InputQueue {
    private static final String TAG = "InputQueue";
    private static final boolean DEBUG = false;
    final InputChannel mChannel;
    private static final Object sLock = new Object();

    private static native void nativeRegisterInputChannel(InputChannel var0, InputHandler var1, MessageQueue var2);

    private static native void nativeUnregisterInputChannel(InputChannel var0);

    private static native void nativeFinished(long var0);

    public InputQueue(InputChannel channel) {
        this.mChannel = channel;
    }

    public InputChannel getInputChannel() {
        return this.mChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerInputChannel(InputChannel inputChannel, InputHandler inputHandler, MessageQueue messageQueue) {
        if (inputChannel == null) {
            throw new IllegalArgumentException("inputChannel must not be null");
        }
        if (inputHandler == null) {
            throw new IllegalArgumentException("inputHandler must not be null");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("messageQueue must not be null");
        }
        Object object = sLock;
        synchronized (object) {
            InputQueue.nativeRegisterInputChannel(inputChannel, inputHandler, messageQueue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterInputChannel(InputChannel inputChannel) {
        if (inputChannel == null) {
            throw new IllegalArgumentException("inputChannel must not be null");
        }
        Object object = sLock;
        synchronized (object) {
            InputQueue.nativeUnregisterInputChannel(inputChannel);
        }
    }

    private static void dispatchKeyEvent(InputHandler inputHandler, KeyEvent event, long finishedToken) {
        FinishedCallback finishedCallback = FinishedCallback.obtain(finishedToken);
        inputHandler.handleKey(event, finishedCallback);
    }

    private static void dispatchMotionEvent(InputHandler inputHandler, MotionEvent event, long finishedToken) {
        FinishedCallback finishedCallback = FinishedCallback.obtain(finishedToken);
        inputHandler.handleMotion(event, finishedCallback);
    }

    private static class FinishedCallback
    implements Runnable {
        private static final boolean DEBUG_RECYCLING = false;
        private static final int RECYCLE_MAX_COUNT = 4;
        private static FinishedCallback sRecycleHead;
        private static int sRecycleCount;
        private FinishedCallback mRecycleNext;
        private long mFinishedToken;

        private FinishedCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static FinishedCallback obtain(long finishedToken) {
            Object object = sLock;
            synchronized (object) {
                FinishedCallback callback = sRecycleHead;
                if (callback != null) {
                    sRecycleHead = callback.mRecycleNext;
                    --sRecycleCount;
                    callback.mRecycleNext = null;
                } else {
                    callback = new FinishedCallback();
                }
                callback.mFinishedToken = finishedToken;
                return callback;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = sLock;
            synchronized (object) {
                if (this.mFinishedToken == -1L) {
                    throw new IllegalStateException("Event finished callback already invoked.");
                }
                InputQueue.nativeFinished(this.mFinishedToken);
                this.mFinishedToken = -1L;
                if (sRecycleCount < 4) {
                    this.mRecycleNext = sRecycleHead;
                    sRecycleHead = this;
                    ++sRecycleCount;
                }
            }
        }
    }

    public static interface Callback {
        public void onInputQueueCreated(InputQueue var1);

        public void onInputQueueDestroyed(InputQueue var1);
    }
}

