/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Parcel;
import android.os.Parcelable;
import android.view.InputDevice;
import android.view.KeyEvent;
import android.view.MotionEvent;

public abstract class InputEvent
implements Parcelable {
    protected int mDeviceId;
    protected int mSource;
    protected static final int PARCEL_TOKEN_MOTION_EVENT = 1;
    protected static final int PARCEL_TOKEN_KEY_EVENT = 2;
    public static final Parcelable.Creator<InputEvent> CREATOR = new Parcelable.Creator<InputEvent>(){

        @Override
        public InputEvent createFromParcel(Parcel in) {
            int token = in.readInt();
            if (token == 2) {
                return KeyEvent.createFromParcelBody(in);
            }
            if (token == 1) {
                return MotionEvent.createFromParcelBody(in);
            }
            throw new IllegalStateException("Unexpected input event type token in parcel.");
        }

        public InputEvent[] newArray(int size) {
            return new InputEvent[size];
        }
    };

    InputEvent() {
    }

    public final int getDeviceId() {
        return this.mDeviceId;
    }

    public final InputDevice getDevice() {
        return InputDevice.getDevice(this.mDeviceId);
    }

    public final int getSource() {
        return this.mSource;
    }

    public final void setSource(int source) {
        this.mSource = source;
    }

    public int describeContents() {
        return 0;
    }

    protected final void readBaseFromParcel(Parcel in) {
        this.mDeviceId = in.readInt();
        this.mSource = in.readInt();
    }

    protected final void writeBaseToParcel(Parcel out) {
        out.writeInt(this.mDeviceId);
        out.writeInt(this.mSource);
    }
}

