/*
 * Decompiled with CFR 0.152.
 */
package android.service.urlrenderer;

import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.service.urlrenderer.IUrlRendererCallback;
import android.service.urlrenderer.IUrlRendererService;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UrlRenderer {
    private IUrlRendererService mService;

    public UrlRenderer(IBinder service) {
        this.mService = IUrlRendererService.Stub.asInterface(service);
    }

    public void render(List<String> urls, int width, int height, Callback callback) {
        if (this.mService != null) {
            try {
                this.mService.render(urls, width, height, new InternalCallback(callback));
            }
            catch (RemoteException ex) {
                // empty catch block
            }
        }
    }

    private static class InternalCallback
    extends IUrlRendererCallback.Stub {
        private final Callback mCallback;

        InternalCallback(Callback cb) {
            this.mCallback = cb;
        }

        public void complete(String url, ParcelFileDescriptor result) {
            this.mCallback.complete(url, result);
        }
    }

    public static interface Callback {
        public void complete(String var1, ParcelFileDescriptor var2);
    }
}

