/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.graphics.Bitmap;
import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.Type;
import android.util.Log;
import android.view.Surface;
import java.lang.reflect.Field;

public class RenderScript {
    static final String LOG_TAG = "RenderScript_jni";
    protected static final boolean DEBUG = false;
    protected static final boolean LOG_ENABLED = false;
    protected static boolean sInitialized = false;
    protected int mDev;
    protected int mContext;
    protected MessageThread mMessageThread;
    Element mElement_USER_U8;
    Element mElement_USER_I8;
    Element mElement_USER_U16;
    Element mElement_USER_I16;
    Element mElement_USER_U32;
    Element mElement_USER_I32;
    Element mElement_USER_F32;
    Element mElement_A_8;
    Element mElement_RGB_565;
    Element mElement_RGB_888;
    Element mElement_RGBA_5551;
    Element mElement_RGBA_4444;
    Element mElement_RGBA_8888;
    Element mElement_INDEX_16;
    Element mElement_POSITION_2;
    Element mElement_POSITION_3;
    Element mElement_TEXTURE_2;
    Element mElement_NORMAL_3;
    Element mElement_COLOR_U8_4;
    Element mElement_COLOR_F32_4;
    public RSMessage mMessageCallback = null;

    protected static native void _nInit();

    native void nInitElements(int var1, int var2, int var3, int var4);

    native int nDeviceCreate();

    native void nDeviceDestroy(int var1);

    native void nDeviceSetConfig(int var1, int var2, int var3);

    native int nContextCreateGL(int var1, int var2, boolean var3);

    native int nContextCreate(int var1, int var2);

    native void nContextDestroy(int var1);

    native void nContextSetSurface(int var1, int var2, Surface var3);

    native void nContextSetPriority(int var1);

    native void nContextDump(int var1);

    native void nContextBindRootScript(int var1);

    native void nContextBindSampler(int var1, int var2);

    native void nContextBindProgramFragmentStore(int var1);

    native void nContextBindProgramFragment(int var1);

    native void nContextBindProgramVertex(int var1);

    native void nContextBindProgramRaster(int var1);

    native void nContextPause();

    native void nContextResume();

    native int nContextGetMessage(int[] var1, boolean var2);

    native void nContextInitToClient();

    native void nContextDeinitToClient();

    native void nAssignName(int var1, byte[] var2);

    native void nObjDestroy(int var1);

    native void nObjDestroyOOB(int var1);

    native int nFileOpen(byte[] var1);

    native int nElementCreate(int var1, int var2, boolean var3, int var4);

    native int nElementCreate2(int[] var1, String[] var2);

    native void nTypeBegin(int var1);

    native void nTypeAdd(int var1, int var2);

    native int nTypeCreate();

    native void nTypeFinalDestroy(Type var1);

    native void nTypeSetupFields(Type var1, int[] var2, int[] var3, Field[] var4);

    native int nAllocationCreateTyped(int var1);

    native int nAllocationCreateFromBitmap(int var1, boolean var2, Bitmap var3);

    native int nAllocationCreateBitmapRef(int var1, Bitmap var2);

    native int nAllocationCreateFromBitmapBoxed(int var1, boolean var2, Bitmap var3);

    native int nAllocationCreateFromAssetStream(int var1, boolean var2, int var3);

    native void nAllocationUploadToTexture(int var1, boolean var2, int var3);

    native void nAllocationUploadToBufferObject(int var1);

    native void nAllocationSubData1D(int var1, int var2, int var3, int[] var4, int var5);

    native void nAllocationSubData1D(int var1, int var2, int var3, short[] var4, int var5);

    native void nAllocationSubData1D(int var1, int var2, int var3, byte[] var4, int var5);

    native void nAllocationSubData1D(int var1, int var2, int var3, float[] var4, int var5);

    native void nAllocationSubData2D(int var1, int var2, int var3, int var4, int var5, int[] var6, int var7);

    native void nAllocationSubData2D(int var1, int var2, int var3, int var4, int var5, float[] var6, int var7);

    native void nAllocationRead(int var1, int[] var2);

    native void nAllocationRead(int var1, float[] var2);

    native void nAllocationSubDataFromObject(int var1, Type var2, int var3, Object var4);

    native void nAllocationSubReadFromObject(int var1, Type var2, int var3, Object var4);

    native void nAdapter1DBindAllocation(int var1, int var2);

    native void nAdapter1DSetConstraint(int var1, int var2, int var3);

    native void nAdapter1DData(int var1, int[] var2);

    native void nAdapter1DData(int var1, float[] var2);

    native void nAdapter1DSubData(int var1, int var2, int var3, int[] var4);

    native void nAdapter1DSubData(int var1, int var2, int var3, float[] var4);

    native int nAdapter1DCreate();

    native void nAdapter2DBindAllocation(int var1, int var2);

    native void nAdapter2DSetConstraint(int var1, int var2, int var3);

    native void nAdapter2DData(int var1, int[] var2);

    native void nAdapter2DData(int var1, float[] var2);

    native void nAdapter2DSubData(int var1, int var2, int var3, int var4, int var5, int[] var6);

    native void nAdapter2DSubData(int var1, int var2, int var3, int var4, int var5, float[] var6);

    native int nAdapter2DCreate();

    native void nScriptBindAllocation(int var1, int var2, int var3);

    native void nScriptSetClearColor(int var1, float var2, float var3, float var4, float var5);

    native void nScriptSetClearDepth(int var1, float var2);

    native void nScriptSetClearStencil(int var1, int var2);

    native void nScriptSetTimeZone(int var1, byte[] var2);

    native void nScriptSetType(int var1, boolean var2, String var3, int var4);

    native void nScriptSetRoot(boolean var1);

    native void nScriptSetInvokable(String var1, int var2);

    native void nScriptInvoke(int var1, int var2);

    native void nScriptCBegin();

    native void nScriptCSetScript(byte[] var1, int var2, int var3);

    native int nScriptCCreate();

    native void nScriptCAddDefineI32(String var1, int var2);

    native void nScriptCAddDefineF(String var1, float var2);

    native void nSamplerBegin();

    native void nSamplerSet(int var1, int var2);

    native int nSamplerCreate();

    native void nProgramFragmentStoreBegin(int var1, int var2);

    native void nProgramFragmentStoreDepthFunc(int var1);

    native void nProgramFragmentStoreDepthMask(boolean var1);

    native void nProgramFragmentStoreColorMask(boolean var1, boolean var2, boolean var3, boolean var4);

    native void nProgramFragmentStoreBlendFunc(int var1, int var2);

    native void nProgramFragmentStoreDither(boolean var1);

    native int nProgramFragmentStoreCreate();

    native int nProgramRasterCreate(int var1, int var2, boolean var3, boolean var4, boolean var5);

    native void nProgramRasterSetLineWidth(int var1, float var2);

    native void nProgramRasterSetPointSize(int var1, float var2);

    native void nProgramBindConstants(int var1, int var2, int var3);

    native void nProgramBindTexture(int var1, int var2, int var3);

    native void nProgramBindSampler(int var1, int var2, int var3);

    native int nProgramFragmentCreate(int[] var1);

    native int nProgramFragmentCreate2(String var1, int[] var2);

    native int nProgramVertexCreate(boolean var1);

    native int nProgramVertexCreate2(String var1, int[] var2);

    native void nLightBegin();

    native void nLightSetIsMono(boolean var1);

    native void nLightSetIsLocal(boolean var1);

    native int nLightCreate();

    native void nLightSetColor(int var1, float var2, float var3, float var4);

    native void nLightSetPosition(int var1, float var2, float var3, float var4);

    native int nSimpleMeshCreate(int var1, int var2, int[] var3, int var4);

    native void nSimpleMeshBindVertex(int var1, int var2, int var3);

    native void nSimpleMeshBindIndex(int var1, int var2);

    native void nAnimationBegin(int var1, int var2);

    native void nAnimationAdd(float var1, float[] var2);

    native int nAnimationCreate();

    void validate() {
        if (this.mContext == 0) {
            throw new IllegalStateException("Calling RS with no Context active.");
        }
    }

    public void contextSetPriority(Priority p) {
        this.validate();
        this.nContextSetPriority(p.mID);
    }

    protected RenderScript() {
    }

    public static RenderScript create() {
        RenderScript rs = new RenderScript();
        rs.mDev = rs.nDeviceCreate();
        rs.mContext = rs.nContextCreate(rs.mDev, 0);
        rs.mMessageThread = new MessageThread(rs);
        rs.mMessageThread.start();
        Element.initPredefined(rs);
        return rs;
    }

    public void contextDump(int bits) {
        this.validate();
        this.nContextDump(bits);
    }

    public void destroy() {
        this.validate();
        this.nContextDeinitToClient();
        this.mMessageThread.mRun = false;
        this.nContextDestroy(this.mContext);
        this.mContext = 0;
        this.nDeviceDestroy(this.mDev);
        this.mDev = 0;
    }

    boolean isAlive() {
        return this.mContext != 0;
    }

    protected int safeID(BaseObj o) {
        if (o != null) {
            return o.mID;
        }
        return 0;
    }

    static {
        try {
            System.loadLibrary("rs_jni");
            RenderScript._nInit();
            sInitialized = true;
        }
        catch (UnsatisfiedLinkError e) {
            Log.d(LOG_TAG, "RenderScript JNI library not found!");
        }
    }

    protected static class MessageThread
    extends Thread {
        RenderScript mRS;
        boolean mRun = true;

        MessageThread(RenderScript rs) {
            super("RSMessageThread");
            this.mRS = rs;
        }

        public void run() {
            int[] rbuf = new int[16];
            this.mRS.nContextInitToClient();
            while (this.mRun) {
                int msg = this.mRS.nContextGetMessage(rbuf, true);
                if (msg == 0) {
                    try {
                        MessageThread.sleep(1L, 0);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.mRS.mMessageCallback == null) continue;
                this.mRS.mMessageCallback.mData = rbuf;
                this.mRS.mMessageCallback.mID = msg;
                this.mRS.mMessageCallback.run();
            }
            Log.d(RenderScript.LOG_TAG, "MessageThread exiting.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Priority {
        LOW(5),
        NORMAL(-4);

        int mID;

        private Priority(int id2) {
            this.mID = id2;
        }
    }

    public static class RSMessage
    implements Runnable {
        protected int[] mData;
        protected int mID;

        public void run() {
        }
    }
}

