/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.accounts.Account;
import android.content.ContentProviderClient;
import android.content.ContentProviderOperation;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.CursorEntityIterator;
import android.content.Entity;
import android.content.EntityIterator;
import android.content.Intent;
import android.content.res.Resources;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteException;
import android.graphics.Rect;
import android.net.Uri;
import android.os.RemoteException;
import android.provider.BaseColumns;
import android.provider.SyncStateContract;
import android.text.TextUtils;
import android.util.Pair;
import android.view.View;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public final class ContactsContract {
    public static final String AUTHORITY = "com.android.contacts";
    public static final Uri AUTHORITY_URI = Uri.parse("content://com.android.contacts");
    public static final String CALLER_IS_SYNCADAPTER = "caller_is_syncadapter";
    public static final String REQUESTING_PACKAGE_PARAM_KEY = "requesting_package";

    public static final class Intents {
        public static final String SEARCH_SUGGESTION_CLICKED = "android.provider.Contacts.SEARCH_SUGGESTION_CLICKED";
        public static final String SEARCH_SUGGESTION_DIAL_NUMBER_CLICKED = "android.provider.Contacts.SEARCH_SUGGESTION_DIAL_NUMBER_CLICKED";
        public static final String SEARCH_SUGGESTION_CREATE_CONTACT_CLICKED = "android.provider.Contacts.SEARCH_SUGGESTION_CREATE_CONTACT_CLICKED";
        public static final String ATTACH_IMAGE = "com.android.contacts.action.ATTACH_IMAGE";
        public static final String SHOW_OR_CREATE_CONTACT = "com.android.contacts.action.SHOW_OR_CREATE_CONTACT";
        public static final String EXTRA_FORCE_CREATE = "com.android.contacts.action.FORCE_CREATE";
        public static final String EXTRA_CREATE_DESCRIPTION = "com.android.contacts.action.CREATE_DESCRIPTION";
        @Deprecated
        public static final String EXTRA_TARGET_RECT = "target_rect";
        @Deprecated
        public static final String EXTRA_MODE = "mode";
        @Deprecated
        public static final int MODE_SMALL = 1;
        @Deprecated
        public static final int MODE_MEDIUM = 2;
        @Deprecated
        public static final int MODE_LARGE = 3;
        @Deprecated
        public static final String EXTRA_EXCLUDE_MIMES = "exclude_mimes";

        public static final class Insert {
            public static final String ACTION = "android.intent.action.INSERT";
            public static final String FULL_MODE = "full_mode";
            public static final String NAME = "name";
            public static final String PHONETIC_NAME = "phonetic_name";
            public static final String COMPANY = "company";
            public static final String JOB_TITLE = "job_title";
            public static final String NOTES = "notes";
            public static final String PHONE = "phone";
            public static final String PHONE_TYPE = "phone_type";
            public static final String PHONE_ISPRIMARY = "phone_isprimary";
            public static final String SECONDARY_PHONE = "secondary_phone";
            public static final String SECONDARY_PHONE_TYPE = "secondary_phone_type";
            public static final String TERTIARY_PHONE = "tertiary_phone";
            public static final String TERTIARY_PHONE_TYPE = "tertiary_phone_type";
            public static final String EMAIL = "email";
            public static final String EMAIL_TYPE = "email_type";
            public static final String EMAIL_ISPRIMARY = "email_isprimary";
            public static final String SECONDARY_EMAIL = "secondary_email";
            public static final String SECONDARY_EMAIL_TYPE = "secondary_email_type";
            public static final String TERTIARY_EMAIL = "tertiary_email";
            public static final String TERTIARY_EMAIL_TYPE = "tertiary_email_type";
            public static final String POSTAL = "postal";
            public static final String POSTAL_TYPE = "postal_type";
            public static final String POSTAL_ISPRIMARY = "postal_isprimary";
            public static final String IM_HANDLE = "im_handle";
            public static final String IM_PROTOCOL = "im_protocol";
            public static final String IM_ISPRIMARY = "im_isprimary";
        }

        public static final class UI {
            public static final String LIST_DEFAULT = "com.android.contacts.action.LIST_DEFAULT";
            public static final String LIST_GROUP_ACTION = "com.android.contacts.action.LIST_GROUP";
            public static final String GROUP_NAME_EXTRA_KEY = "com.android.contacts.extra.GROUP";
            public static final String LIST_ALL_CONTACTS_ACTION = "com.android.contacts.action.LIST_ALL_CONTACTS";
            public static final String LIST_CONTACTS_WITH_PHONES_ACTION = "com.android.contacts.action.LIST_CONTACTS_WITH_PHONES";
            public static final String LIST_STARRED_ACTION = "com.android.contacts.action.LIST_STARRED";
            public static final String LIST_FREQUENT_ACTION = "com.android.contacts.action.LIST_FREQUENT";
            public static final String LIST_STREQUENT_ACTION = "com.android.contacts.action.LIST_STREQUENT";
            public static final String TITLE_EXTRA_KEY = "com.android.contacts.extra.TITLE_EXTRA";
            public static final String FILTER_CONTACTS_ACTION = "com.android.contacts.action.FILTER_CONTACTS";
            public static final String FILTER_TEXT_EXTRA_KEY = "com.android.contacts.extra.FILTER_TEXT";
        }
    }

    public static final class QuickContact {
        public static final String ACTION_QUICK_CONTACT = "com.android.contacts.action.QUICK_CONTACT";
        @Deprecated
        public static final String EXTRA_TARGET_RECT = "target_rect";
        public static final String EXTRA_MODE = "mode";
        public static final String EXTRA_EXCLUDE_MIMES = "exclude_mimes";
        public static final int MODE_SMALL = 1;
        public static final int MODE_MEDIUM = 2;
        public static final int MODE_LARGE = 3;
        public static final String EXTRA_SELECTED_CONTACTS_APP_TAB_INDEX = "SELECTED_TAB_INDEX";

        public static void showQuickContact(Context context, View target, Uri lookupUri, int mode, String[] excludeMimes) {
            context.startActivity(QuickContact.getQuickContactIntent(context, target, lookupUri, mode, excludeMimes));
        }

        public static Intent getQuickContactIntent(Context context, View target, Uri lookupUri, int mode, String[] excludeMimes) {
            float appScale = context.getResources().getCompatibilityInfo().applicationScale;
            int[] pos = new int[2];
            target.getLocationOnScreen(pos);
            Rect rect = new Rect();
            rect.left = (int)((float)pos[0] * appScale + 0.5f);
            rect.top = (int)((float)pos[1] * appScale + 0.5f);
            rect.right = (int)((float)(pos[0] + target.getWidth()) * appScale + 0.5f);
            rect.bottom = (int)((float)(pos[1] + target.getHeight()) * appScale + 0.5f);
            return QuickContact.getQuickContactIntent(context, rect, lookupUri, mode, excludeMimes);
        }

        public static void showQuickContact(Context context, Rect target, Uri lookupUri, int mode, String[] excludeMimes) {
            context.startActivity(QuickContact.getQuickContactIntent(context, target, lookupUri, mode, excludeMimes));
        }

        public static Intent getQuickContactIntent(Context context, Rect target, Uri lookupUri, int mode, String[] excludeMimes) {
            Intent intent = new Intent(ACTION_QUICK_CONTACT);
            intent.setFlags(337641472);
            intent.setData(lookupUri);
            intent.setSourceBounds(target);
            intent.putExtra(EXTRA_MODE, mode);
            intent.putExtra(EXTRA_EXCLUDE_MIMES, excludeMimes);
            return intent;
        }
    }

    public static final class ProviderStatus {
        public static final Uri CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "provider_status");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/provider_status";
        public static final String STATUS = "status";
        public static final int STATUS_NORMAL = 0;
        public static final int STATUS_UPGRADING = 1;
        public static final int STATUS_UPGRADE_OUT_OF_MEMORY = 2;
        public static final int STATUS_CHANGING_LOCALE = 3;
        public static final String DATA1 = "data1";

        private ProviderStatus() {
        }
    }

    public static final class Settings
    implements SettingsColumns {
        public static final Uri CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "settings");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/setting";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/setting";

        private Settings() {
        }
    }

    protected static interface SettingsColumns {
        public static final String ACCOUNT_NAME = "account_name";
        public static final String ACCOUNT_TYPE = "account_type";
        public static final String SHOULD_SYNC = "should_sync";
        public static final String UNGROUPED_VISIBLE = "ungrouped_visible";
        public static final String ANY_UNSYNCED = "any_unsynced";
        public static final String UNGROUPED_COUNT = "summ_count";
        public static final String UNGROUPED_WITH_PHONES = "summ_phones";
    }

    public static final class AggregationExceptions
    implements BaseColumns {
        public static final Uri CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "aggregation_exceptions");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/aggregation_exception";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/aggregation_exception";
        public static final String TYPE = "type";
        public static final int TYPE_AUTOMATIC = 0;
        public static final int TYPE_KEEP_TOGETHER = 1;
        public static final int TYPE_KEEP_SEPARATE = 2;
        public static final String RAW_CONTACT_ID1 = "raw_contact_id1";
        public static final String RAW_CONTACT_ID2 = "raw_contact_id2";

        private AggregationExceptions() {
        }
    }

    public static final class Groups
    implements BaseColumns,
    GroupsColumns,
    SyncColumns {
        public static final Uri CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "groups");
        public static final Uri CONTENT_SUMMARY_URI = Uri.withAppendedPath(AUTHORITY_URI, "groups_summary");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/group";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/group";

        private Groups() {
        }

        public static EntityIterator newEntityIterator(Cursor cursor) {
            return new EntityIteratorImpl(cursor);
        }

        private static class EntityIteratorImpl
        extends CursorEntityIterator {
            public EntityIteratorImpl(Cursor cursor) {
                super(cursor);
            }

            public Entity getEntityAndIncrementCursor(Cursor cursor) throws RemoteException {
                ContentValues values = new ContentValues();
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, values, "_id");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, values, "account_name");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, values, "account_type");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, values, "dirty");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, values, "version");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, values, "sourceid");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, values, "res_package");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, values, "title");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, values, "title_res");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, values, "group_visible");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, values, "sync1");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, values, "sync2");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, values, "sync3");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, values, "sync4");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, values, "system_id");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, values, "deleted");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, values, "notes");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, values, "should_sync");
                cursor.moveToNext();
                return new Entity(values);
            }
        }
    }

    protected static interface GroupsColumns {
        public static final String TITLE = "title";
        public static final String RES_PACKAGE = "res_package";
        public static final String TITLE_RES = "title_res";
        public static final String NOTES = "notes";
        public static final String SYSTEM_ID = "system_id";
        public static final String SUMMARY_COUNT = "summ_count";
        public static final String SUMMARY_WITH_PHONES = "summ_phones";
        public static final String GROUP_VISIBLE = "group_visible";
        public static final String DELETED = "deleted";
        public static final String SHOULD_SYNC = "should_sync";
    }

    public static final class CommonDataKinds {
        public static final String PACKAGE_COMMON = "common";

        private CommonDataKinds() {
        }

        public static final class SipAddress
        implements DataColumnsWithJoins,
        CommonColumns {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/sip_address";
            public static final int TYPE_HOME = 1;
            public static final int TYPE_WORK = 2;
            public static final int TYPE_OTHER = 3;
            public static final String SIP_ADDRESS = "data1";

            private SipAddress() {
            }

            public static final int getTypeLabelResource(int type) {
                switch (type) {
                    case 1: {
                        return 17040001;
                    }
                    case 2: {
                        return 17040002;
                    }
                    case 3: {
                        return 17040003;
                    }
                }
                return 17040000;
            }

            public static final CharSequence getTypeLabel(Resources res, int type, CharSequence label) {
                if (type == 0 && !TextUtils.isEmpty(label)) {
                    return label;
                }
                int labelRes = SipAddress.getTypeLabelResource(type);
                return res.getText(labelRes);
            }
        }

        public static final class Website
        implements DataColumnsWithJoins,
        CommonColumns {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/website";
            public static final int TYPE_HOMEPAGE = 1;
            public static final int TYPE_BLOG = 2;
            public static final int TYPE_PROFILE = 3;
            public static final int TYPE_HOME = 4;
            public static final int TYPE_WORK = 5;
            public static final int TYPE_FTP = 6;
            public static final int TYPE_OTHER = 7;
            public static final String URL = "data1";

            private Website() {
            }
        }

        public static final class GroupMembership
        implements DataColumnsWithJoins {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/group_membership";
            public static final String GROUP_ROW_ID = "data1";
            public static final String GROUP_SOURCE_ID = "group_sourceid";

            private GroupMembership() {
            }
        }

        public static final class Note
        implements DataColumnsWithJoins {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/note";
            public static final String NOTE = "data1";

            private Note() {
            }
        }

        public static final class Photo
        implements DataColumnsWithJoins {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/photo";
            public static final String PHOTO = "data15";

            private Photo() {
            }
        }

        public static final class Event
        implements DataColumnsWithJoins,
        CommonColumns {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/contact_event";
            public static final int TYPE_ANNIVERSARY = 1;
            public static final int TYPE_OTHER = 2;
            public static final int TYPE_BIRTHDAY = 3;
            public static final String START_DATE = "data1";

            private Event() {
            }

            public static int getTypeResource(Integer type) {
                if (type == null) {
                    return 17039973;
                }
                switch (type) {
                    case 1: {
                        return 17039972;
                    }
                    case 3: {
                        return 17039971;
                    }
                    case 2: {
                        return 17039973;
                    }
                }
                return 17039973;
            }
        }

        public static final class Relation
        implements DataColumnsWithJoins,
        CommonColumns {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/relation";
            public static final int TYPE_ASSISTANT = 1;
            public static final int TYPE_BROTHER = 2;
            public static final int TYPE_CHILD = 3;
            public static final int TYPE_DOMESTIC_PARTNER = 4;
            public static final int TYPE_FATHER = 5;
            public static final int TYPE_FRIEND = 6;
            public static final int TYPE_MANAGER = 7;
            public static final int TYPE_MOTHER = 8;
            public static final int TYPE_PARENT = 9;
            public static final int TYPE_PARTNER = 10;
            public static final int TYPE_REFERRED_BY = 11;
            public static final int TYPE_RELATIVE = 12;
            public static final int TYPE_SISTER = 13;
            public static final int TYPE_SPOUSE = 14;
            public static final String NAME = "data1";

            private Relation() {
            }
        }

        public static final class Organization
        implements DataColumnsWithJoins,
        CommonColumns {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/organization";
            public static final int TYPE_WORK = 1;
            public static final int TYPE_OTHER = 2;
            public static final String COMPANY = "data1";
            public static final String TITLE = "data4";
            public static final String DEPARTMENT = "data5";
            public static final String JOB_DESCRIPTION = "data6";
            public static final String SYMBOL = "data7";
            public static final String PHONETIC_NAME = "data8";
            public static final String OFFICE_LOCATION = "data9";
            public static final String PHONETIC_NAME_STYLE = "data10";

            private Organization() {
            }

            public static final int getTypeLabelResource(int type) {
                switch (type) {
                    case 1: {
                        return 17039997;
                    }
                    case 2: {
                        return 17039998;
                    }
                }
                return 17039999;
            }

            public static final CharSequence getTypeLabel(Resources res, int type, CharSequence label) {
                if (type == 0 && !TextUtils.isEmpty(label)) {
                    return label;
                }
                int labelRes = Organization.getTypeLabelResource(type);
                return res.getText(labelRes);
            }
        }

        public static final class Im
        implements DataColumnsWithJoins,
        CommonColumns {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/im";
            public static final int TYPE_HOME = 1;
            public static final int TYPE_WORK = 2;
            public static final int TYPE_OTHER = 3;
            public static final String PROTOCOL = "data5";
            public static final String CUSTOM_PROTOCOL = "data6";
            public static final int PROTOCOL_CUSTOM = -1;
            public static final int PROTOCOL_AIM = 0;
            public static final int PROTOCOL_MSN = 1;
            public static final int PROTOCOL_YAHOO = 2;
            public static final int PROTOCOL_SKYPE = 3;
            public static final int PROTOCOL_QQ = 4;
            public static final int PROTOCOL_GOOGLE_TALK = 5;
            public static final int PROTOCOL_ICQ = 6;
            public static final int PROTOCOL_JABBER = 7;
            public static final int PROTOCOL_NETMEETING = 8;

            private Im() {
            }

            public static final int getTypeLabelResource(int type) {
                switch (type) {
                    case 1: {
                        return 17039984;
                    }
                    case 2: {
                        return 17039985;
                    }
                    case 3: {
                        return 17039986;
                    }
                }
                return 17039983;
            }

            public static final CharSequence getTypeLabel(Resources res, int type, CharSequence label) {
                if (type == 0 && !TextUtils.isEmpty(label)) {
                    return label;
                }
                int labelRes = Im.getTypeLabelResource(type);
                return res.getText(labelRes);
            }

            public static final int getProtocolLabelResource(int type) {
                switch (type) {
                    case 0: {
                        return 17039988;
                    }
                    case 1: {
                        return 17039989;
                    }
                    case 2: {
                        return 17039990;
                    }
                    case 3: {
                        return 17039991;
                    }
                    case 4: {
                        return 17039992;
                    }
                    case 5: {
                        return 17039993;
                    }
                    case 6: {
                        return 17039994;
                    }
                    case 7: {
                        return 17039995;
                    }
                    case 8: {
                        return 17039996;
                    }
                }
                return 17039987;
            }

            public static final CharSequence getProtocolLabel(Resources res, int type, CharSequence label) {
                if (type == -1 && !TextUtils.isEmpty(label)) {
                    return label;
                }
                int labelRes = Im.getProtocolLabelResource(type);
                return res.getText(labelRes);
            }
        }

        public static final class StructuredPostal
        implements DataColumnsWithJoins,
        CommonColumns {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/postal-address_v2";
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/postal-address_v2";
            public static final Uri CONTENT_URI = Uri.withAppendedPath(Data.CONTENT_URI, "postals");
            public static final int TYPE_HOME = 1;
            public static final int TYPE_WORK = 2;
            public static final int TYPE_OTHER = 3;
            public static final String FORMATTED_ADDRESS = "data1";
            public static final String STREET = "data4";
            public static final String POBOX = "data5";
            public static final String NEIGHBORHOOD = "data6";
            public static final String CITY = "data7";
            public static final String REGION = "data8";
            public static final String POSTCODE = "data9";
            public static final String COUNTRY = "data10";

            private StructuredPostal() {
            }

            public static final int getTypeLabelResource(int type) {
                switch (type) {
                    case 1: {
                        return 17039980;
                    }
                    case 2: {
                        return 17039981;
                    }
                    case 3: {
                        return 17039982;
                    }
                }
                return 17039979;
            }

            public static final CharSequence getTypeLabel(Resources res, int type, CharSequence label) {
                if (type == 0 && !TextUtils.isEmpty(label)) {
                    return label;
                }
                int labelRes = StructuredPostal.getTypeLabelResource(type);
                return res.getText(labelRes);
            }
        }

        public static final class Email
        implements DataColumnsWithJoins,
        CommonColumns {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/email_v2";
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/email_v2";
            public static final Uri CONTENT_URI = Uri.withAppendedPath(Data.CONTENT_URI, "emails");
            public static final Uri CONTENT_LOOKUP_URI = Uri.withAppendedPath(CONTENT_URI, "lookup");
            public static final Uri CONTENT_FILTER_URI = Uri.withAppendedPath(CONTENT_URI, "filter");
            public static final String ADDRESS = "data1";
            public static final int TYPE_HOME = 1;
            public static final int TYPE_WORK = 2;
            public static final int TYPE_OTHER = 3;
            public static final int TYPE_MOBILE = 4;
            public static final String DISPLAY_NAME = "data4";

            private Email() {
            }

            public static final int getTypeLabelResource(int type) {
                switch (type) {
                    case 1: {
                        return 17039975;
                    }
                    case 2: {
                        return 17039976;
                    }
                    case 3: {
                        return 17039977;
                    }
                    case 4: {
                        return 17039978;
                    }
                }
                return 17039974;
            }

            public static final CharSequence getTypeLabel(Resources res, int type, CharSequence label) {
                if (type == 0 && !TextUtils.isEmpty(label)) {
                    return label;
                }
                int labelRes = Email.getTypeLabelResource(type);
                return res.getText(labelRes);
            }
        }

        public static final class Phone
        implements DataColumnsWithJoins,
        CommonColumns {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/phone_v2";
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/phone_v2";
            public static final Uri CONTENT_URI = Uri.withAppendedPath(Data.CONTENT_URI, "phones");
            public static final Uri CONTENT_FILTER_URI = Uri.withAppendedPath(CONTENT_URI, "filter");
            public static final int TYPE_HOME = 1;
            public static final int TYPE_MOBILE = 2;
            public static final int TYPE_WORK = 3;
            public static final int TYPE_FAX_WORK = 4;
            public static final int TYPE_FAX_HOME = 5;
            public static final int TYPE_PAGER = 6;
            public static final int TYPE_OTHER = 7;
            public static final int TYPE_CALLBACK = 8;
            public static final int TYPE_CAR = 9;
            public static final int TYPE_COMPANY_MAIN = 10;
            public static final int TYPE_ISDN = 11;
            public static final int TYPE_MAIN = 12;
            public static final int TYPE_OTHER_FAX = 13;
            public static final int TYPE_RADIO = 14;
            public static final int TYPE_TELEX = 15;
            public static final int TYPE_TTY_TDD = 16;
            public static final int TYPE_WORK_MOBILE = 17;
            public static final int TYPE_WORK_PAGER = 18;
            public static final int TYPE_ASSISTANT = 19;
            public static final int TYPE_MMS = 20;
            public static final String NUMBER = "data1";

            private Phone() {
            }

            @Deprecated
            public static final CharSequence getDisplayLabel(Context context, int type, CharSequence label, CharSequence[] labelArray) {
                return Phone.getTypeLabel(context.getResources(), type, label);
            }

            @Deprecated
            public static final CharSequence getDisplayLabel(Context context, int type, CharSequence label) {
                return Phone.getTypeLabel(context.getResources(), type, label);
            }

            public static final int getTypeLabelResource(int type) {
                switch (type) {
                    case 1: {
                        return 17039951;
                    }
                    case 2: {
                        return 17039952;
                    }
                    case 3: {
                        return 17039953;
                    }
                    case 4: {
                        return 17039954;
                    }
                    case 5: {
                        return 17039955;
                    }
                    case 6: {
                        return 17039956;
                    }
                    case 7: {
                        return 17039957;
                    }
                    case 8: {
                        return 17039958;
                    }
                    case 9: {
                        return 17039959;
                    }
                    case 10: {
                        return 17039960;
                    }
                    case 11: {
                        return 17039961;
                    }
                    case 12: {
                        return 17039962;
                    }
                    case 13: {
                        return 17039963;
                    }
                    case 14: {
                        return 17039964;
                    }
                    case 15: {
                        return 17039965;
                    }
                    case 16: {
                        return 17039966;
                    }
                    case 17: {
                        return 17039967;
                    }
                    case 18: {
                        return 17039968;
                    }
                    case 19: {
                        return 17039969;
                    }
                    case 20: {
                        return 17039970;
                    }
                }
                return 17039950;
            }

            public static final CharSequence getTypeLabel(Resources res, int type, CharSequence label) {
                if (!(type != 0 && type != 19 || TextUtils.isEmpty(label))) {
                    return label;
                }
                int labelRes = Phone.getTypeLabelResource(type);
                return res.getText(labelRes);
            }
        }

        public static final class Nickname
        implements DataColumnsWithJoins,
        CommonColumns {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/nickname";
            public static final int TYPE_DEFAULT = 1;
            public static final int TYPE_OTHER_NAME = 2;
            public static final int TYPE_MAIDEN_NAME = 3;
            @Deprecated
            public static final int TYPE_MAINDEN_NAME = 3;
            public static final int TYPE_SHORT_NAME = 4;
            public static final int TYPE_INITIALS = 5;
            public static final String NAME = "data1";

            private Nickname() {
            }
        }

        public static final class StructuredName
        implements DataColumnsWithJoins {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/name";
            public static final String DISPLAY_NAME = "data1";
            public static final String GIVEN_NAME = "data2";
            public static final String FAMILY_NAME = "data3";
            public static final String PREFIX = "data4";
            public static final String MIDDLE_NAME = "data5";
            public static final String SUFFIX = "data6";
            public static final String PHONETIC_GIVEN_NAME = "data7";
            public static final String PHONETIC_MIDDLE_NAME = "data8";
            public static final String PHONETIC_FAMILY_NAME = "data9";
            public static final String FULL_NAME_STYLE = "data10";
            public static final String PHONETIC_NAME_STYLE = "data11";

            private StructuredName() {
            }
        }

        protected static interface CommonColumns
        extends BaseTypes {
            public static final String DATA = "data1";
            public static final String TYPE = "data2";
            public static final String LABEL = "data3";
        }

        public static interface BaseTypes {
            public static final int TYPE_CUSTOM = 0;
        }
    }

    public static class SearchSnippetColumns {
        public static final String SNIPPET_DATA_ID = "snippet_data_id";
        public static final String SNIPPET_MIMETYPE = "snippet_mimetype";
        public static final String SNIPPET_DATA1 = "snippet_data1";
        public static final String SNIPPET_DATA2 = "snippet_data2";
        public static final String SNIPPET_DATA3 = "snippet_data3";
        public static final String SNIPPET_DATA4 = "snippet_data4";
    }

    @Deprecated
    public static final class Presence
    extends StatusUpdates {
    }

    public static class StatusUpdates
    implements StatusColumns,
    PresenceColumns {
        public static final Uri CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "status_updates");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/status-update";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/status-update";

        private StatusUpdates() {
        }

        public static final int getPresenceIconResourceId(int status) {
            switch (status) {
                case 5: {
                    return 17301611;
                }
                case 2: 
                case 3: {
                    return 17301607;
                }
                case 4: {
                    return 17301608;
                }
                case 1: {
                    return 17301609;
                }
            }
            return 17301610;
        }

        public static final int getPresencePrecedence(int status) {
            return status;
        }
    }

    protected static interface PresenceColumns {
        public static final String DATA_ID = "presence_data_id";
        public static final String PROTOCOL = "protocol";
        public static final String CUSTOM_PROTOCOL = "custom_protocol";
        public static final String IM_HANDLE = "im_handle";
        public static final String IM_ACCOUNT = "im_account";
    }

    public static final class PhoneLookup
    implements BaseColumns,
    PhoneLookupColumns,
    ContactsColumns,
    ContactOptionsColumns {
        public static final Uri CONTENT_FILTER_URI = Uri.withAppendedPath(AUTHORITY_URI, "phone_lookup");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/phone_lookup";

        private PhoneLookup() {
        }
    }

    protected static interface PhoneLookupColumns {
        public static final String NUMBER = "number";
        public static final String TYPE = "type";
        public static final String LABEL = "label";
    }

    public static final class RawContactsEntity
    implements BaseColumns,
    DataColumns,
    RawContactsColumns {
        public static final Uri CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "raw_contact_entities");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/raw_contact_entity";
        public static final String FOR_EXPORT_ONLY = "for_export_only";
        public static final String DATA_ID = "data_id";

        private RawContactsEntity() {
        }
    }

    public static final class Data
    implements DataColumnsWithJoins {
        public static final Uri CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "data");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/data";
        public static final String FOR_EXPORT_ONLY = "for_export_only";

        private Data() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Uri getContactLookupUri(ContentResolver resolver, Uri dataUri) {
            Cursor cursor = resolver.query(dataUri, new String[]{"contact_id", "lookup"}, null, null, null);
            Uri lookupUri = null;
            try {
                if (cursor != null && cursor.moveToFirst()) {
                    long contactId = cursor.getLong(0);
                    String lookupKey = cursor.getString(1);
                    Uri uri = Contacts.getLookupUri(contactId, lookupKey);
                    return uri;
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            return lookupUri;
        }
    }

    protected static interface DataColumnsWithJoins
    extends BaseColumns,
    DataColumns,
    StatusColumns,
    RawContactsColumns,
    ContactsColumns,
    ContactNameColumns,
    ContactOptionsColumns,
    ContactStatusColumns {
    }

    protected static interface DataColumns {
        public static final String RES_PACKAGE = "res_package";
        public static final String MIMETYPE = "mimetype";
        public static final String RAW_CONTACT_ID = "raw_contact_id";
        public static final String IS_PRIMARY = "is_primary";
        public static final String IS_SUPER_PRIMARY = "is_super_primary";
        public static final String DATA_VERSION = "data_version";
        public static final String DATA1 = "data1";
        public static final String DATA2 = "data2";
        public static final String DATA3 = "data3";
        public static final String DATA4 = "data4";
        public static final String DATA5 = "data5";
        public static final String DATA6 = "data6";
        public static final String DATA7 = "data7";
        public static final String DATA8 = "data8";
        public static final String DATA9 = "data9";
        public static final String DATA10 = "data10";
        public static final String DATA11 = "data11";
        public static final String DATA12 = "data12";
        public static final String DATA13 = "data13";
        public static final String DATA14 = "data14";
        public static final String DATA15 = "data15";
        public static final String SYNC1 = "data_sync1";
        public static final String SYNC2 = "data_sync2";
        public static final String SYNC3 = "data_sync3";
        public static final String SYNC4 = "data_sync4";
    }

    protected static interface StatusColumns {
        public static final String PRESENCE = "mode";
        @Deprecated
        public static final String PRESENCE_STATUS = "mode";
        public static final int OFFLINE = 0;
        public static final int INVISIBLE = 1;
        public static final int AWAY = 2;
        public static final int IDLE = 3;
        public static final int DO_NOT_DISTURB = 4;
        public static final int AVAILABLE = 5;
        public static final String STATUS = "status";
        @Deprecated
        public static final String PRESENCE_CUSTOM_STATUS = "status";
        public static final String STATUS_TIMESTAMP = "status_ts";
        public static final String STATUS_RES_PACKAGE = "status_res_package";
        public static final String STATUS_LABEL = "status_label";
        public static final String STATUS_ICON = "status_icon";
        public static final String CHAT_CAPABILITY = "chat_capability";
        public static final int CAPABILITY_HAS_VIDEO_PLAYBACK_ONLY = 1;
        public static final int CAPABILITY_HAS_VOICE = 2;
        public static final int CAPABILITY_HAS_CAMERA = 4;
    }

    public static final class RawContacts
    implements BaseColumns,
    RawContactsColumns,
    ContactOptionsColumns,
    ContactNameColumns,
    SyncColumns {
        public static final Uri CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "raw_contacts");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/raw_contact";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/raw_contact";
        public static final int AGGREGATION_MODE_DEFAULT = 0;
        public static final int AGGREGATION_MODE_IMMEDIATE = 1;
        public static final int AGGREGATION_MODE_SUSPENDED = 2;
        public static final int AGGREGATION_MODE_DISABLED = 3;

        private RawContacts() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Uri getContactLookupUri(ContentResolver resolver, Uri rawContactUri) {
            Uri dataUri = Uri.withAppendedPath(rawContactUri, "data");
            Cursor cursor = resolver.query(dataUri, new String[]{"contact_id", "lookup"}, null, null, null);
            Uri lookupUri = null;
            try {
                if (cursor != null && cursor.moveToFirst()) {
                    long contactId = cursor.getLong(0);
                    String lookupKey = cursor.getString(1);
                    Uri uri = Contacts.getLookupUri(contactId, lookupKey);
                    return uri;
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            return lookupUri;
        }

        public static EntityIterator newEntityIterator(Cursor cursor) {
            return new EntityIteratorImpl(cursor);
        }

        private static class EntityIteratorImpl
        extends CursorEntityIterator {
            private static final String[] DATA_KEYS = new String[]{"data1", "data2", "data3", "data4", "data5", "data6", "data7", "data8", "data9", "data10", "data11", "data12", "data13", "data14", "data15", "data_sync1", "data_sync2", "data_sync3", "data_sync4"};

            public EntityIteratorImpl(Cursor cursor) {
                super(cursor);
            }

            public android.content.Entity getEntityAndIncrementCursor(Cursor cursor) throws RemoteException {
                int columnRawContactId = cursor.getColumnIndexOrThrow("_id");
                long rawContactId = cursor.getLong(columnRawContactId);
                ContentValues cv = new ContentValues();
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "account_name");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "account_type");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, cv, "_id");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, cv, "dirty");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, cv, "version");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "sourceid");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "sync1");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "sync2");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "sync3");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "sync4");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, cv, "deleted");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, cv, "contact_id");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, cv, "starred");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "is_restricted");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "name_verified");
                android.content.Entity contact = new android.content.Entity(cv);
                while (rawContactId == cursor.getLong(columnRawContactId)) {
                    cv = new ContentValues();
                    cv.put("_id", cursor.getLong(cursor.getColumnIndexOrThrow("data_id")));
                    DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "res_package");
                    DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "mimetype");
                    DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, cv, "is_primary");
                    DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, cv, "is_super_primary");
                    DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, cv, "data_version");
                    DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "group_sourceid");
                    DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "data_version");
                    for (String key : DATA_KEYS) {
                        int columnIndex = cursor.getColumnIndexOrThrow(key);
                        if (cursor.isNull(columnIndex)) continue;
                        try {
                            cv.put(key, cursor.getString(columnIndex));
                        }
                        catch (SQLiteException e) {
                            cv.put(key, cursor.getBlob(columnIndex));
                        }
                    }
                    contact.addSubValue(android.provider.ContactsContract$Data.CONTENT_URI, cv);
                    if (cursor.moveToNext()) continue;
                }
                return contact;
            }
        }

        public static final class Entity
        implements BaseColumns,
        DataColumns {
            public static final String CONTENT_DIRECTORY = "entity";
            public static final String DATA_ID = "data_id";

            private Entity() {
            }
        }

        public static final class Data
        implements BaseColumns,
        DataColumns {
            public static final String CONTENT_DIRECTORY = "data";

            private Data() {
            }
        }
    }

    protected static interface RawContactsColumns {
        public static final String CONTACT_ID = "contact_id";
        public static final String IS_RESTRICTED = "is_restricted";
        public static final String AGGREGATION_MODE = "aggregation_mode";
        public static final String DELETED = "deleted";
        public static final String NAME_VERIFIED = "name_verified";
    }

    public static class Contacts
    implements BaseColumns,
    ContactsColumns,
    ContactOptionsColumns,
    ContactNameColumns,
    ContactStatusColumns {
        public static final Uri CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "contacts");
        public static final Uri CONTENT_LOOKUP_URI = Uri.withAppendedPath(CONTENT_URI, "lookup");
        public static final Uri CONTENT_VCARD_URI = Uri.withAppendedPath(CONTENT_URI, "as_vcard");
        public static final Uri CONTENT_MULTI_VCARD_URI = Uri.withAppendedPath(CONTENT_URI, "as_multi_vcard");
        public static final Uri CONTENT_FILTER_URI = Uri.withAppendedPath(CONTENT_URI, "filter");
        public static final Uri CONTENT_STREQUENT_URI = Uri.withAppendedPath(CONTENT_URI, "strequent");
        public static final Uri CONTENT_STREQUENT_FILTER_URI = Uri.withAppendedPath(CONTENT_STREQUENT_URI, "filter");
        public static final Uri CONTENT_GROUP_URI = Uri.withAppendedPath(CONTENT_URI, "group");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/contact";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/contact";
        public static final String CONTENT_VCARD_TYPE = "text/x-vcard";

        private Contacts() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Uri getLookupUri(ContentResolver resolver, Uri contactUri) {
            Cursor c = resolver.query(contactUri, new String[]{"lookup", "_id"}, null, null, null);
            if (c == null) {
                return null;
            }
            try {
                if (c.moveToFirst()) {
                    String lookupKey = c.getString(0);
                    long contactId = c.getLong(1);
                    Uri uri = Contacts.getLookupUri(contactId, lookupKey);
                    return uri;
                }
            }
            finally {
                c.close();
            }
            return null;
        }

        public static Uri getLookupUri(long contactId, String lookupKey) {
            return ContentUris.withAppendedId(Uri.withAppendedPath(CONTENT_LOOKUP_URI, lookupKey), contactId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Uri lookupContact(ContentResolver resolver, Uri lookupUri) {
            if (lookupUri == null) {
                return null;
            }
            Cursor c = resolver.query(lookupUri, new String[]{"_id"}, null, null, null);
            if (c == null) {
                return null;
            }
            try {
                if (c.moveToFirst()) {
                    long contactId = c.getLong(0);
                    Uri uri = ContentUris.withAppendedId(CONTENT_URI, contactId);
                    return uri;
                }
            }
            finally {
                c.close();
            }
            return null;
        }

        public static void markAsContacted(ContentResolver resolver, long contactId) {
            Uri uri = ContentUris.withAppendedId(CONTENT_URI, contactId);
            ContentValues values = new ContentValues();
            values.put("last_time_contacted", System.currentTimeMillis());
            resolver.update(uri, values, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static InputStream openContactPhotoInputStream(ContentResolver cr, Uri contactUri) {
            Uri photoUri = Uri.withAppendedPath(contactUri, "photo");
            if (photoUri == null) {
                return null;
            }
            Cursor cursor = cr.query(photoUri, new String[]{"data15"}, null, null, null);
            try {
                if (cursor == null || !cursor.moveToNext()) {
                    InputStream inputStream = null;
                    return inputStream;
                }
                byte[] data = cursor.getBlob(0);
                if (data == null) {
                    InputStream inputStream = null;
                    return inputStream;
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
                return byteArrayInputStream;
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }

        public static final class Photo
        implements BaseColumns,
        DataColumns {
            public static final String CONTENT_DIRECTORY = "photo";
            public static final String PHOTO = "data15";

            private Photo() {
            }
        }

        public static final class AggregationSuggestions
        implements BaseColumns,
        ContactsColumns {
            public static final String CONTENT_DIRECTORY = "suggestions";

            private AggregationSuggestions() {
            }
        }

        public static final class Data
        implements BaseColumns,
        DataColumns {
            public static final String CONTENT_DIRECTORY = "data";

            private Data() {
            }
        }
    }

    public static final class ContactCounts {
        public static final String ADDRESS_BOOK_INDEX_EXTRAS = "address_book_index_extras";
        public static final String EXTRA_ADDRESS_BOOK_INDEX_TITLES = "address_book_index_titles";
        public static final String EXTRA_ADDRESS_BOOK_INDEX_COUNTS = "address_book_index_counts";
    }

    protected static interface ContactNameColumns {
        public static final String DISPLAY_NAME_SOURCE = "display_name_source";
        public static final String DISPLAY_NAME_PRIMARY = "display_name";
        public static final String DISPLAY_NAME_ALTERNATIVE = "display_name_alt";
        public static final String PHONETIC_NAME_STYLE = "phonetic_name_style";
        public static final String PHONETIC_NAME = "phonetic_name";
        public static final String SORT_KEY_PRIMARY = "sort_key";
        public static final String SORT_KEY_ALTERNATIVE = "sort_key_alt";
    }

    public static interface DisplayNameSources {
        public static final int UNDEFINED = 0;
        public static final int EMAIL = 10;
        public static final int PHONE = 20;
        public static final int ORGANIZATION = 30;
        public static final int NICKNAME = 35;
        public static final int STRUCTURED_NAME = 40;
    }

    public static interface PhoneticNameStyle {
        public static final int UNDEFINED = 0;
        public static final int PINYIN = 3;
        public static final int JAPANESE = 4;
        public static final int KOREAN = 5;
    }

    public static interface FullNameStyle {
        public static final int UNDEFINED = 0;
        public static final int WESTERN = 1;
        public static final int CJK = 2;
        public static final int CHINESE = 3;
        public static final int JAPANESE = 4;
        public static final int KOREAN = 5;
    }

    protected static interface ContactStatusColumns {
        public static final String CONTACT_PRESENCE = "contact_presence";
        public static final String CONTACT_CHAT_CAPABILITY = "contact_chat_capability";
        public static final String CONTACT_STATUS = "contact_status";
        public static final String CONTACT_STATUS_TIMESTAMP = "contact_status_ts";
        public static final String CONTACT_STATUS_RES_PACKAGE = "contact_status_res_package";
        public static final String CONTACT_STATUS_LABEL = "contact_status_label";
        public static final String CONTACT_STATUS_ICON = "contact_status_icon";
    }

    protected static interface ContactsColumns {
        public static final String DISPLAY_NAME = "display_name";
        public static final String NAME_RAW_CONTACT_ID = "name_raw_contact_id";
        public static final String PHOTO_ID = "photo_id";
        public static final String IN_VISIBLE_GROUP = "in_visible_group";
        public static final String HAS_PHONE_NUMBER = "has_phone_number";
        public static final String LOOKUP_KEY = "lookup";
    }

    protected static interface ContactOptionsColumns {
        public static final String TIMES_CONTACTED = "times_contacted";
        public static final String LAST_TIME_CONTACTED = "last_time_contacted";
        public static final String STARRED = "starred";
        public static final String CUSTOM_RINGTONE = "custom_ringtone";
        public static final String SEND_TO_VOICEMAIL = "send_to_voicemail";
    }

    protected static interface SyncColumns
    extends BaseSyncColumns {
        public static final String ACCOUNT_NAME = "account_name";
        public static final String ACCOUNT_TYPE = "account_type";
        public static final String SOURCE_ID = "sourceid";
        public static final String VERSION = "version";
        public static final String DIRTY = "dirty";
    }

    protected static interface BaseSyncColumns {
        public static final String SYNC1 = "sync1";
        public static final String SYNC2 = "sync2";
        public static final String SYNC3 = "sync3";
        public static final String SYNC4 = "sync4";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SyncState
    implements SyncStateContract.Columns {
        public static final String CONTENT_DIRECTORY = "syncstate";
        public static final Uri CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "syncstate");

        private SyncState() {
        }

        public static byte[] get(ContentProviderClient provider, Account account) throws RemoteException {
            return SyncStateContract.Helpers.get(provider, CONTENT_URI, account);
        }

        public static Pair<Uri, byte[]> getWithUri(ContentProviderClient provider, Account account) throws RemoteException {
            return SyncStateContract.Helpers.getWithUri(provider, CONTENT_URI, account);
        }

        public static void set(ContentProviderClient provider, Account account, byte[] data) throws RemoteException {
            SyncStateContract.Helpers.set(provider, CONTENT_URI, account, data);
        }

        public static ContentProviderOperation newSetOperation(Account account, byte[] data) {
            return SyncStateContract.Helpers.newSetOperation(CONTENT_URI, account, data);
        }
    }

    @Deprecated
    public static interface SyncStateColumns
    extends SyncStateContract.Columns {
    }

    public static final class Preferences {
        public static final String SORT_ORDER = "android.contacts.SORT_ORDER";
        public static final int SORT_ORDER_PRIMARY = 1;
        public static final int SORT_ORDER_ALTERNATIVE = 2;
        public static final String DISPLAY_ORDER = "android.contacts.DISPLAY_ORDER";
        public static final int DISPLAY_ORDER_PRIMARY = 1;
        public static final int DISPLAY_ORDER_ALTERNATIVE = 2;
    }
}

