/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.Preference;
import android.util.AttributeSet;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.widget.Checkable;
import android.widget.TextView;
import com.android.internal.R;

public class CheckBoxPreference
extends Preference {
    private CharSequence mSummaryOn;
    private CharSequence mSummaryOff;
    private boolean mChecked;
    private boolean mSendAccessibilityEventViewClickedType;
    private AccessibilityManager mAccessibilityManager;
    private boolean mDisableDependentsState;

    public CheckBoxPreference(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CheckBoxPreference, defStyle, 0);
        this.mSummaryOn = a.getString(0);
        this.mSummaryOff = a.getString(1);
        this.mDisableDependentsState = a.getBoolean(2, false);
        a.recycle();
        this.mAccessibilityManager = (AccessibilityManager)this.getContext().getSystemService("accessibility");
    }

    public CheckBoxPreference(Context context, AttributeSet attrs) {
        this(context, attrs, 16842895);
    }

    public CheckBoxPreference(Context context) {
        this(context, null);
    }

    protected void onBindView(View view) {
        TextView summaryView;
        super.onBindView(view);
        View checkboxView = view.findViewById(0x1020001);
        if (checkboxView != null && checkboxView instanceof Checkable) {
            ((Checkable)((Object)checkboxView)).setChecked(this.mChecked);
            if (this.mSendAccessibilityEventViewClickedType && this.mAccessibilityManager.isEnabled() && checkboxView.isEnabled()) {
                this.mSendAccessibilityEventViewClickedType = false;
                int eventType = 1;
                checkboxView.sendAccessibilityEventUnchecked(AccessibilityEvent.obtain(eventType));
            }
        }
        if ((summaryView = (TextView)view.findViewById(0x1020010)) != null) {
            CharSequence summary;
            boolean useDefaultSummary = true;
            if (this.mChecked && this.mSummaryOn != null) {
                summaryView.setText(this.mSummaryOn);
                useDefaultSummary = false;
            } else if (!this.mChecked && this.mSummaryOff != null) {
                summaryView.setText(this.mSummaryOff);
                useDefaultSummary = false;
            }
            if (useDefaultSummary && (summary = this.getSummary()) != null) {
                summaryView.setText(summary);
                useDefaultSummary = false;
            }
            int newVisibility = 8;
            if (!useDefaultSummary) {
                newVisibility = 0;
            }
            if (newVisibility != summaryView.getVisibility()) {
                summaryView.setVisibility(newVisibility);
            }
        }
    }

    protected void onClick() {
        super.onClick();
        boolean newValue = !this.isChecked();
        this.mSendAccessibilityEventViewClickedType = true;
        if (!this.callChangeListener(newValue)) {
            return;
        }
        this.setChecked(newValue);
    }

    public void setChecked(boolean checked) {
        if (this.mChecked != checked) {
            this.mChecked = checked;
            this.persistBoolean(checked);
            this.notifyDependencyChange(this.shouldDisableDependents());
            this.notifyChanged();
        }
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    public boolean shouldDisableDependents() {
        boolean shouldDisable = this.mDisableDependentsState ? this.mChecked : !this.mChecked;
        return shouldDisable || super.shouldDisableDependents();
    }

    public void setSummaryOn(CharSequence summary) {
        this.mSummaryOn = summary;
        if (this.isChecked()) {
            this.notifyChanged();
        }
    }

    public void setSummaryOn(int summaryResId) {
        this.setSummaryOn(this.getContext().getString(summaryResId));
    }

    public CharSequence getSummaryOn() {
        return this.mSummaryOn;
    }

    public void setSummaryOff(CharSequence summary) {
        this.mSummaryOff = summary;
        if (!this.isChecked()) {
            this.notifyChanged();
        }
    }

    public void setSummaryOff(int summaryResId) {
        this.setSummaryOff(this.getContext().getString(summaryResId));
    }

    public CharSequence getSummaryOff() {
        return this.mSummaryOff;
    }

    public boolean getDisableDependentsState() {
        return this.mDisableDependentsState;
    }

    public void setDisableDependentsState(boolean disableDependentsState) {
        this.mDisableDependentsState = disableDependentsState;
    }

    protected Object onGetDefaultValue(TypedArray a, int index) {
        return a.getBoolean(index, false);
    }

    protected void onSetInitialValue(boolean restoreValue, Object defaultValue) {
        this.setChecked(restoreValue ? this.getPersistedBoolean(this.mChecked) : ((Boolean)defaultValue).booleanValue());
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        if (this.isPersistent()) {
            return superState;
        }
        SavedState myState = new SavedState(superState);
        myState.checked = this.isChecked();
        return myState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state == null || !state.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState myState = (SavedState)state;
        super.onRestoreInstanceState(myState.getSuperState());
        this.setChecked(myState.checked);
    }

    private static class SavedState
    extends Preference.BaseSavedState {
        boolean checked;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcel source) {
            super(source);
            this.checked = source.readInt() == 1;
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.checked ? 1 : 0);
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }
    }
}

