/*
 * Decompiled with CFR 0.152.
 */
package android.pim.vcard;

import android.content.ContentProviderOperation;
import android.pim.vcard.JapaneseUtils;
import android.pim.vcard.VCardConfig;
import android.pim.vcard.VCardEntry;
import android.pim.vcard.VCardParser;
import android.pim.vcard.VCardParserImpl_V21;
import android.pim.vcard.VCardParserImpl_V30;
import android.pim.vcard.VCardParserImpl_V40;
import android.pim.vcard.VCardParser_V21;
import android.pim.vcard.VCardParser_V30;
import android.pim.vcard.VCardParser_V40;
import android.pim.vcard.exception.VCardException;
import android.text.TextUtils;
import android.util.Log;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.QuotedPrintableCodec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VCardUtils {
    private static final String LOG_TAG = "VCardUtils";
    private static final Map<Integer, String> sKnownPhoneTypesMap_ItoS = new HashMap<Integer, String>();
    private static final Set<String> sPhoneTypesUnknownToContactsSet;
    private static final Map<String, Integer> sKnownPhoneTypeMap_StoI;
    private static final Map<Integer, String> sKnownImPropNameMap_ItoS;
    private static final Set<String> sMobilePhoneLabelSet;
    private static final Set<Character> sUnAcceptableAsciiInV21WordSet;
    private static final int[] sEscapeIndicatorsV30;
    private static final int[] sEscapeIndicatorsV40;

    public static String getPhoneTypeString(Integer type) {
        return sKnownPhoneTypesMap_ItoS.get(type);
    }

    public static Object getPhoneTypeFromStrings(Collection<String> types, String number) {
        if (number == null) {
            number = "";
        }
        int type = -1;
        String label = null;
        boolean isFax = false;
        boolean hasPref = false;
        if (types != null) {
            for (String typeString : types) {
                if (typeString == null) continue;
                if ((typeString = typeString.toUpperCase()).equals("PREF")) {
                    hasPref = true;
                    continue;
                }
                if (typeString.equals("FAX")) {
                    isFax = true;
                    continue;
                }
                if (typeString.startsWith("X-") && type < 0) {
                    typeString = typeString.substring(2);
                }
                if (typeString.length() == 0) continue;
                Integer tmp = sKnownPhoneTypeMap_StoI.get(typeString);
                if (tmp != null) {
                    int typeCandidate = tmp;
                    int indexOfAt = number.indexOf("@");
                    if ((typeCandidate != 6 || 0 >= indexOfAt || indexOfAt >= number.length() - 1) && type >= 0 && type != 0) continue;
                    type = tmp;
                    continue;
                }
                if (type >= 0) continue;
                type = 0;
                label = typeString;
            }
        }
        if (type < 0) {
            type = hasPref ? 12 : 1;
        }
        if (isFax) {
            if (type == 1) {
                type = 5;
            } else if (type == 3) {
                type = 4;
            } else if (type == 7) {
                type = 13;
            }
        }
        if (type == 0) {
            return label;
        }
        return type;
    }

    public static boolean isMobilePhoneLabel(String label) {
        return "_AUTO_CELL".equals(label) || sMobilePhoneLabelSet.contains(label);
    }

    public static boolean isValidInV21ButUnknownToContactsPhoteType(String label) {
        return sPhoneTypesUnknownToContactsSet.contains(label);
    }

    public static String getPropertyNameForIm(int protocol) {
        return sKnownImPropNameMap_ItoS.get(protocol);
    }

    public static String[] sortNameElements(int vcardType, String familyName, String middleName, String givenName) {
        String[] list = new String[3];
        int nameOrderType = VCardConfig.getNameOrderType(vcardType);
        switch (nameOrderType) {
            case 8: {
                if (VCardUtils.containsOnlyPrintableAscii(familyName) && VCardUtils.containsOnlyPrintableAscii(givenName)) {
                    list[0] = givenName;
                    list[1] = middleName;
                    list[2] = familyName;
                    break;
                }
                list[0] = familyName;
                list[1] = middleName;
                list[2] = givenName;
                break;
            }
            case 4: {
                list[0] = middleName;
                list[1] = givenName;
                list[2] = familyName;
                break;
            }
            default: {
                list[0] = givenName;
                list[1] = middleName;
                list[2] = familyName;
            }
        }
        return list;
    }

    public static int getPhoneNumberFormat(int vcardType) {
        if (VCardConfig.isJapaneseDevice(vcardType)) {
            return 2;
        }
        return 1;
    }

    public static void insertStructuredPostalDataUsingContactsStruct(int vcardType, ContentProviderOperation.Builder builder, VCardEntry.PostalData postalData) {
        builder.withValueBackReference("raw_contact_id", 0);
        builder.withValue("mimetype", "vnd.android.cursor.item/postal-address_v2");
        builder.withValue("data2", postalData.type);
        if (postalData.type == 0) {
            builder.withValue("data3", postalData.label);
        }
        String streetString = TextUtils.isEmpty(postalData.street) ? (TextUtils.isEmpty(postalData.extendedAddress) ? null : postalData.extendedAddress) : (TextUtils.isEmpty(postalData.extendedAddress) ? postalData.street : postalData.street + " " + postalData.extendedAddress);
        builder.withValue("data5", postalData.pobox);
        builder.withValue("data4", streetString);
        builder.withValue("data7", postalData.localty);
        builder.withValue("data8", postalData.region);
        builder.withValue("data9", postalData.postalCode);
        builder.withValue("data10", postalData.country);
        builder.withValue("data1", postalData.getFormattedAddress(vcardType));
        if (postalData.isPrimary) {
            builder.withValue("is_primary", 1);
        }
    }

    public static String constructNameFromElements(int vcardType, String familyName, String middleName, String givenName) {
        return VCardUtils.constructNameFromElements(vcardType, familyName, middleName, givenName, null, null);
    }

    public static String constructNameFromElements(int vcardType, String familyName, String middleName, String givenName, String prefix, String suffix) {
        StringBuilder builder = new StringBuilder();
        String[] nameList = VCardUtils.sortNameElements(vcardType, familyName, middleName, givenName);
        boolean first = true;
        if (!TextUtils.isEmpty(prefix)) {
            first = false;
            builder.append(prefix);
        }
        for (String namePart : nameList) {
            if (TextUtils.isEmpty(namePart)) continue;
            if (first) {
                first = false;
            } else {
                builder.append(' ');
            }
            builder.append(namePart);
        }
        if (!TextUtils.isEmpty(suffix)) {
            if (!first) {
                builder.append(' ');
            }
            builder.append(suffix);
        }
        return builder.toString();
    }

    public static List<String> constructListFromValue(String value, int vcardType) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            char ch = value.charAt(i);
            if (ch == '\\' && i < length - 1) {
                String unescapedString;
                char nextCh = value.charAt(i + 1);
                if (VCardConfig.isVersion40(vcardType)) {
                    unescapedString = VCardParserImpl_V40.unescapeCharacter(nextCh);
                } else if (VCardConfig.isVersion30(vcardType)) {
                    unescapedString = VCardParserImpl_V30.unescapeCharacter(nextCh);
                } else {
                    if (!VCardConfig.isVersion21(vcardType)) {
                        Log.w(LOG_TAG, "Unknown vCard type");
                    }
                    unescapedString = VCardParserImpl_V21.unescapeCharacter(nextCh);
                }
                if (unescapedString != null) {
                    builder.append(unescapedString);
                    ++i;
                    continue;
                }
                builder.append(ch);
                continue;
            }
            if (ch == ';') {
                list.add(builder.toString());
                builder = new StringBuilder();
                continue;
            }
            builder.append(ch);
        }
        list.add(builder.toString());
        return list;
    }

    public static boolean containsOnlyPrintableAscii(String ... values) {
        if (values == null) {
            return true;
        }
        return VCardUtils.containsOnlyPrintableAscii(Arrays.asList(values));
    }

    public static boolean containsOnlyPrintableAscii(Collection<String> values) {
        if (values == null) {
            return true;
        }
        for (String value : values) {
            if (TextUtils.isEmpty(value) || TextUtils.isPrintableAsciiOnly(value)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsOnlyNonCrLfPrintableAscii(String ... values) {
        if (values == null) {
            return true;
        }
        return VCardUtils.containsOnlyNonCrLfPrintableAscii(Arrays.asList(values));
    }

    public static boolean containsOnlyNonCrLfPrintableAscii(Collection<String> values) {
        if (values == null) {
            return true;
        }
        int asciiFirst = 32;
        int asciiLast = 126;
        for (String value : values) {
            if (TextUtils.isEmpty(value)) continue;
            int length = value.length();
            int i = 0;
            while (i < length) {
                int c = value.codePointAt(i);
                if (32 > c || c > 126) {
                    return false;
                }
                i = value.offsetByCodePoints(i, 1);
            }
        }
        return true;
    }

    public static boolean containsOnlyAlphaDigitHyphen(String ... values) {
        if (values == null) {
            return true;
        }
        return VCardUtils.containsOnlyAlphaDigitHyphen(Arrays.asList(values));
    }

    public static boolean containsOnlyAlphaDigitHyphen(Collection<String> values) {
        if (values == null) {
            return true;
        }
        int upperAlphabetFirst = 65;
        int upperAlphabetAfterLast = 91;
        int lowerAlphabetFirst = 97;
        int lowerAlphabetAfterLast = 123;
        int digitFirst = 48;
        int digitAfterLast = 58;
        int hyphen = 45;
        for (String str : values) {
            if (TextUtils.isEmpty(str)) continue;
            int length = str.length();
            int i = 0;
            while (i < length) {
                int codepoint = str.codePointAt(i);
                if (!(97 <= codepoint && codepoint < 123 || 65 <= codepoint && codepoint < 91 || 48 <= codepoint && codepoint < 58 || codepoint == 45)) {
                    return false;
                }
                i = str.offsetByCodePoints(i, 1);
            }
        }
        return true;
    }

    public static boolean containsOnlyWhiteSpaces(String ... values) {
        if (values == null) {
            return true;
        }
        return VCardUtils.containsOnlyWhiteSpaces(Arrays.asList(values));
    }

    public static boolean containsOnlyWhiteSpaces(Collection<String> values) {
        if (values == null) {
            return true;
        }
        for (String str : values) {
            if (TextUtils.isEmpty(str)) continue;
            int length = str.length();
            int i = 0;
            while (i < length) {
                if (!Character.isWhitespace(str.codePointAt(i))) {
                    return false;
                }
                i = str.offsetByCodePoints(i, 1);
            }
        }
        return true;
    }

    public static boolean isV21Word(String value) {
        if (TextUtils.isEmpty(value)) {
            return true;
        }
        int asciiFirst = 32;
        int asciiLast = 126;
        int length = value.length();
        int i = 0;
        while (i < length) {
            int c = value.codePointAt(i);
            if (32 > c || c > 126 || sUnAcceptableAsciiInV21WordSet.contains(Character.valueOf((char)c))) {
                return false;
            }
            i = value.offsetByCodePoints(i, 1);
        }
        return true;
    }

    public static String toStringAsV30ParamValue(String value) {
        return VCardUtils.toStringAsParamValue(value, sEscapeIndicatorsV30);
    }

    public static String toStringAsV40ParamValue(String value) {
        return VCardUtils.toStringAsParamValue(value, sEscapeIndicatorsV40);
    }

    private static String toStringAsParamValue(String value, int[] escapeIndicators) {
        if (TextUtils.isEmpty(value)) {
            value = "";
        }
        int asciiFirst = 32;
        int asciiLast = 126;
        StringBuilder builder = new StringBuilder();
        int length = value.length();
        boolean needQuote = false;
        int i = 0;
        while (i < length) {
            int codePoint = value.codePointAt(i);
            if (codePoint >= 32 && codePoint != 34) {
                builder.appendCodePoint(codePoint);
                for (int indicator : escapeIndicators) {
                    if (codePoint != indicator) continue;
                    needQuote = true;
                    break;
                }
            }
            i = value.offsetByCodePoints(i, 1);
        }
        String result = builder.toString();
        return result.isEmpty() || VCardUtils.containsOnlyWhiteSpaces(result) ? "" : (needQuote ? '\"' + result + '\"' : result);
    }

    public static String toHalfWidthString(String orgString) {
        if (TextUtils.isEmpty(orgString)) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int length = orgString.length();
        int i = 0;
        while (i < length) {
            char ch = orgString.charAt(i);
            String halfWidthText = JapaneseUtils.tryGetHalfWidthText(ch);
            if (halfWidthText != null) {
                builder.append(halfWidthText);
            } else {
                builder.append(ch);
            }
            i = orgString.offsetByCodePoints(i, 1);
        }
        return builder.toString();
    }

    public static String guessImageType(byte[] input) {
        if (input == null) {
            return null;
        }
        if (input.length >= 3 && input[0] == 71 && input[1] == 73 && input[2] == 70) {
            return "GIF";
        }
        if (input.length >= 4 && input[0] == -119 && input[1] == 80 && input[2] == 78 && input[3] == 71) {
            return "PNG";
        }
        if (input.length >= 2 && input[0] == -1 && input[1] == -40) {
            return "JPEG";
        }
        return null;
    }

    public static boolean areAllEmpty(String ... values) {
        if (values == null) {
            return true;
        }
        for (String value : values) {
            if (TextUtils.isEmpty(value)) continue;
            return false;
        }
        return true;
    }

    public static String parseQuotedPrintable(String value, boolean strictLineBreaking, String sourceCharset, String targetCharset) {
        String[] lines;
        StringBuilder builder = new StringBuilder();
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            char nextCh;
            char ch = value.charAt(i);
            if (ch == '=' && i < length - 1 && ((nextCh = value.charAt(i + 1)) == ' ' || nextCh == '\t')) {
                builder.append(nextCh);
                ++i;
                continue;
            }
            builder.append(ch);
        }
        String quotedPrintable = builder.toString();
        if (strictLineBreaking) {
            lines = quotedPrintable.split("\r\n");
        } else {
            StringBuilder builder2 = new StringBuilder();
            int length2 = quotedPrintable.length();
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < length2; ++i) {
                char ch = quotedPrintable.charAt(i);
                if (ch == '\n') {
                    list.add(builder2.toString());
                    builder2 = new StringBuilder();
                    continue;
                }
                if (ch == '\r') {
                    char nextCh;
                    list.add(builder2.toString());
                    builder2 = new StringBuilder();
                    if (i >= length2 - 1 || (nextCh = quotedPrintable.charAt(i + 1)) != '\n') continue;
                    ++i;
                    continue;
                }
                builder2.append(ch);
            }
            String lastLine = builder2.toString();
            if (lastLine.length() > 0) {
                list.add(lastLine);
            }
            lines = list.toArray(new String[0]);
        }
        StringBuilder builder3 = new StringBuilder();
        for (String line : lines) {
            if (line.endsWith("=")) {
                line = line.substring(0, line.length() - 1);
            }
            builder3.append(line);
        }
        String rawString = builder3.toString();
        if (TextUtils.isEmpty(rawString)) {
            Log.w(LOG_TAG, "Given raw string is empty.");
        }
        byte[] rawBytes = null;
        try {
            rawBytes = rawString.getBytes(sourceCharset);
        }
        catch (UnsupportedEncodingException e) {
            Log.w(LOG_TAG, "Failed to decode: " + sourceCharset);
            rawBytes = rawString.getBytes();
        }
        byte[] decodedBytes = null;
        try {
            decodedBytes = QuotedPrintableCodec.decodeQuotedPrintable((byte[])rawBytes);
        }
        catch (DecoderException e) {
            Log.e(LOG_TAG, "DecoderException is thrown.");
            decodedBytes = rawBytes;
        }
        try {
            return new String(decodedBytes, targetCharset);
        }
        catch (UnsupportedEncodingException e) {
            Log.e(LOG_TAG, "Failed to encode: charset=" + targetCharset);
            return new String(decodedBytes);
        }
    }

    public static final VCardParser getAppropriateParser(int vcardType) throws VCardException {
        if (VCardConfig.isVersion21(vcardType)) {
            return new VCardParser_V21();
        }
        if (VCardConfig.isVersion30(vcardType)) {
            return new VCardParser_V30();
        }
        if (VCardConfig.isVersion40(vcardType)) {
            return new VCardParser_V40();
        }
        throw new VCardException("Version is not specified");
    }

    public static final String convertStringCharset(String originalString, String sourceCharset, String targetCharset) {
        if (sourceCharset.equalsIgnoreCase(targetCharset)) {
            return originalString;
        }
        Charset charset = Charset.forName(sourceCharset);
        ByteBuffer byteBuffer = charset.encode(originalString);
        byte[] bytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(bytes);
        try {
            return new String(bytes, targetCharset);
        }
        catch (UnsupportedEncodingException e) {
            Log.e(LOG_TAG, "Failed to encode: charset=" + targetCharset);
            return null;
        }
    }

    private VCardUtils() {
    }

    static {
        sKnownPhoneTypeMap_StoI = new HashMap<String, Integer>();
        sKnownPhoneTypesMap_ItoS.put(9, "CAR");
        sKnownPhoneTypeMap_StoI.put("CAR", 9);
        sKnownPhoneTypesMap_ItoS.put(6, "PAGER");
        sKnownPhoneTypeMap_StoI.put("PAGER", 6);
        sKnownPhoneTypesMap_ItoS.put(11, "ISDN");
        sKnownPhoneTypeMap_StoI.put("ISDN", 11);
        sKnownPhoneTypeMap_StoI.put("HOME", 1);
        sKnownPhoneTypeMap_StoI.put("WORK", 3);
        sKnownPhoneTypeMap_StoI.put("CELL", 2);
        sKnownPhoneTypeMap_StoI.put("OTHER", 7);
        sKnownPhoneTypeMap_StoI.put("CALLBACK", 8);
        sKnownPhoneTypeMap_StoI.put("COMPANY-MAIN", 10);
        sKnownPhoneTypeMap_StoI.put("RADIO", 14);
        sKnownPhoneTypeMap_StoI.put("TTY-TDD", 16);
        sKnownPhoneTypeMap_StoI.put("ASSISTANT", 19);
        sPhoneTypesUnknownToContactsSet = new HashSet<String>();
        sPhoneTypesUnknownToContactsSet.add("MODEM");
        sPhoneTypesUnknownToContactsSet.add("MSG");
        sPhoneTypesUnknownToContactsSet.add("BBS");
        sPhoneTypesUnknownToContactsSet.add("VIDEO");
        sKnownImPropNameMap_ItoS = new HashMap<Integer, String>();
        sKnownImPropNameMap_ItoS.put(0, "X-AIM");
        sKnownImPropNameMap_ItoS.put(1, "X-MSN");
        sKnownImPropNameMap_ItoS.put(2, "X-YAHOO");
        sKnownImPropNameMap_ItoS.put(3, "X-SKYPE-USERNAME");
        sKnownImPropNameMap_ItoS.put(5, "X-GOOGLE-TALK");
        sKnownImPropNameMap_ItoS.put(6, "X-ICQ");
        sKnownImPropNameMap_ItoS.put(7, "X-JABBER");
        sKnownImPropNameMap_ItoS.put(4, "X-QQ");
        sKnownImPropNameMap_ItoS.put(8, "X-NETMEETING");
        sMobilePhoneLabelSet = new HashSet<String>(Arrays.asList("MOBILE", "\u643a\u5e2f\u96fb\u8a71", "\u643a\u5e2f", "\u30b1\u30a4\u30bf\u30a4", "\uff79\uff72\uff80\uff72"));
        sUnAcceptableAsciiInV21WordSet = new HashSet<Character>(Arrays.asList(Character.valueOf('['), Character.valueOf(']'), Character.valueOf('='), Character.valueOf(':'), Character.valueOf('.'), Character.valueOf(','), Character.valueOf(' ')));
        sEscapeIndicatorsV30 = new int[]{58, 59, 44, 32};
        sEscapeIndicatorsV40 = new int[]{59, 58};
    }
}

