/*
 * Decompiled with CFR 0.152.
 */
package android.pim.vcard;

import android.content.ContentResolver;
import android.net.Uri;
import android.pim.vcard.VCardConfig;
import android.pim.vcard.VCardEntry;
import android.pim.vcard.VCardEntryHandler;
import android.util.Log;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VCardEntryCommitter
implements VCardEntryHandler {
    public static String LOG_TAG = "VCardEntryComitter";
    private final ContentResolver mContentResolver;
    private long mTimeToCommit;
    private ArrayList<Uri> mCreatedUris = new ArrayList();

    public VCardEntryCommitter(ContentResolver resolver) {
        this.mContentResolver = resolver;
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onEnd() {
        if (VCardConfig.showPerformanceLog()) {
            Log.d(LOG_TAG, String.format("time to commit entries: %d ms", this.mTimeToCommit));
        }
    }

    @Override
    public void onEntryCreated(VCardEntry vcardEntry) {
        long start = System.currentTimeMillis();
        this.mCreatedUris.add(vcardEntry.pushIntoContentResolver(this.mContentResolver));
        this.mTimeToCommit += System.currentTimeMillis() - start;
    }

    public ArrayList<Uri> getCreatedUris() {
        return this.mCreatedUris;
    }
}

