/*
 * Decompiled with CFR 0.152.
 */
package android.pim;

import android.content.ContentUris;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.provider.ContactsContract;
import android.util.Log;
import android.widget.ImageView;
import com.android.internal.telephony.CallerInfo;
import com.android.internal.telephony.Connection;
import java.io.InputStream;

public class ContactsAsyncHelper
extends Handler {
    private static final boolean DBG = false;
    private static final String LOG_TAG = "ContactsAsyncHelper";
    private static final int EVENT_LOAD_IMAGE = 1;
    private static final int DEFAULT_TOKEN = -1;
    private static Handler sThreadHandler;
    private static ContactsAsyncHelper sInstance;

    private ContactsAsyncHelper() {
        HandlerThread thread = new HandlerThread("ContactsAsyncWorker");
        thread.start();
        sThreadHandler = new WorkerHandler(thread.getLooper());
    }

    public static final void updateImageViewWithContactPhotoAsync(Context context, ImageView imageView, Uri person, int placeholderImageResource) {
        ContactsAsyncHelper.updateImageViewWithContactPhotoAsync(null, -1, null, null, context, imageView, person, placeholderImageResource);
    }

    public static final void updateImageViewWithContactPhotoAsync(CallerInfo info, Context context, ImageView imageView, Uri person, int placeholderImageResource) {
        ContactsAsyncHelper.updateImageViewWithContactPhotoAsync(info, -1, null, null, context, imageView, person, placeholderImageResource);
    }

    public static final void updateImageViewWithContactPhotoAsync(CallerInfo info, int token, OnImageLoadCompleteListener listener, Object cookie, Context context, ImageView imageView, Uri person, int placeholderImageResource) {
        if (person == null) {
            imageView.setVisibility(0);
            imageView.setImageResource(placeholderImageResource);
            return;
        }
        WorkerArgs args = new WorkerArgs();
        args.cookie = cookie;
        args.context = context;
        args.view = imageView;
        args.uri = person;
        args.defaultResource = placeholderImageResource;
        args.listener = listener;
        args.info = info;
        Message msg = sThreadHandler.obtainMessage(token);
        msg.arg1 = 1;
        msg.obj = args;
        if (placeholderImageResource != -1) {
            imageView.setVisibility(0);
            imageView.setImageResource(placeholderImageResource);
        } else {
            imageView.setVisibility(4);
        }
        sThreadHandler.sendMessage(msg);
    }

    public void handleMessage(Message msg) {
        WorkerArgs args = (WorkerArgs)msg.obj;
        switch (msg.arg1) {
            case 1: {
                boolean imagePresent = false;
                if (args.result != null) {
                    args.view.setVisibility(0);
                    args.view.setImageDrawable((Drawable)args.result);
                    if (args.info != null) {
                        args.info.cachedPhoto = (Drawable)args.result;
                    }
                    imagePresent = true;
                } else if (args.defaultResource != -1) {
                    args.view.setVisibility(0);
                    args.view.setImageResource(args.defaultResource);
                }
                if (args.info != null) {
                    args.info.isCachedPhotoCurrent = true;
                }
                if (args.listener == null) break;
                args.listener.onImageLoadComplete(msg.what, args.cookie, args.view, imagePresent);
                break;
            }
        }
    }

    static {
        sInstance = new ContactsAsyncHelper();
    }

    private class WorkerHandler
    extends Handler {
        public WorkerHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            WorkerArgs args = (WorkerArgs)msg.obj;
            switch (msg.arg1) {
                case 1: {
                    InputStream inputStream = null;
                    try {
                        inputStream = ContactsContract.Contacts.openContactPhotoInputStream(args.context.getContentResolver(), args.uri);
                    }
                    catch (Exception e) {
                        Log.e(ContactsAsyncHelper.LOG_TAG, "Error opening photo input stream", e);
                    }
                    if (inputStream != null) {
                        args.result = Drawable.createFromStream(inputStream, args.uri.toString());
                        break;
                    }
                    args.result = null;
                    break;
                }
            }
            Message reply = ContactsAsyncHelper.this.obtainMessage(msg.what);
            reply.arg1 = msg.arg1;
            reply.obj = msg.obj;
            reply.sendToTarget();
        }
    }

    public static class ImageTracker {
        public static final int DISPLAY_UNDEFINED = 0;
        public static final int DISPLAY_IMAGE = -1;
        public static final int DISPLAY_DEFAULT = -2;
        private CallerInfo mCurrentCallerInfo = null;
        private int displayMode = 0;

        public boolean isDifferentImageRequest(CallerInfo ci) {
            return this.mCurrentCallerInfo != ci;
        }

        public boolean isDifferentImageRequest(Connection connection) {
            if (connection == null) {
                return this.mCurrentCallerInfo != null;
            }
            Object o = connection.getUserData();
            boolean runQuery = true;
            if (o instanceof CallerInfo) {
                runQuery = this.isDifferentImageRequest((CallerInfo)o);
            }
            return runQuery;
        }

        public void setPhotoRequest(CallerInfo ci) {
            this.mCurrentCallerInfo = ci;
        }

        public Uri getPhotoUri() {
            if (this.mCurrentCallerInfo != null) {
                return ContentUris.withAppendedId(ContactsContract.Contacts.CONTENT_URI, this.mCurrentCallerInfo.person_id);
            }
            return null;
        }

        public void setPhotoState(int state) {
            this.displayMode = state;
        }

        public int getPhotoState() {
            return this.displayMode;
        }
    }

    private static final class WorkerArgs {
        public Context context;
        public ImageView view;
        public Uri uri;
        public int defaultResource;
        public Object result;
        public Object cookie;
        public OnImageLoadCompleteListener listener;
        public CallerInfo info;

        private WorkerArgs() {
        }
    }

    public static interface OnImageLoadCompleteListener {
        public void onImageLoadComplete(int var1, Object var2, ImageView var3, boolean var4);
    }
}

