/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.Message;
import android.os.MessageQueue;
import android.os.Process;
import android.os.SystemClock;
import android.util.Log;
import android.util.Printer;

public class Looper {
    private static final boolean DEBUG = false;
    private static final boolean localLOGV = false;
    private static final ThreadLocal sThreadLocal = new ThreadLocal();
    final MessageQueue mQueue = new MessageQueue();
    volatile boolean mRun = true;
    Thread mThread = Thread.currentThread();
    private Printer mLogging = null;
    private static Looper mMainLooper = null;

    public static final void prepare() {
        if (sThreadLocal.get() != null) {
            throw new RuntimeException("Only one Looper may be created per thread");
        }
        sThreadLocal.set(new Looper());
    }

    public static final void prepareMainLooper() {
        Looper.prepare();
        Looper.setMainLooper(Looper.myLooper());
        if (Process.supportsProcesses()) {
            Looper.myLooper().mQueue.mQuitAllowed = false;
        }
    }

    private static synchronized void setMainLooper(Looper looper) {
        mMainLooper = looper;
    }

    public static final synchronized Looper getMainLooper() {
        return mMainLooper;
    }

    public static final void loop() {
        Looper me = Looper.myLooper();
        MessageQueue queue = me.mQueue;
        Binder.clearCallingIdentity();
        long ident = Binder.clearCallingIdentity();
        while (true) {
            long newIdent;
            Message msg;
            if ((msg = queue.next()) == null) {
                continue;
            }
            if (msg.target == null) {
                return;
            }
            if (me.mLogging != null) {
                me.mLogging.println(">>>>> Dispatching to " + msg.target + " " + msg.callback + ": " + msg.what);
            }
            msg.target.dispatchMessage(msg);
            if (me.mLogging != null) {
                me.mLogging.println("<<<<< Finished to    " + msg.target + " " + msg.callback);
            }
            if (ident != (newIdent = Binder.clearCallingIdentity())) {
                Log.wtf("Looper", "Thread identity changed from 0x" + Long.toHexString(ident) + " to 0x" + Long.toHexString(newIdent) + " while dispatching to " + msg.target.getClass().getName() + " " + msg.callback + " what=" + msg.what);
            }
            msg.recycle();
        }
    }

    public static final Looper myLooper() {
        return (Looper)sThreadLocal.get();
    }

    public void setMessageLogging(Printer printer) {
        this.mLogging = printer;
    }

    public static final MessageQueue myQueue() {
        return Looper.myLooper().mQueue;
    }

    private Looper() {
    }

    public void quit() {
        Message msg = Message.obtain();
        this.mQueue.enqueueMessage(msg, 0L);
    }

    public Thread getThread() {
        return this.mThread;
    }

    public MessageQueue getQueue() {
        return this.mQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(Printer pw, String prefix) {
        pw.println(prefix + this);
        pw.println(prefix + "mRun=" + this.mRun);
        pw.println(prefix + "mThread=" + this.mThread);
        pw.println(prefix + "mQueue=" + (this.mQueue != null ? this.mQueue : "(null"));
        if (this.mQueue != null) {
            MessageQueue messageQueue = this.mQueue;
            synchronized (messageQueue) {
                long now = SystemClock.uptimeMillis();
                Message msg = this.mQueue.mMessages;
                int n = 0;
                while (msg != null) {
                    pw.println(prefix + "  Message " + n + ": " + msg.toString(now));
                    ++n;
                    msg = msg.next;
                }
                pw.println(prefix + "(Total messages: " + n + ")");
            }
        }
    }

    public String toString() {
        return "Looper{" + Integer.toHexString(System.identityHashCode(this)) + "}";
    }

    static class HandlerException
    extends Exception {
        HandlerException(Message message, Throwable cause) {
            super(HandlerException.createMessage(cause), cause);
        }

        static String createMessage(Throwable cause) {
            String causeMsg = cause.getMessage();
            if (causeMsg == null) {
                causeMsg = cause.toString();
            }
            return causeMsg;
        }
    }
}

