/*
 * Decompiled with CFR 0.152.
 */
package android.opengl;

import android.opengl.Group;
import android.opengl.Material;
import android.opengl.Texture;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.microedition.khronos.opengles.GL10;

public abstract class Object3D {
    private boolean mHasTexcoords = false;
    private float mBoundsMinX = Float.MAX_VALUE;
    private float mBoundsMaxX = Float.MIN_VALUE;
    private float mBoundsMinY = Float.MAX_VALUE;
    private float mBoundsMaxY = Float.MIN_VALUE;
    private float mBoundsMinZ = Float.MAX_VALUE;
    private float mBoundsMaxZ = Float.MIN_VALUE;
    private IntBuffer mVertexBuffer;
    private IntBuffer mNormalBuffer;
    private IntBuffer mTexcoordBuffer;
    private Map<String, Group> mGroups;
    private Map<String, Material> mMaterials;
    private Map<String, Texture> mTextures;

    public Object3D() {
        this.reset();
    }

    public abstract InputStream readFile(String var1) throws IOException;

    private void reset() {
        this.mTexcoordBuffer = null;
        this.mNormalBuffer = null;
        this.mVertexBuffer = null;
        this.mGroups = new HashMap<String, Group>();
        this.mMaterials = new HashMap<String, Material>();
        this.mTextures = new HashMap<String, Texture>();
    }

    public Material getMaterial(String name) {
        Material mat = this.mMaterials.get(name);
        return mat;
    }

    public Texture getTexture(String name) {
        return this.mTextures.get(name);
    }

    public IntBuffer getVertexBuffer() {
        return this.mVertexBuffer;
    }

    public IntBuffer getNormalBuffer() {
        return this.mNormalBuffer;
    }

    public IntBuffer getTexcoordBuffer() {
        return this.mTexcoordBuffer;
    }

    public int getNumTriangles() {
        int numTriangles = 0;
        Iterator<Group> iter = this.mGroups.values().iterator();
        while (iter.hasNext()) {
            numTriangles += iter.next().getNumTriangles();
        }
        return numTriangles;
    }

    public boolean hasTexcoords() {
        return this.mHasTexcoords;
    }

    public float getBoundsMinX() {
        return this.mBoundsMinX;
    }

    public float getBoundsMaxX() {
        return this.mBoundsMaxX;
    }

    public float getBoundsMinY() {
        return this.mBoundsMinY;
    }

    public float getBoundsMaxY() {
        return this.mBoundsMaxY;
    }

    public float getBoundsMinZ() {
        return this.mBoundsMinZ;
    }

    public float getBoundsMaxZ() {
        return this.mBoundsMaxZ;
    }

    public void loadTexture(String name) throws IOException {
        InputStream is = this.readFile(name + ".raw");
        Texture texture = new Texture(is);
        this.mTextures.put(name, texture);
    }

    private static void verifyByte(DataInputStream dis, int b) throws IOException {
        int x = dis.read() & 0xFF;
        if (x != b) {
            throw new RuntimeException("Bad byte: " + x + " (expected " + b + ")");
        }
    }

    public void load(String filename) throws IOException {
        this.reset();
        DataInputStream dis = new DataInputStream(this.readFile(filename));
        Object3D.verifyByte(dis, 231);
        Object3D.verifyByte(dis, 108);
        Object3D.verifyByte(dis, 101);
        Object3D.verifyByte(dis, 115);
        int numTuples = dis.readInt();
        this.mBoundsMinX = dis.readFloat();
        this.mBoundsMaxX = dis.readFloat();
        this.mBoundsMinY = dis.readFloat();
        this.mBoundsMaxY = dis.readFloat();
        this.mBoundsMinZ = dis.readFloat();
        this.mBoundsMaxZ = dis.readFloat();
        this.mHasTexcoords = dis.readInt() == 1;
        int intsPerTuple = this.mHasTexcoords ? 8 : 6;
        int numInts = numTuples * intsPerTuple;
        int len = 4 * numTuples * (this.mHasTexcoords ? 8 : 6);
        byte[] tmp = new byte[len];
        for (int tidx = 0; tidx < len; tidx += dis.read(tmp, tidx, len - tidx)) {
        }
        if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
            for (int i = 0; i < len; i += 4) {
                byte tmp3;
                byte tmp0 = tmp[i];
                byte tmp1 = tmp[i + 1];
                byte tmp2 = tmp[i + 2];
                tmp[i] = tmp3 = tmp[i + 3];
                tmp[i + 1] = tmp2;
                tmp[i + 2] = tmp1;
                tmp[i + 3] = tmp0;
            }
        }
        ByteBuffer allbb = ByteBuffer.allocateDirect(len);
        allbb.order(ByteOrder.nativeOrder());
        allbb.put(tmp);
        allbb.position(0);
        allbb.limit(12 * numTuples);
        ByteBuffer vbb = allbb.slice();
        this.mVertexBuffer = vbb.asIntBuffer();
        this.mVertexBuffer.position(0);
        if (this.mHasTexcoords) {
            allbb.position(allbb.limit());
            allbb.limit(allbb.position() + 8 * numTuples);
            ByteBuffer tbb = allbb.slice();
            this.mTexcoordBuffer = tbb.asIntBuffer();
            this.mTexcoordBuffer.position(0);
        }
        allbb.position(allbb.limit());
        allbb.limit(allbb.position() + 12 * numTuples);
        ByteBuffer nbb = allbb.slice();
        this.mNormalBuffer = nbb.asIntBuffer();
        this.mNormalBuffer.position(0);
        int numMaterials = dis.readInt();
        for (int i = 0; i < numMaterials; ++i) {
            Material mat = new Material(this);
            mat.load(dis);
            this.mMaterials.put(mat.getName(), mat);
        }
        int numGroups = dis.readInt();
        for (int i = 0; i < numGroups; ++i) {
            Group g = new Group(this);
            g.load(dis);
            this.mGroups.put(g.getName(), g);
        }
    }

    public void draw(GL10 gl) {
        Iterator<Group> iter = this.mGroups.values().iterator();
        while (iter.hasNext()) {
            iter.next().draw(gl);
        }
    }
}

