/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.tech;

import android.nfc.Tag;
import android.nfc.tech.BasicTagTechnology;
import android.nfc.tech.NfcA;
import android.os.RemoteException;
import java.io.IOException;

public final class MifareUltralight
extends BasicTagTechnology {
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_ULTRALIGHT = 1;
    public static final int TYPE_ULTRALIGHT_C = 2;
    public static final int PAGE_SIZE = 4;
    private static final int NXP_MANUFACTURER_ID = 4;
    private static final int MAX_PAGE_COUNT = 256;
    private int mType;

    public static MifareUltralight get(Tag tag) {
        if (!tag.hasTech(9)) {
            return null;
        }
        try {
            return new MifareUltralight(tag);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public MifareUltralight(Tag tag) throws RemoteException {
        super(tag, 9);
        NfcA a = NfcA.get(tag);
        this.mType = -1;
        if (a.getSak() == 0 && tag.getId()[0] == 4) {
            this.mType = 1;
        }
    }

    public int getType() {
        return this.mType;
    }

    public byte[] readPages(int pageOffset) throws IOException {
        MifareUltralight.validatePageIndex(pageOffset);
        this.checkConnected();
        byte[] cmd = new byte[]{48, (byte)pageOffset};
        return this.transceive(cmd, false);
    }

    public void writePage(int pageOffset, byte[] data) throws IOException {
        MifareUltralight.validatePageIndex(pageOffset);
        this.checkConnected();
        byte[] cmd = new byte[data.length + 2];
        cmd[0] = -94;
        cmd[1] = (byte)pageOffset;
        System.arraycopy(data, 0, cmd, 2, data.length);
        this.transceive(cmd, false);
    }

    public byte[] transceive(byte[] data) throws IOException {
        return this.transceive(data, true);
    }

    private static void validatePageIndex(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= 256) {
            throw new IndexOutOfBoundsException("page out of bounds: " + pageIndex);
        }
    }
}

