/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.tech;

import android.nfc.Tag;
import android.nfc.TagLostException;
import android.nfc.TransceiveResult;
import android.nfc.tech.TagTechnology;
import android.os.RemoteException;
import android.util.Log;
import java.io.IOException;

abstract class BasicTagTechnology
implements TagTechnology {
    private static final String TAG = "NFC";
    final Tag mTag;
    boolean mIsConnected;
    int mSelectedTechnology;

    BasicTagTechnology(Tag tag, int tech) throws RemoteException {
        this.mTag = tag;
        this.mSelectedTechnology = tech;
    }

    public Tag getTag() {
        return this.mTag;
    }

    void checkConnected() {
        if (this.mTag.getConnectedTechnology() != this.mSelectedTechnology || this.mTag.getConnectedTechnology() == -1) {
            throw new IllegalStateException("Call connect() first!");
        }
    }

    public boolean isConnected() {
        if (!this.mIsConnected) {
            return false;
        }
        try {
            return this.mTag.getTagService().isPresent(this.mTag.getServiceHandle());
        }
        catch (RemoteException e) {
            Log.e(TAG, "NFC service dead", e);
            return false;
        }
    }

    public void connect() throws IOException {
        try {
            int errorCode = this.mTag.getTagService().connect(this.mTag.getServiceHandle(), this.mSelectedTechnology);
            if (errorCode != 0) {
                throw new IOException();
            }
            this.mTag.setConnectedTechnology(this.mSelectedTechnology);
            this.mIsConnected = true;
        }
        catch (RemoteException e) {
            Log.e(TAG, "NFC service dead", e);
            throw new IOException("NFC service died");
        }
    }

    public void reconnect() throws IOException {
        if (!this.mIsConnected) {
            throw new IllegalStateException("Technology not connected yet");
        }
        try {
            int errorCode = this.mTag.getTagService().reconnect(this.mTag.getServiceHandle());
            if (errorCode != 0) {
                this.mIsConnected = false;
                this.mTag.setTechnologyDisconnected();
                throw new IOException();
            }
        }
        catch (RemoteException e) {
            this.mIsConnected = false;
            this.mTag.setTechnologyDisconnected();
            Log.e(TAG, "NFC service dead", e);
            throw new IOException("NFC service died");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.mTag.getTagService().reconnect(this.mTag.getServiceHandle());
        }
        catch (RemoteException e) {
            Log.e(TAG, "NFC service dead", e);
        }
        finally {
            this.mIsConnected = false;
            this.mTag.setTechnologyDisconnected();
        }
    }

    byte[] transceive(byte[] data, boolean raw2) throws IOException {
        this.checkConnected();
        try {
            TransceiveResult result = this.mTag.getTagService().transceive(this.mTag.getServiceHandle(), data, raw2);
            if (result == null) {
                throw new IOException("transceive failed");
            }
            if (result.isSuccessful()) {
                return result.getResponseData();
            }
            if (result.isTagLost()) {
                throw new TagLostException("Tag was lost.");
            }
            throw new IOException("transceive failed");
        }
        catch (RemoteException e) {
            Log.e(TAG, "NFC service dead", e);
            throw new IOException("NFC service died");
        }
    }
}

