/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.NetworkInfo;
import android.net.NetworkStateTracker;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiNative;
import android.net.wifi.WifiStateTracker;
import android.util.Log;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WifiMonitor {
    private static final String TAG = "WifiMonitor";
    private static final int CONNECTED = 1;
    private static final int DISCONNECTED = 2;
    private static final int STATE_CHANGE = 3;
    private static final int SCAN_RESULTS = 4;
    private static final int LINK_SPEED = 5;
    private static final int TERMINATING = 6;
    private static final int DRIVER_STATE = 7;
    private static final int UNKNOWN = 8;
    private static final String eventPrefix = "CTRL-EVENT-";
    private static final int eventPrefixLen = "CTRL-EVENT-".length();
    private static final String wpaEventPrefix = "WPA:";
    private static final String passwordKeyMayBeIncorrectEvent = "pre-shared key may be incorrect";
    private static final String connectedEvent = "CONNECTED";
    private static final String disconnectedEvent = "DISCONNECTED";
    private static final String stateChangeEvent = "STATE-CHANGE";
    private static final String scanResultsEvent = "SCAN-RESULTS";
    private static final String linkSpeedEvent = "LINK-SPEED";
    private static final String terminatingEvent = "TERMINATING";
    private static final String driverStateEvent = "DRIVER-STATE";
    private static Pattern mConnectedEventPattern = Pattern.compile("((?:[0-9a-f]{2}:){5}[0-9a-f]{2}) .* \\[id=([0-9]+) ");
    private final WifiStateTracker mWifiStateTracker;
    private static final String monitorSocketClosed = "connection closed";
    private static final String wpaRecvError = "recv error";
    private int mRecvErrors = 0;
    private static final int MAX_RECV_ERRORS = 10;

    public WifiMonitor(WifiStateTracker tracker) {
        this.mWifiStateTracker = tracker;
    }

    public void startMonitoring() {
        new MonitorThread().start();
    }

    public NetworkStateTracker getNetworkStateTracker() {
        return this.mWifiStateTracker;
    }

    private void handleNetworkStateChange(NetworkInfo.DetailedState newState, String data) {
        String BSSID = null;
        int networkId = -1;
        if (newState == NetworkInfo.DetailedState.CONNECTED) {
            Matcher match = mConnectedEventPattern.matcher(data);
            if (!match.find()) {
                Log.d(TAG, "Could not find BSSID in CONNECTED event string");
            } else {
                BSSID = match.group(1);
                try {
                    networkId = Integer.parseInt(match.group(2));
                }
                catch (NumberFormatException e) {
                    networkId = -1;
                }
            }
        }
        this.mWifiStateTracker.notifyStateChange(newState, BSSID, networkId);
    }

    private static void nap(int secs) {
        try {
            Thread.sleep(secs * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    class MonitorThread
    extends Thread {
        public MonitorThread() {
            super(WifiMonitor.TAG);
        }

        public void run() {
            if (!this.connectToSupplicant()) {
                WifiMonitor.this.mWifiStateTracker.notifySupplicantLost();
                return;
            }
            WifiMonitor.this.mWifiStateTracker.notifySupplicantConnection();
            while (true) {
                int ind;
                String eventStr;
                if ((eventStr = WifiNative.waitForEvent()).indexOf(WifiMonitor.scanResultsEvent) == -1) {
                    Log.v(WifiMonitor.TAG, "Event [" + eventStr + "]");
                }
                if (!eventStr.startsWith(WifiMonitor.eventPrefix)) {
                    if (!eventStr.startsWith(WifiMonitor.wpaEventPrefix) || 0 >= eventStr.indexOf(WifiMonitor.passwordKeyMayBeIncorrectEvent)) continue;
                    this.handlePasswordKeyMayBeIncorrect();
                    continue;
                }
                String eventName = eventStr.substring(eventPrefixLen);
                int nameEnd = eventName.indexOf(32);
                if (nameEnd != -1) {
                    eventName = eventName.substring(0, nameEnd);
                }
                if (eventName.length() == 0) {
                    Log.i(WifiMonitor.TAG, "Received wpa_supplicant event with empty event name");
                    continue;
                }
                int event = eventName.equals(WifiMonitor.connectedEvent) ? 1 : (eventName.equals(WifiMonitor.disconnectedEvent) ? 2 : (eventName.equals(WifiMonitor.stateChangeEvent) ? 3 : (eventName.equals(WifiMonitor.scanResultsEvent) ? 4 : (eventName.equals(WifiMonitor.linkSpeedEvent) ? 5 : (eventName.equals(WifiMonitor.terminatingEvent) ? 6 : (eventName.equals(WifiMonitor.driverStateEvent) ? 7 : 8))))));
                String eventData = eventStr;
                if (event == 7 || event == 5) {
                    eventData = eventData.split(" ")[1];
                } else if (event == 3) {
                    ind = eventStr.indexOf(" ");
                    if (ind != -1) {
                        eventData = eventStr.substring(ind + 1);
                    }
                } else {
                    ind = eventStr.indexOf(" - ");
                    if (ind != -1) {
                        eventData = eventStr.substring(ind + 3);
                    }
                }
                if (event == 3) {
                    this.handleSupplicantStateChange(eventData);
                } else if (event == 7) {
                    this.handleDriverEvent(eventData);
                } else {
                    if (event == 6) {
                        if (eventData.startsWith(WifiMonitor.monitorSocketClosed)) {
                            Log.d(WifiMonitor.TAG, "Monitor socket is closed, exiting thread");
                            break;
                        }
                        if (eventData.startsWith(WifiMonitor.wpaRecvError)) {
                            if (++WifiMonitor.this.mRecvErrors <= 10) continue;
                            Log.d(WifiMonitor.TAG, "too many recv errors, closing connection");
                        }
                        WifiMonitor.this.mWifiStateTracker.notifySupplicantLost();
                        break;
                    }
                    this.handleEvent(event, eventData);
                }
                WifiMonitor.this.mRecvErrors = 0;
            }
        }

        private boolean connectToSupplicant() {
            int connectTries = 0;
            while (true) {
                if (WifiMonitor.this.mWifiStateTracker.connectToSupplicant()) {
                    return true;
                }
                if (connectTries++ >= 3) break;
                WifiMonitor.nap(5);
            }
            return false;
        }

        private void handlePasswordKeyMayBeIncorrect() {
            WifiMonitor.this.mWifiStateTracker.notifyPasswordKeyMayBeIncorrect();
        }

        private void handleDriverEvent(String state) {
            if (state == null) {
                return;
            }
            if (state.equals("STOPPED")) {
                WifiMonitor.this.mWifiStateTracker.notifyDriverStopped();
            } else if (state.equals("STARTED")) {
                WifiMonitor.this.mWifiStateTracker.notifyDriverStarted();
            } else if (state.equals("HANGED")) {
                WifiMonitor.this.mWifiStateTracker.notifyDriverHung();
            }
        }

        void handleEvent(int event, String remainder) {
            switch (event) {
                case 2: {
                    WifiMonitor.this.handleNetworkStateChange(NetworkInfo.DetailedState.DISCONNECTED, remainder);
                    break;
                }
                case 1: {
                    WifiMonitor.this.handleNetworkStateChange(NetworkInfo.DetailedState.CONNECTED, remainder);
                    break;
                }
                case 4: {
                    WifiMonitor.this.mWifiStateTracker.notifyScanResultsAvailable();
                    break;
                }
            }
        }

        private void handleSupplicantStateChange(String dataString) {
            String[] dataTokens = dataString.split(" ");
            String BSSID = null;
            int networkId = -1;
            int newState = -1;
            for (String token : dataTokens) {
                int value;
                String[] nameValue = token.split("=");
                if (nameValue.length != 2) continue;
                if (nameValue[0].equals("BSSID")) {
                    BSSID = nameValue[1];
                    continue;
                }
                try {
                    value = Integer.parseInt(nameValue[1]);
                }
                catch (NumberFormatException e) {
                    Log.w(WifiMonitor.TAG, "STATE-CHANGE non-integer parameter: " + token);
                    continue;
                }
                if (nameValue[0].equals("id")) {
                    networkId = value;
                    continue;
                }
                if (!nameValue[0].equals("state")) continue;
                newState = value;
            }
            if (newState == -1) {
                return;
            }
            SupplicantState newSupplicantState = SupplicantState.INVALID;
            for (SupplicantState state : SupplicantState.values()) {
                if (state.ordinal() != newState) continue;
                newSupplicantState = state;
                break;
            }
            if (newSupplicantState == SupplicantState.INVALID) {
                Log.w(WifiMonitor.TAG, "Invalid supplicant state: " + newState);
            }
            WifiMonitor.this.mWifiStateTracker.notifyStateChange(networkId, BSSID, newSupplicantState);
        }
    }
}

