/*
 * Decompiled with CFR 0.152.
 */
package android.net.vpn;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.net.vpn.VpnProfile;
import android.net.vpn.VpnState;
import android.net.vpn.VpnType;
import android.os.Environment;
import android.util.Log;
import java.io.Serializable;

public class VpnManager {
    private static final String ACTION_VPN_CONNECTIVITY = "vpn.connectivity";
    public static final String BROADCAST_PROFILE_NAME = "profile_name";
    public static final String BROADCAST_CONNECTION_STATE = "connection_state";
    public static final String BROADCAST_ERROR_CODE = "err";
    public static final int VPN_ERROR_AUTH = 51;
    public static final int VPN_ERROR_CONNECTION_FAILED = 101;
    public static final int VPN_ERROR_UNKNOWN_SERVER = 102;
    public static final int VPN_ERROR_CHALLENGE = 5;
    public static final int VPN_ERROR_REMOTE_HUNG_UP = 7;
    public static final int VPN_ERROR_REMOTE_PPP_HUNG_UP = 48;
    public static final int VPN_ERROR_PPP_NEGOTIATION_FAILED = 42;
    public static final int VPN_ERROR_CONNECTION_LOST = 103;
    public static final int VPN_ERROR_LARGEST = 200;
    public static final int VPN_ERROR_NO_ERROR = 0;
    public static final String PROFILES_PATH = "/misc/vpn/profiles";
    private static final String PACKAGE_PREFIX = VpnManager.class.getPackage().getName() + ".";
    private static final String ACTION_VPN_SERVICE = PACKAGE_PREFIX + "SERVICE";
    private static final String ACTION_VPN_SETTINGS = PACKAGE_PREFIX + "SETTINGS";
    public static final String TAG = VpnManager.class.getSimpleName();
    private Context mContext;

    public static String getProfilePath() {
        return Environment.getSecureDataDirectory().getPath() + PROFILES_PATH;
    }

    public static VpnType[] getSupportedVpnTypes() {
        return VpnType.values();
    }

    public VpnManager(Context c) {
        this.mContext = c;
    }

    public VpnProfile createVpnProfile(VpnType type) {
        return this.createVpnProfile(type, false);
    }

    public VpnProfile createVpnProfile(VpnType type, boolean customized) {
        try {
            VpnProfile p = type.getProfileClass().newInstance();
            p.setCustomized(customized);
            return p;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public void startVpnService() {
        this.mContext.startService(new Intent(ACTION_VPN_SERVICE));
    }

    public void stopVpnService() {
        this.mContext.stopService(new Intent(ACTION_VPN_SERVICE));
    }

    public boolean bindVpnService(ServiceConnection c) {
        if (!this.mContext.bindService(new Intent(ACTION_VPN_SERVICE), c, 0)) {
            Log.w(TAG, "failed to connect to VPN service");
            return false;
        }
        Log.d(TAG, "succeeded to connect to VPN service");
        return true;
    }

    public void broadcastConnectivity(String profileName, VpnState s) {
        this.broadcastConnectivity(profileName, s, 0);
    }

    public void broadcastConnectivity(String profileName, VpnState s, int error) {
        Intent intent = new Intent(ACTION_VPN_CONNECTIVITY);
        intent.putExtra(BROADCAST_PROFILE_NAME, profileName);
        intent.putExtra(BROADCAST_CONNECTION_STATE, (Serializable)((Object)s));
        if (error != 0) {
            intent.putExtra(BROADCAST_ERROR_CODE, error);
        }
        this.mContext.sendBroadcast(intent);
    }

    public void registerConnectivityReceiver(BroadcastReceiver r) {
        IntentFilter filter = new IntentFilter();
        filter.addAction(ACTION_VPN_CONNECTIVITY);
        this.mContext.registerReceiver(r, filter);
    }

    public void unregisterConnectivityReceiver(BroadcastReceiver r) {
        this.mContext.unregisterReceiver(r);
    }

    public void startSettingsActivity() {
        Intent intent = new Intent(ACTION_VPN_SETTINGS);
        intent.setFlags(0x10000000);
        this.mContext.startActivity(intent);
    }

    public Intent createSettingsActivityIntent() {
        Intent intent = new Intent(ACTION_VPN_SETTINGS);
        intent.setFlags(0x10000000);
        return intent;
    }
}

