/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.SystemClock;
import android.provider.Downloads;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public final class Downloads {
    public static final int STATUS_PENDING = 190;
    public static final int STATUS_RUNNING = 192;
    public static final int STATUS_SUCCESS = 200;
    public static final int STATUS_NOT_ACCEPTABLE = 406;
    public static final int STATUS_UNKNOWN_ERROR = 491;
    public static final int STATUS_UNHANDLED_REDIRECT = 493;
    public static final int STATUS_INSUFFICIENT_SPACE_ERROR = 498;
    public static final int STATUS_DEVICE_NOT_FOUND_ERROR = 499;
    public static final int DOWNLOAD_DESTINATION_EXTERNAL = 1;
    public static final int DOWNLOAD_DESTINATION_CACHE = 2;
    public static final int DOWNLOAD_DESTINATION_CACHE_PURGEABLE = 3;
    public static final long DOWNLOAD_ID_INVALID = -1L;
    public static final String ACTION_DOWNLOAD_COMPLETED = "android.intent.action.DOWNLOAD_COMPLETED";
    public static final String COLUMN_NOTIFICATION_EXTRAS = "notificationextras";
    private static final int STATUS_INVALID = 0;
    private static final int STATUS_DOWNLOADING_UPDATE = 3;
    private static final int STATUS_DOWNLOADED_UPDATE = 4;
    private static final String[] DOWNLOADS_PROJECTION = new String[]{"_id", "entity", "status", "_data", "lastmod", "current_bytes"};
    private static final int DOWNLOADS_COLUMN_ID = 0;
    private static final int DOWNLOADS_COLUMN_URI = 1;
    private static final int DOWNLOADS_COLUMN_STATUS = 2;
    private static final int DOWNLOADS_COLUMN_FILENAME = 3;
    private static final int DOWNLOADS_COLUMN_LAST_MODIFICATION = 4;
    private static final int DOWNLOADS_COLUMN_CURRENT_BYTES = 5;

    public static boolean isStatusSuccess(int status) {
        return status >= 200 && status < 300;
    }

    public static boolean isStatusError(int status) {
        return status >= 400 && status < 600;
    }

    private static final int getStatusOfDownload(Cursor c, long redownload_threshold) {
        int status = c.getInt(2);
        long realtime = SystemClock.elapsedRealtime();
        if (!Downloads.Impl.isStatusCompleted(status)) {
            long modified = c.getLong(4);
            long now = System.currentTimeMillis();
            if (now < modified || now - modified > redownload_threshold) {
                return 0;
            }
            return 3;
        }
        if (Downloads.Impl.isStatusError(status)) {
            return 0;
        }
        String filename = c.getString(3);
        if (filename == null) {
            return 0;
        }
        return 4;
    }

    private Downloads() {
    }

    public static class DownloadBase {
        DownloadBase() {
        }

        public static long startDownloadByUri(Context context, String url, String cookieData, boolean showDownload, int downloadDestination, boolean allowRoaming, boolean skipIntegrityCheck, String title, String notification_package, String notification_class, String notification_extras) {
            ContentResolver cr = context.getContentResolver();
            ContentValues values = new ContentValues();
            values.put("uri", url);
            values.put("cookiedata", cookieData);
            values.put("visibility", showDownload ? 0 : 2);
            if (title != null) {
                values.put("title", title);
            }
            values.put("entity", url);
            int destination = 0;
            switch (downloadDestination) {
                case 1: {
                    destination = 0;
                    break;
                }
                case 2: {
                    if (allowRoaming) {
                        destination = 1;
                        break;
                    }
                    destination = 3;
                    break;
                }
                case 3: {
                    destination = 2;
                }
            }
            values.put("destination", destination);
            values.put("no_integrity", skipIntegrityCheck);
            if (notification_package != null && notification_class != null) {
                values.put("notificationpackage", notification_package);
                values.put("notificationclass", notification_class);
                if (notification_extras != null) {
                    values.put(Downloads.COLUMN_NOTIFICATION_EXTRAS, notification_extras);
                }
            }
            Uri downloadUri = cr.insert(Downloads.Impl.CONTENT_URI, values);
            long downloadId = -1L;
            if (downloadUri != null) {
                downloadId = Long.parseLong(downloadUri.getLastPathSegment());
            }
            return downloadId;
        }
    }

    public static final class ById
    extends DownloadBase {
        private ById() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String getMimeTypeForId(Context context, long downloadId) {
            ContentResolver cr = context.getContentResolver();
            String mimeType = null;
            Cursor downloadCursor = null;
            try {
                Uri downloadUri = ById.getDownloadUri(downloadId);
                downloadCursor = cr.query(downloadUri, new String[]{"mimetype"}, null, null, null);
                if (downloadCursor.moveToNext()) {
                    mimeType = downloadCursor.getString(0);
                }
            }
            finally {
                if (downloadCursor != null) {
                    downloadCursor.close();
                }
            }
            return mimeType;
        }

        public static void deleteDownload(Context context, long downloadId) {
            ContentResolver cr = context.getContentResolver();
            Object mimeType = null;
            Uri downloadUri = ById.getDownloadUri(downloadId);
            cr.delete(downloadUri, null, null);
        }

        public static ParcelFileDescriptor openDownload(Context context, long downloadId, String mode) throws FileNotFoundException {
            ContentResolver cr = context.getContentResolver();
            Object mimeType = null;
            Uri downloadUri = ById.getDownloadUri(downloadId);
            return cr.openFileDescriptor(downloadUri, mode);
        }

        public static InputStream openDownloadStream(Context context, long downloadId) throws FileNotFoundException, IOException {
            ContentResolver cr = context.getContentResolver();
            Object mimeType = null;
            Uri downloadUri = ById.getDownloadUri(downloadId);
            return cr.openInputStream(downloadUri);
        }

        private static Uri getDownloadUri(long downloadId) {
            return Uri.parse(Downloads.Impl.CONTENT_URI + "/" + downloadId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static final StatusInfo getStatus(Context context, long downloadId) {
            StatusInfo result = null;
            boolean hasFailedDownload = false;
            long failedDownloadModificationTime = 0L;
            Uri downloadUri = ById.getDownloadUri(downloadId);
            ContentResolver cr = context.getContentResolver();
            Cursor c = cr.query(downloadUri, DOWNLOADS_PROJECTION, null, null, null);
            try {
                int status;
                if (!c.moveToNext()) {
                    StatusInfo statusInfo = result;
                    return statusInfo;
                }
                if (result == null) {
                    result = new StatusInfo();
                }
                if ((status = Downloads.getStatusOfDownload(c, 0L)) == 3 || status == 4) {
                    result.completed = status == 4;
                    result.filename = c.getString(3);
                    result.id = c.getLong(0);
                    result.statusCode = c.getInt(2);
                    result.bytesSoFar = c.getLong(5);
                    StatusInfo statusInfo = result;
                    return statusInfo;
                }
                long modTime = c.getLong(4);
                result.statusCode = c.getInt(2);
                result.bytesSoFar = c.getLong(5);
            }
            finally {
                if (c != null) {
                    c.close();
                }
            }
            return result;
        }
    }

    public static final class ByUri
    extends DownloadBase {
        private static final String QUERY_WHERE_APP_DATA_CLAUSE = "entity=?";
        private static final String QUERY_WHERE_CLAUSE = "notificationpackage=? AND notificationclass=?";
        private static final String[] PROJECTION = new String[]{"_id", "current_bytes", "total_bytes"};

        private ByUri() {
        }

        private static final Cursor getCurrentOtaDownloads(Context context, String url) {
            return context.getContentResolver().query(Downloads.Impl.CONTENT_URI, DOWNLOADS_PROJECTION, QUERY_WHERE_APP_DATA_CLAUSE, new String[]{url}, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static final StatusInfo getStatus(Context context, String url, long redownload_threshold) {
            StatusInfo result = null;
            boolean hasFailedDownload = false;
            long failedDownloadModificationTime = 0L;
            Cursor c = ByUri.getCurrentOtaDownloads(context, url);
            try {
                while (c != null && c.moveToNext()) {
                    int status;
                    if (result == null) {
                        result = new StatusInfo();
                    }
                    if ((status = Downloads.getStatusOfDownload(c, redownload_threshold)) == 3 || status == 4) {
                        result.completed = status == 4;
                        result.filename = c.getString(3);
                        result.id = c.getLong(0);
                        result.statusCode = c.getInt(2);
                        result.bytesSoFar = c.getLong(5);
                        StatusInfo statusInfo = result;
                        return statusInfo;
                    }
                    long modTime = c.getLong(4);
                    if (hasFailedDownload && modTime < failedDownloadModificationTime) continue;
                    hasFailedDownload = true;
                    failedDownloadModificationTime = modTime;
                    result.statusCode = c.getInt(2);
                    result.bytesSoFar = c.getLong(5);
                }
            }
            finally {
                if (c != null) {
                    c.close();
                }
            }
            return result;
        }

        public static final void removeAllDownloadsByPackage(Context context, String notification_package, String notification_class) {
            context.getContentResolver().delete(Downloads.Impl.CONTENT_URI, QUERY_WHERE_CLAUSE, new String[]{notification_package, notification_class});
        }

        public static final int getProgressColumnId() {
            return 0;
        }

        public static final int getProgressColumnCurrentBytes() {
            return 1;
        }

        public static final int getProgressColumnTotalBytes() {
            return 2;
        }

        public static final Cursor getProgressCursor(Context context, long id2) {
            Uri downloadUri = Uri.withAppendedPath(Downloads.Impl.CONTENT_URI, String.valueOf(id2));
            return context.getContentResolver().query(downloadUri, PROJECTION, null, null, null);
        }
    }

    public static final class StatusInfo {
        public boolean completed = false;
        public String filename = null;
        public long id = -1L;
        public int statusCode = -1;
        public long bytesSoFar = -1L;

        public boolean isComplete() {
            return Downloads.Impl.isStatusCompleted(this.statusCode);
        }

        public boolean isSuccessful() {
            return Downloads.Impl.isStatusCompleted(this.statusCode);
        }
    }
}

