/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.net.Uri;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;

public class MediaMetadataRetriever {
    private int mNativeContext;
    private static final int EMBEDDED_PICTURE_TYPE_ANY = 65535;
    public static final int OPTION_PREVIOUS_SYNC = 0;
    public static final int OPTION_NEXT_SYNC = 1;
    public static final int OPTION_CLOSEST_SYNC = 2;
    public static final int OPTION_CLOSEST = 3;
    public static final int METADATA_KEY_CD_TRACK_NUMBER = 0;
    public static final int METADATA_KEY_ALBUM = 1;
    public static final int METADATA_KEY_ARTIST = 2;
    public static final int METADATA_KEY_AUTHOR = 3;
    public static final int METADATA_KEY_COMPOSER = 4;
    public static final int METADATA_KEY_DATE = 5;
    public static final int METADATA_KEY_GENRE = 6;
    public static final int METADATA_KEY_TITLE = 7;
    public static final int METADATA_KEY_YEAR = 8;
    public static final int METADATA_KEY_DURATION = 9;
    public static final int METADATA_KEY_NUM_TRACKS = 10;
    public static final int METADATA_KEY_WRITER = 11;
    public static final int METADATA_KEY_MIMETYPE = 12;
    public static final int METADATA_KEY_ALBUMARTIST = 13;
    public static final int METADATA_KEY_DISC_NUMBER = 14;
    public static final int METADATA_KEY_COMPILATION = 15;

    public MediaMetadataRetriever() {
        this.native_setup();
    }

    public native void setDataSource(String var1) throws IllegalArgumentException;

    public native void setDataSource(FileDescriptor var1, long var2, long var4) throws IllegalArgumentException;

    public void setDataSource(FileDescriptor fd) throws IllegalArgumentException {
        this.setDataSource(fd, 0L, 0x7FFFFFFFFFFFFFFL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataSource(Context context, Uri uri) throws IllegalArgumentException, SecurityException {
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        String scheme = uri.getScheme();
        if (scheme == null || scheme.equals("file")) {
            this.setDataSource(uri.getPath());
            return;
        }
        AssetFileDescriptor fd = null;
        try {
            ContentResolver resolver = context.getContentResolver();
            try {
                fd = resolver.openAssetFileDescriptor(uri, "r");
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException();
            }
            if (fd == null) {
                throw new IllegalArgumentException();
            }
            FileDescriptor descriptor = fd.getFileDescriptor();
            if (!descriptor.valid()) {
                throw new IllegalArgumentException();
            }
            if (fd.getDeclaredLength() < 0L) {
                this.setDataSource(descriptor);
            } else {
                this.setDataSource(descriptor, fd.getStartOffset(), fd.getDeclaredLength());
            }
            return;
        }
        catch (SecurityException ex) {
        }
        finally {
            try {
                if (fd != null) {
                    fd.close();
                }
            }
            catch (IOException ioEx) {}
        }
        this.setDataSource(uri.toString());
    }

    public native String extractMetadata(int var1);

    public Bitmap getFrameAtTime(long timeUs, int option) {
        if (option < 0 || option > 3) {
            throw new IllegalArgumentException("Unsupported option: " + option);
        }
        return this._getFrameAtTime(timeUs, option);
    }

    public Bitmap getFrameAtTime(long timeUs) {
        return this.getFrameAtTime(timeUs, 2);
    }

    public Bitmap getFrameAtTime() {
        return this.getFrameAtTime(-1L, 2);
    }

    private native Bitmap _getFrameAtTime(long var1, int var3);

    public byte[] getEmbeddedPicture() {
        return this.getEmbeddedPicture(65535);
    }

    private native byte[] getEmbeddedPicture(int var1);

    public native void release();

    private native void native_setup();

    private static native void native_init();

    private final native void native_finalize();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.native_finalize();
        }
        finally {
            super.finalize();
        }
    }

    static {
        System.loadLibrary("media_jni");
        MediaMetadataRetriever.native_init();
    }
}

