/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityManagerNative;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.media.AudioManager;
import android.media.AudioSystem;
import android.media.IAudioFocusDispatcher;
import android.media.IAudioService;
import android.media.MediaPlayer;
import android.media.SoundPool;
import android.os.Binder;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.provider.Settings;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.view.KeyEvent;
import android.view.VolumePanel;
import com.android.internal.telephony.ITelephony;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;

public class AudioService
extends IAudioService.Stub {
    private static final String TAG = "AudioService";
    private static final int PERSIST_DELAY = 3000;
    private Context mContext;
    private ContentResolver mContentResolver;
    private VolumePanel mVolumePanel;
    private static final int SHARED_MSG = -1;
    private static final int SENDMSG_REPLACE = 0;
    private static final int SENDMSG_NOOP = 1;
    private static final int SENDMSG_QUEUE = 2;
    private static final int MSG_SET_SYSTEM_VOLUME = 0;
    private static final int MSG_PERSIST_VOLUME = 1;
    private static final int MSG_PERSIST_RINGER_MODE = 3;
    private static final int MSG_PERSIST_VIBRATE_SETTING = 4;
    private static final int MSG_MEDIA_SERVER_DIED = 5;
    private static final int MSG_MEDIA_SERVER_STARTED = 6;
    private static final int MSG_PLAY_SOUND_EFFECT = 7;
    private static final int MSG_BTA2DP_DOCK_TIMEOUT = 8;
    private static final int BTA2DP_DOCK_TIMEOUT_MILLIS = 8000;
    private AudioSystemThread mAudioSystemThread;
    private AudioHandler mAudioHandler;
    private VolumeStreamState[] mStreamStates;
    private SettingsObserver mSettingsObserver;
    private int mMode;
    private Object mSettingsLock = new Object();
    private boolean mMediaServerOk;
    private SoundPool mSoundPool;
    private Object mSoundEffectsLock = new Object();
    private static final int NUM_SOUNDPOOL_CHANNELS = 4;
    private static final int SOUND_EFFECT_VOLUME = 1000;
    private static final String SOUND_EFFECTS_PATH = "/media/audio/ui/";
    private static final String[] SOUND_EFFECT_FILES = new String[]{"Effect_Tick.ogg", "KeypressStandard.ogg", "KeypressSpacebar.ogg", "KeypressDelete.ogg", "KeypressReturn.ogg"};
    private int[][] SOUND_EFFECT_FILES_MAP = new int[][]{{0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {1, -1}, {2, -1}, {3, -1}, {4, -1}};
    private int[] MAX_STREAM_VOLUME = new int[]{5, 7, 7, 15, 7, 7, 15, 7, 15, 15};
    private int[] STREAM_VOLUME_ALIAS = new int[]{0, 1, 2, 3, 4, 5, 6, 1, 0, 3};
    private AudioSystem.ErrorCallback mAudioSystemCallback = new AudioSystem.ErrorCallback(){

        public void onError(int error) {
            switch (error) {
                case 100: {
                    if (!AudioService.this.mMediaServerOk) break;
                    AudioService.sendMsg(AudioService.this.mAudioHandler, 5, -1, 1, 0, 0, null, 1500);
                    AudioService.this.mMediaServerOk = false;
                    break;
                }
                case 0: {
                    if (AudioService.this.mMediaServerOk) break;
                    AudioService.sendMsg(AudioService.this.mAudioHandler, 6, -1, 1, 0, 0, null, 0);
                    AudioService.this.mMediaServerOk = true;
                    break;
                }
            }
        }
    };
    private int mRingerMode;
    private int mRingerModeAffectedStreams;
    private int mRingerModeMutedStreams;
    private int mMuteAffectedStreams;
    private int mVibrateSetting;
    private int mNotificationsUseRingVolume;
    private final BroadcastReceiver mReceiver = new AudioServiceBroadcastReceiver();
    private final BroadcastReceiver mMediaButtonReceiver = new MediaButtonBroadcastReceiver();
    private boolean mIsRinging = false;
    private HashMap<Integer, String> mConnectedDevices = new HashMap();
    private int mForcedUseForComm;
    private ArrayList<SetModeDeathHandler> mSetModeDeathHandlers = new ArrayList();
    private ArrayList<ScoClient> mScoClients = new ArrayList();
    private BluetoothHeadset mBluetoothHeadset;
    private boolean mBluetoothHeadsetConnected;
    private BluetoothHeadset.ServiceListener mBluetoothHeadsetServiceListener = new BluetoothHeadset.ServiceListener(){

        public void onServiceConnected() {
            if (AudioService.this.mBluetoothHeadset != null) {
                BluetoothDevice device = AudioService.this.mBluetoothHeadset.getCurrentHeadset();
                if (AudioService.this.mBluetoothHeadset.getState(device) == 2) {
                    AudioService.this.mBluetoothHeadsetConnected = true;
                }
            }
        }

        public void onServiceDisconnected() {
            if (AudioService.this.mBluetoothHeadset != null) {
                BluetoothDevice device = AudioService.this.mBluetoothHeadset.getCurrentHeadset();
                if (AudioService.this.mBluetoothHeadset.getState(device) == 0) {
                    AudioService.this.mBluetoothHeadsetConnected = false;
                    AudioService.this.clearAllScoClients();
                }
            }
        }
    };
    private String mDockAddress;
    private static final String IN_VOICE_COMM_FOCUS_ID = "AudioFocus_For_Phone_Ring_And_Calls";
    private static final Object mAudioFocusLock = new Object();
    private static final Object mRingingLock = new Object();
    private PhoneStateListener mPhoneStateListener = new PhoneStateListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCallStateChanged(int state, String incomingNumber) {
            if (state == 1) {
                Object object = mRingingLock;
                synchronized (object) {
                    AudioService.this.mIsRinging = true;
                }
                int ringVolume = AudioService.this.getStreamVolume(2);
                if (ringVolume > 0) {
                    AudioService.this.requestAudioFocus(2, 2, null, null, AudioService.IN_VOICE_COMM_FOCUS_ID);
                }
            } else if (state == 2) {
                Object object = mRingingLock;
                synchronized (object) {
                    AudioService.this.mIsRinging = false;
                }
                AudioService.this.requestAudioFocus(2, 2, null, null, AudioService.IN_VOICE_COMM_FOCUS_ID);
            } else if (state == 0) {
                Object object = mRingingLock;
                synchronized (object) {
                    AudioService.this.mIsRinging = false;
                }
                AudioService.this.abandonAudioFocus(null, AudioService.IN_VOICE_COMM_FOCUS_ID);
            }
        }
    };
    private Stack<FocusStackEntry> mFocusStack = new Stack();
    private Stack<RemoteControlStackEntry> mRCStack = new Stack();

    public AudioService(Context context) {
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
        this.MAX_STREAM_VOLUME[0] = SystemProperties.getInt("ro.config.vc_call_vol_steps", this.MAX_STREAM_VOLUME[0]);
        this.mVolumePanel = new VolumePanel(context, this);
        this.mSettingsObserver = new SettingsObserver();
        this.mForcedUseForComm = 0;
        this.createAudioSystemThread();
        this.readPersistedSettings();
        this.createStreamStates();
        this.mMode = -2;
        this.setMode(0, null);
        this.mMediaServerOk = true;
        this.mRingerModeMutedStreams = 0;
        this.setRingerModeInt(this.getRingerMode(), false);
        AudioSystem.setErrorCallback(this.mAudioSystemCallback);
        this.loadSoundEffects();
        this.mBluetoothHeadsetConnected = false;
        this.mBluetoothHeadset = new BluetoothHeadset(context, this.mBluetoothHeadsetServiceListener);
        IntentFilter intentFilter = new IntentFilter("android.intent.action.HEADSET_PLUG");
        intentFilter.addAction("android.bluetooth.a2dp.action.SINK_STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.headset.action.STATE_CHANGED");
        intentFilter.addAction("android.intent.action.DOCK_EVENT");
        intentFilter.addAction("android.bluetooth.headset.action.AUDIO_STATE_CHANGED");
        context.registerReceiver(this.mReceiver, intentFilter);
        intentFilter = new IntentFilter("android.intent.action.MEDIA_BUTTON");
        intentFilter.setPriority(1000);
        context.registerReceiver(this.mMediaButtonReceiver, intentFilter);
        TelephonyManager tmgr = (TelephonyManager)context.getSystemService("phone");
        tmgr.listen(this.mPhoneStateListener, 32);
    }

    private void createAudioSystemThread() {
        this.mAudioSystemThread = new AudioSystemThread();
        this.mAudioSystemThread.start();
        this.waitForAudioHandlerCreation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAudioHandlerCreation() {
        AudioService audioService = this;
        synchronized (audioService) {
            while (this.mAudioHandler == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Log.e(TAG, "Interrupted while waiting on volume handler.");
                }
            }
        }
    }

    private void createStreamStates() {
        int i;
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        this.mStreamStates = new VolumeStreamState[numStreamTypes];
        VolumeStreamState[] streams = this.mStreamStates;
        for (i = 0; i < numStreamTypes; ++i) {
            streams[i] = new VolumeStreamState(Settings.System.VOLUME_SETTINGS[this.STREAM_VOLUME_ALIAS[i]], i);
        }
        for (i = 0; i < numStreamTypes; ++i) {
            if (this.STREAM_VOLUME_ALIAS[i] == i) continue;
            int index = this.rescaleIndex(streams[i].mIndex, this.STREAM_VOLUME_ALIAS[i], i);
            streams[i].mIndex = streams[i].getValidIndex(index);
            this.setStreamVolumeIndex(i, index);
            index = this.rescaleIndex(streams[i].mLastAudibleIndex, this.STREAM_VOLUME_ALIAS[i], i);
            streams[i].mLastAudibleIndex = streams[i].getValidIndex(index);
        }
    }

    private void readPersistedSettings() {
        ContentResolver cr = this.mContentResolver;
        this.mRingerMode = Settings.System.getInt(cr, "mode_ringer", 2);
        this.mVibrateSetting = Settings.System.getInt(cr, "vibrate_on", 0);
        this.mRingerModeAffectedStreams = Settings.System.getInt(cr, "mode_ringer_streams_affected", 166);
        this.mMuteAffectedStreams = Settings.System.getInt(cr, "mute_streams_affected", 14);
        this.mNotificationsUseRingVolume = Settings.System.getInt(cr, "notifications_use_ring_volume", 1);
        if (this.mNotificationsUseRingVolume == 1) {
            this.STREAM_VOLUME_ALIAS[5] = 2;
        }
        this.broadcastRingerMode();
        this.broadcastVibrateSetting(0);
        this.broadcastVibrateSetting(1);
    }

    private void setStreamVolumeIndex(int stream, int index) {
        AudioSystem.setStreamVolumeIndex(stream, (index + 5) / 10);
    }

    private int rescaleIndex(int index, int srcStream, int dstStream) {
        return (index * this.mStreamStates[dstStream].getMaxIndex() + this.mStreamStates[srcStream].getMaxIndex() / 2) / this.mStreamStates[srcStream].getMaxIndex();
    }

    public void adjustVolume(int direction, int flags) {
        this.adjustSuggestedStreamVolume(direction, Integer.MIN_VALUE, flags);
    }

    public void adjustSuggestedStreamVolume(int direction, int suggestedStreamType, int flags) {
        int streamType = this.getActiveStreamType(suggestedStreamType);
        if (streamType != 2 && (flags & 4) != 0) {
            flags &= 0xFFFFFFFB;
        }
        this.adjustStreamVolume(streamType, direction, flags);
    }

    public void adjustStreamVolume(int streamType, int direction, int flags) {
        int index;
        this.ensureValidDirection(direction);
        this.ensureValidStreamType(streamType);
        VolumeStreamState streamState = this.mStreamStates[this.STREAM_VOLUME_ALIAS[streamType]];
        int oldIndex = streamState.muteCount() != 0 ? streamState.mLastAudibleIndex : streamState.mIndex;
        boolean adjustVolume = true;
        if ((flags & 2) != 0 || streamType == 2) {
            adjustVolume = this.checkForRingerModeChange(oldIndex, direction);
        }
        if (streamState.muteCount() != 0) {
            if (adjustVolume) {
                streamState.adjustLastAudibleIndex(direction);
                AudioService.sendMsg(this.mAudioHandler, 1, streamType, 0, 0, 1, streamState, 3000);
            }
            index = streamState.mLastAudibleIndex;
        } else {
            if (adjustVolume && streamState.adjustIndex(direction)) {
                AudioService.sendMsg(this.mAudioHandler, 0, this.STREAM_VOLUME_ALIAS[streamType], 1, 0, 0, streamState, 0);
            }
            index = streamState.mIndex;
        }
        this.mVolumePanel.postVolumeChanged(streamType, flags);
        this.sendVolumeUpdate(streamType, oldIndex, index);
    }

    public void setStreamVolume(int streamType, int index, int flags) {
        this.ensureValidStreamType(streamType);
        VolumeStreamState streamState = this.mStreamStates[this.STREAM_VOLUME_ALIAS[streamType]];
        int oldIndex = streamState.muteCount() != 0 ? streamState.mLastAudibleIndex : streamState.mIndex;
        index = this.rescaleIndex(index * 10, streamType, this.STREAM_VOLUME_ALIAS[streamType]);
        this.setStreamVolumeInt(this.STREAM_VOLUME_ALIAS[streamType], index, false, true);
        index = streamState.muteCount() != 0 ? streamState.mLastAudibleIndex : streamState.mIndex;
        this.mVolumePanel.postVolumeChanged(streamType, flags);
        this.sendVolumeUpdate(streamType, oldIndex, index);
    }

    private void sendVolumeUpdate(int streamType, int oldIndex, int index) {
        oldIndex = (oldIndex + 5) / 10;
        index = (index + 5) / 10;
        Intent intent = new Intent("android.media.VOLUME_CHANGED_ACTION");
        intent.putExtra("android.media.EXTRA_VOLUME_STREAM_TYPE", streamType);
        intent.putExtra("android.media.EXTRA_VOLUME_STREAM_VALUE", index);
        intent.putExtra("android.media.EXTRA_PREV_VOLUME_STREAM_VALUE", oldIndex);
        this.mContext.sendBroadcast(intent);
    }

    private void setStreamVolumeInt(int streamType, int index, boolean force, boolean lastAudible) {
        VolumeStreamState streamState = this.mStreamStates[streamType];
        if (streamState.muteCount() != 0) {
            if (index != 0) {
                streamState.setLastAudibleIndex(index);
                AudioService.sendMsg(this.mAudioHandler, 1, streamType, 0, 0, 1, streamState, 3000);
            }
        } else if (streamState.setIndex(index, lastAudible) || force) {
            AudioService.sendMsg(this.mAudioHandler, 0, streamType, 1, 0, 0, streamState, 0);
        }
    }

    public void setStreamSolo(int streamType, boolean state, IBinder cb) {
        for (int stream = 0; stream < this.mStreamStates.length; ++stream) {
            if (!this.isStreamAffectedByMute(stream) || stream == streamType) continue;
            this.mStreamStates[stream].mute(cb, state);
        }
    }

    public void setStreamMute(int streamType, boolean state, IBinder cb) {
        if (this.isStreamAffectedByMute(streamType)) {
            this.mStreamStates[streamType].mute(cb, state);
        }
    }

    public int getStreamVolume(int streamType) {
        this.ensureValidStreamType(streamType);
        return (this.mStreamStates[streamType].mIndex + 5) / 10;
    }

    public int getStreamMaxVolume(int streamType) {
        this.ensureValidStreamType(streamType);
        return (this.mStreamStates[streamType].getMaxIndex() + 5) / 10;
    }

    public int getRingerMode() {
        return this.mRingerMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRingerMode(int ringerMode) {
        Object object = this.mSettingsLock;
        synchronized (object) {
            if (ringerMode != this.mRingerMode) {
                this.setRingerModeInt(ringerMode, true);
                this.broadcastRingerMode();
            }
        }
    }

    private void setRingerModeInt(int ringerMode, boolean persist) {
        this.mRingerMode = ringerMode;
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        for (int streamType = numStreamTypes - 1; streamType >= 0; --streamType) {
            if (this.isStreamMutedByRingerMode(streamType)) {
                if (this.isStreamAffectedByRingerMode(streamType) && this.mRingerMode != 2) continue;
                this.mStreamStates[streamType].mute(null, false);
                this.mRingerModeMutedStreams &= ~(1 << streamType);
                continue;
            }
            if (!this.isStreamAffectedByRingerMode(streamType) || this.mRingerMode == 2) continue;
            this.mStreamStates[streamType].mute(null, true);
            this.mRingerModeMutedStreams |= 1 << streamType;
        }
        if (persist) {
            AudioService.sendMsg(this.mAudioHandler, 3, -1, 0, 0, 0, null, 3000);
        }
    }

    public boolean shouldVibrate(int vibrateType) {
        switch (this.getVibrateSetting(vibrateType)) {
            case 1: {
                return this.mRingerMode != 0;
            }
            case 2: {
                return this.mRingerMode == 1;
            }
            case 0: {
                return false;
            }
        }
        return false;
    }

    public int getVibrateSetting(int vibrateType) {
        return this.mVibrateSetting >> vibrateType * 2 & 3;
    }

    public void setVibrateSetting(int vibrateType, int vibrateSetting) {
        this.mVibrateSetting = AudioService.getValueForVibrateSetting(this.mVibrateSetting, vibrateType, vibrateSetting);
        this.broadcastVibrateSetting(vibrateType);
        AudioService.sendMsg(this.mAudioHandler, 4, -1, 1, 0, 0, null, 0);
    }

    public static int getValueForVibrateSetting(int existingValue, int vibrateType, int vibrateSetting) {
        existingValue &= ~(3 << vibrateType * 2);
        return existingValue |= (vibrateSetting & 3) << vibrateType * 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMode(int mode, IBinder cb) {
        if (!this.checkAudioSettingsPermission("setMode()")) {
            return;
        }
        if (mode < -1 || mode >= 4) {
            return;
        }
        Object object = this.mSettingsLock;
        synchronized (object) {
            if (mode == -1) {
                mode = this.mMode;
            }
            if (mode != this.mMode && AudioSystem.setPhoneState(mode) == 0) {
                this.mMode = mode;
                ArrayList<SetModeDeathHandler> arrayList = this.mSetModeDeathHandlers;
                synchronized (arrayList) {
                    SetModeDeathHandler hdlr = null;
                    Iterator<SetModeDeathHandler> iter = this.mSetModeDeathHandlers.iterator();
                    while (iter.hasNext()) {
                        SetModeDeathHandler h = iter.next();
                        if (h.getBinder() != cb) continue;
                        hdlr = h;
                        iter.remove();
                        break;
                    }
                    if (hdlr == null) {
                        hdlr = new SetModeDeathHandler(cb);
                        if (cb != null) {
                            try {
                                cb.linkToDeath(hdlr, 0);
                            }
                            catch (RemoteException e) {
                                Log.w(TAG, "setMode() could not link to " + cb + " binder death");
                            }
                        }
                    }
                    this.mSetModeDeathHandlers.add(0, hdlr);
                    hdlr.setMode(mode);
                }
                if (mode != 0) {
                    this.clearAllScoClients();
                }
            }
            int streamType = this.getActiveStreamType(Integer.MIN_VALUE);
            int index = this.mStreamStates[this.STREAM_VOLUME_ALIAS[streamType]].mIndex;
            this.setStreamVolumeInt(this.STREAM_VOLUME_ALIAS[streamType], index, true, false);
        }
    }

    public int getMode() {
        return this.mMode;
    }

    public void playSoundEffect(int effectType) {
        AudioService.sendMsg(this.mAudioHandler, 7, -1, 1, effectType, -1, null, 0);
    }

    public void playSoundEffectVolume(int effectType, float volume) {
        this.loadSoundEffects();
        AudioService.sendMsg(this.mAudioHandler, 7, -1, 1, effectType, (int)(volume * 1000.0f), null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadSoundEffects() {
        Object object = this.mSoundEffectsLock;
        synchronized (object) {
            if (this.mSoundPool != null) {
                return true;
            }
            this.mSoundPool = new SoundPool(4, 1, 0);
            if (this.mSoundPool == null) {
                return false;
            }
            int[] poolId = new int[SOUND_EFFECT_FILES.length];
            for (int fileIdx = 0; fileIdx < SOUND_EFFECT_FILES.length; ++fileIdx) {
                poolId[fileIdx] = -1;
            }
            for (int effect = 0; effect < 9; ++effect) {
                if (this.SOUND_EFFECT_FILES_MAP[effect][1] == 0) continue;
                if (poolId[this.SOUND_EFFECT_FILES_MAP[effect][0]] == -1) {
                    int sampleId;
                    String filePath = Environment.getRootDirectory() + SOUND_EFFECTS_PATH + SOUND_EFFECT_FILES[this.SOUND_EFFECT_FILES_MAP[effect][0]];
                    this.SOUND_EFFECT_FILES_MAP[effect][1] = sampleId = this.mSoundPool.load(filePath, 0);
                    poolId[this.SOUND_EFFECT_FILES_MAP[effect][0]] = sampleId;
                    if (sampleId > 0) continue;
                    Log.w(TAG, "Soundpool could not load file: " + filePath);
                    continue;
                }
                this.SOUND_EFFECT_FILES_MAP[effect][1] = poolId[this.SOUND_EFFECT_FILES_MAP[effect][0]];
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadSoundEffects() {
        Object object = this.mSoundEffectsLock;
        synchronized (object) {
            if (this.mSoundPool == null) {
                return;
            }
            int[] poolId = new int[SOUND_EFFECT_FILES.length];
            for (int fileIdx = 0; fileIdx < SOUND_EFFECT_FILES.length; ++fileIdx) {
                poolId[fileIdx] = 0;
            }
            for (int effect = 0; effect < 9; ++effect) {
                if (this.SOUND_EFFECT_FILES_MAP[effect][1] <= 0 || poolId[this.SOUND_EFFECT_FILES_MAP[effect][0]] != 0) continue;
                this.mSoundPool.unload(this.SOUND_EFFECT_FILES_MAP[effect][1]);
                this.SOUND_EFFECT_FILES_MAP[effect][1] = -1;
                poolId[this.SOUND_EFFECT_FILES_MAP[effect][0]] = -1;
            }
            this.mSoundPool = null;
        }
    }

    public void reloadAudioSettings() {
        this.readPersistedSettings();
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        for (int streamType = 0; streamType < numStreamTypes; ++streamType) {
            VolumeStreamState streamState = this.mStreamStates[streamType];
            String settingName = Settings.System.VOLUME_SETTINGS[this.STREAM_VOLUME_ALIAS[streamType]];
            String lastAudibleSettingName = settingName + "_last_audible";
            int index = Settings.System.getInt(this.mContentResolver, settingName, AudioManager.DEFAULT_STREAM_VOLUME[streamType]);
            index = this.STREAM_VOLUME_ALIAS[streamType] != streamType ? this.rescaleIndex(index * 10, this.STREAM_VOLUME_ALIAS[streamType], streamType) : (index *= 10);
            streamState.mIndex = streamState.getValidIndex(index);
            index = (index + 5) / 10;
            index = Settings.System.getInt(this.mContentResolver, lastAudibleSettingName, index > 0 ? index : AudioManager.DEFAULT_STREAM_VOLUME[streamType]);
            index = this.STREAM_VOLUME_ALIAS[streamType] != streamType ? this.rescaleIndex(index * 10, this.STREAM_VOLUME_ALIAS[streamType], streamType) : (index *= 10);
            streamState.mLastAudibleIndex = streamState.getValidIndex(index);
            if (streamState.muteCount() != 0 && !this.isStreamAffectedByMute(streamType)) {
                int size = streamState.mDeathHandlers.size();
                for (int i = 0; i < size; ++i) {
                    ((VolumeStreamState.VolumeDeathHandler)streamState.mDeathHandlers.get(i)).mMuteCount = 1;
                    ((VolumeStreamState.VolumeDeathHandler)streamState.mDeathHandlers.get(i)).mute(false);
                }
            }
            if (streamState.muteCount() != 0) continue;
            this.setStreamVolumeIndex(streamType, streamState.mIndex);
        }
        this.setRingerModeInt(this.getRingerMode(), false);
    }

    public void setSpeakerphoneOn(boolean on) {
        if (!this.checkAudioSettingsPermission("setSpeakerphoneOn()")) {
            return;
        }
        if (on) {
            AudioSystem.setForceUse(0, 1);
            this.mForcedUseForComm = 1;
        } else {
            AudioSystem.setForceUse(0, 0);
            this.mForcedUseForComm = 0;
        }
    }

    public boolean isSpeakerphoneOn() {
        return this.mForcedUseForComm == 1;
    }

    public void setBluetoothScoOn(boolean on) {
        if (!this.checkAudioSettingsPermission("setBluetoothScoOn()")) {
            return;
        }
        if (on) {
            AudioSystem.setForceUse(0, 3);
            AudioSystem.setForceUse(2, 3);
            this.mForcedUseForComm = 3;
        } else {
            AudioSystem.setForceUse(0, 0);
            AudioSystem.setForceUse(2, 0);
            this.mForcedUseForComm = 0;
        }
    }

    public boolean isBluetoothScoOn() {
        return this.mForcedUseForComm == 3;
    }

    public void startBluetoothSco(IBinder cb) {
        if (!this.checkAudioSettingsPermission("startBluetoothSco()")) {
            return;
        }
        ScoClient client = this.getScoClient(cb);
        client.incCount();
    }

    public void stopBluetoothSco(IBinder cb) {
        if (!this.checkAudioSettingsPermission("stopBluetoothSco()")) {
            return;
        }
        ScoClient client = this.getScoClient(cb);
        client.decCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScoClient getScoClient(IBinder cb) {
        ArrayList<ScoClient> arrayList = this.mScoClients;
        synchronized (arrayList) {
            ScoClient client;
            int size = this.mScoClients.size();
            for (int i = 0; i < size; ++i) {
                client = this.mScoClients.get(i);
                if (client.getBinder() != cb) continue;
                return client;
            }
            client = new ScoClient(cb);
            this.mScoClients.add(client);
            return client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllScoClients() {
        ArrayList<ScoClient> arrayList = this.mScoClients;
        synchronized (arrayList) {
            int size = this.mScoClients.size();
            for (int i = 0; i < size; ++i) {
                this.mScoClients.get(i).clearCount(false);
            }
        }
    }

    private boolean checkForRingerModeChange(int oldIndex, int direction) {
        boolean adjustVolumeIndex = true;
        int newRingerMode = this.mRingerMode;
        if (this.mRingerMode == 2) {
            if (direction == -1 && (oldIndex + 5) / 10 == 1) {
                newRingerMode = Settings.System.getInt(this.mContentResolver, "vibrate_in_silent", 1) == 1 ? 1 : 0;
            }
        } else if (direction == 1) {
            newRingerMode = 2;
        } else {
            adjustVolumeIndex = false;
        }
        if (newRingerMode != this.mRingerMode) {
            this.setRingerMode(newRingerMode);
            adjustVolumeIndex = false;
        }
        return adjustVolumeIndex;
    }

    public boolean isStreamAffectedByRingerMode(int streamType) {
        return (this.mRingerModeAffectedStreams & 1 << streamType) != 0;
    }

    private boolean isStreamMutedByRingerMode(int streamType) {
        return (this.mRingerModeMutedStreams & 1 << streamType) != 0;
    }

    public boolean isStreamAffectedByMute(int streamType) {
        return (this.mMuteAffectedStreams & 1 << streamType) != 0;
    }

    private void ensureValidDirection(int direction) {
        if (direction < -1 || direction > 1) {
            throw new IllegalArgumentException("Bad direction " + direction);
        }
    }

    private void ensureValidStreamType(int streamType) {
        if (streamType < 0 || streamType >= this.mStreamStates.length) {
            throw new IllegalArgumentException("Bad stream type " + streamType);
        }
    }

    private int getActiveStreamType(int suggestedStreamType) {
        boolean isOffhook = false;
        try {
            ITelephony phone = ITelephony.Stub.asInterface(ServiceManager.checkService("phone"));
            if (phone != null) {
                isOffhook = phone.isOffhook();
            }
        }
        catch (RemoteException e) {
            Log.w(TAG, "Couldn't connect to phone service", e);
        }
        if (AudioSystem.getForceUse(0) == 3) {
            return 6;
        }
        if (isOffhook || AudioSystem.isStreamActive(0)) {
            return 0;
        }
        if (AudioSystem.isStreamActive(3)) {
            return 3;
        }
        if (suggestedStreamType == Integer.MIN_VALUE) {
            return 2;
        }
        return suggestedStreamType;
    }

    private void broadcastRingerMode() {
        Intent broadcast = new Intent("android.media.RINGER_MODE_CHANGED");
        broadcast.putExtra("android.media.EXTRA_RINGER_MODE", this.mRingerMode);
        broadcast.addFlags(0x30000000);
        long origCallerIdentityToken = Binder.clearCallingIdentity();
        this.mContext.sendStickyBroadcast(broadcast);
        Binder.restoreCallingIdentity(origCallerIdentityToken);
    }

    private void broadcastVibrateSetting(int vibrateType) {
        if (ActivityManagerNative.isSystemReady()) {
            Intent broadcast = new Intent("android.media.VIBRATE_SETTING_CHANGED");
            broadcast.putExtra("android.media.EXTRA_VIBRATE_TYPE", vibrateType);
            broadcast.putExtra("android.media.EXTRA_VIBRATE_SETTING", this.getVibrateSetting(vibrateType));
            this.mContext.sendBroadcast(broadcast);
        }
    }

    private static int getMsg(int baseMsg, int streamType) {
        return baseMsg & 0xFFFF | streamType << 16;
    }

    private static int getMsgBase(int msg) {
        return msg & 0xFFFF;
    }

    private static void sendMsg(Handler handler, int baseMsg, int streamType, int existingMsgPolicy, int arg1, int arg2, Object obj, int delay) {
        int msg;
        int n = msg = streamType == -1 ? baseMsg : AudioService.getMsg(baseMsg, streamType);
        if (existingMsgPolicy == 0) {
            handler.removeMessages(msg);
        } else if (existingMsgPolicy == 1 && handler.hasMessages(msg)) {
            return;
        }
        handler.sendMessageDelayed(handler.obtainMessage(msg, arg1, arg2, obj), delay);
    }

    boolean checkAudioSettingsPermission(String method) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_AUDIO_SETTINGS") == 0) {
            return true;
        }
        String msg = "Audio Settings Permission Denial: " + method + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid();
        Log.w(TAG, msg);
        return false;
    }

    private void makeA2dpDeviceAvailable(String address) {
        AudioSystem.setDeviceConnectionState(128, 1, address);
        AudioSystem.setParameters("A2dpSuspended=false");
        this.mConnectedDevices.put(new Integer(128), address);
    }

    private void makeA2dpDeviceUnavailableNow(String address) {
        Intent noisyIntent = new Intent("android.media.AUDIO_BECOMING_NOISY");
        this.mContext.sendBroadcast(noisyIntent);
        AudioSystem.setDeviceConnectionState(128, 0, address);
        this.mConnectedDevices.remove(128);
    }

    private void makeA2dpDeviceUnavailableLater(String address) {
        AudioSystem.setParameters("A2dpSuspended=true");
        this.mConnectedDevices.remove(128);
        Message msg = this.mAudioHandler.obtainMessage(8, address);
        this.mAudioHandler.sendMessageDelayed(msg, 8000L);
    }

    private void cancelA2dpDeviceTimeout() {
        this.mAudioHandler.removeMessages(8);
    }

    private boolean hasScheduledA2dpDockTimeout() {
        return this.mAudioHandler.hasMessages(8);
    }

    private void notifyTopOfAudioFocusStack() {
        if (!this.mFocusStack.empty() && this.mFocusStack.peek().mFocusDispatcher != null && this.canReassignAudioFocus()) {
            try {
                this.mFocusStack.peek().mFocusDispatcher.dispatchAudioFocusChange(1, this.mFocusStack.peek().mClientId);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failure to signal gain of audio control focus due to " + e);
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpFocusStack(PrintWriter pw) {
        pw.println("\nAudio Focus stack entries:");
        Object object = mAudioFocusLock;
        synchronized (object) {
            for (FocusStackEntry fse : this.mFocusStack) {
                pw.println("     source:" + fse.mSourceRef + " -- client: " + fse.mClientId + " -- duration: " + fse.mFocusChangeType);
            }
        }
    }

    private void removeFocusStackEntry(String clientToRemove, boolean signal) {
        if (!this.mFocusStack.empty() && this.mFocusStack.peek().mClientId.equals(clientToRemove)) {
            this.mFocusStack.pop();
            if (signal) {
                this.notifyTopOfAudioFocusStack();
            }
        } else {
            for (FocusStackEntry fse : this.mFocusStack) {
                if (!fse.mClientId.equals(clientToRemove)) continue;
                Log.i(TAG, " AudioFocus  abandonAudioFocus(): removing entry for " + fse.mClientId);
                this.mFocusStack.remove(fse);
            }
        }
    }

    private void removeFocusStackEntryForClient(IBinder cb) {
        boolean isTopOfStackForClientToRemove = !this.mFocusStack.isEmpty() && this.mFocusStack.peek().mSourceRef.equals(cb);
        for (FocusStackEntry fse : this.mFocusStack) {
            if (!fse.mSourceRef.equals(cb)) continue;
            Log.i(TAG, " AudioFocus  abandonAudioFocus(): removing entry for " + fse.mClientId);
            this.mFocusStack.remove(fse);
        }
        if (isTopOfStackForClientToRemove) {
            this.notifyTopOfAudioFocusStack();
        }
    }

    private boolean canReassignAudioFocus() {
        return this.mFocusStack.isEmpty() || !IN_VOICE_COMM_FOCUS_ID.equals(this.mFocusStack.peek().mClientId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int requestAudioFocus(int mainStreamType, int focusChangeHint, IBinder cb, IAudioFocusDispatcher fd, String clientId) {
        Log.i(TAG, " AudioFocus  requestAudioFocus() from " + clientId);
        if (!(IN_VOICE_COMM_FOCUS_ID.equals(clientId) || cb != null && cb.pingBinder())) {
            Log.i(TAG, " AudioFocus  DOA client for requestAudioFocus(), exiting");
            return 0;
        }
        Object object = mAudioFocusLock;
        synchronized (object) {
            if (!this.canReassignAudioFocus()) {
                return 0;
            }
            if (!this.mFocusStack.empty() && this.mFocusStack.peek().mClientId.equals(clientId)) {
                if (this.mFocusStack.peek().mFocusChangeType == focusChangeHint) {
                    return 1;
                }
                this.mFocusStack.pop();
            }
            if (!this.mFocusStack.empty() && this.mFocusStack.peek().mFocusDispatcher != null) {
                try {
                    this.mFocusStack.peek().mFocusDispatcher.dispatchAudioFocusChange(-1 * focusChangeHint, this.mFocusStack.peek().mClientId);
                }
                catch (RemoteException e) {
                    Log.e(TAG, " Failure to signal loss of focus due to " + e);
                    e.printStackTrace();
                }
            }
            this.removeFocusStackEntry(clientId, false);
            this.mFocusStack.push(new FocusStackEntry(mainStreamType, focusChangeHint, false, fd, cb, clientId));
        }
        if (!IN_VOICE_COMM_FOCUS_ID.equals(clientId)) {
            AudioFocusDeathHandler afdh = new AudioFocusDeathHandler(cb);
            try {
                cb.linkToDeath(afdh, 0);
            }
            catch (RemoteException e) {
                Log.w(TAG, "AudioFocus  requestAudioFocus() could not link to " + cb + " binder death");
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int abandonAudioFocus(IAudioFocusDispatcher fl, String clientId) {
        Log.i(TAG, " AudioFocus  abandonAudioFocus() from " + clientId);
        try {
            Object object = mAudioFocusLock;
            synchronized (object) {
                this.removeFocusStackEntry(clientId, true);
            }
        }
        catch (ConcurrentModificationException cme) {
            Log.e(TAG, "FATAL EXCEPTION AudioFocus  abandonAudioFocus() caused " + cme);
            cme.printStackTrace();
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAudioFocusClient(String clientId) {
        Object object = mAudioFocusLock;
        synchronized (object) {
            this.removeFocusStackEntry(clientId, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpRCStack(PrintWriter pw) {
        pw.println("\nRemote Control stack entries:");
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        synchronized (stack) {
            for (RemoteControlStackEntry fse : this.mRCStack) {
                pw.println("     receiver:" + fse.mReceiverComponent);
            }
        }
    }

    private void pushMediaButtonReceiver(ComponentName newReceiver) {
        if (!this.mRCStack.empty() && this.mRCStack.peek().mReceiverComponent.equals(newReceiver)) {
            return;
        }
        for (RemoteControlStackEntry rcse : this.mRCStack) {
            if (!rcse.mReceiverComponent.equals(newReceiver)) continue;
            this.mRCStack.remove(rcse);
            break;
        }
        this.mRCStack.push(new RemoteControlStackEntry(newReceiver));
    }

    private void removeMediaButtonReceiver(ComponentName newReceiver) {
        for (RemoteControlStackEntry rcse : this.mRCStack) {
            if (!rcse.mReceiverComponent.equals(newReceiver)) continue;
            this.mRCStack.remove(rcse);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMediaButtonEventReceiver(ComponentName eventReceiver) {
        Log.i(TAG, "  Remote Control   registerMediaButtonEventReceiver() for " + eventReceiver);
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        synchronized (stack) {
            this.pushMediaButtonReceiver(eventReceiver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterMediaButtonEventReceiver(ComponentName eventReceiver) {
        Log.i(TAG, "  Remote Control   unregisterMediaButtonEventReceiver() for " + eventReceiver);
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        synchronized (stack) {
            this.removeMediaButtonReceiver(eventReceiver);
        }
    }

    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.dumpFocusStack(pw);
        this.dumpRCStack(pw);
    }

    private static class RemoteControlStackEntry {
        public ComponentName mReceiverComponent;

        public RemoteControlStackEntry() {
        }

        public RemoteControlStackEntry(ComponentName r) {
            this.mReceiverComponent = r;
        }
    }

    private class MediaButtonBroadcastReceiver
    extends BroadcastReceiver {
        private MediaButtonBroadcastReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (!"android.intent.action.MEDIA_BUTTON".equals(action)) {
                return;
            }
            KeyEvent event = (KeyEvent)intent.getParcelableExtra("android.intent.extra.KEY_EVENT");
            if (event != null) {
                Object object = mRingingLock;
                synchronized (object) {
                    if (AudioService.this.mIsRinging || AudioService.this.getMode() == 2 || AudioService.this.getMode() == 3 || AudioService.this.getMode() == 1) {
                        return;
                    }
                }
                object = AudioService.this.mRCStack;
                synchronized (object) {
                    if (!AudioService.this.mRCStack.empty()) {
                        Intent targetedIntent = new Intent("android.intent.action.MEDIA_BUTTON");
                        targetedIntent.putExtras(intent.getExtras());
                        targetedIntent.setComponent(((RemoteControlStackEntry)((AudioService)AudioService.this).mRCStack.peek()).mReceiverComponent);
                        this.abortBroadcast();
                        context.sendBroadcast(targetedIntent, null);
                    }
                }
            }
        }
    }

    private class AudioFocusDeathHandler
    implements IBinder.DeathRecipient {
        private IBinder mCb;

        AudioFocusDeathHandler(IBinder cb) {
            this.mCb = cb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void binderDied() {
            Object object = mAudioFocusLock;
            synchronized (object) {
                Log.w(AudioService.TAG, "  AudioFocus   audio focus client died");
                AudioService.this.removeFocusStackEntryForClient(this.mCb);
            }
        }

        public IBinder getBinder() {
            return this.mCb;
        }
    }

    private static class FocusStackEntry {
        public int mStreamType = -1;
        public boolean mIsTransportControlReceiver = false;
        public IAudioFocusDispatcher mFocusDispatcher = null;
        public IBinder mSourceRef = null;
        public String mClientId;
        public int mFocusChangeType;

        public FocusStackEntry() {
        }

        public FocusStackEntry(int streamType, int duration, boolean isTransportControlReceiver, IAudioFocusDispatcher afl, IBinder source, String id2) {
            this.mStreamType = streamType;
            this.mIsTransportControlReceiver = isTransportControlReceiver;
            this.mFocusDispatcher = afl;
            this.mSourceRef = source;
            this.mClientId = id2;
            this.mFocusChangeType = duration;
        }
    }

    private class AudioServiceBroadcastReceiver
    extends BroadcastReceiver {
        private AudioServiceBroadcastReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.intent.action.DOCK_EVENT")) {
                int config;
                int dockState = intent.getIntExtra("android.intent.extra.DOCK_STATE", 0);
                switch (dockState) {
                    case 1: {
                        config = 7;
                        break;
                    }
                    case 2: {
                        config = 6;
                        break;
                    }
                    default: {
                        config = 0;
                    }
                }
                AudioSystem.setForceUse(3, config);
            } else if (action.equals("android.bluetooth.a2dp.action.SINK_STATE_CHANGED")) {
                boolean isConnected;
                int state = intent.getIntExtra("android.bluetooth.a2dp.extra.SINK_STATE", 0);
                BluetoothDevice btDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                String address = btDevice.getAddress();
                boolean bl = isConnected = AudioService.this.mConnectedDevices.containsKey(128) && ((String)AudioService.this.mConnectedDevices.get(128)).equals(address);
                if (isConnected && state != 2 && state != 4) {
                    if (btDevice.isBluetoothDock()) {
                        if (state == 0) {
                            AudioService.this.makeA2dpDeviceUnavailableLater(address);
                        }
                    } else {
                        AudioService.this.makeA2dpDeviceUnavailableNow(address);
                    }
                } else if (!(isConnected || state != 2 && state != 4)) {
                    if (btDevice.isBluetoothDock()) {
                        AudioService.this.cancelA2dpDeviceTimeout();
                        AudioService.this.mDockAddress = address;
                    } else if (AudioService.this.hasScheduledA2dpDockTimeout()) {
                        AudioService.this.cancelA2dpDeviceTimeout();
                        AudioService.this.makeA2dpDeviceUnavailableNow(AudioService.this.mDockAddress);
                    }
                    AudioService.this.makeA2dpDeviceAvailable(address);
                }
            } else if (action.equals("android.bluetooth.headset.action.STATE_CHANGED")) {
                boolean isConnected;
                int state = intent.getIntExtra("android.bluetooth.headset.extra.STATE", -1);
                int device = 16;
                BluetoothDevice btDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                String address = null;
                if (btDevice != null) {
                    address = btDevice.getAddress();
                    BluetoothClass btClass = btDevice.getBluetoothClass();
                    if (btClass != null) {
                        switch (btClass.getDeviceClass()) {
                            case 1028: 
                            case 1032: {
                                device = 32;
                                break;
                            }
                            case 1056: {
                                device = 64;
                            }
                        }
                    }
                }
                boolean bl = isConnected = AudioService.this.mConnectedDevices.containsKey(device) && ((String)AudioService.this.mConnectedDevices.get(device)).equals(address);
                if (isConnected && state != 2) {
                    AudioSystem.setDeviceConnectionState(device, 0, address);
                    AudioService.this.mConnectedDevices.remove(device);
                    AudioService.this.mBluetoothHeadsetConnected = false;
                    AudioService.this.clearAllScoClients();
                } else if (!isConnected && state == 2) {
                    AudioSystem.setDeviceConnectionState(device, 1, address);
                    AudioService.this.mConnectedDevices.put(new Integer(device), address);
                    AudioService.this.mBluetoothHeadsetConnected = true;
                }
            } else if (action.equals("android.intent.action.HEADSET_PLUG")) {
                int state = intent.getIntExtra("state", 0);
                int microphone = intent.getIntExtra("microphone", 0);
                if (microphone != 0) {
                    boolean isConnected = AudioService.this.mConnectedDevices.containsKey(4);
                    if (state == 0 && isConnected) {
                        AudioSystem.setDeviceConnectionState(4, 0, "");
                        AudioService.this.mConnectedDevices.remove(4);
                    } else if (state == 1 && !isConnected) {
                        AudioSystem.setDeviceConnectionState(4, 1, "");
                        AudioService.this.mConnectedDevices.put(new Integer(4), "");
                    }
                } else {
                    boolean isConnected = AudioService.this.mConnectedDevices.containsKey(8);
                    if (state == 0 && isConnected) {
                        AudioSystem.setDeviceConnectionState(8, 0, "");
                        AudioService.this.mConnectedDevices.remove(8);
                    } else if (state == 1 && !isConnected) {
                        AudioSystem.setDeviceConnectionState(8, 1, "");
                        AudioService.this.mConnectedDevices.put(new Integer(8), "");
                    }
                }
            } else if (action.equals("android.bluetooth.headset.action.AUDIO_STATE_CHANGED")) {
                int state = intent.getIntExtra("android.bluetooth.headset.extra.AUDIO_STATE", -1);
                ArrayList arrayList = AudioService.this.mScoClients;
                synchronized (arrayList) {
                    if (!AudioService.this.mScoClients.isEmpty()) {
                        switch (state) {
                            case 1: {
                                state = 1;
                                break;
                            }
                            case 0: {
                                state = 0;
                                break;
                            }
                            default: {
                                state = -1;
                            }
                        }
                        if (state != -1) {
                            Intent newIntent = new Intent("android.media.SCO_AUDIO_STATE_CHANGED");
                            newIntent.putExtra("android.media.extra.SCO_AUDIO_STATE", state);
                            AudioService.this.mContext.sendStickyBroadcast(newIntent);
                        }
                    }
                }
            }
        }
    }

    private class SettingsObserver
    extends ContentObserver {
        SettingsObserver() {
            super(new Handler());
            AudioService.this.mContentResolver.registerContentObserver(Settings.System.getUriFor("mode_ringer_streams_affected"), false, this);
            AudioService.this.mContentResolver.registerContentObserver(Settings.System.getUriFor("notifications_use_ring_volume"), false, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onChange(boolean selfChange) {
            super.onChange(selfChange);
            Object object = AudioService.this.mSettingsLock;
            synchronized (object) {
                int notificationsUseRingVolume;
                int ringerModeAffectedStreams = Settings.System.getInt(AudioService.this.mContentResolver, "mode_ringer_streams_affected", 0);
                if (ringerModeAffectedStreams != AudioService.this.mRingerModeAffectedStreams) {
                    AudioService.this.mRingerModeAffectedStreams = ringerModeAffectedStreams;
                    AudioService.this.setRingerModeInt(AudioService.this.getRingerMode(), false);
                }
                if ((notificationsUseRingVolume = Settings.System.getInt(AudioService.this.mContentResolver, "notifications_use_ring_volume", 1)) != AudioService.this.mNotificationsUseRingVolume) {
                    AudioService.this.mNotificationsUseRingVolume = notificationsUseRingVolume;
                    if (AudioService.this.mNotificationsUseRingVolume == 1) {
                        ((AudioService)AudioService.this).STREAM_VOLUME_ALIAS[5] = 2;
                        AudioService.this.mStreamStates[5].setVolumeIndexSettingName(Settings.System.VOLUME_SETTINGS[2]);
                    } else {
                        ((AudioService)AudioService.this).STREAM_VOLUME_ALIAS[5] = 5;
                        AudioService.this.mStreamStates[5].setVolumeIndexSettingName(Settings.System.VOLUME_SETTINGS[5]);
                        AudioService.sendMsg(AudioService.this.mAudioHandler, 1, 5, 0, 1, 1, AudioService.this.mStreamStates[5], 0);
                    }
                }
            }
        }
    }

    private class AudioHandler
    extends Handler {
        private AudioHandler() {
        }

        private void setSystemVolume(VolumeStreamState streamState) {
            AudioService.this.setStreamVolumeIndex(streamState.mStreamType, streamState.mIndex);
            int numStreamTypes = AudioSystem.getNumStreamTypes();
            for (int streamType = numStreamTypes - 1; streamType >= 0; --streamType) {
                if (streamType == streamState.mStreamType || AudioService.this.STREAM_VOLUME_ALIAS[streamType] != streamState.mStreamType) continue;
                AudioService.this.setStreamVolumeIndex(streamType, AudioService.this.mStreamStates[streamType].mIndex);
            }
            AudioService.sendMsg(AudioService.this.mAudioHandler, 1, streamState.mStreamType, 0, 1, 1, streamState, 3000);
        }

        private void persistVolume(VolumeStreamState streamState, boolean current, boolean lastAudible) {
            if (current) {
                Settings.System.putInt(AudioService.this.mContentResolver, streamState.mVolumeIndexSettingName, (streamState.mIndex + 5) / 10);
            }
            if (lastAudible) {
                Settings.System.putInt(AudioService.this.mContentResolver, streamState.mLastAudibleVolumeIndexSettingName, (streamState.mLastAudibleIndex + 5) / 10);
            }
        }

        private void persistRingerMode() {
            Settings.System.putInt(AudioService.this.mContentResolver, "mode_ringer", AudioService.this.mRingerMode);
        }

        private void persistVibrateSetting() {
            Settings.System.putInt(AudioService.this.mContentResolver, "vibrate_on", AudioService.this.mVibrateSetting);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void playSoundEffect(int effectType, int volume) {
            Object object = AudioService.this.mSoundEffectsLock;
            synchronized (object) {
                float volFloat;
                if (AudioService.this.mSoundPool == null) {
                    return;
                }
                if (volume < 0) {
                    float dBPerStep = (float)(50.0 / (double)AudioService.this.MAX_STREAM_VOLUME[3]);
                    int musicVolIndex = (AudioService.this.mStreamStates[3].mIndex + 5) / 10;
                    float musicVoldB = dBPerStep * (float)(musicVolIndex - AudioService.this.MAX_STREAM_VOLUME[3]);
                    volFloat = (float)Math.pow(10.0, (musicVoldB - 3.0f) / 20.0f);
                } else {
                    volFloat = (float)volume / 1000.0f;
                }
                if (AudioService.this.SOUND_EFFECT_FILES_MAP[effectType][1] > 0) {
                    AudioService.this.mSoundPool.play(AudioService.this.SOUND_EFFECT_FILES_MAP[effectType][1], volFloat, volFloat, 0, 0, 1.0f);
                } else {
                    MediaPlayer mediaPlayer = new MediaPlayer();
                    if (mediaPlayer != null) {
                        try {
                            String filePath = Environment.getRootDirectory() + AudioService.SOUND_EFFECTS_PATH + SOUND_EFFECT_FILES[AudioService.this.SOUND_EFFECT_FILES_MAP[effectType][0]];
                            mediaPlayer.setDataSource(filePath);
                            mediaPlayer.setAudioStreamType(1);
                            mediaPlayer.prepare();
                            mediaPlayer.setVolume(volFloat, volFloat);
                            mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                                public void onCompletion(MediaPlayer mp) {
                                    AudioHandler.this.cleanupPlayer(mp);
                                }
                            });
                            mediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                                public boolean onError(MediaPlayer mp, int what, int extra) {
                                    AudioHandler.this.cleanupPlayer(mp);
                                    return true;
                                }
                            });
                            mediaPlayer.start();
                        }
                        catch (IOException ex) {
                            Log.w(AudioService.TAG, "MediaPlayer IOException: " + ex);
                        }
                        catch (IllegalArgumentException ex) {
                            Log.w(AudioService.TAG, "MediaPlayer IllegalArgumentException: " + ex);
                        }
                        catch (IllegalStateException ex) {
                            Log.w(AudioService.TAG, "MediaPlayer IllegalStateException: " + ex);
                        }
                    }
                }
            }
        }

        private void cleanupPlayer(MediaPlayer mp) {
            if (mp != null) {
                try {
                    mp.stop();
                    mp.release();
                }
                catch (IllegalStateException ex) {
                    Log.w(AudioService.TAG, "MediaPlayer IllegalStateException: " + ex);
                }
            }
        }

        public void handleMessage(Message msg) {
            int baseMsgWhat = AudioService.getMsgBase(msg.what);
            switch (baseMsgWhat) {
                case 0: {
                    this.setSystemVolume((VolumeStreamState)msg.obj);
                    break;
                }
                case 1: {
                    this.persistVolume((VolumeStreamState)msg.obj, msg.arg1 != 0, msg.arg2 != 0);
                    break;
                }
                case 3: {
                    this.persistRingerMode();
                    break;
                }
                case 4: {
                    this.persistVibrateSetting();
                    break;
                }
                case 5: {
                    if (AudioService.this.mMediaServerOk) break;
                    Log.e(AudioService.TAG, "Media server died.");
                    AudioSystem.isStreamActive(3);
                    AudioService.sendMsg(AudioService.this.mAudioHandler, 5, -1, 1, 0, 0, null, 500);
                    break;
                }
                case 6: {
                    Log.e(AudioService.TAG, "Media server started.");
                    AudioSystem.setParameters("restarting=true");
                    Set set = AudioService.this.mConnectedDevices.entrySet();
                    for (Map.Entry device : set) {
                        AudioSystem.setDeviceConnectionState((Integer)device.getKey(), 1, (String)device.getValue());
                    }
                    AudioSystem.setPhoneState(AudioService.this.mMode);
                    AudioSystem.setForceUse(0, AudioService.this.mForcedUseForComm);
                    AudioSystem.setForceUse(2, AudioService.this.mForcedUseForComm);
                    int numStreamTypes = AudioSystem.getNumStreamTypes();
                    for (int streamType = numStreamTypes - 1; streamType >= 0; --streamType) {
                        VolumeStreamState streamState = AudioService.this.mStreamStates[streamType];
                        AudioSystem.initStreamVolume(streamType, 0, (streamState.mIndexMax + 5) / 10);
                        int index = streamState.muteCount() == 0 ? streamState.mIndex : 0;
                        AudioService.this.setStreamVolumeIndex(streamType, index);
                    }
                    AudioService.this.setRingerModeInt(AudioService.this.getRingerMode(), false);
                    AudioSystem.setParameters("restarting=false");
                    break;
                }
                case 7: {
                    this.playSoundEffect(msg.arg1, msg.arg2);
                    break;
                }
                case 8: {
                    AudioService.this.makeA2dpDeviceUnavailableNow((String)msg.obj);
                }
            }
        }
    }

    private class AudioSystemThread
    extends Thread {
        AudioSystemThread() {
            super(AudioService.TAG);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Looper.prepare();
            AudioService audioService = AudioService.this;
            synchronized (audioService) {
                AudioService.this.mAudioHandler = new AudioHandler();
                AudioService.this.notify();
            }
            Looper.loop();
        }
    }

    public class VolumeStreamState {
        private final int mStreamType;
        private String mVolumeIndexSettingName;
        private String mLastAudibleVolumeIndexSettingName;
        private int mIndexMax;
        private int mIndex;
        private int mLastAudibleIndex;
        private ArrayList<VolumeDeathHandler> mDeathHandlers;

        private VolumeStreamState(String settingName, int streamType) {
            this.setVolumeIndexSettingName(settingName);
            this.mStreamType = streamType;
            ContentResolver cr = AudioService.this.mContentResolver;
            this.mIndexMax = AudioService.this.MAX_STREAM_VOLUME[streamType];
            this.mIndex = Settings.System.getInt(cr, this.mVolumeIndexSettingName, AudioManager.DEFAULT_STREAM_VOLUME[streamType]);
            this.mLastAudibleIndex = Settings.System.getInt(cr, this.mLastAudibleVolumeIndexSettingName, this.mIndex > 0 ? this.mIndex : AudioManager.DEFAULT_STREAM_VOLUME[streamType]);
            AudioSystem.initStreamVolume(streamType, 0, this.mIndexMax);
            this.mIndexMax *= 10;
            this.mIndex = this.getValidIndex(10 * this.mIndex);
            this.mLastAudibleIndex = this.getValidIndex(10 * this.mLastAudibleIndex);
            AudioService.this.setStreamVolumeIndex(streamType, this.mIndex);
            this.mDeathHandlers = new ArrayList();
        }

        public void setVolumeIndexSettingName(String settingName) {
            this.mVolumeIndexSettingName = settingName;
            this.mLastAudibleVolumeIndexSettingName = settingName + "_last_audible";
        }

        public boolean adjustIndex(int deltaIndex) {
            return this.setIndex(this.mIndex + deltaIndex * 10, true);
        }

        public boolean setIndex(int index, boolean lastAudible) {
            int oldIndex = this.mIndex;
            this.mIndex = this.getValidIndex(index);
            if (oldIndex != this.mIndex) {
                if (lastAudible) {
                    this.mLastAudibleIndex = this.mIndex;
                }
                int numStreamTypes = AudioSystem.getNumStreamTypes();
                for (int streamType = numStreamTypes - 1; streamType >= 0; --streamType) {
                    if (streamType == this.mStreamType || AudioService.this.STREAM_VOLUME_ALIAS[streamType] != this.mStreamType) continue;
                    AudioService.this.mStreamStates[streamType].setIndex(AudioService.this.rescaleIndex(this.mIndex, this.mStreamType, streamType), lastAudible);
                }
                return true;
            }
            return false;
        }

        public void setLastAudibleIndex(int index) {
            this.mLastAudibleIndex = this.getValidIndex(index);
        }

        public void adjustLastAudibleIndex(int deltaIndex) {
            this.setLastAudibleIndex(this.mLastAudibleIndex + deltaIndex * 10);
        }

        public int getMaxIndex() {
            return this.mIndexMax;
        }

        public void mute(IBinder cb, boolean state) {
            VolumeDeathHandler handler = this.getDeathHandler(cb, state);
            if (handler == null) {
                Log.e(AudioService.TAG, "Could not get client death handler for stream: " + this.mStreamType);
                return;
            }
            handler.mute(state);
        }

        private int getValidIndex(int index) {
            if (index < 0) {
                return 0;
            }
            if (index > this.mIndexMax) {
                return this.mIndexMax;
            }
            return index;
        }

        private int muteCount() {
            int count = 0;
            int size = this.mDeathHandlers.size();
            for (int i = 0; i < size; ++i) {
                count += this.mDeathHandlers.get(i).mMuteCount;
            }
            return count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private VolumeDeathHandler getDeathHandler(IBinder cb, boolean state) {
            ArrayList<VolumeDeathHandler> arrayList = this.mDeathHandlers;
            synchronized (arrayList) {
                VolumeDeathHandler handler;
                int size = this.mDeathHandlers.size();
                for (int i = 0; i < size; ++i) {
                    handler = this.mDeathHandlers.get(i);
                    if (cb != handler.mICallback) continue;
                    return handler;
                }
                if (state) {
                    handler = new VolumeDeathHandler(cb);
                } else {
                    Log.w(AudioService.TAG, "stream was not muted by this client");
                    handler = null;
                }
                return handler;
            }
        }

        private class VolumeDeathHandler
        implements IBinder.DeathRecipient {
            private IBinder mICallback;
            private int mMuteCount;

            VolumeDeathHandler(IBinder cb) {
                this.mICallback = cb;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public void mute(boolean state) {
                var2_2 = VolumeStreamState.access$1200(VolumeStreamState.this);
                synchronized (var2_2) {
                    if (state) {
                        if (this.mMuteCount == 0) {
                            try {
                                if (this.mICallback != null) {
                                    this.mICallback.linkToDeath(this, 0);
                                }
                                VolumeStreamState.access$1200(VolumeStreamState.this).add(this);
                                if (VolumeStreamState.access$900(VolumeStreamState.this) != 0) ** GOTO lbl22
                                VolumeStreamState.this.setIndex(0, false);
                                AudioService.access$200(AudioService.access$100(AudioService.this), 0, VolumeStreamState.access$2300(VolumeStreamState.this), 1, 0, 0, VolumeStreamState.this, 0);
                            }
                            catch (RemoteException e) {
                                this.binderDied();
                                VolumeStreamState.access$1200(VolumeStreamState.this).notify();
                                return;
                            }
                        } else {
                            Log.w("AudioService", "stream: " + VolumeStreamState.access$2300(VolumeStreamState.this) + " was already muted by this client");
                        }
lbl22:
                        // 3 sources

                        ++this.mMuteCount;
                    } else if (this.mMuteCount == 0) {
                        Log.e("AudioService", "unexpected unmute for stream: " + VolumeStreamState.access$2300(VolumeStreamState.this));
                    } else {
                        --this.mMuteCount;
                        if (this.mMuteCount == 0) {
                            VolumeStreamState.access$1200(VolumeStreamState.this).remove(this);
                            if (this.mICallback != null) {
                                this.mICallback.unlinkToDeath(this, 0);
                            }
                            if (!(VolumeStreamState.access$900(VolumeStreamState.this) != 0 || AudioService.this.isStreamAffectedByRingerMode(VolumeStreamState.access$2300(VolumeStreamState.this)) && AudioService.access$2400(AudioService.this) != 2)) {
                                VolumeStreamState.this.setIndex(VolumeStreamState.access$800(VolumeStreamState.this), false);
                                AudioService.access$200(AudioService.access$100(AudioService.this), 0, VolumeStreamState.access$2300(VolumeStreamState.this), 1, 0, 0, VolumeStreamState.this, 0);
                            }
                        }
                    }
                    VolumeStreamState.access$1200(VolumeStreamState.this).notify();
                }
            }

            public void binderDied() {
                Log.w(AudioService.TAG, "Volume service client died for stream: " + VolumeStreamState.this.mStreamType);
                if (this.mMuteCount != 0) {
                    this.mMuteCount = 1;
                    this.mute(false);
                }
            }
        }
    }

    private class ScoClient
    implements IBinder.DeathRecipient {
        private IBinder mCb;
        private int mStartcount;

        ScoClient(IBinder cb) {
            this.mCb = cb;
            this.mStartcount = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void binderDied() {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                Log.w(AudioService.TAG, "SCO client died");
                int index = AudioService.this.mScoClients.indexOf(this);
                if (index < 0) {
                    Log.w(AudioService.TAG, "unregistered SCO client died");
                } else {
                    this.clearCount(true);
                    AudioService.this.mScoClients.remove(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void incCount() {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                this.requestScoState(1);
                if (this.mStartcount == 0) {
                    try {
                        this.mCb.linkToDeath(this, 0);
                    }
                    catch (RemoteException e) {
                        Log.w(AudioService.TAG, "ScoClient  incCount() could not link to " + this.mCb + " binder death");
                    }
                }
                ++this.mStartcount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void decCount() {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                if (this.mStartcount == 0) {
                    Log.w(AudioService.TAG, "ScoClient.decCount() already 0");
                } else {
                    --this.mStartcount;
                    if (this.mStartcount == 0) {
                        try {
                            this.mCb.unlinkToDeath(this, 0);
                        }
                        catch (NoSuchElementException e) {
                            Log.w(AudioService.TAG, "decCount() going to 0 but not registered to binder");
                        }
                    }
                    this.requestScoState(0);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearCount(boolean stopSco) {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                if (this.mStartcount != 0) {
                    try {
                        this.mCb.unlinkToDeath(this, 0);
                    }
                    catch (NoSuchElementException e) {
                        Log.w(AudioService.TAG, "clearCount() mStartcount: " + this.mStartcount + " != 0 but not registered to binder");
                    }
                }
                this.mStartcount = 0;
                if (stopSco) {
                    this.requestScoState(0);
                }
            }
        }

        public int getCount() {
            return this.mStartcount;
        }

        public IBinder getBinder() {
            return this.mCb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int totalCount() {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                int count = 0;
                int size = AudioService.this.mScoClients.size();
                for (int i = 0; i < size; ++i) {
                    count += ((ScoClient)AudioService.this.mScoClients.get(i)).getCount();
                }
                return count;
            }
        }

        private void requestScoState(int state) {
            if (this.totalCount() == 0 && AudioService.this.mBluetoothHeadsetConnected && AudioService.this.mMode == 0) {
                if (state == 1) {
                    AudioService.this.mBluetoothHeadset.startVoiceRecognition();
                } else {
                    AudioService.this.mBluetoothHeadset.stopVoiceRecognition();
                }
            }
        }
    }

    private class SetModeDeathHandler
    implements IBinder.DeathRecipient {
        private IBinder mCb;
        private int mMode = 0;

        SetModeDeathHandler(IBinder cb) {
            this.mCb = cb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void binderDied() {
            ArrayList arrayList = AudioService.this.mSetModeDeathHandlers;
            synchronized (arrayList) {
                Log.w(AudioService.TAG, "setMode() client died");
                int index = AudioService.this.mSetModeDeathHandlers.indexOf(this);
                if (index < 0) {
                    Log.w(AudioService.TAG, "unregistered setMode() client died");
                } else {
                    AudioService.this.mSetModeDeathHandlers.remove(this);
                    if (index == 0) {
                        SetModeDeathHandler hdlr = (SetModeDeathHandler)AudioService.this.mSetModeDeathHandlers.get(0);
                        int mode = hdlr.getMode();
                        if (AudioService.this.mMode != mode && AudioSystem.setPhoneState(mode) == 0) {
                            AudioService.this.mMode = mode;
                        }
                    }
                }
            }
        }

        public void setMode(int mode) {
            this.mMode = mode;
        }

        public int getMode() {
            return this.mMode;
        }

        public IBinder getBinder() {
            return this.mCb;
        }
    }
}

