/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.ComponentName;
import android.content.Context;
import android.media.AudioSystem;
import android.media.IAudioFocusDispatcher;
import android.media.IAudioService;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.provider.Settings;
import android.util.Log;
import java.util.HashMap;

public class AudioManager {
    private final Context mContext;
    private final Handler mHandler;
    private static String TAG = "AudioManager";
    private static boolean DEBUG = false;
    private static boolean localLOGV = DEBUG;
    public static final String ACTION_AUDIO_BECOMING_NOISY = "android.media.AUDIO_BECOMING_NOISY";
    public static final String RINGER_MODE_CHANGED_ACTION = "android.media.RINGER_MODE_CHANGED";
    public static final String EXTRA_RINGER_MODE = "android.media.EXTRA_RINGER_MODE";
    public static final String VIBRATE_SETTING_CHANGED_ACTION = "android.media.VIBRATE_SETTING_CHANGED";
    public static final String VOLUME_CHANGED_ACTION = "android.media.VOLUME_CHANGED_ACTION";
    public static final String EXTRA_VIBRATE_SETTING = "android.media.EXTRA_VIBRATE_SETTING";
    public static final String EXTRA_VIBRATE_TYPE = "android.media.EXTRA_VIBRATE_TYPE";
    public static final String EXTRA_VOLUME_STREAM_TYPE = "android.media.EXTRA_VOLUME_STREAM_TYPE";
    public static final String EXTRA_VOLUME_STREAM_VALUE = "android.media.EXTRA_VOLUME_STREAM_VALUE";
    public static final String EXTRA_PREV_VOLUME_STREAM_VALUE = "android.media.EXTRA_PREV_VOLUME_STREAM_VALUE";
    public static final int STREAM_VOICE_CALL = 0;
    public static final int STREAM_SYSTEM = 1;
    public static final int STREAM_RING = 2;
    public static final int STREAM_MUSIC = 3;
    public static final int STREAM_ALARM = 4;
    public static final int STREAM_NOTIFICATION = 5;
    public static final int STREAM_BLUETOOTH_SCO = 6;
    public static final int STREAM_SYSTEM_ENFORCED = 7;
    public static final int STREAM_DTMF = 8;
    public static final int STREAM_TTS = 9;
    @Deprecated
    public static final int NUM_STREAMS = 5;
    public static final int[] DEFAULT_STREAM_VOLUME = new int[]{4, 7, 5, 11, 6, 5, 7, 7, 11, 11};
    public static final int ADJUST_RAISE = 1;
    public static final int ADJUST_LOWER = -1;
    public static final int ADJUST_SAME = 0;
    public static final int FLAG_SHOW_UI = 1;
    public static final int FLAG_ALLOW_RINGER_MODES = 2;
    public static final int FLAG_PLAY_SOUND = 4;
    public static final int FLAG_REMOVE_SOUND_AND_VIBRATE = 8;
    public static final int FLAG_VIBRATE = 16;
    public static final int RINGER_MODE_SILENT = 0;
    public static final int RINGER_MODE_VIBRATE = 1;
    public static final int RINGER_MODE_NORMAL = 2;
    public static final int VIBRATE_TYPE_RINGER = 0;
    public static final int VIBRATE_TYPE_NOTIFICATION = 1;
    public static final int VIBRATE_SETTING_OFF = 0;
    public static final int VIBRATE_SETTING_ON = 1;
    public static final int VIBRATE_SETTING_ONLY_SILENT = 2;
    public static final int USE_DEFAULT_STREAM_TYPE = Integer.MIN_VALUE;
    private static IAudioService sService;
    public static final String ACTION_SCO_AUDIO_STATE_CHANGED = "android.media.SCO_AUDIO_STATE_CHANGED";
    public static final String EXTRA_SCO_AUDIO_STATE = "android.media.extra.SCO_AUDIO_STATE";
    public static final int SCO_AUDIO_STATE_DISCONNECTED = 0;
    public static final int SCO_AUDIO_STATE_CONNECTED = 1;
    public static final int SCO_AUDIO_STATE_ERROR = -1;
    public static final int MODE_INVALID = -2;
    public static final int MODE_CURRENT = -1;
    public static final int MODE_NORMAL = 0;
    public static final int MODE_RINGTONE = 1;
    public static final int MODE_IN_CALL = 2;
    public static final int MODE_IN_COMMUNICATION = 3;
    @Deprecated
    public static final int ROUTE_EARPIECE = 1;
    @Deprecated
    public static final int ROUTE_SPEAKER = 2;
    @Deprecated
    public static final int ROUTE_BLUETOOTH = 4;
    @Deprecated
    public static final int ROUTE_BLUETOOTH_SCO = 4;
    @Deprecated
    public static final int ROUTE_HEADSET = 8;
    @Deprecated
    public static final int ROUTE_BLUETOOTH_A2DP = 16;
    @Deprecated
    public static final int ROUTE_ALL = -1;
    public static final int FX_KEY_CLICK = 0;
    public static final int FX_FOCUS_NAVIGATION_UP = 1;
    public static final int FX_FOCUS_NAVIGATION_DOWN = 2;
    public static final int FX_FOCUS_NAVIGATION_LEFT = 3;
    public static final int FX_FOCUS_NAVIGATION_RIGHT = 4;
    public static final int FX_KEYPRESS_STANDARD = 5;
    public static final int FX_KEYPRESS_SPACEBAR = 6;
    public static final int FX_KEYPRESS_DELETE = 7;
    public static final int FX_KEYPRESS_RETURN = 8;
    public static final int NUM_SOUND_EFFECTS = 9;
    public static final int AUDIOFOCUS_GAIN = 1;
    public static final int AUDIOFOCUS_GAIN_TRANSIENT = 2;
    public static final int AUDIOFOCUS_GAIN_TRANSIENT_MAY_DUCK = 3;
    public static final int AUDIOFOCUS_LOSS = -1;
    public static final int AUDIOFOCUS_LOSS_TRANSIENT = -2;
    public static final int AUDIOFOCUS_LOSS_TRANSIENT_CAN_DUCK = -3;
    private HashMap<String, OnAudioFocusChangeListener> mAudioFocusIdListenerMap = new HashMap();
    private final Object mFocusListenerLock = new Object();
    private FocusEventHandlerDelegate mAudioFocusEventHandlerDelegate = new FocusEventHandlerDelegate();
    private IAudioFocusDispatcher mAudioFocusDispatcher = new IAudioFocusDispatcher.Stub(){

        public void dispatchAudioFocusChange(int focusChange, String id2) {
            Message m = AudioManager.this.mAudioFocusEventHandlerDelegate.getHandler().obtainMessage(focusChange, id2);
            AudioManager.this.mAudioFocusEventHandlerDelegate.getHandler().sendMessage(m);
        }
    };
    public static final int AUDIOFOCUS_REQUEST_FAILED = 0;
    public static final int AUDIOFOCUS_REQUEST_GRANTED = 1;
    private IBinder mICallBack = new Binder();

    public AudioManager(Context context) {
        this.mContext = context;
        this.mHandler = new Handler(context.getMainLooper());
    }

    private static IAudioService getService() {
        if (sService != null) {
            return sService;
        }
        IBinder b = ServiceManager.getService("audio");
        sService = IAudioService.Stub.asInterface(b);
        return sService;
    }

    public void adjustStreamVolume(int streamType, int direction, int flags) {
        IAudioService service = AudioManager.getService();
        try {
            service.adjustStreamVolume(streamType, direction, flags);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in adjustStreamVolume", e);
        }
    }

    public void adjustVolume(int direction, int flags) {
        IAudioService service = AudioManager.getService();
        try {
            service.adjustVolume(direction, flags);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in adjustVolume", e);
        }
    }

    public void adjustSuggestedStreamVolume(int direction, int suggestedStreamType, int flags) {
        IAudioService service = AudioManager.getService();
        try {
            service.adjustSuggestedStreamVolume(direction, suggestedStreamType, flags);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in adjustVolume", e);
        }
    }

    public int getRingerMode() {
        IAudioService service = AudioManager.getService();
        try {
            return service.getRingerMode();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in getRingerMode", e);
            return 2;
        }
    }

    public int getStreamMaxVolume(int streamType) {
        IAudioService service = AudioManager.getService();
        try {
            return service.getStreamMaxVolume(streamType);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in getStreamMaxVolume", e);
            return 0;
        }
    }

    public int getStreamVolume(int streamType) {
        IAudioService service = AudioManager.getService();
        try {
            return service.getStreamVolume(streamType);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in getStreamVolume", e);
            return 0;
        }
    }

    public void setRingerMode(int ringerMode) {
        IAudioService service = AudioManager.getService();
        try {
            service.setRingerMode(ringerMode);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in setRingerMode", e);
        }
    }

    public void setStreamVolume(int streamType, int index, int flags) {
        IAudioService service = AudioManager.getService();
        try {
            service.setStreamVolume(streamType, index, flags);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in setStreamVolume", e);
        }
    }

    public void setStreamSolo(int streamType, boolean state) {
        IAudioService service = AudioManager.getService();
        try {
            service.setStreamSolo(streamType, state, this.mICallBack);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in setStreamSolo", e);
        }
    }

    public void setStreamMute(int streamType, boolean state) {
        IAudioService service = AudioManager.getService();
        try {
            service.setStreamMute(streamType, state, this.mICallBack);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in setStreamMute", e);
        }
    }

    public boolean shouldVibrate(int vibrateType) {
        IAudioService service = AudioManager.getService();
        try {
            return service.shouldVibrate(vibrateType);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in shouldVibrate", e);
            return false;
        }
    }

    public int getVibrateSetting(int vibrateType) {
        IAudioService service = AudioManager.getService();
        try {
            return service.getVibrateSetting(vibrateType);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in getVibrateSetting", e);
            return 0;
        }
    }

    public void setVibrateSetting(int vibrateType, int vibrateSetting) {
        IAudioService service = AudioManager.getService();
        try {
            service.setVibrateSetting(vibrateType, vibrateSetting);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in setVibrateSetting", e);
        }
    }

    public void setSpeakerphoneOn(boolean on) {
        IAudioService service = AudioManager.getService();
        try {
            service.setSpeakerphoneOn(on);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in setSpeakerphoneOn", e);
        }
    }

    public boolean isSpeakerphoneOn() {
        IAudioService service = AudioManager.getService();
        try {
            return service.isSpeakerphoneOn();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in isSpeakerphoneOn", e);
            return false;
        }
    }

    public boolean isBluetoothScoAvailableOffCall() {
        return this.mContext.getResources().getBoolean(0x10D0011);
    }

    public void startBluetoothSco() {
        IAudioService service = AudioManager.getService();
        try {
            service.startBluetoothSco(this.mICallBack);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in startBluetoothSco", e);
        }
    }

    public void stopBluetoothSco() {
        IAudioService service = AudioManager.getService();
        try {
            service.stopBluetoothSco(this.mICallBack);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in stopBluetoothSco", e);
        }
    }

    public void setBluetoothScoOn(boolean on) {
        IAudioService service = AudioManager.getService();
        try {
            service.setBluetoothScoOn(on);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in setBluetoothScoOn", e);
        }
    }

    public boolean isBluetoothScoOn() {
        IAudioService service = AudioManager.getService();
        try {
            return service.isBluetoothScoOn();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in isBluetoothScoOn", e);
            return false;
        }
    }

    @Deprecated
    public void setBluetoothA2dpOn(boolean on) {
    }

    public boolean isBluetoothA2dpOn() {
        return AudioSystem.getDeviceConnectionState(128, "") != 0;
    }

    @Deprecated
    public void setWiredHeadsetOn(boolean on) {
    }

    public boolean isWiredHeadsetOn() {
        return AudioSystem.getDeviceConnectionState(4, "") != 0 || AudioSystem.getDeviceConnectionState(8, "") != 0;
    }

    public void setMicrophoneMute(boolean on) {
        AudioSystem.muteMicrophone(on);
    }

    public boolean isMicrophoneMute() {
        return AudioSystem.isMicrophoneMuted();
    }

    public void setMode(int mode) {
        IAudioService service = AudioManager.getService();
        try {
            service.setMode(mode, this.mICallBack);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in setMode", e);
        }
    }

    public int getMode() {
        IAudioService service = AudioManager.getService();
        try {
            return service.getMode();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in getMode", e);
            return -2;
        }
    }

    @Deprecated
    public void setRouting(int mode, int routes, int mask) {
    }

    @Deprecated
    public int getRouting(int mode) {
        return -1;
    }

    public boolean isMusicActive() {
        return AudioSystem.isStreamActive(3);
    }

    @Deprecated
    public void setParameter(String key, String value) {
        this.setParameters(key + "=" + value);
    }

    public void setParameters(String keyValuePairs) {
        AudioSystem.setParameters(keyValuePairs);
    }

    public String getParameters(String keys) {
        return AudioSystem.getParameters(keys);
    }

    public void playSoundEffect(int effectType) {
        if (effectType < 0 || effectType >= 9) {
            return;
        }
        if (!this.querySoundEffectsEnabled()) {
            return;
        }
        IAudioService service = AudioManager.getService();
        try {
            service.playSoundEffect(effectType);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in playSoundEffect" + e);
        }
    }

    public void playSoundEffect(int effectType, float volume) {
        if (effectType < 0 || effectType >= 9) {
            return;
        }
        IAudioService service = AudioManager.getService();
        try {
            service.playSoundEffectVolume(effectType, volume);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in playSoundEffect" + e);
        }
    }

    private boolean querySoundEffectsEnabled() {
        return Settings.System.getInt(this.mContext.getContentResolver(), "sound_effects_enabled", 0) != 0;
    }

    public void loadSoundEffects() {
        IAudioService service = AudioManager.getService();
        try {
            service.loadSoundEffects();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in loadSoundEffects" + e);
        }
    }

    public void unloadSoundEffects() {
        IAudioService service = AudioManager.getService();
        try {
            service.unloadSoundEffects();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in unloadSoundEffects" + e);
        }
    }

    private OnAudioFocusChangeListener findFocusListener(String id2) {
        return this.mAudioFocusIdListenerMap.get(id2);
    }

    private String getIdForAudioFocusListener(OnAudioFocusChangeListener l) {
        if (l == null) {
            return new String(this.toString());
        }
        return new String(this.toString() + l.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAudioFocusListener(OnAudioFocusChangeListener l) {
        Object object = this.mFocusListenerLock;
        synchronized (object) {
            if (this.mAudioFocusIdListenerMap.containsKey(this.getIdForAudioFocusListener(l))) {
                return;
            }
            this.mAudioFocusIdListenerMap.put(this.getIdForAudioFocusListener(l), l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAudioFocusListener(OnAudioFocusChangeListener l) {
        Object object = this.mFocusListenerLock;
        synchronized (object) {
            this.mAudioFocusIdListenerMap.remove(this.getIdForAudioFocusListener(l));
        }
    }

    public int requestAudioFocus(OnAudioFocusChangeListener l, int streamType, int durationHint) {
        int status = 0;
        if (durationHint < 1 || durationHint > 3) {
            Log.e(TAG, "Invalid duration hint, audio focus request denied");
            return status;
        }
        this.registerAudioFocusListener(l);
        IAudioService service = AudioManager.getService();
        try {
            status = service.requestAudioFocus(streamType, durationHint, this.mICallBack, this.mAudioFocusDispatcher, this.getIdForAudioFocusListener(l));
        }
        catch (RemoteException e) {
            Log.e(TAG, "Can't call requestAudioFocus() from AudioService due to " + e);
        }
        return status;
    }

    public int abandonAudioFocus(OnAudioFocusChangeListener l) {
        int status = 0;
        this.unregisterAudioFocusListener(l);
        IAudioService service = AudioManager.getService();
        try {
            status = service.abandonAudioFocus(this.mAudioFocusDispatcher, this.getIdForAudioFocusListener(l));
        }
        catch (RemoteException e) {
            Log.e(TAG, "Can't call abandonAudioFocus() from AudioService due to " + e);
        }
        return status;
    }

    public void registerMediaButtonEventReceiver(ComponentName eventReceiver) {
        IAudioService service = AudioManager.getService();
        try {
            service.registerMediaButtonEventReceiver(eventReceiver);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in registerMediaButtonEventReceiver" + e);
        }
    }

    public void unregisterMediaButtonEventReceiver(ComponentName eventReceiver) {
        IAudioService service = AudioManager.getService();
        try {
            service.unregisterMediaButtonEventReceiver(eventReceiver);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in unregisterMediaButtonEventReceiver" + e);
        }
    }

    public void reloadAudioSettings() {
        IAudioService service = AudioManager.getService();
        try {
            service.reloadAudioSettings();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in reloadAudioSettings" + e);
        }
    }

    private class FocusEventHandlerDelegate {
        private final Handler mHandler;

        FocusEventHandlerDelegate() {
            Looper looper = Looper.myLooper();
            if (looper == null) {
                looper = Looper.getMainLooper();
            }
            this.mHandler = looper != null ? new Handler(looper){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handleMessage(Message msg) {
                    OnAudioFocusChangeListener listener = null;
                    Object object = AudioManager.this.mFocusListenerLock;
                    synchronized (object) {
                        listener = AudioManager.this.findFocusListener((String)msg.obj);
                    }
                    if (listener != null) {
                        listener.onAudioFocusChange(msg.what);
                    }
                }
            } : null;
        }

        Handler getHandler() {
            return this.mHandler;
        }
    }

    public static interface OnAudioFocusChangeListener {
        public void onAudioFocusChange(int var1);
    }
}

