/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Matrix;
import android.graphics.RectF;

public class Path {
    private static final FillType[] sFillTypeArray = new FillType[]{FillType.WINDING, FillType.EVEN_ODD, FillType.INVERSE_WINDING, FillType.INVERSE_EVEN_ODD};
    private final int mNativePath;

    public Path() {
        this.mNativePath = Path.init1();
    }

    public Path(Path src) {
        int valNative = 0;
        if (src != null) {
            valNative = src.mNativePath;
        }
        this.mNativePath = Path.init2(valNative);
    }

    public void reset() {
        Path.native_reset(this.mNativePath);
    }

    public void rewind() {
        Path.native_rewind(this.mNativePath);
    }

    public void set(Path src) {
        if (this != src) {
            Path.native_set(this.mNativePath, src.mNativePath);
        }
    }

    public FillType getFillType() {
        return sFillTypeArray[Path.native_getFillType(this.mNativePath)];
    }

    public void setFillType(FillType ft) {
        Path.native_setFillType(this.mNativePath, ft.nativeInt);
    }

    public boolean isInverseFillType() {
        int ft = Path.native_getFillType(this.mNativePath);
        return (ft & 2) != 0;
    }

    public void toggleInverseFillType() {
        int ft = Path.native_getFillType(this.mNativePath);
        Path.native_setFillType(this.mNativePath, ft ^= 2);
    }

    public boolean isEmpty() {
        return Path.native_isEmpty(this.mNativePath);
    }

    public boolean isRect(RectF rect) {
        return Path.native_isRect(this.mNativePath, rect);
    }

    public void computeBounds(RectF bounds, boolean exact) {
        Path.native_computeBounds(this.mNativePath, bounds);
    }

    public void incReserve(int extraPtCount) {
        Path.native_incReserve(this.mNativePath, extraPtCount);
    }

    public void moveTo(float x, float y) {
        Path.native_moveTo(this.mNativePath, x, y);
    }

    public void rMoveTo(float dx, float dy) {
        Path.native_rMoveTo(this.mNativePath, dx, dy);
    }

    public void lineTo(float x, float y) {
        Path.native_lineTo(this.mNativePath, x, y);
    }

    public void rLineTo(float dx, float dy) {
        Path.native_rLineTo(this.mNativePath, dx, dy);
    }

    public void quadTo(float x1, float y1, float x2, float y2) {
        Path.native_quadTo(this.mNativePath, x1, y1, x2, y2);
    }

    public void rQuadTo(float dx1, float dy1, float dx2, float dy2) {
        Path.native_rQuadTo(this.mNativePath, dx1, dy1, dx2, dy2);
    }

    public void cubicTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        Path.native_cubicTo(this.mNativePath, x1, y1, x2, y2, x3, y3);
    }

    public void rCubicTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        Path.native_rCubicTo(this.mNativePath, x1, y1, x2, y2, x3, y3);
    }

    public void arcTo(RectF oval, float startAngle, float sweepAngle, boolean forceMoveTo) {
        Path.native_arcTo(this.mNativePath, oval, startAngle, sweepAngle, forceMoveTo);
    }

    public void arcTo(RectF oval, float startAngle, float sweepAngle) {
        Path.native_arcTo(this.mNativePath, oval, startAngle, sweepAngle, false);
    }

    public void close() {
        Path.native_close(this.mNativePath);
    }

    public void addRect(RectF rect, Direction dir) {
        if (rect == null) {
            throw new NullPointerException("need rect parameter");
        }
        Path.native_addRect(this.mNativePath, rect, dir.nativeInt);
    }

    public void addRect(float left, float top, float right, float bottom, Direction dir) {
        Path.native_addRect(this.mNativePath, left, top, right, bottom, dir.nativeInt);
    }

    public void addOval(RectF oval, Direction dir) {
        if (oval == null) {
            throw new NullPointerException("need oval parameter");
        }
        Path.native_addOval(this.mNativePath, oval, dir.nativeInt);
    }

    public void addCircle(float x, float y, float radius, Direction dir) {
        Path.native_addCircle(this.mNativePath, x, y, radius, dir.nativeInt);
    }

    public void addArc(RectF oval, float startAngle, float sweepAngle) {
        if (oval == null) {
            throw new NullPointerException("need oval parameter");
        }
        Path.native_addArc(this.mNativePath, oval, startAngle, sweepAngle);
    }

    public void addRoundRect(RectF rect, float rx, float ry, Direction dir) {
        if (rect == null) {
            throw new NullPointerException("need rect parameter");
        }
        Path.native_addRoundRect(this.mNativePath, rect, rx, ry, dir.nativeInt);
    }

    public void addRoundRect(RectF rect, float[] radii, Direction dir) {
        if (rect == null) {
            throw new NullPointerException("need rect parameter");
        }
        if (radii.length < 8) {
            throw new ArrayIndexOutOfBoundsException("radii[] needs 8 values");
        }
        Path.native_addRoundRect(this.mNativePath, rect, radii, dir.nativeInt);
    }

    public void addPath(Path src, float dx, float dy) {
        Path.native_addPath(this.mNativePath, src.mNativePath, dx, dy);
    }

    public void addPath(Path src) {
        Path.native_addPath(this.mNativePath, src.mNativePath);
    }

    public void addPath(Path src, Matrix matrix) {
        Path.native_addPath(this.mNativePath, src.mNativePath, matrix.native_instance);
    }

    public void offset(float dx, float dy, Path dst) {
        int dstNative = 0;
        if (dst != null) {
            dstNative = dst.mNativePath;
        }
        Path.native_offset(this.mNativePath, dx, dy, dstNative);
    }

    public void offset(float dx, float dy) {
        Path.native_offset(this.mNativePath, dx, dy);
    }

    public void setLastPoint(float dx, float dy) {
        Path.native_setLastPoint(this.mNativePath, dx, dy);
    }

    public void transform(Matrix matrix, Path dst) {
        int dstNative = 0;
        if (dst != null) {
            dstNative = dst.mNativePath;
        }
        Path.native_transform(this.mNativePath, matrix.native_instance, dstNative);
    }

    public void transform(Matrix matrix) {
        Path.native_transform(this.mNativePath, matrix.native_instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            Path.finalizer(this.mNativePath);
        }
        finally {
            super.finalize();
        }
    }

    final int ni() {
        return this.mNativePath;
    }

    private static native int init1();

    private static native int init2(int var0);

    private static native void native_reset(int var0);

    private static native void native_rewind(int var0);

    private static native void native_set(int var0, int var1);

    private static native int native_getFillType(int var0);

    private static native void native_setFillType(int var0, int var1);

    private static native boolean native_isEmpty(int var0);

    private static native boolean native_isRect(int var0, RectF var1);

    private static native void native_computeBounds(int var0, RectF var1);

    private static native void native_incReserve(int var0, int var1);

    private static native void native_moveTo(int var0, float var1, float var2);

    private static native void native_rMoveTo(int var0, float var1, float var2);

    private static native void native_lineTo(int var0, float var1, float var2);

    private static native void native_rLineTo(int var0, float var1, float var2);

    private static native void native_quadTo(int var0, float var1, float var2, float var3, float var4);

    private static native void native_rQuadTo(int var0, float var1, float var2, float var3, float var4);

    private static native void native_cubicTo(int var0, float var1, float var2, float var3, float var4, float var5, float var6);

    private static native void native_rCubicTo(int var0, float var1, float var2, float var3, float var4, float var5, float var6);

    private static native void native_arcTo(int var0, RectF var1, float var2, float var3, boolean var4);

    private static native void native_close(int var0);

    private static native void native_addRect(int var0, RectF var1, int var2);

    private static native void native_addRect(int var0, float var1, float var2, float var3, float var4, int var5);

    private static native void native_addOval(int var0, RectF var1, int var2);

    private static native void native_addCircle(int var0, float var1, float var2, float var3, int var4);

    private static native void native_addArc(int var0, RectF var1, float var2, float var3);

    private static native void native_addRoundRect(int var0, RectF var1, float var2, float var3, int var4);

    private static native void native_addRoundRect(int var0, RectF var1, float[] var2, int var3);

    private static native void native_addPath(int var0, int var1, float var2, float var3);

    private static native void native_addPath(int var0, int var1);

    private static native void native_addPath(int var0, int var1, int var2);

    private static native void native_offset(int var0, float var1, float var2, int var3);

    private static native void native_offset(int var0, float var1, float var2);

    private static native void native_setLastPoint(int var0, float var1, float var2);

    private static native void native_transform(int var0, int var1, int var2);

    private static native void native_transform(int var0, int var1);

    private static native void finalizer(int var0);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        CW(0),
        CCW(1);

        final int nativeInt;

        private Direction(int ni) {
            this.nativeInt = ni;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FillType {
        WINDING(0),
        EVEN_ODD(1),
        INVERSE_WINDING(2),
        INVERSE_EVEN_ODD(3);

        final int nativeInt;

        private FillType(int ni) {
            this.nativeInt = ni;
        }
    }
}

