/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.ColorFilter;
import android.graphics.MaskFilter;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rasterizer;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.TemporaryBuffer;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.text.GraphicsOperations;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextUtils;

public class Paint {
    int mNativePaint;
    private ColorFilter mColorFilter;
    private MaskFilter mMaskFilter;
    private PathEffect mPathEffect;
    private Rasterizer mRasterizer;
    private Shader mShader;
    private Typeface mTypeface;
    private Xfermode mXfermode;
    private boolean mHasCompatScaling;
    private float mCompatScaling;
    private float mInvCompatScaling;
    private static final Style[] sStyleArray = new Style[]{Style.FILL, Style.STROKE, Style.FILL_AND_STROKE};
    private static final Cap[] sCapArray = new Cap[]{Cap.BUTT, Cap.ROUND, Cap.SQUARE};
    private static final Join[] sJoinArray = new Join[]{Join.MITER, Join.ROUND, Join.BEVEL};
    private static final Align[] sAlignArray = new Align[]{Align.LEFT, Align.CENTER, Align.RIGHT};
    public static final int ANTI_ALIAS_FLAG = 1;
    public static final int FILTER_BITMAP_FLAG = 2;
    public static final int DITHER_FLAG = 4;
    public static final int UNDERLINE_TEXT_FLAG = 8;
    public static final int STRIKE_THRU_TEXT_FLAG = 16;
    public static final int FAKE_BOLD_TEXT_FLAG = 32;
    public static final int LINEAR_TEXT_FLAG = 64;
    public static final int SUBPIXEL_TEXT_FLAG = 128;
    public static final int DEV_KERN_TEXT_FLAG = 256;
    private static final int DEFAULT_PAINT_FLAGS = 256;

    public Paint() {
        this(0);
    }

    public Paint(int flags) {
        this.mNativePaint = Paint.native_init();
        this.setFlags(flags | 0x100);
        this.mInvCompatScaling = 1.0f;
        this.mCompatScaling = 1.0f;
    }

    public Paint(Paint paint) {
        this.mNativePaint = Paint.native_initWithPaint(paint.mNativePaint);
        this.mHasCompatScaling = paint.mHasCompatScaling;
        this.mCompatScaling = paint.mCompatScaling;
        this.mInvCompatScaling = paint.mInvCompatScaling;
    }

    public void reset() {
        Paint.native_reset(this.mNativePaint);
        this.setFlags(256);
        this.mHasCompatScaling = false;
        this.mInvCompatScaling = 1.0f;
        this.mCompatScaling = 1.0f;
    }

    public void set(Paint src) {
        if (this != src) {
            Paint.native_set(this.mNativePaint, src.mNativePaint);
            this.mColorFilter = src.mColorFilter;
            this.mMaskFilter = src.mMaskFilter;
            this.mPathEffect = src.mPathEffect;
            this.mRasterizer = src.mRasterizer;
            this.mShader = src.mShader;
            this.mTypeface = src.mTypeface;
            this.mXfermode = src.mXfermode;
            this.mHasCompatScaling = src.mHasCompatScaling;
            this.mCompatScaling = src.mCompatScaling;
            this.mInvCompatScaling = src.mInvCompatScaling;
        }
    }

    public void setCompatibilityScaling(float factor) {
        if ((double)factor == 1.0) {
            this.mHasCompatScaling = false;
            this.mInvCompatScaling = 1.0f;
            this.mCompatScaling = 1.0f;
        } else {
            this.mHasCompatScaling = true;
            this.mCompatScaling = factor;
            this.mInvCompatScaling = 1.0f / factor;
        }
    }

    public native int getFlags();

    public native void setFlags(int var1);

    public final boolean isAntiAlias() {
        return (this.getFlags() & 1) != 0;
    }

    public native void setAntiAlias(boolean var1);

    public final boolean isDither() {
        return (this.getFlags() & 4) != 0;
    }

    public native void setDither(boolean var1);

    public final boolean isLinearText() {
        return (this.getFlags() & 0x40) != 0;
    }

    public native void setLinearText(boolean var1);

    public final boolean isSubpixelText() {
        return (this.getFlags() & 0x80) != 0;
    }

    public native void setSubpixelText(boolean var1);

    public final boolean isUnderlineText() {
        return (this.getFlags() & 8) != 0;
    }

    public native void setUnderlineText(boolean var1);

    public final boolean isStrikeThruText() {
        return (this.getFlags() & 0x10) != 0;
    }

    public native void setStrikeThruText(boolean var1);

    public final boolean isFakeBoldText() {
        return (this.getFlags() & 0x20) != 0;
    }

    public native void setFakeBoldText(boolean var1);

    public final boolean isFilterBitmap() {
        return (this.getFlags() & 2) != 0;
    }

    public native void setFilterBitmap(boolean var1);

    public Style getStyle() {
        return sStyleArray[Paint.native_getStyle(this.mNativePaint)];
    }

    public void setStyle(Style style2) {
        Paint.native_setStyle(this.mNativePaint, style2.nativeInt);
    }

    public native int getColor();

    public native void setColor(int var1);

    public native int getAlpha();

    public native void setAlpha(int var1);

    public void setARGB(int a, int r, int g, int b) {
        this.setColor(a << 24 | r << 16 | g << 8 | b);
    }

    public native float getStrokeWidth();

    public native void setStrokeWidth(float var1);

    public native float getStrokeMiter();

    public native void setStrokeMiter(float var1);

    public Cap getStrokeCap() {
        return sCapArray[Paint.native_getStrokeCap(this.mNativePaint)];
    }

    public void setStrokeCap(Cap cap) {
        Paint.native_setStrokeCap(this.mNativePaint, cap.nativeInt);
    }

    public Join getStrokeJoin() {
        return sJoinArray[Paint.native_getStrokeJoin(this.mNativePaint)];
    }

    public void setStrokeJoin(Join join) {
        Paint.native_setStrokeJoin(this.mNativePaint, join.nativeInt);
    }

    public boolean getFillPath(Path src, Path dst) {
        return Paint.native_getFillPath(this.mNativePaint, src.ni(), dst.ni());
    }

    public Shader getShader() {
        return this.mShader;
    }

    public Shader setShader(Shader shader) {
        int shaderNative = 0;
        if (shader != null) {
            shaderNative = shader.native_instance;
        }
        Paint.native_setShader(this.mNativePaint, shaderNative);
        this.mShader = shader;
        return shader;
    }

    public ColorFilter getColorFilter() {
        return this.mColorFilter;
    }

    public ColorFilter setColorFilter(ColorFilter filter) {
        int filterNative = 0;
        if (filter != null) {
            filterNative = filter.native_instance;
        }
        Paint.native_setColorFilter(this.mNativePaint, filterNative);
        this.mColorFilter = filter;
        return filter;
    }

    public Xfermode getXfermode() {
        return this.mXfermode;
    }

    public Xfermode setXfermode(Xfermode xfermode) {
        int xfermodeNative = 0;
        if (xfermode != null) {
            xfermodeNative = xfermode.native_instance;
        }
        Paint.native_setXfermode(this.mNativePaint, xfermodeNative);
        this.mXfermode = xfermode;
        return xfermode;
    }

    public PathEffect getPathEffect() {
        return this.mPathEffect;
    }

    public PathEffect setPathEffect(PathEffect effect) {
        int effectNative = 0;
        if (effect != null) {
            effectNative = effect.native_instance;
        }
        Paint.native_setPathEffect(this.mNativePaint, effectNative);
        this.mPathEffect = effect;
        return effect;
    }

    public MaskFilter getMaskFilter() {
        return this.mMaskFilter;
    }

    public MaskFilter setMaskFilter(MaskFilter maskfilter) {
        int maskfilterNative = 0;
        if (maskfilter != null) {
            maskfilterNative = maskfilter.native_instance;
        }
        Paint.native_setMaskFilter(this.mNativePaint, maskfilterNative);
        this.mMaskFilter = maskfilter;
        return maskfilter;
    }

    public Typeface getTypeface() {
        return this.mTypeface;
    }

    public Typeface setTypeface(Typeface typeface) {
        int typefaceNative = 0;
        if (typeface != null) {
            typefaceNative = typeface.native_instance;
        }
        Paint.native_setTypeface(this.mNativePaint, typefaceNative);
        this.mTypeface = typeface;
        return typeface;
    }

    public Rasterizer getRasterizer() {
        return this.mRasterizer;
    }

    public Rasterizer setRasterizer(Rasterizer rasterizer) {
        int rasterizerNative = 0;
        if (rasterizer != null) {
            rasterizerNative = rasterizer.native_instance;
        }
        Paint.native_setRasterizer(this.mNativePaint, rasterizerNative);
        this.mRasterizer = rasterizer;
        return rasterizer;
    }

    public native void setShadowLayer(float var1, float var2, float var3, int var4);

    public void clearShadowLayer() {
        this.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
    }

    public Align getTextAlign() {
        return sAlignArray[Paint.native_getTextAlign(this.mNativePaint)];
    }

    public void setTextAlign(Align align) {
        Paint.native_setTextAlign(this.mNativePaint, align.nativeInt);
    }

    public native float getTextSize();

    public native void setTextSize(float var1);

    public native float getTextScaleX();

    public native void setTextScaleX(float var1);

    public native float getTextSkewX();

    public native void setTextSkewX(float var1);

    public native float ascent();

    public native float descent();

    public native float getFontMetrics(FontMetrics var1);

    public FontMetrics getFontMetrics() {
        FontMetrics fm = new FontMetrics();
        this.getFontMetrics(fm);
        return fm;
    }

    public native int getFontMetricsInt(FontMetricsInt var1);

    public FontMetricsInt getFontMetricsInt() {
        FontMetricsInt fm = new FontMetricsInt();
        this.getFontMetricsInt(fm);
        return fm;
    }

    public float getFontSpacing() {
        return this.getFontMetrics(null);
    }

    public float measureText(char[] text, int index, int count) {
        if (!this.mHasCompatScaling) {
            return this.native_measureText(text, index, count);
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        float w = this.native_measureText(text, index, count);
        this.setTextSize(oldSize);
        return w * this.mInvCompatScaling;
    }

    private native float native_measureText(char[] var1, int var2, int var3);

    public float measureText(String text, int start, int end) {
        if (!this.mHasCompatScaling) {
            return this.native_measureText(text, start, end);
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        float w = this.native_measureText(text, start, end);
        this.setTextSize(oldSize);
        return w * this.mInvCompatScaling;
    }

    private native float native_measureText(String var1, int var2, int var3);

    public float measureText(String text) {
        if (!this.mHasCompatScaling) {
            return this.native_measureText(text);
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        float w = this.native_measureText(text);
        this.setTextSize(oldSize);
        return w * this.mInvCompatScaling;
    }

    private native float native_measureText(String var1);

    public float measureText(CharSequence text, int start, int end) {
        if (text instanceof String) {
            return this.measureText((String)text, start, end);
        }
        if (text instanceof SpannedString || text instanceof SpannableString) {
            return this.measureText(((Object)text).toString(), start, end);
        }
        if (text instanceof GraphicsOperations) {
            return ((GraphicsOperations)text).measureText(start, end, this);
        }
        char[] buf = TemporaryBuffer.obtain(end - start);
        TextUtils.getChars(text, start, end, buf, 0);
        float result = this.measureText(buf, 0, end - start);
        TemporaryBuffer.recycle(buf);
        return result;
    }

    public int breakText(char[] text, int index, int count, float maxWidth, float[] measuredWidth) {
        if (!this.mHasCompatScaling) {
            return this.native_breakText(text, index, count, maxWidth, measuredWidth);
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        int res = this.native_breakText(text, index, count, maxWidth * this.mCompatScaling, measuredWidth);
        this.setTextSize(oldSize);
        if (measuredWidth != null) {
            measuredWidth[0] = measuredWidth[0] * this.mInvCompatScaling;
        }
        return res;
    }

    private native int native_breakText(char[] var1, int var2, int var3, float var4, float[] var5);

    public int breakText(CharSequence text, int start, int end, boolean measureForwards, float maxWidth, float[] measuredWidth) {
        if (start == 0 && text instanceof String && end == text.length()) {
            return this.breakText((String)text, measureForwards, maxWidth, measuredWidth);
        }
        char[] buf = TemporaryBuffer.obtain(end - start);
        TextUtils.getChars(text, start, end, buf, 0);
        int result = measureForwards ? this.breakText(buf, 0, end - start, maxWidth, measuredWidth) : this.breakText(buf, 0, -(end - start), maxWidth, measuredWidth);
        TemporaryBuffer.recycle(buf);
        return result;
    }

    public int breakText(String text, boolean measureForwards, float maxWidth, float[] measuredWidth) {
        if (!this.mHasCompatScaling) {
            return this.native_breakText(text, measureForwards, maxWidth, measuredWidth);
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        int res = this.native_breakText(text, measureForwards, maxWidth * this.mCompatScaling, measuredWidth);
        this.setTextSize(oldSize);
        if (measuredWidth != null) {
            measuredWidth[0] = measuredWidth[0] * this.mInvCompatScaling;
        }
        return res;
    }

    private native int native_breakText(String var1, boolean var2, float var3, float[] var4);

    public int getTextWidths(char[] text, int index, int count, float[] widths) {
        if ((index | count) < 0 || index + count > text.length || count > widths.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (!this.mHasCompatScaling) {
            return Paint.native_getTextWidths(this.mNativePaint, text, index, count, widths);
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        int res = Paint.native_getTextWidths(this.mNativePaint, text, index, count, widths);
        this.setTextSize(oldSize);
        int i = 0;
        while (i < res) {
            int n = i++;
            widths[n] = widths[n] * this.mInvCompatScaling;
        }
        return res;
    }

    public int getTextWidths(CharSequence text, int start, int end, float[] widths) {
        if (text instanceof String) {
            return this.getTextWidths((String)text, start, end, widths);
        }
        if (text instanceof SpannedString || text instanceof SpannableString) {
            return this.getTextWidths(((Object)text).toString(), start, end, widths);
        }
        if (text instanceof GraphicsOperations) {
            return ((GraphicsOperations)text).getTextWidths(start, end, widths, this);
        }
        char[] buf = TemporaryBuffer.obtain(end - start);
        TextUtils.getChars(text, start, end, buf, 0);
        int result = this.getTextWidths(buf, 0, end - start, widths);
        TemporaryBuffer.recycle(buf);
        return result;
    }

    public int getTextWidths(String text, int start, int end, float[] widths) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (end - start > widths.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (!this.mHasCompatScaling) {
            return Paint.native_getTextWidths(this.mNativePaint, text, start, end, widths);
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        int res = Paint.native_getTextWidths(this.mNativePaint, text, start, end, widths);
        this.setTextSize(oldSize);
        int i = 0;
        while (i < res) {
            int n = i++;
            widths[n] = widths[n] * this.mInvCompatScaling;
        }
        return res;
    }

    public int getTextWidths(String text, float[] widths) {
        return this.getTextWidths(text, 0, text.length(), widths);
    }

    public void getTextPath(char[] text, int index, int count, float x, float y, Path path) {
        if ((index | count) < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Paint.native_getTextPath(this.mNativePaint, text, index, count, x, y, path.ni());
    }

    public void getTextPath(String text, int start, int end, float x, float y, Path path) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        Paint.native_getTextPath(this.mNativePaint, text, start, end, x, y, path.ni());
    }

    public void getTextBounds(String text, int start, int end, Rect bounds) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (bounds == null) {
            throw new NullPointerException("need bounds Rect");
        }
        Paint.nativeGetStringBounds(this.mNativePaint, text, start, end, bounds);
    }

    public void getTextBounds(char[] text, int index, int count, Rect bounds) {
        if ((index | count) < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (bounds == null) {
            throw new NullPointerException("need bounds Rect");
        }
        Paint.nativeGetCharArrayBounds(this.mNativePaint, text, index, count, bounds);
    }

    protected void finalize() throws Throwable {
        Paint.finalizer(this.mNativePaint);
    }

    private static native int native_init();

    private static native int native_initWithPaint(int var0);

    private static native void native_reset(int var0);

    private static native void native_set(int var0, int var1);

    private static native int native_getStyle(int var0);

    private static native void native_setStyle(int var0, int var1);

    private static native int native_getStrokeCap(int var0);

    private static native void native_setStrokeCap(int var0, int var1);

    private static native int native_getStrokeJoin(int var0);

    private static native void native_setStrokeJoin(int var0, int var1);

    private static native boolean native_getFillPath(int var0, int var1, int var2);

    private static native int native_setShader(int var0, int var1);

    private static native int native_setColorFilter(int var0, int var1);

    private static native int native_setXfermode(int var0, int var1);

    private static native int native_setPathEffect(int var0, int var1);

    private static native int native_setMaskFilter(int var0, int var1);

    private static native int native_setTypeface(int var0, int var1);

    private static native int native_setRasterizer(int var0, int var1);

    private static native int native_getTextAlign(int var0);

    private static native void native_setTextAlign(int var0, int var1);

    private static native float native_getFontMetrics(int var0, FontMetrics var1);

    private static native int native_getTextWidths(int var0, char[] var1, int var2, int var3, float[] var4);

    private static native int native_getTextWidths(int var0, String var1, int var2, int var3, float[] var4);

    private static native void native_getTextPath(int var0, char[] var1, int var2, int var3, float var4, float var5, int var6);

    private static native void native_getTextPath(int var0, String var1, int var2, int var3, float var4, float var5, int var6);

    private static native void nativeGetStringBounds(int var0, String var1, int var2, int var3, Rect var4);

    private static native void nativeGetCharArrayBounds(int var0, char[] var1, int var2, int var3, Rect var4);

    private static native void finalizer(int var0);

    public static class FontMetricsInt {
        public int top;
        public int ascent;
        public int descent;
        public int bottom;
        public int leading;

        public String toString() {
            return "FontMetricsInt: top=" + this.top + " ascent=" + this.ascent + " descent=" + this.descent + " bottom=" + this.bottom + " leading=" + this.leading;
        }
    }

    public static class FontMetrics {
        public float top;
        public float ascent;
        public float descent;
        public float bottom;
        public float leading;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Align {
        LEFT(0),
        CENTER(1),
        RIGHT(2);

        final int nativeInt;

        private Align(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Join {
        MITER(0),
        ROUND(1),
        BEVEL(2);

        final int nativeInt;

        private Join(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Cap {
        BUTT(0),
        ROUND(1),
        SQUARE(2);

        final int nativeInt;

        private Cap(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        FILL(0),
        STROKE(1),
        FILL_AND_STROKE(2);

        final int nativeInt;

        private Style(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }
}

