/*
 * Decompiled with CFR 0.152.
 */
package android.drm.mobile1;

import android.drm.mobile1.DrmException;
import android.drm.mobile1.DrmRights;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DrmRawContent {
    public static final String DRM_MIMETYPE_MESSAGE_STRING = "application/vnd.oma.drm.message";
    public static final String DRM_MIMETYPE_CONTENT_STRING = "application/vnd.oma.drm.content";
    public static final int DRM_FORWARD_LOCK = 1;
    public static final int DRM_COMBINED_DELIVERY = 2;
    public static final int DRM_SEPARATE_DELIVERY = 3;
    public static final int DRM_SEPARATE_DELIVERY_DM = 4;
    public static final int DRM_UNKNOWN_DATA_LEN = -1;
    private static final int DRM_MIMETYPE_MESSAGE = 1;
    private static final int DRM_MIMETYPE_CONTENT = 2;
    private static final int JNI_DRM_SUCCESS = 0;
    private static final int JNI_DRM_FAILURE = -1;
    private static final int JNI_DRM_EOF = -2;
    private static final int JNI_DRM_UNKNOWN_DATA_LEN = -3;
    private BufferedInputStream inData;
    private int inDataLen;
    private int id = -1;
    private String rightsIssuer;
    private String mediaType;
    private int rawType;

    public DrmRawContent(InputStream inRawdata, int len, String mimeTypeStr) throws DrmException, IOException {
        int mimeType;
        this.inData = new BufferedInputStream(inRawdata, 1024);
        this.inDataLen = len;
        if (DRM_MIMETYPE_MESSAGE_STRING.equals(mimeTypeStr)) {
            mimeType = 1;
        } else if (DRM_MIMETYPE_CONTENT_STRING.equals(mimeTypeStr)) {
            mimeType = 2;
        } else {
            throw new IllegalArgumentException("mimeType must be DRM_MIMETYPE_MESSAGE or DRM_MIMETYPE_CONTENT");
        }
        if (len <= 0) {
            throw new IllegalArgumentException("len must be > 0");
        }
        this.id = this.nativeConstructDrmContent(this.inData, this.inDataLen, mimeType);
        if (-1 == this.id) {
            throw new DrmException("nativeConstructDrmContent() returned JNI_DRM_FAILURE");
        }
        this.rightsIssuer = this.nativeGetRightsAddress();
        this.rawType = this.nativeGetDeliveryMethod();
        if (-1 == this.rawType) {
            throw new DrmException("nativeGetDeliveryMethod() returned JNI_DRM_FAILURE");
        }
        this.mediaType = this.nativeGetContentType();
        if (null == this.mediaType) {
            throw new DrmException("nativeGetContentType() returned null");
        }
    }

    public String getRightsAddress() {
        return this.rightsIssuer;
    }

    public int getRawType() {
        return this.rawType;
    }

    public InputStream getContentInputStream(DrmRights rights) {
        if (null == rights) {
            throw new NullPointerException();
        }
        return new DrmInputStream(rights);
    }

    public String getContentType() {
        return this.mediaType;
    }

    public int getContentLength(DrmRights rights) throws DrmException {
        if (null == rights) {
            throw new NullPointerException();
        }
        int mediaLen = this.nativeGetContentLength();
        if (-1 == mediaLen) {
            throw new DrmException("nativeGetContentLength() returned JNI_DRM_FAILURE");
        }
        if (-3 == mediaLen) {
            return -1;
        }
        return mediaLen;
    }

    private native int nativeConstructDrmContent(InputStream var1, int var2, int var3);

    private native String nativeGetRightsAddress();

    private native int nativeGetDeliveryMethod();

    private native int nativeReadContent(byte[] var1, int var2, int var3, int var4);

    private native String nativeGetContentType();

    private native int nativeGetContentLength();

    protected native void finalize();

    static {
        try {
            System.loadLibrary("drm1_jni");
        }
        catch (UnsatisfiedLinkError ule) {
            System.err.println("WARNING: Could not load libdrm1_jni.so");
        }
    }

    class DrmInputStream
    extends InputStream {
        private boolean isClosed = false;
        private int offset = 0;
        private byte[] b = new byte[1];

        public DrmInputStream(DrmRights rights) {
        }

        public int available() throws IOException {
            int len = DrmRawContent.this.nativeGetContentLength();
            if (-1 == len) {
                throw new IOException();
            }
            if (-3 == len) {
                return 0;
            }
            int availableLen = len - this.offset;
            if (availableLen < 0) {
                throw new IOException();
            }
            return availableLen;
        }

        public int read() throws IOException {
            int res = this.read(this.b, 0, 1);
            if (-1 == res) {
                return -1;
            }
            return this.b[0] & 0xFF;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (null == b) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || off + len > b.length) {
                throw new IndexOutOfBoundsException();
            }
            if (this.isClosed) {
                throw new IOException();
            }
            if (0 == len) {
                return 0;
            }
            if (-1 == (len = DrmRawContent.this.nativeReadContent(b, off, len, this.offset))) {
                throw new IOException();
            }
            if (-2 == len) {
                return -1;
            }
            this.offset += len;
            return len;
        }

        public boolean markSupported() {
            return false;
        }

        public void mark(int readlimit) {
        }

        public void reset() throws IOException {
            throw new IOException();
        }

        public long skip(long n) throws IOException {
            return 0L;
        }

        public void close() {
            this.isClosed = true;
        }
    }
}

