/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.sqlite.DatabaseObjectNotClosedException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDebug;
import android.os.StrictMode;
import android.util.Log;

class SQLiteCompiledSql {
    private static final String TAG = "SQLiteCompiledSql";
    SQLiteDatabase mDatabase;
    int nHandle = 0;
    int nStatement = 0;
    private String mSqlStmt = null;
    private Throwable mStackTrace = null;
    private boolean mInUse = false;

    SQLiteCompiledSql(SQLiteDatabase db, String sql) {
        if (!db.isOpen()) {
            throw new IllegalStateException("database " + db.getPath() + " already closed");
        }
        this.mDatabase = db;
        this.mSqlStmt = sql;
        this.mStackTrace = new DatabaseObjectNotClosedException().fillInStackTrace();
        this.nHandle = db.mNativeHandle;
        this.compile(sql, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compile(String sql, boolean forceCompilation) {
        if (!this.mDatabase.isOpen()) {
            throw new IllegalStateException("database " + this.mDatabase.getPath() + " already closed");
        }
        if (forceCompilation) {
            this.mDatabase.lock();
            try {
                this.native_compile(sql);
            }
            finally {
                this.mDatabase.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseSqlStatement() {
        if (this.nStatement != 0) {
            if (SQLiteDebug.DEBUG_ACTIVE_CURSOR_FINALIZATION) {
                Log.v(TAG, "closed and deallocated DbObj (id#" + this.nStatement + ")");
            }
            try {
                this.mDatabase.lock();
                this.native_finalize();
                this.nStatement = 0;
            }
            finally {
                this.mDatabase.unlock();
            }
        }
    }

    synchronized boolean acquire() {
        if (this.mInUse) {
            return false;
        }
        this.mInUse = true;
        if (SQLiteDebug.DEBUG_ACTIVE_CURSOR_FINALIZATION) {
            Log.v(TAG, "Acquired DbObj (id#" + this.nStatement + ") from DB cache");
        }
        return true;
    }

    synchronized void release() {
        if (SQLiteDebug.DEBUG_ACTIVE_CURSOR_FINALIZATION) {
            Log.v(TAG, "Released DbObj (id#" + this.nStatement + ") back to DB cache");
        }
        this.mInUse = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.nStatement == 0) {
                return;
            }
            if (SQLiteDebug.DEBUG_ACTIVE_CURSOR_FINALIZATION) {
                Log.v(TAG, "** warning ** Finalized DbObj (id#" + this.nStatement + ")");
            }
            if (StrictMode.vmSqliteObjectLeaksEnabled()) {
                int len = this.mSqlStmt.length();
                StrictMode.onSqliteObjectLeaked("Releasing statement in a finalizer. Please ensure that you explicitly call close() on your cursor: " + this.mSqlStmt.substring(0, len > 100 ? 100 : len), this.mStackTrace);
            }
            this.releaseSqlStatement();
        }
        finally {
            super.finalize();
        }
    }

    private final native void native_compile(String var1);

    private final native void native_finalize();
}

