/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.accounts.Account;
import android.content.SyncOperation;
import android.content.SyncStorageEngine;
import android.os.SystemClock;
import android.util.Log;
import android.util.Pair;
import com.google.android.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncQueue {
    private static final String TAG = "SyncManager";
    private SyncStorageEngine mSyncStorageEngine;
    private final HashMap<String, SyncOperation> mOperationsMap = Maps.newHashMap();

    public SyncQueue(SyncStorageEngine syncStorageEngine) {
        this.mSyncStorageEngine = syncStorageEngine;
        ArrayList<SyncStorageEngine.PendingOperation> ops = this.mSyncStorageEngine.getPendingOperations();
        int N = ops.size();
        for (int i = 0; i < N; ++i) {
            SyncStorageEngine.PendingOperation op = ops.get(i);
            SyncOperation syncOperation = new SyncOperation(op.account, op.syncSource, op.authority, op.extras, 0L);
            syncOperation.expedited = op.expedited;
            syncOperation.pendingOperation = op;
            this.add(syncOperation, op);
        }
    }

    public boolean add(SyncOperation operation) {
        return this.add(operation, null);
    }

    private boolean add(SyncOperation operation, SyncStorageEngine.PendingOperation pop) {
        String operationKey = operation.key;
        SyncOperation existingOperation = this.mOperationsMap.get(operationKey);
        if (existingOperation != null) {
            boolean changed = false;
            if (existingOperation.expedited == operation.expedited) {
                long newRunTime = Math.min(existingOperation.earliestRunTime, operation.earliestRunTime);
                if (existingOperation.earliestRunTime != newRunTime) {
                    existingOperation.earliestRunTime = newRunTime;
                    changed = true;
                }
            } else if (operation.expedited) {
                existingOperation.expedited = true;
                changed = true;
            }
            return changed;
        }
        operation.pendingOperation = pop;
        if (operation.pendingOperation == null) {
            pop = new SyncStorageEngine.PendingOperation(operation.account, operation.syncSource, operation.authority, operation.extras, operation.expedited);
            if ((pop = this.mSyncStorageEngine.insertIntoPending(pop)) == null) {
                throw new IllegalStateException("error adding pending sync operation " + operation);
            }
            operation.pendingOperation = pop;
        }
        this.mOperationsMap.put(operationKey, operation);
        return true;
    }

    public void remove(SyncOperation operation) {
        SyncOperation operationToRemove = this.mOperationsMap.remove(operation.key);
        if (operationToRemove == null) {
            return;
        }
        if (!this.mSyncStorageEngine.deleteFromPending(operationToRemove.pendingOperation)) {
            String errorMessage = "unable to find pending row for " + operationToRemove;
            Log.e(TAG, errorMessage, new IllegalStateException(errorMessage));
        }
    }

    public Pair<SyncOperation, Long> nextOperation() {
        SyncOperation best = null;
        long bestRunTime = 0L;
        boolean bestIsInitial = false;
        for (SyncOperation op : this.mOperationsMap.values()) {
            boolean opIsInitial;
            long opRunTime;
            if (!this.isOpBetter(best, bestRunTime, bestIsInitial, op, opRunTime = this.getOpTime(op), opIsInitial = this.getIsInitial(op))) continue;
            best = op;
            bestIsInitial = opIsInitial;
            bestRunTime = opRunTime;
        }
        if (best == null) {
            return null;
        }
        return Pair.create(best, bestRunTime);
    }

    long getOpTime(SyncOperation op) {
        long opRunTime = op.earliestRunTime;
        if (!op.extras.getBoolean("ignore_backoff", false)) {
            Pair<Long, Long> backoff = this.mSyncStorageEngine.getBackoff(op.account, op.authority);
            long delayUntil = this.mSyncStorageEngine.getDelayUntilTime(op.account, op.authority);
            opRunTime = Math.max(Math.max(opRunTime, delayUntil), backoff != null ? (Long)backoff.first : 0L);
        }
        return opRunTime;
    }

    boolean getIsInitial(SyncOperation op) {
        return !op.extras.getBoolean("initialize", false) && this.mSyncStorageEngine.getIsSyncable(op.account, op.authority) < 0;
    }

    boolean isOpBetter(SyncOperation best, long bestRunTime, boolean bestIsInitial, SyncOperation op, long opRunTime, boolean opIsInitial) {
        boolean setBest = false;
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "nextOperation: Processing op: " + op);
        }
        if (best == null) {
            if (Log.isLoggable(TAG, 2)) {
                Log.v(TAG, "   First op selected");
            }
            setBest = true;
        } else if (bestIsInitial == opIsInitial) {
            if (best.expedited == op.expedited) {
                if (opRunTime < bestRunTime) {
                    if (Log.isLoggable(TAG, 2)) {
                        Log.v(TAG, "   Same expedite level - new op selected");
                    }
                    setBest = true;
                }
            } else {
                long now = SystemClock.elapsedRealtime();
                if (op.expedited) {
                    if (opRunTime <= now || bestRunTime > now) {
                        if (Log.isLoggable(TAG, 2)) {
                            Log.v(TAG, "   New op is expedited and can run - new op selected");
                        }
                        setBest = true;
                    } else if (Log.isLoggable(TAG, 2)) {
                        Log.v(TAG, "   New op is expedited but can't run and best can");
                    }
                } else if (bestRunTime > now && opRunTime <= now) {
                    if (Log.isLoggable(TAG, 2)) {
                        Log.v(TAG, "   New op is not expedited but can run - new op selected");
                    }
                    setBest = true;
                }
            }
        } else if (opIsInitial) {
            if (Log.isLoggable(TAG, 2)) {
                Log.v(TAG, "   New op is init - new op selected");
            }
            setBest = true;
        }
        return setBest;
    }

    public Pair<SyncOperation, Long> nextReadyToRun(long now) {
        Pair<SyncOperation, Long> nextOpAndRunTime = this.nextOperation();
        if (nextOpAndRunTime == null || (Long)nextOpAndRunTime.second > now) {
            return null;
        }
        return nextOpAndRunTime;
    }

    public void remove(Account account, String authority) {
        Iterator<Map.Entry<String, SyncOperation>> entries = this.mOperationsMap.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<String, SyncOperation> entry = entries.next();
            SyncOperation syncOperation = entry.getValue();
            if (account != null && !syncOperation.account.equals(account) || authority != null && !syncOperation.authority.equals(authority)) continue;
            entries.remove();
            if (this.mSyncStorageEngine.deleteFromPending(syncOperation.pendingOperation)) continue;
            String errorMessage = "unable to find pending row for " + syncOperation;
            Log.e(TAG, errorMessage, new IllegalStateException(errorMessage));
        }
    }

    public void dump(StringBuilder sb) {
        sb.append("SyncQueue: ").append(this.mOperationsMap.size()).append(" operation(s)\n");
        for (SyncOperation operation : this.mOperationsMap.values()) {
            sb.append(operation).append("\n");
        }
    }
}

