/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.accounts.Account;
import android.content.SyncStorageEngine;
import android.os.Bundle;
import android.os.SystemClock;

public class SyncOperation
implements Comparable {
    public final Account account;
    public int syncSource;
    public String authority;
    public Bundle extras;
    public final String key;
    public long earliestRunTime;
    public boolean expedited;
    public SyncStorageEngine.PendingOperation pendingOperation;

    public SyncOperation(Account account, int source, String authority, Bundle extras, long delayInMs) {
        this.account = account;
        this.syncSource = source;
        this.authority = authority;
        this.extras = new Bundle(extras);
        this.removeFalseExtra("upload");
        this.removeFalseExtra("force");
        this.removeFalseExtra("ignore_settings");
        this.removeFalseExtra("ignore_backoff");
        this.removeFalseExtra("do_not_retry");
        this.removeFalseExtra("discard_deletions");
        this.removeFalseExtra("expedited");
        this.removeFalseExtra("deletions_override");
        long now = SystemClock.elapsedRealtime();
        if (delayInMs < 0L) {
            this.expedited = true;
            this.earliestRunTime = now;
        } else {
            this.expedited = false;
            this.earliestRunTime = now + delayInMs;
        }
        this.key = this.toKey();
    }

    private void removeFalseExtra(String extraName) {
        if (!this.extras.getBoolean(extraName, false)) {
            this.extras.remove(extraName);
        }
    }

    SyncOperation(SyncOperation other) {
        this.account = other.account;
        this.syncSource = other.syncSource;
        this.authority = other.authority;
        this.extras = new Bundle(other.extras);
        this.expedited = other.expedited;
        this.earliestRunTime = SystemClock.elapsedRealtime();
        this.key = this.toKey();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("authority: ").append(this.authority);
        sb.append(" account: ").append(this.account);
        sb.append(" extras: ");
        SyncOperation.extrasToStringBuilder(this.extras, sb, false);
        sb.append(" syncSource: ").append(this.syncSource);
        sb.append(" when: ").append(this.earliestRunTime);
        sb.append(" expedited: ").append(this.expedited);
        return sb.toString();
    }

    private String toKey() {
        StringBuilder sb = new StringBuilder();
        sb.append("authority: ").append(this.authority);
        sb.append(" account {name=" + this.account.name + ", type=" + this.account.type + "}");
        sb.append(" extras: ");
        SyncOperation.extrasToStringBuilder(this.extras, sb, true);
        return sb.toString();
    }

    public static void extrasToStringBuilder(Bundle bundle, StringBuilder sb, boolean asKey) {
        sb.append("[");
        for (String key : bundle.keySet()) {
            if (asKey && "initialize".equals(key)) continue;
            sb.append(key).append("=").append(bundle.get(key)).append(" ");
        }
        sb.append("]");
    }

    public int compareTo(Object o) {
        SyncOperation other = (SyncOperation)o;
        if (this.earliestRunTime == other.earliestRunTime) {
            return 0;
        }
        return this.earliestRunTime < other.earliestRunTime ? -1 : 1;
    }
}

