/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.AtCommandResult;
import android.bluetooth.AtParser;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.os.Handler;
import android.os.PowerManager;
import android.util.Log;

public final class HeadsetBase {
    private static final String TAG = "Bluetooth HeadsetBase";
    private static final boolean DBG = false;
    public static final int RFCOMM_DISCONNECTED = 1;
    public static final int DIRECTION_INCOMING = 1;
    public static final int DIRECTION_OUTGOING = 2;
    private static int sAtInputCount = 0;
    private final BluetoothAdapter mAdapter;
    private final BluetoothDevice mRemoteDevice;
    private final String mAddress;
    private final int mRfcommChannel;
    private int mNativeData;
    private Thread mEventThread;
    private volatile boolean mEventThreadInterrupted;
    private Handler mEventThreadHandler;
    private int mTimeoutRemainingMs;
    private final int mDirection;
    private final long mConnectTimestamp;
    protected AtParser mAtParser;
    private PowerManager.WakeLock mWakeLock;

    private static native void classInitNative();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.cleanupNativeDataNative();
            this.releaseWakeLock();
        }
        finally {
            super.finalize();
        }
    }

    private native void cleanupNativeDataNative();

    public HeadsetBase(PowerManager pm, BluetoothAdapter adapter, BluetoothDevice device, int rfcommChannel) {
        this.mDirection = 2;
        this.mConnectTimestamp = System.currentTimeMillis();
        this.mAdapter = adapter;
        this.mRemoteDevice = device;
        this.mAddress = device.getAddress();
        this.mRfcommChannel = rfcommChannel;
        this.mWakeLock = pm.newWakeLock(1, "HeadsetBase");
        this.mWakeLock.setReferenceCounted(false);
        this.initializeAtParser();
        this.initializeNativeDataNative(-1);
    }

    public HeadsetBase(PowerManager pm, BluetoothAdapter adapter, BluetoothDevice device, int socketFd, int rfcommChannel, Handler handler) {
        this.mDirection = 1;
        this.mConnectTimestamp = System.currentTimeMillis();
        this.mAdapter = adapter;
        this.mRemoteDevice = device;
        this.mAddress = device.getAddress();
        this.mRfcommChannel = rfcommChannel;
        this.mEventThreadHandler = handler;
        this.mWakeLock = pm.newWakeLock(1, "HeadsetBase");
        this.mWakeLock.setReferenceCounted(false);
        this.initializeAtParser();
        this.initializeNativeDataNative(socketFd);
    }

    private native void initializeNativeDataNative(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleInput(String input) {
        this.acquireWakeLock();
        Class<HeadsetBase> clazz = HeadsetBase.class;
        synchronized (HeadsetBase.class) {
            sAtInputCount = sAtInputCount == Integer.MAX_VALUE ? 0 : ++sAtInputCount;
            // ** MonitorExit[var4_2] (shouldn't be in output)
            AtCommandResult result = this.mAtParser.process(input);
            if (result.getResultCode() == 1) {
                Log.i(TAG, "Error processing <" + input + ">");
            }
            this.sendURC(result.toString());
            this.releaseWakeLock();
            return;
        }
    }

    protected void initializeAtParser() {
        this.mAtParser = new AtParser();
    }

    public AtParser getAtParser() {
        return this.mAtParser;
    }

    public void startEventThread() {
        this.mEventThread = new Thread("HeadsetBase Event Thread"){

            public void run() {
                while (!HeadsetBase.this.mEventThreadInterrupted) {
                    String input = HeadsetBase.this.readNative(500);
                    if (input != null) {
                        HeadsetBase.this.handleInput(input);
                        continue;
                    }
                    int last_read_error = HeadsetBase.this.getLastReadStatusNative();
                    if (last_read_error == 0) continue;
                    Log.i(HeadsetBase.TAG, "headset read error " + last_read_error);
                    if (HeadsetBase.this.mEventThreadHandler != null) {
                        HeadsetBase.this.mEventThreadHandler.obtainMessage(1).sendToTarget();
                    }
                    HeadsetBase.this.disconnectNative();
                    break;
                }
            }
        };
        this.mEventThreadInterrupted = false;
        this.mEventThread.start();
    }

    private native String readNative(int var1);

    private native int getLastReadStatusNative();

    private void stopEventThread() {
        this.mEventThreadInterrupted = true;
        this.mEventThread.interrupt();
        try {
            this.mEventThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.mEventThread = null;
    }

    public boolean connect(Handler handler) {
        if (this.mEventThread == null) {
            if (!this.connectNative()) {
                return false;
            }
            this.mEventThreadHandler = handler;
        }
        return true;
    }

    private native boolean connectNative();

    public boolean connectAsync() {
        int ret = this.connectAsyncNative();
        return ret == 0;
    }

    private native int connectAsyncNative();

    public int getRemainingAsyncConnectWaitingTimeMs() {
        return this.mTimeoutRemainingMs;
    }

    public int waitForAsyncConnect(int timeout_ms, Handler handler) {
        int res = this.waitForAsyncConnectNative(timeout_ms);
        if (res > 0) {
            this.mEventThreadHandler = handler;
        }
        return res;
    }

    private native int waitForAsyncConnectNative(int var1);

    public void disconnect() {
        if (this.mEventThread != null) {
            this.stopEventThread();
        }
        this.disconnectNative();
    }

    private native void disconnectNative();

    public boolean isConnected() {
        return this.mEventThread != null;
    }

    public BluetoothDevice getRemoteDevice() {
        return this.mRemoteDevice;
    }

    public int getDirection() {
        return this.mDirection;
    }

    public long getConnectTimestamp() {
        return this.mConnectTimestamp;
    }

    public synchronized boolean sendURC(String urc) {
        if (urc.length() > 0) {
            boolean ret = this.sendURCNative(urc);
            return ret;
        }
        return true;
    }

    private native boolean sendURCNative(String var1);

    private synchronized void acquireWakeLock() {
        if (!this.mWakeLock.isHeld()) {
            this.mWakeLock.acquire();
        }
    }

    private synchronized void releaseWakeLock() {
        if (this.mWakeLock.isHeld()) {
            this.mWakeLock.release();
        }
    }

    public static int getAtInputCount() {
        return sAtInputCount;
    }

    private static void log(String msg) {
        Log.d(TAG, msg);
    }

    static {
        HeadsetBase.classInitNative();
    }
}

