/*
 * Decompiled with CFR 0.152.
 */
package android.appwidget;

import android.appwidget.AppWidgetHostView;
import android.appwidget.AppWidgetProviderInfo;
import android.content.Context;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.widget.RemoteViews;
import com.android.internal.appwidget.IAppWidgetHost;
import com.android.internal.appwidget.IAppWidgetService;
import java.util.ArrayList;
import java.util.HashMap;

public class AppWidgetHost {
    static final int HANDLE_UPDATE = 1;
    static final int HANDLE_PROVIDER_CHANGED = 2;
    static final Object sServiceLock = new Object();
    static IAppWidgetService sService;
    Context mContext;
    String mPackageName;
    Handler mHandler;
    int mHostId;
    Callbacks mCallbacks = new Callbacks();
    final HashMap<Integer, AppWidgetHostView> mViews = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppWidgetHost(Context context, int hostId) {
        this.mContext = context;
        this.mHostId = hostId;
        this.mHandler = new UpdateHandler(context.getMainLooper());
        Object object = sServiceLock;
        synchronized (object) {
            if (sService == null) {
                IBinder b = ServiceManager.getService("appwidget");
                sService = IAppWidgetService.Stub.asInterface(b);
            }
        }
    }

    public void startListening() {
        int[] updatedIds;
        ArrayList<RemoteViews> updatedViews = new ArrayList<RemoteViews>();
        try {
            if (this.mPackageName == null) {
                this.mPackageName = this.mContext.getPackageName();
            }
            updatedIds = sService.startListening(this.mCallbacks, this.mPackageName, this.mHostId, updatedViews);
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
        int N = updatedIds.length;
        for (int i = 0; i < N; ++i) {
            this.updateAppWidgetView(updatedIds[i], updatedViews.get(i));
        }
    }

    public void stopListening() {
        try {
            sService.stopListening(this.mHostId);
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
    }

    public int allocateAppWidgetId() {
        try {
            if (this.mPackageName == null) {
                this.mPackageName = this.mContext.getPackageName();
            }
            return sService.allocateAppWidgetId(this.mPackageName, this.mHostId);
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAppWidgetId(int appWidgetId) {
        HashMap<Integer, AppWidgetHostView> hashMap = this.mViews;
        synchronized (hashMap) {
            this.mViews.remove(appWidgetId);
            try {
                sService.deleteAppWidgetId(appWidgetId);
            }
            catch (RemoteException e) {
                throw new RuntimeException("system server dead?", e);
            }
        }
    }

    public void deleteHost() {
        try {
            sService.deleteHost(this.mHostId);
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
    }

    public static void deleteAllHosts() {
        try {
            sService.deleteAllHosts();
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AppWidgetHostView createView(Context context, int appWidgetId, AppWidgetProviderInfo appWidget) {
        RemoteViews views;
        AppWidgetHostView view = this.onCreateView(context, appWidgetId, appWidget);
        view.setAppWidget(appWidgetId, appWidget);
        HashMap<Integer, AppWidgetHostView> hashMap = this.mViews;
        synchronized (hashMap) {
            this.mViews.put(appWidgetId, view);
        }
        try {
            views = sService.getAppWidgetViews(appWidgetId);
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
        view.updateAppWidget(views);
        return view;
    }

    protected AppWidgetHostView onCreateView(Context context, int appWidgetId, AppWidgetProviderInfo appWidget) {
        return new AppWidgetHostView(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onProviderChanged(int appWidgetId, AppWidgetProviderInfo appWidget) {
        AppWidgetHostView v;
        HashMap<Integer, AppWidgetHostView> hashMap = this.mViews;
        synchronized (hashMap) {
            v = this.mViews.get(appWidgetId);
        }
        if (v != null) {
            v.resetAppWidget(appWidget);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateAppWidgetView(int appWidgetId, RemoteViews views) {
        AppWidgetHostView v;
        HashMap<Integer, AppWidgetHostView> hashMap = this.mViews;
        synchronized (hashMap) {
            v = this.mViews.get(appWidgetId);
        }
        if (v != null) {
            v.updateAppWidget(views);
        }
    }

    class UpdateHandler
    extends Handler {
        public UpdateHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    AppWidgetHost.this.updateAppWidgetView(msg.arg1, (RemoteViews)msg.obj);
                    break;
                }
                case 2: {
                    AppWidgetHost.this.onProviderChanged(msg.arg1, (AppWidgetProviderInfo)msg.obj);
                }
            }
        }
    }

    class Callbacks
    extends IAppWidgetHost.Stub {
        Callbacks() {
        }

        public void updateAppWidget(int appWidgetId, RemoteViews views) {
            Message msg = AppWidgetHost.this.mHandler.obtainMessage(1);
            msg.arg1 = appWidgetId;
            msg.obj = views;
            msg.sendToTarget();
        }

        public void providerChanged(int appWidgetId, AppWidgetProviderInfo info) {
            Message msg = AppWidgetHost.this.mHandler.obtainMessage(2);
            msg.arg1 = appWidgetId;
            msg.obj = info;
            msg.sendToTarget();
        }
    }
}

