/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.content.Context;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import com.android.internal.statusbar.IStatusBarService;

public class StatusBarManager {
    public static final int DISABLE_EXPAND = 1;
    public static final int DISABLE_NOTIFICATION_ICONS = 2;
    public static final int DISABLE_NOTIFICATION_ALERTS = 4;
    public static final int DISABLE_NOTIFICATION_TICKER = 8;
    public static final int DISABLE_NONE = 0;
    private Context mContext;
    private IStatusBarService mService;
    private IBinder mToken = new Binder();

    StatusBarManager(Context context) {
        this.mContext = context;
        this.mService = IStatusBarService.Stub.asInterface(ServiceManager.getService("statusbar"));
    }

    public void disable(int what) {
        try {
            this.mService.disable(what, this.mToken, this.mContext.getPackageName());
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void expand() {
        try {
            this.mService.expand();
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void collapse() {
        try {
            this.mService.collapse();
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setIcon(String slot, int iconId, int iconLevel) {
        try {
            this.mService.setIcon(slot, this.mContext.getPackageName(), iconId, iconLevel);
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void removeIcon(String slot) {
        try {
            this.mService.removeIcon(slot);
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setIconVisibility(String slot, boolean visible) {
        try {
            this.mService.setIconVisibility(slot, visible);
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex);
        }
    }
}

