/*
 * Decompiled with CFR 0.152.
 */
package android.dpi.cts;

import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.test.AndroidTestCase;

public abstract class DefaultManifestAttributesTest
extends AndroidTestCase {
    protected String packageName;
    private boolean expectedResult;
    private ApplicationInfo appInfo;

    protected ApplicationInfo getAppInfo() {
        return this.appInfo;
    }

    protected abstract String getPackageName();

    protected void setUp() {
        this.packageName = this.getPackageName();
        PackageManager pm = this.getContext().getPackageManager();
        try {
            this.appInfo = pm.getApplicationInfo(this.packageName, 0);
            this.expectedResult = this.appInfo.targetSdkVersion > 3;
        }
        catch (PackageManager.NameNotFoundException e) {
            DefaultManifestAttributesTest.fail((String)"Should be able to find application info for this package");
        }
    }

    public void testSmallScreenDefault() {
        DefaultManifestAttributesTest.assertEquals((boolean)this.expectedResult, ((this.getAppInfo().flags & 0x200) != 0 ? 1 : 0) != 0);
    }

    public void testNormalScreenDefault() {
        DefaultManifestAttributesTest.assertEquals((boolean)true, ((this.getAppInfo().flags & 0x400) != 0 ? 1 : 0) != 0);
    }

    public void testLargeScreenDefault() {
        DefaultManifestAttributesTest.assertEquals((boolean)this.expectedResult, ((this.getAppInfo().flags & 0x800) != 0 ? 1 : 0) != 0);
    }

    public void testResizableDefault() {
        DefaultManifestAttributesTest.assertEquals((boolean)this.expectedResult, ((this.getAppInfo().flags & 0x1000) != 0 ? 1 : 0) != 0);
    }

    public void testAnyDensityDefault() {
        DefaultManifestAttributesTest.assertEquals((boolean)this.expectedResult, ((this.getAppInfo().flags & 0x2000) != 0 ? 1 : 0) != 0);
    }
}

