/*
 * Decompiled with CFR 0.152.
 */
package tests.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;

public class SerializationTester {
    private static Object lastOutput = null;

    private SerializationTester() {
    }

    public static Object getDeserilizedObject(Object inputObject) throws IOException, ClassNotFoundException {
        Object outputObject;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(inputObject);
        oos.close();
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bis);
        lastOutput = outputObject = ois.readObject();
        ois.close();
        return outputObject;
    }

    public static boolean assertSame(Object inputObject) throws Exception {
        return inputObject == SerializationTester.getDeserilizedObject(inputObject);
    }

    public static boolean assertEquals(Object inputObject) throws Exception {
        return inputObject.equals(SerializationTester.getDeserilizedObject(inputObject));
    }

    public static boolean assertCompabilitySame(Object obj, String fileName) throws Exception {
        return obj == SerializationTester.readObject(obj, fileName);
    }

    public static boolean assertCompabilityEquals(Object obj, String fileName) throws Exception {
        return obj.equals(SerializationTester.readObject(obj, fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readObject(Object obj, String fileName) throws Exception {
        InputStream input = null;
        ObjectInputStream oinput = null;
        URL url = SerializationTester.class.getResource(fileName);
        if (null == url) {
            SerializationTester.writeObject(obj, new File(fileName).getName());
            throw new Error("Serialization file does not exist, created in the current dir.");
        }
        input = url.openStream();
        try {
            Object newObj;
            oinput = new ObjectInputStream(input);
            Object object = newObj = oinput.readObject();
            return object;
        }
        finally {
            try {
                if (null != oinput) {
                    oinput.close();
                }
            }
            catch (Exception e) {}
            try {
                if (null != input) {
                    input.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObject(Object obj, String fileName) throws Exception {
        FileOutputStream output = null;
        ObjectOutputStream ooutput = null;
        try {
            output = new FileOutputStream(fileName);
            ooutput = new ObjectOutputStream(output);
            ooutput.writeObject(obj);
        }
        finally {
            try {
                if (null != ooutput) {
                    ooutput.close();
                }
            }
            catch (Exception e) {}
            try {
                if (null != output) {
                    ((OutputStream)output).close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static Object getLastOutput() {
        return lastOutput;
    }

    public static void main(String[] args) {
    }
}

