/*
 * Decompiled with CFR 0.152.
 */
package tests.util;

import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallVerificationStack
extends Stack<Object> {
    private static final long serialVersionUID = 1L;
    private static final CallVerificationStack _instance = new CallVerificationStack();
    private final Stack<StackTraceElement> callStack = new Stack();

    private CallVerificationStack() {
    }

    public static CallVerificationStack getInstance() {
        return _instance;
    }

    private void pushCallStack() {
        int i;
        StackTraceElement[] eles = new Throwable().getStackTrace();
        for (i = 1; i < eles.length && eles[i].getClassName().equals(this.getClass().getName()); ++i) {
        }
        this.callStack.push(eles[i]);
    }

    public String getCurrentSourceClass() {
        return this.callStack.peek().getClassName();
    }

    public String getCurrentSourceMethod() {
        return this.callStack.peek().getMethodName();
    }

    @Override
    public void clear() {
        this.callStack.clear();
        super.clear();
    }

    @Override
    public Object push(Object o) {
        this.pushCallStack();
        return super.push(o);
    }

    @Override
    public void push(boolean val) {
        this.push(new BaseTypeWrapper(val));
    }

    @Override
    public void push(char val) {
        this.push(new BaseTypeWrapper(val));
    }

    @Override
    public void push(double val) {
        this.push(new BaseTypeWrapper(val));
    }

    @Override
    public void push(float val) {
        this.push(new BaseTypeWrapper(val));
    }

    @Override
    public void push(int val) {
        this.push(new BaseTypeWrapper(val));
    }

    @Override
    public void push(long val) {
        this.push(new BaseTypeWrapper(val));
    }

    @Override
    public void push(short val) {
        this.push(new BaseTypeWrapper(val));
    }

    @Override
    public Object pop() {
        this.callStack.pop();
        return super.pop();
    }

    public boolean popBoolean() {
        BaseTypeWrapper wrapper = (BaseTypeWrapper)this.pop();
        Boolean value = (Boolean)wrapper.getValue();
        return value;
    }

    public char popChar() {
        BaseTypeWrapper wrapper = (BaseTypeWrapper)this.pop();
        Character value = (Character)wrapper.getValue();
        return value.charValue();
    }

    public double popDouble() {
        BaseTypeWrapper wrapper = (BaseTypeWrapper)this.pop();
        Double value = (Double)wrapper.getValue();
        return value;
    }

    public float popFloat() {
        BaseTypeWrapper wrapper = (BaseTypeWrapper)this.pop();
        Float value = (Float)wrapper.getValue();
        return value.floatValue();
    }

    public int popInt() {
        BaseTypeWrapper wrapper = (BaseTypeWrapper)this.pop();
        Integer value = (Integer)wrapper.getValue();
        return value;
    }

    public long popLong() {
        BaseTypeWrapper wrapper = (BaseTypeWrapper)this.pop();
        Long value = (Long)wrapper.getValue();
        return value;
    }

    public short popShort() {
        BaseTypeWrapper wrapper = (BaseTypeWrapper)this.pop();
        Short value = (Short)wrapper.getValue();
        return value;
    }

    class BaseTypeWrapper {
        private Object value;

        public BaseTypeWrapper(boolean val) {
            this.value = new Boolean(val);
        }

        public BaseTypeWrapper(byte val) {
            this.value = new Byte(val);
        }

        public BaseTypeWrapper(char val) {
            this.value = new Character(val);
        }

        public BaseTypeWrapper(double val) {
            this.value = new Double(val);
        }

        public BaseTypeWrapper(float val) {
            this.value = new Float(val);
        }

        public BaseTypeWrapper(int val) {
            this.value = new Integer(val);
        }

        public BaseTypeWrapper(long val) {
            this.value = new Long(val);
        }

        public BaseTypeWrapper(short val) {
            this.value = new Short(val);
        }

        public Object getValue() {
            return this.value;
        }
    }
}

