/*
 * Decompiled with CFR 0.152.
 */
package tests.support;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class ThrowingReader
extends FilterReader {
    private int total = 0;
    private int throwAt;

    public ThrowingReader(Reader in, int throwAt) {
        super(in);
        this.throwAt = throwAt;
    }

    public int read() throws IOException {
        this.explodeIfNecessary();
        int result = super.read();
        ++this.total;
        return result;
    }

    public int read(char[] buf, int offset, int count) throws IOException {
        this.explodeIfNecessary();
        if (this.total < this.throwAt) {
            count = Math.min(count, this.throwAt - this.total);
        }
        int returned = super.read(buf, offset, count);
        this.total += returned;
        return returned;
    }

    private void explodeIfNecessary() throws IOException {
        if (this.total == this.throwAt) {
            this.throwAt = Integer.MAX_VALUE;
            throw new IOException();
        }
    }
}

